/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.relation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public class RelationImportDataOp
extends BatchImportPlugin {
    public List<ComboItem> getOverrideFieldsConfig() {
        List overrideFieldsConfig = super.getOverrideFieldsConfig();
        return overrideFieldsConfig;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        String importType = (String)this.ctx.getOption().get("importtype");
        if (StringUtils.equals((CharSequence)importType, (CharSequence)"new")) {
            ArrayList afterFilterRowDatas = Lists.newArrayListWithExpectedSize((int)rowdatas.size());
            if (this.dataValidate(rowdatas, logger)) {
                for (ImportBillData data : rowdatas) {
                    JSONObject jsonData = data.getData();
                    JSONArray entryentity = jsonData.getJSONArray("entryentity");
                    ArrayList goodsNameInfos = Lists.newArrayList();
                    ArrayList goodsNameImportInfos = Lists.newArrayList();
                    for (int i = 0; i < entryentity.size(); ++i) {
                        JSONObject goodsNameInfo = (JSONObject)entryentity.get(i);
                        String goodsInfo = JSON.toJSONString((Object)goodsNameInfo);
                        EntityInfo info = (EntityInfo)JSON.parseObject((String)goodsInfo, EntityInfo.class);
                        String substr = goodsInfo.replaceAll(",\"rowNum\":\\d*", "");
                        if (goodsNameInfos.contains(substr) || !StringUtils.isNotBlank((CharSequence)info.getMapfactor())) continue;
                        goodsNameInfos.add(substr);
                        goodsNameImportInfos.add(goodsNameInfo);
                    }
                    jsonData.put("entryentity", (Object)goodsNameImportInfos);
                    ArrayList expItemNumbers = Lists.newArrayList();
                    ArrayList expItemNumberImport = Lists.newArrayList();
                    JSONArray expitemrange = jsonData.getJSONArray("expitemrange");
                    if (expitemrange != null && expitemrange.size() > 0) {
                        for (int i = 0; i < expitemrange.size(); ++i) {
                            JSONObject row = (JSONObject)expitemrange.get(i);
                            JSONObject entryexpenseitem = row.getJSONObject("entryexpenseitem");
                            String expNumber = entryexpenseitem.getString("number");
                            if (expItemNumbers.contains(expNumber)) continue;
                            expItemNumbers.add(expNumber);
                            expItemNumberImport.add(row);
                            Boolean isdefault = row.getBoolean("isdefault");
                            if (isdefault == null || !isdefault.booleanValue()) continue;
                            jsonData.put("expenseitem", (Object)entryexpenseitem);
                        }
                    }
                    if (expItemNumberImport.size() != 0 && jsonData.get((Object)"expenseitem") == null) {
                        jsonData.put("expenseitem", (Object)((JSONObject)expItemNumberImport.get(0)).getJSONObject("entryexpenseitem"));
                    }
                    jsonData.put("expitemrange", (Object)expItemNumberImport);
                    afterFilterRowDatas.add(data);
                }
            }
            return super.save((List)afterFilterRowDatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    private boolean dataValidate(List<ImportBillData> rowdatas, ImportLogger logger) {
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            JSONArray expitemrange = jsonData.getJSONArray("expitemrange");
            if (expitemrange == null || expitemrange.size() <= 0) continue;
            boolean defaultSelect = false;
            for (int i = 0; i < expitemrange.size(); ++i) {
                JSONObject row = (JSONObject)expitemrange.get(i);
                Integer idx = row.getInteger("rowNum");
                Boolean isDefault = row.getBoolean("isdefault");
                if (isDefault == null) {
                    isDefault = false;
                }
                if (isDefault.booleanValue() && defaultSelect) {
                    return ImportUtils.assertFalse((ImportLogger)logger, (int)idx, (String)ResManager.loadKDString((String)"\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u8d39\u7528\u9879\u76ee\u4e3a\u9ed8\u8ba4\u503c\u3002", (String)"RelationImportDataOp_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                defaultSelect |= isDefault.booleanValue();
                JSONObject entryexpenseitem = row.getJSONObject("entryexpenseitem");
                if (entryexpenseitem != null && entryexpenseitem.getString("number") != null && !entryexpenseitem.getString("number").equals("")) continue;
                return ImportUtils.assertFalse((ImportLogger)logger, (int)idx, (String)ResManager.loadKDString((String)"\u6a21\u7248\u4e2d\u7f3a\u5c11\u5fc5\u586b\u9879\uff1a[\u8d39\u7528\u9879\u76ee\u8303\u56f4]\u5206\u5f55\u4e2d[\u8d39\u7528\u9879\u76ee.\u7f16\u7801]\u5b57\u6bb5\u3002", (String)"RelationImportDataOp_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    public static class EntityInfo {
        private String inv_mappingtype;
        private int rowNum;
        private String invoicefactor;
        private String mapfactor;

        public String getInv_mappingtype() {
            return this.inv_mappingtype;
        }

        public void setInv_mappingtype(String inv_mappingtype) {
            this.inv_mappingtype = inv_mappingtype;
        }

        public int getRowNum() {
            return this.rowNum;
        }

        public void setRowNum(int rowNum) {
            this.rowNum = rowNum;
        }

        public String getInvoicefactor() {
            return this.invoicefactor;
        }

        public void setInvoicefactor(String invoicefactor) {
            this.invoicefactor = invoicefactor;
        }

        public String getMapfactor() {
            return this.mapfactor;
        }

        public void setMapfactor(String mapfactor) {
            this.mapfactor = mapfactor;
        }
    }
}

