/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.service;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.InvoiceFormPluginService;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class OutSideInvoicePluginService
implements InvoiceFormPluginService {
    private static final Log log = LogFactory.getLog(OutSideInvoicePluginService.class);

    @Override
    public void afterImportInvoicePC(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        ClosedCallBackEvent closedCallBackEvent = (ClosedCallBackEvent)event.getEvent();
        Object returnData = closedCallBackEvent.getReturnData();
        Map returnMap = (Map)returnData;
        this.importInvoice(returnMap, plugin);
        if (returnMap != null) {
            InvoicePluginUtils.getInvoiceAttachments(plugin);
        }
    }

    @Override
    public void afterEditInvoicePC(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        ClosedCallBackEvent closedCallBackEvent = (ClosedCallBackEvent)event.getEvent();
        IFormView view = plugin.getView();
        Object returnData = closedCallBackEvent.getReturnData();
        Map returnMap = (Map)returnData;
        String serialNo = (String)returnMap.get("serialNo");
        String oldSerialNo = (String)returnMap.get("oldSerialNo");
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)oldSerialNo)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u7684\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        log.info("serialNo:" + serialNo + "; oldSerialNo:" + oldSerialNo);
        DynamicObjectCollection invoiceEntryDOs = view.getModel().getEntryEntity("invoiceentry");
        Optional<DynamicObject> invoiceEntryOp = invoiceEntryDOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getString("serialno"), (CharSequence)oldSerialNo)).findFirst();
        if (!invoiceEntryOp.isPresent()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u4fee\u6539\u524d\u7684\u6d41\u6c34\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u5206\u5f55\u3002", (String)"AbstractImportInvoicePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            QueryInvoiceDetailBO queryInvoiceDetailBO = InvoicePluginUtils.buildQueryInvoiceDetailBO(plugin, serialNo);
            List invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO, plugin.getAfterSelectInvoicePluginProxy());
            plugin.editInvoice(oldSerialNo, (InvoiceVO)invoiceVOs.get(0));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        InvoicePluginUtils.getInvoiceAttachments(plugin);
    }

    @Override
    public void afterDeleteAttachmentPC(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        List attachVos = InvoiceService.getInstanceService().queryAttachments((AbstractFormPlugin)plugin);
        InvoicePluginUtils.updateAttachments((AbstractFormPlugin)plugin, plugin.getView(), true, attachVos);
    }

    @Override
    public void afterImportInvoiceMob(AbstractImportInvoicePlugin plugin, InvoiceEvent event) throws Exception {
        String serialNosStr;
        IFormView view = plugin.getView();
        String msg = (String)event.getReturnData();
        String billNo = "";
        if (view.getModel().getProperty("billno") != null) {
            billNo = (String)view.getModel().getValue("billno");
        }
        if (!StringUtils.isBlank((CharSequence)(serialNosStr = InvoicePluginUtils.getOutSideInvoiceSerialNos(msg)))) {
            List invoiceVOs = null;
            Map queryInvoiceMap = plugin.getQueryInvoiceMap();
            if (queryInvoiceMap != null && queryInvoiceMap.containsKey("isquery")) {
                invoiceVOs = JSONArray.parseArray((String)((String)queryInvoiceMap.get("isquery")), InvoiceVO.class);
                plugin.getQueryInvoiceMap().clear();
            } else {
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO, (String)billNo, (String)ResManager.loadKDString((String)"\u91c7\u96c6\u53d1\u7968\u5e8f\u5217\u53f7", (String)"ImportInvoice_4", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)msg);
                QueryInvoiceDetailBO queryInvoiceDetailBO = InvoicePluginUtils.buildQueryInvoiceDetailBO(plugin, serialNosStr);
                invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO);
                InvoiceLogUtils.insertBatchLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO, (String)billNo, (String)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO.getDesc(), (List)invoiceVOs);
            }
            if (!CollectionUtils.isEmpty((Collection)invoiceVOs)) {
                plugin.executeProcess(invoiceVOs);
            }
        }
        InvoicePluginUtils.getInvoiceAttachments(plugin, msg);
    }

    @Override
    public void afterEditInvoiceMob(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
    }

    @Override
    public void afterDeleteAttachmentMob(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
    }

    private void importInvoice(Map<String, String> m, AbstractImportInvoicePlugin plugin) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        if (m == null) {
            return;
        }
        if ("0".equals(m.get("state"))) {
            if (ErStdConfig.isDev() && ErStdConfig.getShowImportInvoiceDataSimulatorPC()) {
                InvoicePluginUtils.executeDevInvoice(m, plugin);
                return;
            }
            String serialNosStr = m.get("msg");
            serialNosStr = (String)StringUtils.defaultIfBlank((CharSequence)serialNosStr, (CharSequence)"");
            String[] serialNoArr = serialNosStr.split(",");
            Set serialNos = Arrays.stream(serialNoArr).collect(Collectors.toSet());
            try {
                if (serialNos == null || serialNos.isEmpty()) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u53d1\u7968", (String)"AbstractImportInvoicePlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    log.info("\u672a\u9009\u4e2d\u53d1\u7968");
                } else {
                    String billNo = "";
                    IDataEntityProperty billNoProp = model.getProperty("billno");
                    if (billNoProp != null) {
                        billNo = (String)model.getValue("billno");
                    }
                    List invoiceVOs = null;
                    if (m.containsKey("isquery")) {
                        invoiceVOs = JSONArray.parseArray((String)m.get("isquery"), InvoiceVO.class);
                    } else {
                        QueryInvoiceDetailBO queryInvoiceDetailBO = InvoicePluginUtils.buildQueryInvoiceDetailBO(plugin, serialNosStr);
                        InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO, (String)billNo, (String)ResManager.loadKDString((String)"\u91c7\u96c6\u53d1\u7968\u5e8f\u5217\u53f7", (String)"ImportInvoice_4", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)m.toString());
                        invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO, plugin.getAfterSelectInvoicePluginProxy());
                        InvoiceLogUtils.insertBatchLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO, (String)billNo, (String)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO.getDesc(), (List)invoiceVOs);
                    }
                    if (!CollectionUtils.isEmpty((Collection)invoiceVOs)) {
                        plugin.executeProcess(invoiceVOs);
                    }
                }
            }
            catch (InvoiceCloudException e) {
                view.showErrorNotification(e.getMessage());
                log.error((Throwable)e);
            }
            catch (Exception e) {
                throw new KDException(ThrowableHelper.toString((Exception)e));
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011AWS\u63a5\u6536\u5230pc\u7aef\u9009\u62e9\u5bfc\u5165\u7684\u53d1\u7968\u6570\u636e:" + (String)StringUtils.defaultIfBlank((CharSequence)serialNosStr, (CharSequence)""));
        } else {
            view.showErrorNotification(m.get("msg"));
        }
    }
}

