/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.service.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.transf.bo.SelectedInvoiceInfoBO;
import kd.fi.er.business.invoicecloud.util.InvoicePackageUtil;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.AttachmentUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.attachment.AttachmentData;
import kd.fi.er.common.model.invoice.AttachVo;
import kd.fi.er.common.model.invoice.InvoiceAttachmentVo;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.xh.AttachData;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.InvoiceFormPluginService;
import kd.fi.er.formplugin.invoicecloud.v2.service.InvoicePluginServiceFactory;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.DeleteAttachmentByDeleteInvoiceUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoicePluginUtils {
    private static final Log log = LogFactory.getLog(InvoicePluginUtils.class);

    public static void saveAttachment(AbstractImportInvoicePlugin plugin, IFormView view, List<AttachData> attachData) {
        if (attachData == null || attachData.size() <= 0) {
            log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f,\u6ca1\u6709\u9644\u4ef6\u6570\u636e");
            return;
        }
        InvoicePluginUtils.setNeedInvokeInvoiceCloud(view.getModel());
        List<AttachVo> attachVos = attachData.stream().map(e -> e.toAttachVO()).collect(Collectors.toList());
        InvoicePluginUtils.updateAttachments((AbstractFormPlugin)plugin, view, false, attachVos);
    }

    public static void setNeedInvokeInvoiceCloud(IDataModel model) {
        if (model.getProperty("invokeinvoicecloud") != null) {
            model.setValue("invokeinvoicecloud", (Object)Boolean.TRUE);
        }
    }

    public static void getInvoiceAttachments(AbstractImportInvoicePlugin plugin) {
        InvoicePluginUtils.getInvoiceAttachments(plugin, "");
    }

    public static void getInvoiceAttachments(AbstractImportInvoicePlugin plugin, String msg) {
        log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5f00\u59cb : " + msg);
        IFormView view = plugin.getView();
        try {
            boolean hasEntry;
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            Map<String, Object> attachmentAndModel = InvoicePluginUtils.getAttachmentPanel(plugin);
            IDataModel model = (IDataModel)attachmentAndModel.get("model");
            AttachmentPanel filePanel = (AttachmentPanel)attachmentAndModel.get("panel");
            boolean bl = hasEntry = model.getProperty("invoiceattachinfo") != null;
            if (filePanel == null && !hasEntry) {
                return;
            }
            DynamicObject dataEntity = model.getDataEntity();
            if (dataEntity == null) {
                return;
            }
            DynamicObject costCompany = plugin.getCostCompanyDO();
            if (costCompany == null) {
                costCompany = (DynamicObject)model.getValue("costcompany");
            }
            if (costCompany == null) {
                return;
            }
            List invoiceAttachments = null;
            if (plugin.isPc()) {
                invoiceAttachments = APIHelper.getTempInvoiceAttachments((DynamicObject)dataEntity, (long)ErCommonUtils.getPk((Object)costCompany));
            } else {
                JSONObject option;
                JSONObject jsonObject = JSON.parseObject((String)msg);
                if (ErStdConfig.isInvokeMiniProgramInImportInvoice().booleanValue()) {
                    if (jsonObject.containsKey((Object)"data") && (jsonObject = jsonObject.getJSONObject("data")).containsKey((Object)"extraData") && (option = jsonObject.getJSONObject("extraData")) != null && option.containsKey((Object)"certificateList")) {
                        invoiceAttachments = JSON.parseArray((String)option.getString("certificateList"), InvoiceAttachmentVo.class);
                    }
                } else if (jsonObject.containsKey((Object)"version") && jsonObject.containsKey((Object)"option") && (option = jsonObject.getJSONObject("option")) != null && option.containsKey((Object)"certificateList")) {
                    invoiceAttachments = JSON.parseArray((String)option.getString("certificateList"), InvoiceAttachmentVo.class);
                }
            }
            if (invoiceAttachments == null || invoiceAttachments.isEmpty()) {
                log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f,\u6ca1\u6709\u9644\u4ef6\u6570\u636e");
                return;
            }
            if (CollectionUtils.isEmpty(invoiceAttachments = invoiceAttachments.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
                log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f,\u6ca1\u6709\u9644\u4ef6\u6570\u636e");
                return;
            }
            InvoicePluginUtils.setNeedInvokeInvoiceCloud(model);
            invoiceAttachments.forEach(e -> e.setSerialNo("rc-upload-ia-" + e.getSerialNo()));
            Map<String, InvoiceAttachmentVo> invoiceAttachmentsMap = invoiceAttachments.stream().collect(Collectors.toMap(InvoiceAttachmentVo::getSerialNo, e -> e));
            if (KingdeeInvoiceCloudConfig.syncInvoiceAttachmentToBill() && filePanel != null) {
                if (plugin.isPc()) {
                    List billAttachmentData = filePanel.getAttachmentData();
                    log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5355\u636e\u4e0a\u539f\u6709\u7684\u9644\u4ef6," + SerializationUtils.toJsonString((Object)billAttachmentData));
                    Map<String, Map> billAttachmentMap = billAttachmentData.stream().filter(e -> e != null && StringUtils.startsWith((CharSequence)((String)e.get("uid")), (CharSequence)"rc-upload-ia-")).collect(Collectors.toMap(e -> (String)e.get("uid"), e -> e));
                    HashSet<String> uids = new HashSet<String>(billAttachmentMap.keySet());
                    HashSet<String> invoiceAttachmentSerialNos = new HashSet<String>(invoiceAttachmentsMap.keySet());
                    invoiceAttachmentSerialNos.forEach(e -> {
                        Map cfr_ignored_0 = (Map)billAttachmentMap.remove(e);
                    });
                    log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5355\u636e\u4e0a\u9700\u5220\u9664\u6389\u7684\u9644\u4ef6," + SerializationUtils.toJsonString(billAttachmentMap));
                    billAttachmentMap.values().forEach(e -> filePanel.remove(e));
                    uids.forEach(key -> {
                        InvoiceAttachmentVo cfr_ignored_0 = (InvoiceAttachmentVo)invoiceAttachmentsMap.remove(key);
                    });
                }
                log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u672c\u6b21\u8ffd\u52a0\u7684\u9644\u4ef6:" + SerializationUtils.toJsonString(invoiceAttachmentsMap));
                Iterator<Map.Entry<String, InvoiceAttachmentVo>> iterator = invoiceAttachmentsMap.entrySet().iterator();
                ArrayList<Map> newAttachments = new ArrayList<Map>(invoiceAttachmentsMap.size());
                while (iterator.hasNext()) {
                    Map.Entry<String, InvoiceAttachmentVo> invoiceAttachment = iterator.next();
                    InvoiceAttachmentVo attachment = invoiceAttachment.getValue();
                    Map invoiceAttachmentMap = AttachmentUtils.buildInvoiceAttachmentMap((InvoiceAttachmentVo)attachment);
                    if (invoiceAttachmentMap == null || invoiceAttachmentMap.isEmpty()) continue;
                    newAttachments.add(invoiceAttachmentMap);
                }
                filePanel.upload(newAttachments);
                String attachmentPanelId = plugin.getAttachmentPanelId();
                view.updateView(attachmentPanelId);
                if (parentView != null) {
                    parentView.updateView(attachmentPanelId);
                    view.sendFormAction(parentView);
                }
            } else {
                log.info("\u53d1\u7968\u96c6\u6210,AbstractImportInvoicePlugin_getInvoiceAttachments: \u672a\u5f00\u542f\u540c\u6b65\u9644\u4ef6");
            }
            InvoicePluginUtils.updateAttachments((AbstractFormPlugin)plugin, view, plugin.isPc(), invoiceAttachments.stream().map(e -> {
                e.setSerialNo(e.getSerialNo().replace("rc-upload-ia-", ""));
                return e.toAttachVO();
            }).collect(Collectors.toList()));
        }
        catch (Exception e2) {
            view.showTipNotification(e2.getMessage());
            log.error("\u53d1\u7968\u96c6\u6210,AbstractImportInvoicePlugin_getInvoiceAttachments: \u4ece\u53d1\u7968\u4e91\u62c9\u53d6\u9644\u4ef6\u5931\u8d25: ", (Throwable)e2);
        }
        log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f");
    }

    public static void updateAttachments(AbstractFormPlugin plugin, IFormView view, boolean replaceAll, List<AttachVo> attachVos) {
        InvoicePluginUtils.updateAttachments(plugin, view, replaceAll, attachVos, false);
    }

    public static void updateAttachments(AbstractFormPlugin plugin, IFormView view, boolean replaceAll, List<AttachVo> attachVos, boolean tempDetelteAttachment) {
        log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5f00\u59cb" + SerializationUtils.toJsonString(attachVos));
        try {
            DynamicObjectCollection attachEntries;
            String attachEntryId;
            int level;
            boolean syncToBill = KingdeeInvoiceCloudConfig.syncInvoiceAttachmentToBill();
            String attachPanelId = "attachmentpanel";
            if (plugin instanceof AbstractImportInvoicePlugin) {
                attachPanelId = ((AbstractImportInvoicePlugin)plugin).getAttachmentPanelId();
            }
            IFormView viewWithPanel = view;
            AttachmentPanel filePanel = (AttachmentPanel)viewWithPanel.getControl(attachPanelId);
            for (level = 1; filePanel == null && level <= 3 && (viewWithPanel = viewWithPanel.getViewNoPlugin(viewWithPanel.getFormShowParameter().getParentPageId())) != null; ++level) {
                filePanel = (AttachmentPanel)viewWithPanel.getControl(attachPanelId);
            }
            log.info(String.format("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5f53\u524d\u4e3a %d \u7ea7\u660e\u7ec6\u754c\u9762\u5bfc\u5165\u53d1\u7968", level));
            if (filePanel == null) {
                return;
            }
            IDataModel model = viewWithPanel.getModel();
            boolean hasAttachEntry = model.getProperty(attachEntryId = "invoiceattachinfo") != null;
            List attachments = attachVos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getAttachNo())).collect(Collectors.toList());
            Set importAttachNos = attachments.stream().map(e -> e.getAttachNo()).collect(Collectors.toSet());
            if (replaceAll) {
                if (hasAttachEntry) {
                    attachEntries = model.getEntryEntity(attachEntryId);
                    HashMap attachNoIndexes = new HashMap(attachEntries.size());
                    Set attachNosToRemove = attachEntries.stream().map(m -> m.getString("attachno")).collect(Collectors.toSet());
                    attachNosToRemove.removeAll(importAttachNos);
                    log.info("\u540c\u6b65\u9644\u4ef6\uff0c\u5bf9\u6bd4\u540e\u8981\u5220\u9664\u7684\u9644\u4ef6\u5e8f\u5217\u53f7 :" + attachNosToRemove);
                    HashSet<Integer> indexesToRemove = new HashSet<Integer>(attachNosToRemove.size());
                    for (int i = 0; i < attachEntries.size(); ++i) {
                        if (!attachNosToRemove.contains(((DynamicObject)attachEntries.get(i)).getString("attachno"))) continue;
                        indexesToRemove.add(i);
                    }
                    log.info("\u540c\u6b65\u9644\u4ef6\uff0c\u5bf9\u6bd4\u540e\u8981\u5220\u9664\u7684\u9644\u4ef6\u5206\u5f55\u884c\u53f7 :" + indexesToRemove);
                    if (indexesToRemove.size() > 0) {
                        model.deleteEntryRows(attachEntryId, indexesToRemove.stream().mapToInt(Integer::intValue).toArray());
                        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
                            IPageCache pageCache = viewWithPanel.getPageCache();
                            String attachnos = pageCache.get("cache_attachno_bydelete_invoice");
                            Set oldAttachnos = new HashSet(0);
                            if (StringUtils.isNotBlank((CharSequence)attachnos)) {
                                oldAttachnos = (Set)JSON.parseObject((String)attachnos, Set.class);
                            }
                            attachNosToRemove.addAll(oldAttachnos);
                            pageCache.put("cache_attachno_bydelete_invoice", SerializationUtils.toJsonString((Object)attachNosToRemove));
                        }
                    }
                }
                if (syncToBill) {
                    List billAttachmentData = filePanel.getAttachmentData();
                    ArrayList removeResults = Lists.newArrayListWithExpectedSize((int)billAttachmentData.size());
                    for (Map billAttach : billAttachmentData) {
                        String uid = (String)billAttach.get("uid");
                        if (!AttachmentCountUtils.isInvoiceAttach((String)uid)) continue;
                        String attachNo = AttachmentCountUtils.getRealAttachNo((String)uid);
                        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() && tempDetelteAttachment && !importAttachNos.contains(attachNo)) {
                            removeResults.add(billAttach);
                            continue;
                        }
                        if (importAttachNos.contains(attachNo)) continue;
                        filePanel.remove(billAttach);
                    }
                    if (removeResults.size() > 0) {
                        DeleteAttachmentByDeleteInvoiceUtil.removeAttachmentByInvoice(viewWithPanel, filePanel, removeResults);
                    }
                }
            }
            if (hasAttachEntry) {
                attachEntries = model.getEntryEntity(attachEntryId);
                Set attachNoLeft = attachEntries.stream().map(e -> e.getString("attachno")).collect(Collectors.toSet());
                List attachmentsToAdd = attachments.stream().filter(e -> !attachNoLeft.contains(e.getAttachNo())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(attachmentsToAdd)) {
                    int[] addedIndexes = model.batchCreateNewEntryRow(attachEntryId, attachmentsToAdd.size());
                    DataEntityPropertyCollection properties = model.getDataEntity().getDynamicObjectCollection("invoiceattachinfo").getDynamicObjectType().getProperties();
                    boolean existAttachSerialno = properties.containsKey((Object)"attachserialno");
                    for (int i = 0; i < attachmentsToAdd.size(); ++i) {
                        AttachVo attachData = (AttachVo)attachmentsToAdd.get(i);
                        int index = addedIndexes[i];
                        model.setValue("attachno", (Object)attachData.getAttachNo(), index);
                        model.setValue("attachname", (Object)attachData.getAttachName(), index);
                        model.setValue("originalname", (Object)attachData.getOriginalName(), index);
                        model.setValue("attachremark", (Object)attachData.getRemark(), index);
                        model.setValue("gathertime", (Object)attachData.getGatherTime(), index);
                        model.setValue("attachtype", (Object)attachData.getAttachType(), index);
                        model.setValue("attachurl", (Object)attachData.getAttachUrl(), index);
                        if (!existAttachSerialno) continue;
                        model.setValue("attachserialno", (Object)attachData.getSerialNo(), index);
                    }
                }
            }
            if (syncToBill) {
                Set attachNoLeft = AttachmentCountUtils.getInvoiceAttachmentSerialNoSet((AttachmentPanel)filePanel);
                List attachmentsToAdd = attachments.stream().filter(e -> !attachNoLeft.contains(e.getAttachNo())).collect(Collectors.toList());
                log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u672c\u6b21\u8ffd\u52a0\u7684\u9644\u4ef6:" + SerializationUtils.toJsonString(attachmentsToAdd));
                ArrayList newAttachmentDatas = Lists.newArrayListWithExpectedSize((int)attachmentsToAdd.size());
                long currentTimeMillis = System.currentTimeMillis();
                for (AttachVo attachDataFromInvoiceCloud : attachmentsToAdd) {
                    AttachmentData attachmentDataForUpload = new AttachmentData();
                    attachmentDataForUpload.setBillPkId(String.valueOf(model.getDataEntity().getPkValue()));
                    String attachmentName = attachDataFromInvoiceCloud.getAttachName();
                    String type = "";
                    String attachUrl = attachDataFromInvoiceCloud.getAttachUrl();
                    if (StringUtils.isNotBlank((CharSequence)attachUrl)) {
                        int lastIndexOfDot = attachUrl.lastIndexOf(46);
                        if (lastIndexOfDot >= 0) {
                            type = attachUrl.substring(lastIndexOfDot + 1);
                        } else {
                            String decodeUrl = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(attachUrl);
                            lastIndexOfDot = decodeUrl.lastIndexOf(46);
                            if (lastIndexOfDot >= 0) {
                                type = decodeUrl.substring(lastIndexOfDot + 1);
                            }
                        }
                    }
                    if (!AttachmentUtils.AttType.isValid((String)type)) {
                        type = AttachmentUtils.AttType.getExtByType((String)attachDataFromInvoiceCloud.getAttachType());
                    }
                    attachmentDataForUpload.setType(type);
                    if (!attachmentName.endsWith("." + type)) {
                        attachmentName = attachmentName + "." + type;
                    }
                    attachmentDataForUpload.setName(attachmentName);
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    InputStream inputStream = attachmentFileService.getInputStream(attachDataFromInvoiceCloud.getAttachUrl());
                    try {
                        byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                        String filePath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000);
                        attachmentDataForUpload.setUrl(filePath);
                        attachmentDataForUpload.setSize((long)bytes.length);
                    }
                    catch (IOException e2) {
                        log.error("\u53d1\u7968\u96c6\u6210,", (Throwable)e2);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u4ece\u53d1\u7968\u4e91\u62c9\u53d6\u9644\u4ef6\u5931\u8d25\u3002", (String)"AbstractImportInvoicePlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    attachmentDataForUpload.setClient("web");
                    attachmentDataForUpload.setUid(AttachmentCountUtils.getAttachmentUidPrefix() + attachDataFromInvoiceCloud.getAttachNo());
                    attachmentDataForUpload.setEntityNum(model.getDataEntityType().getName());
                    attachmentDataForUpload.setStatus("success");
                    attachmentDataForUpload.setLastModified(currentTimeMillis);
                    attachmentDataForUpload.setCreatedate(currentTimeMillis);
                    newAttachmentDatas.add((Map)JSON.toJSON((Object)attachmentDataForUpload));
                }
                filePanel.upload((List)newAttachmentDatas);
                viewWithPanel.updateView(attachPanelId);
            }
            if (level != 1) {
                view.sendFormAction(viewWithPanel);
            }
        }
        catch (Exception e3) {
            log.error("\u53d1\u7968\u96c6\u6210,AbstractImportInvoicePlugin_getInvoiceAttachments: \u4ece\u53d1\u7968\u4e91\u62c9\u53d6\u9644\u4ef6\u5931\u8d25: ", (Throwable)e3);
        }
        log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f");
    }

    public static Map<String, Object> getAttachmentPanel(AbstractImportInvoicePlugin plugin) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IFormView view = plugin.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        IDataModel model = view.getModel();
        String attachmentPanelId = plugin.getAttachmentPanelId();
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl(attachmentPanelId);
        if (filePanel == null && parentView != null) {
            log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5f53\u524d\u4e3a\u660e\u7ec6\u754c\u9762\u5bfc\u5165\u53d1\u7968");
            model = parentView.getModel();
            filePanel = (AttachmentPanel)parentView.getControl(attachmentPanelId);
            IFormView grandParentView = parentView.getViewNoPlugin(parentView.getFormShowParameter().getParentPageId());
            if (filePanel == null && grandParentView != null) {
                log.info("\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u5f53\u524d\u4e3a\u4e09\u7ea7\u660e\u7ec6\u754c\u9762\u5bfc\u5165\u53d1\u7968");
                model = grandParentView.getModel();
                filePanel = (AttachmentPanel)grandParentView.getControl(attachmentPanelId);
            }
        }
        result.put("model", model);
        result.put("panel", filePanel);
        return result;
    }

    public static void handleDeleteAttachment(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        IFormView view = plugin.getView();
        IPageCache pageCache = view.getPageCache();
        String actionId = !plugin.isPc() ? pageCache.get("invoice.ClickKey") : event.getActionId();
        log.info("\u5220\u9664\u9644\u4ef6\u8fd4\u56de actionId: " + actionId + ", data:" + event.getReturnData());
        InvoiceFormPluginService invoiceFormPluginService = InvoicePluginServiceFactory.getInstance();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"delete_attach_callback_key") || "deleteerattachmentoperate".equals(pageCache.get("deleteerattachmentoperate"))) {
            pageCache.remove("invoice.ClickKey");
            pageCache.remove("deleteerattachmentoperate");
            invoiceFormPluginService.afterDeleteAttachmentPC(plugin, event);
        }
    }

    public static String getOutSideInvoiceSerialNos(String msg) {
        String serialNosStr;
        JSONObject jsonObject = JSON.parseObject((String)msg);
        if (jsonObject.containsKey((Object)"version")) {
            serialNosStr = jsonObject.getString("serialNo");
        } else {
            JSONObject data = jsonObject.getJSONObject("data");
            String extraDataStr = null;
            if (data != null) {
                extraDataStr = data.getString("extraData");
            }
            if (StringUtils.isBlank(extraDataStr)) {
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u672a\u8fd4\u56de\u53d1\u7968\u6570\u636e:" + msg);
                return "";
            }
            Object invoiceDataObj = JSON.parseObject((String)extraDataStr).get((Object)"data");
            if (invoiceDataObj instanceof JSONArray) {
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u672a\u9009\u4e2d\u53d1\u7968:" + msg);
                return "";
            }
            JSONObject invoiceDataJO = (JSONObject)invoiceDataObj;
            serialNosStr = invoiceDataJO.getString("serialNos");
        }
        return serialNosStr;
    }

    public static void executeDevInvoice(Map<String, String> m, AbstractImportInvoicePlugin plugin) {
        String apiReturnJson = m.get("msg");
        IFormView view = plugin.getView();
        try {
            List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
            log.info("\u4e8c\u5f00\u7f13\u5b58\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968json");
            plugin.getAfterSelectInvoicePluginProxy().callReplace(p -> {
                p.cacheJsonFromInvoiceCloud(apiReturnJson);
                return null;
            });
            log.info("end \u4e8c\u5f00\u7f13\u5b58\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968json");
            plugin.executeProcess(invoiceVOs);
        }
        catch (InvoiceCloudException e) {
            log.error((Throwable)e);
            view.showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            throw new KDException(ThrowableHelper.toString((Exception)e));
        }
    }

    public static QueryInvoiceDetailBO buildQueryInvoiceDetailBO(AbstractImportInvoicePlugin plugin, String serialNosStr) {
        IFormView view = plugin.getView();
        DynamicObject costCompanyDO = plugin.getCostCompanyDO();
        QueryInvoiceDetailBO queryInvoiceDetailBO = QueryInvoiceDetailBO.buildQueryInvoiceDetailBO((DynamicObject)costCompanyDO, (String)serialNosStr);
        queryInvoiceDetailBO.setBxdKey(APIHelper.getBillNoCachedInCloud((DynamicObject)plugin.getExtView().getModel().getDataEntity()));
        queryInvoiceDetailBO.setView(view);
        return queryInvoiceDetailBO;
    }

    public static void mobTest(AbstractImportInvoicePlugin plugin, Object returnData) {
        ListSelectedRowCollection lsrc;
        if (returnData instanceof ListSelectedRowCollection && (lsrc = (ListSelectedRowCollection)returnData) != null && !lsrc.isEmpty()) {
            DynamicObject invoiceData = BusinessDataServiceHelper.loadSingle((Object)lsrc.get(0).getPrimaryKeyValue(), (String)"er_invoicedata_pre");
            String invoiceJson = invoiceData.getString("invoicejson_tag");
            try {
                JSONObject jsonObject;
                JSONArray invoiceDataJsonArray;
                List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)invoiceJson);
                if (CollectionUtils.isEmpty((Collection)invoiceVOs) && (invoiceDataJsonArray = (jsonObject = JSONObject.parseObject((String)invoiceJson)).getJSONArray("invoiceData")) != null) {
                    invoiceVOs = invoiceDataJsonArray.toJavaList(InvoiceVO.class);
                }
                plugin.executeProcess(invoiceVOs);
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
                plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u4ece\u5916\u90e8\u5bfc\u5165\u53d1\u7968\u5f02\u5e38\uff1a%1$s\u3002", (String)"AbstractImportInvoicePlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), e1.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importInvoiceForQuickReim(AbstractImportInvoicePlugin plugin) {
        IFormView view = plugin.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        if (InvoicePackageUtil.checkPackageSign((AbstractFormPlugin)plugin)) {
            block9: {
                try {
                    String selectInvoiceStr = (String)showParameter.getCustomParam("selectedInvoiceInfoBo");
                    if (!StringUtils.isNotBlank((CharSequence)selectInvoiceStr)) break block9;
                    SelectedInvoiceInfoBO selectedInvoiceInfoBO = (SelectedInvoiceInfoBO)JSON.parseObject((String)selectInvoiceStr, SelectedInvoiceInfoBO.class);
                    List invoiceVOs = selectedInvoiceInfoBO.getInvoiceVOs();
                    if (invoiceVOs != null && !invoiceVOs.isEmpty()) {
                        InvoicePackageUtil.initPackageFormData((AbstractFormPlugin)plugin);
                        plugin.executeProcess(invoiceVOs);
                    }
                    List attachmentVOs = selectedInvoiceInfoBO.getAttachmentVOs();
                    List attachData = selectedInvoiceInfoBO.getAttachData();
                    if (!CollectionUtils.isEmpty((Collection)attachmentVOs)) {
                        ArrayList<Map> newAttachment = new ArrayList<Map>(attachmentVOs.size());
                        for (InvoiceAttachmentVo attachment : attachmentVOs) {
                            Map invoiceAttachmentMap = AttachmentUtils.buildInvoiceAttachmentMap((InvoiceAttachmentVo)attachment);
                            if (invoiceAttachmentMap == null || invoiceAttachmentMap.isEmpty()) continue;
                            newAttachment.add(invoiceAttachmentMap);
                        }
                        Map<String, Object> attachmentPanel = InvoicePluginUtils.getAttachmentPanel(plugin);
                        AttachmentPanel filePanel = (AttachmentPanel)attachmentPanel.get("panel");
                        filePanel.upload(newAttachment);
                        String attachmentPanelId = plugin.getAttachmentPanelId();
                        view.updateView(attachmentPanelId);
                        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
                        if (parentView != null) {
                            parentView.updateView(attachmentPanelId);
                            view.sendFormAction(parentView);
                        }
                        break block9;
                    }
                    if (CollectionUtils.isEmpty((Collection)attachData)) break block9;
                    InvoicePluginUtils.saveAttachment(plugin, view, attachData);
                }
                catch (Exception ept) {
                    try {
                        log.error("\u3010\u4e00\u952e\u62a5\u9500\u3011\u5f02\u5e38\uff1a", (Throwable)ept);
                        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u5f02\u5e38\uff1a%s", (String)"QuickReimUtil_0", (String)"fi-er-business", (Object[])new Object[0]), ept));
                    }
                    catch (Throwable throwable) {
                        view.setVisible(Boolean.FALSE, new String[]{"lb_change"});
                        InvoicePackageUtil.clearPackageSign((AbstractFormPlugin)plugin);
                        throw throwable;
                    }
                    view.setVisible(Boolean.FALSE, new String[]{"lb_change"});
                    InvoicePackageUtil.clearPackageSign((AbstractFormPlugin)plugin);
                }
            }
            view.setVisible(Boolean.FALSE, new String[]{"lb_change"});
            InvoicePackageUtil.clearPackageSign((AbstractFormPlugin)plugin);
        }
    }

    public static void updateInvoiceLabel(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        int invoiceCount = invoiceEntryDOs.stream().mapToInt(invoiceHead -> invoiceHead.getInt("count")).sum();
        BigDecimal invoiceTotalAmount = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Label countLab = (Label)view.getControl("lbl_invoicecount");
        Label amountLab = (Label)view.getControl("lbl_totalamount");
        countLab.setText(String.valueOf(invoiceCount));
        Integer amtprecision = 4;
        String sign = "\uffe5";
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject company = (DynamicObject)model.getValue("company");
        Long invoiceEntryCurrency = SystemParamterUtil.getInvoiceEntryCurrency((Long)((Long)company.getPkValue()));
        if (invoiceEntryCurrency != null && !currency.getPkValue().equals(invoiceEntryCurrency)) {
            model.setValue("iscurrency", (Object)true);
            String selectPropties = "id,createorg,number,name,enable,sign,amtprecision";
            DynamicObject invoiceCurrency = BusinessDataServiceHelper.loadSingle((Object)invoiceEntryCurrency, (String)"bd_currency", (String)selectPropties);
            if (invoiceCurrency != null) {
                sign = invoiceCurrency.getString("sign");
                amtprecision = invoiceCurrency.getInt("amtprecision");
            }
        } else {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceTotalAmount);
        amountLab.setText(formatMoneyByUser);
    }
}

