/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.tripbusi;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;

public class ImportInvoiceForTripReimPCSupplementPlugin
extends AbstractBillPlugIn {
    private static final String SAVESUPPLEMENTINVOICE = "saveinvoice";
    private static final String CLOSE = "close";
    private static final String IMPORTINVOICE = "importInvoice";
    private static final String DELETEINVOICE = "deleteInvoice";
    private static final Set<String> LOCKSUPPLEMENTSTATUSSET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D", "H", "I"}));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getControl("advcontoolbarap31") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap31"});
        }
        this.addItemClickListeners(new String[]{"supplementinvoice"});
    }

    public void afterBindData(EventObject e) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl("invoice_entry_container");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needsuppleinvoice) {
            invoiceAdvContainer.setCollapse(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"automapinvoice") && ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
            this.getModel().setValue("needsuppleinvoice", (Object)false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"supplementinvoice")) {
            this.showTripSupPage();
        }
    }

    private void showTripSupPage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "er_tripinvoicesup");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setCustomParam("TRIP_COUNT", (Object)this.getModel().getEntryRowCount("tripentry"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "supplementinvoice"));
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CLOSE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(SAVESUPPLEMENTINVOICE, "true");
                operateOption.setVariableValue(CLOSE, "true");
                this.getView().invokeOperation(SAVESUPPLEMENTINVOICE, operateOption);
            } else {
                this.getPageCache().put(CLOSE, CLOSE);
            }
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        StringBuilder info = this.invoiceChangeInfo();
        if (info.length() != 0) {
            info.append(",").append(ResManager.loadKDString((String)"\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u786e\u5b9a\u662f\u5426\u4fdd\u5b58\u4fee\u6539\u3002", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            String close = this.getPageCache().get(CLOSE);
            if (close == null) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
                this.getView().showConfirm(info.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                e.setCancel(true);
            } else {
                if (!StringUtils.equals((CharSequence)close, (CharSequence)CLOSE)) {
                    e.setCancel(true);
                }
                this.getPageCache().remove(CLOSE);
            }
        }
    }

    protected StringBuilder invoiceChangeInfo() {
        StringBuilder info = new StringBuilder();
        if (this.isImportInvoice()) {
            info.append(ResManager.loadKDString((String)"\u5df2\u5bfc\u5165\u53d1\u7968", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (this.isDeleteInvoice()) {
            if (info.length() != 0) {
                info = new StringBuilder();
                info.append(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u5df2\u4fee\u6539\u3002", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                info.append(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u53d1\u7968", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        return info;
    }

    protected boolean isImportInvoice() {
        String importInvoiceType = this.getPageCache().get(IMPORTINVOICE);
        return StringUtils.equals((CharSequence)importInvoiceType, (CharSequence)"1");
    }

    protected boolean isDeleteInvoice() {
        String deleteInvoiceType = this.getPageCache().get(DELETEINVOICE);
        return StringUtils.equals((CharSequence)deleteInvoiceType, (CharSequence)"1");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)SAVESUPPLEMENTINVOICE)) {
            if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.setDeleteInvoice(false);
                this.setImportInvoice(false);
            } else if (Boolean.parseBoolean((String)((Save)afterDoOperationEventArgs.getSource()).getOption().getVariables().get(SAVESUPPLEMENTINVOICE))) {
                this.getPageCache().put(CLOSE, "noClose");
            }
        }
    }

    protected void setImportInvoice(boolean bool) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needsuppleinvoice) {
            this.getPageCache().put(IMPORTINVOICE, bool ? "1" : "0");
        }
    }

    protected void setDeleteInvoice(boolean bool) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needsuppleinvoice) {
            this.getPageCache().put(DELETEINVOICE, bool ? "1" : "0");
        }
    }
}

