/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.voucher;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.provider.param.req.SaveVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.SaveVoucherResp;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceVoucherUpdateFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewStatus(true);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean pass = true;
        switch (itemKey) {
            case "commit": {
                pass = this.checkCommitData();
                break;
            }
            case "queryvoucherinfo": {
                pass = this.checkQueryVoucherData();
            }
        }
        evt.setCancel(!pass);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "queryvoucherinfo": {
                this.queryVoucher();
                break;
            }
            case "queryhistory": {
                this.getModel().deleteEntryData("updateentryentity");
                this.queryHistory();
                this.setViewStatus(false);
                break;
            }
            case "commit": {
                this.commitVoucher();
                break;
            }
            case "back": {
                this.getModel().deleteEntryData("updateentryentity");
                this.setViewStatus(true);
                break;
            }
        }
    }

    private boolean checkQueryVoucherData() {
        DynamicObjectCollection updateEntry = this.getModel().getEntryEntity("updateentryentity");
        for (int index = 0; index < updateEntry.size(); ++index) {
            String billNo = (String)this.getModel().getValue("billno", index);
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", index);
            if (!StringUtils.isEmpty((CharSequence)billNo) && billType != null) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCommitData() {
        DynamicObjectCollection updateEntry = this.getModel().getEntryEntity("updateentryentity");
        for (int index = 0; index < updateEntry.size(); ++index) {
            Long billId = (Long)this.getModel().getValue("billid", index);
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", index);
            Date accountDay = (Date)this.getModel().getValue("accountday", index);
            Date accountDate = (Date)this.getModel().getValue("accountdate", index);
            Date businessDate = (Date)this.getModel().getValue("businessdate", index);
            String voucherId = (String)this.getModel().getValue("voucherid", index);
            if (billId == null || billId == 0L || billType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (accountDay == null || accountDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u8d26\u5c5e\u671f\u6216\u5165\u8d26\u65f6\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (businessDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)voucherId)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void queryVoucher() {
        VoucherUpgradeModel upgradeModel;
        int oldDataCount = 0;
        int size = this.getModel().getEntryRowCount("updateentryentity");
        ArrayList<VoucherUpgradeModel> voucherModels = new ArrayList<VoucherUpgradeModel>();
        for (int index = 0; index < size; ++index) {
            QFilter qFilter;
            DynamicObject updateObject = this.getModel().getEntryRowEntity("updateentryentity", index);
            String status = updateObject.getString("status");
            if (StringUtils.isNotEmpty((CharSequence)status)) {
                upgradeModel = this.buildUpgradeModel(updateObject);
                voucherModels.add(upgradeModel);
                continue;
            }
            DynamicObject billType = updateObject.getDynamicObject("billtype");
            String billNo = updateObject.getString("billno");
            if (billType == null || StringUtils.isEmpty((CharSequence)billNo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u586b\u5199\u5355\u636e\u7c7b\u578b\u548c\u5355\u636e\u7f16\u53f7\u3002", (String)"InvoiceVoucherUpdateFormPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityId = billType.getString("number");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityId, (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("billno", "=", (Object)billNo)});
            if (dynamicObjects.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a%s \u5b58\u5728\u76f8\u540c\u7684\u5355\u636e\u7f16\u53f7\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), entityId));
                return;
            }
            if (dynamicObjects.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a%1$s \u672a\u67e5\u8be2\u5230\u5355\u636e\u7f16\u53f7\u4e3a %2$s \u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), entityId, billNo));
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            Long pkValue = dynamicObject.getLong("id");
            QFilter idFilter = new QFilter("sourcebillid", "=", (Object)pkValue);
            DynamicObjectCollection voucherDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype, sourcebillid, voucherid", (QFilter[])new QFilter[]{idFilter});
            List voucherIds = voucherDaps.stream().map(dap -> dap.getLong("voucherid")).collect(Collectors.toList());
            QFilter voucherIdFilter = new QFilter("id", "in", voucherIds);
            DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id, billno, period.number, bizdate, bookeddate", (QFilter[])new QFilter[]{voucherIdFilter});
            if (vouchers.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a%1$s \u672a\u67e5\u8be2\u5230\u5355\u636e\u7f16\u53f7\u4e3a %2$s \u7684\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), entityId, billNo));
                return;
            }
            Optional<DynamicObject> lastBookDateOpt = vouchers.stream().max(Comparator.comparing(obj -> obj.getDate("bookeddate")));
            Date bookedDate = null;
            if (lastBookDateOpt.isPresent()) {
                DynamicObject lastBookDateObj = lastBookDateOpt.get();
                bookedDate = lastBookDateObj.getDate("bookeddate");
            }
            Optional<DynamicObject> lastBizDateOpt = vouchers.stream().max(Comparator.comparing(obj -> obj.getDate("bizdate")));
            Date bizDate = null;
            if (lastBizDateOpt.isPresent()) {
                DynamicObject lastBizDateObj = lastBizDateOpt.get();
                bizDate = lastBizDateObj.getDate("bizdate");
            }
            for (DynamicObject voucherDy : vouchers) {
                VoucherUpgradeModel voucherUpgradeModel = this.buildUpgradeModel(voucherDy, pkValue, billNo, billType, bookedDate, bizDate);
                voucherModels.add(voucherUpgradeModel);
            }
        }
        if (!voucherModels.isEmpty() && voucherModels.size() != 0) {
            this.getModel().deleteEntryData("updateentryentity");
            int[] createEntryRows = this.getModel().batchCreateNewEntryRow("updateentryentity", voucherModels.size() - oldDataCount);
            long[] pkIds = ORM.create().genLongIds("er_invoicevoucher_up", voucherModels.size());
            for (int voucherIndex = 0; voucherIndex < voucherModels.size(); ++voucherIndex) {
                upgradeModel = (VoucherUpgradeModel)voucherModels.get(voucherIndex);
                this.getModel().setValue("id", (Object)pkIds[voucherIndex], createEntryRows[voucherIndex]);
                this.getModel().setValue("billid", (Object)upgradeModel.getBillId(), createEntryRows[voucherIndex]);
                this.getModel().setValue("billno", (Object)upgradeModel.getBillNo(), createEntryRows[voucherIndex]);
                this.getModel().setValue("billtype", (Object)upgradeModel.getBillTypeId(), createEntryRows[voucherIndex]);
                this.getModel().setValue("accountday", (Object)upgradeModel.getAccountDay(), createEntryRows[voucherIndex]);
                this.getModel().setValue("accountdate", (Object)upgradeModel.getAccountDate(), createEntryRows[voucherIndex]);
                this.getModel().setValue("businessdate", (Object)upgradeModel.getBusinessDate(), createEntryRows[voucherIndex]);
                this.getModel().setValue("voucherid", (Object)upgradeModel.getVoucherId(), createEntryRows[voucherIndex]);
                this.getModel().setValue("voucherno", (Object)upgradeModel.getVoucherNo(), createEntryRows[voucherIndex]);
                this.getModel().setValue("updatetime", (Object)upgradeModel.getUpdateTime(), createEntryRows[voucherIndex]);
                this.getModel().setValue("status", (Object)upgradeModel.getStatus(), createEntryRows[voucherIndex]);
                this.getModel().setValue("userid", (Object)upgradeModel.getUserId(), createEntryRows[voucherIndex]);
            }
        }
    }

    private void commitVoucher() {
        DynamicObjectCollection updateEntry = this.getModel().getEntryEntity("updateentryentity");
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>(updateEntry.size());
        String insertSql = "INSERT INTO T_ER_INVVOUCHERUP(FID,FBILLTYPE,FBILLNO,FBILLID,FACCOUNTDAY,FACCOUNTDATE,FBUSINESSDATE,FVOUCHERNO,FVOUCHERID,FUPDATETIME,FUSERID,FSTATUS) VALUES(?,?,?,?,?,?,?,?,?,?,?,?);";
        long[] Ids = DB.genLongIds((String)"T_ER_INVVOUCHERUP", (int)updateEntry.size());
        int successCount = 0;
        int failCount = 0;
        for (int i = 0; i < updateEntry.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)updateEntry.get(i);
            if ("1".equals(dynamicObject.getString("status"))) continue;
            Object[] objArgs = new Object[12];
            DynamicObject billType = dynamicObject.getDynamicObject("billtype");
            String entityId = billType.getString("number");
            String billId = dynamicObject.getString("billid");
            ArrayList<String> billIds = new ArrayList<String>(1);
            billIds.add(billId);
            String billNo = dynamicObject.getString("billno");
            QFilter billIdFilter = new QFilter("id", "=", (Object)Long.parseLong(billId));
            String costCompanyField = "costcompany";
            if (ErEntityTypeUtils.isCheckingpayBill((String)entityId)) {
                costCompanyField = "company";
            }
            String selectFields = String.format("id, %s.id as %s,invoiceentry.serialno", costCompanyField, costCompanyField);
            DynamicObjectCollection invoiceSerialNos = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{billIdFilter});
            Long invoiceOrgId = ((DynamicObject)invoiceSerialNos.get(0)).getLong(costCompanyField);
            List serialNos = invoiceSerialNos.stream().map(obj -> obj.getString("invoiceentry.serialno")).collect(Collectors.toList());
            SaveVoucherRequestParam saveRequestParam = new SaveVoucherRequestParam();
            saveRequestParam.setEntityName(entityId);
            saveRequestParam.setExpenseIdArray(billIds);
            saveRequestParam.setSerialNoArray(serialNos);
            saveRequestParam.setInvoiceOrgId(invoiceOrgId);
            long id = Ids[i];
            Date accountDate = dynamicObject.getDate("accountdate");
            Date businessDate = dynamicObject.getDate("businessdate");
            String voucherId = dynamicObject.getString("voucherid");
            String voucherNo = dynamicObject.getString("voucherno");
            Date updateTime = new Date();
            long userId = RequestContext.get().getCurrUserId();
            String status = "1";
            SaveVoucherRequestParam.VoucherInfo voucherInfo = new SaveVoucherRequestParam.VoucherInfo();
            voucherInfo.setAccountDate(accountDate);
            voucherInfo.setBusinessDate(businessDate);
            voucherInfo.setVouchId(voucherId);
            voucherInfo.setVouchNo(voucherNo);
            saveRequestParam.setVoucherInfo(voucherInfo);
            SaveVoucherResp saveVoucherResp = InvoiceService.getInstanceService().saveVoucherToInvoiceCloud(saveRequestParam, null);
            if (!"0000".equals(saveVoucherResp.getErrcode())) {
                status = "0";
                ++failCount;
            }
            this.getModel().setValue("status", (Object)status, i);
            this.getModel().setValue("updatetime", (Object)updateTime, i);
            objArgs[0] = id;
            objArgs[1] = billType.get("id");
            objArgs[2] = billNo;
            objArgs[3] = Long.parseLong(billId);
            objArgs[4] = accountDate;
            objArgs[5] = accountDate;
            objArgs[6] = businessDate;
            objArgs[7] = voucherNo;
            objArgs[8] = Long.parseLong(voucherId);
            objArgs[9] = updateTime;
            objArgs[10] = userId;
            objArgs[11] = status;
            batchArgs.add(objArgs);
        }
        if (batchArgs.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceVoucherUpdateFormPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), successCount, failCount));
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)insertSql, batchArgs);
        successCount = updateEntry.size() - failCount;
        if (successCount != 0 || failCount != 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u66f4\u65b0\u5168\u7968\u6c60\u51ed\u8bc1\u4fe1\u606f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"InvoiceVoucherUpdateFormPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]), successCount, failCount));
        }
    }

    private void setViewStatus(boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"queryvoucherinfo", "commit", "queryhistory", "newrow", "deleterow"});
        this.getView().setVisible(Boolean.valueOf(!isVisible), new String[]{"back"});
        this.getView().setEnable(Boolean.valueOf(isVisible), new String[]{"updateentryentity"});
        HashMap<String, String> nameArg = new HashMap<String, String>();
        if (isVisible) {
            nameArg.put("zh_CN", ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u636e", (String)"InvoiceVoucherUpdateFormPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            nameArg.put("zh_CN", ResManager.loadKDString((String)"\u67e5\u8be2\u5347\u7ea7\u5386\u53f2", (String)"InvoiceVoucherUpdateFormPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, HashMap<String, String>> textMap = new HashMap<String, HashMap<String, String>>();
        textMap.put("text", nameArg);
        this.getView().updateControlMetadata("advconap", textMap);
    }

    private void queryHistory() {
        ArrayList vouchers = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)"SELECT FID,FBILLTYPE,FBILLNO,FBILLID,FACCOUNTDAY,FACCOUNTDATE,FBUSINESSDATE,FVOUCHERNO,FVOUCHERID,FUPDATETIME,FUSERID,FSTATUS FROM T_ER_INVVOUCHERUP", resultSet -> {
            while (resultSet.next()) {
                VoucherUpgradeModel voucher = new VoucherUpgradeModel();
                voucher.setId(resultSet.getLong("fid"));
                voucher.setBillTypeId(resultSet.getString("FBILLTYPE"));
                voucher.setBillNo(resultSet.getString("FBILLNO"));
                voucher.setBillId(resultSet.getLong("FBILLID"));
                voucher.setAccountDay(resultSet.getDate("FACCOUNTDAY"));
                voucher.setAccountDate(resultSet.getDate("FACCOUNTDATE"));
                voucher.setBusinessDate(resultSet.getDate("FBUSINESSDATE"));
                voucher.setVoucherNo(resultSet.getString("FVOUCHERNO"));
                voucher.setVoucherId(resultSet.getLong("FVOUCHERID"));
                voucher.setUpdateTime(resultSet.getTimestamp("FUPDATETIME"));
                voucher.setUserId(resultSet.getLong("FUSERID"));
                voucher.setStatus(resultSet.getString("FSTATUS"));
                vouchers.add(voucher);
            }
            return null;
        });
        if (vouchers.isEmpty()) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow("updateentryentity", vouchers.size());
        for (int i = 0; i < vouchers.size(); ++i) {
            VoucherUpgradeModel voucher = (VoucherUpgradeModel)vouchers.get(i);
            this.getModel().setValue("id", (Object)voucher.getId(), rows[i]);
            this.getModel().setValue("billtype", (Object)voucher.getBillTypeId(), rows[i]);
            this.getModel().setValue("billno", (Object)voucher.getBillNo(), rows[i]);
            this.getModel().setValue("billid", (Object)voucher.getBillId(), rows[i]);
            this.getModel().setValue("accountday", (Object)voucher.getAccountDay(), rows[i]);
            this.getModel().setValue("accountdate", (Object)voucher.getAccountDate(), rows[i]);
            this.getModel().setValue("businessdate", (Object)voucher.getBusinessDate(), rows[i]);
            this.getModel().setValue("voucherno", (Object)voucher.getVoucherNo(), rows[i]);
            this.getModel().setValue("voucherid", (Object)voucher.getVoucherId(), rows[i]);
            this.getModel().setValue("updatetime", (Object)voucher.getUpdateTime(), rows[i]);
            this.getModel().setValue("userid", (Object)voucher.getUserId(), rows[i]);
            this.getModel().setValue("status", (Object)voucher.getStatus(), rows[i]);
        }
    }

    private VoucherUpgradeModel buildUpgradeModel(DynamicObject voucherDy, Long pkValue, String billNo, DynamicObject billType, Date bookedDate, Date bizDate) {
        bookedDate = bookedDate == null ? voucherDy.getDate("bookeddate") : bookedDate;
        bizDate = bizDate == null ? voucherDy.getDate("bizdate") : bizDate;
        VoucherUpgradeModel model = new VoucherUpgradeModel();
        model.setBillId(pkValue);
        model.setBillNo(billNo);
        model.setBillTypeId(billType.getString("id"));
        model.setAccountDay(bookedDate);
        model.setAccountDate(bookedDate);
        model.setBusinessDate(bizDate);
        model.setVoucherId(voucherDy.getLong("id"));
        model.setVoucherNo(voucherDy.getString("billno"));
        return model;
    }

    private VoucherUpgradeModel buildUpgradeModel(DynamicObject oldData) {
        VoucherUpgradeModel model = new VoucherUpgradeModel();
        model.setId(oldData.getLong("id"));
        model.setBillTypeId(oldData.getDynamicObject("billtype").getString("id"));
        model.setBillNo(oldData.getString("billno"));
        model.setBillId(oldData.getLong("billid"));
        model.setAccountDay(oldData.getDate("accountday"));
        model.setAccountDate(oldData.getDate("accountdate"));
        model.setBusinessDate(oldData.getDate("businessdate"));
        model.setVoucherNo(oldData.getString("voucherno"));
        model.setVoucherId(oldData.getLong("voucherid"));
        model.setUpdateTime(oldData.getDate("updatetime"));
        model.setUserId(oldData.getLong("userid"));
        model.setStatus(oldData.getString("status"));
        return model;
    }

    static class VoucherUpgradeModel {
        private Long id;
        private String billTypeId;
        private String billNo;
        private Long billId;
        private Date accountDay;
        private Date accountDate;
        private Date businessDate;
        private String voucherNo;
        private Long voucherId;
        private Date updateTime;
        private Long userId;
        private String status;

        VoucherUpgradeModel() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getBillTypeId() {
            return this.billTypeId;
        }

        public void setBillTypeId(String billTypeId) {
            this.billTypeId = billTypeId;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public Date getAccountDay() {
            return this.accountDay;
        }

        public void setAccountDay(Date accountDay) {
            this.accountDay = accountDay;
        }

        public Date getAccountDate() {
            return this.accountDate;
        }

        public void setAccountDate(Date accountDate) {
            this.accountDate = accountDate;
        }

        public Date getBusinessDate() {
            return this.businessDate;
        }

        public void setBusinessDate(Date businessDate) {
            this.businessDate = businessDate;
        }

        public String getVoucherNo() {
            return this.voucherNo;
        }

        public void setVoucherNo(String voucherNo) {
            this.voucherNo = voucherNo;
        }

        public Long getVoucherId() {
            return this.voucherId;
        }

        public void setVoucherId(Long voucherId) {
            this.voucherId = voucherId;
        }

        public Date getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Date updateTime) {
            this.updateTime = updateTime;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

