/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mob.costcompany;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.mob.costcompany.ICostCompanyProp;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSecondPageCostCompanyMobPlugin
extends AbstractFormPlugin
implements ICostCompanyProp {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.costDeptF7Filter();
        this.setCostCompanyF7Filter();
    }

    protected void costDeptF7Filter() {
        BasedataEdit entrycostDeptF7 = (BasedataEdit)this.getControl("entrycostdept");
        if (entrycostDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getView());
            entrycostDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("entrycostcompany");
        Object costDept = this.getModel().getValue("entrycostdept");
        Object company = this.getModel().getValue("company");
        if (costCompanyF7 != null && costDept != null) {
            if (this.getView().getEntityId() != null && ErEntityTypeUtils.isReimCtlApplyBill((String)this.getView().getEntityId())) {
                return;
            }
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel pModel = this.getView().getParentView().getModel();
        String billStatus = (String)pModel.getValue("billstatus");
        Object company = pModel.getValue("company");
        if (billStatus != null && StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            this.setCostCompanyEnable(company, 0);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int index = e.getRowDataEntities()[0].getRowIndex();
        IDataModel pModel = this.getView().getParentView().getModel();
        Object company = pModel.getValue("company");
        this.setCostCompanyEnable(company, index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        IDataModel pModel = this.getView().getParentView().getModel();
        String costCompanyshowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView().getParentView());
        Object newValue = e.getChangeSet()[0].getNewValue();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        Integer index = (Integer)customParams.get("index");
        int expenseEntryRowCount = pModel.getEntryRowCount(this.getExpenseEntryName());
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ((StringUtils.equals((CharSequence)name, (CharSequence)"entrycostdept") || StringUtils.equals((CharSequence)name, (CharSequence)"entrycostcompany")) && newValue == null && e.getChangeSet()[0].getOldValue() != null) {
            if (StringUtils.equals((CharSequence)name, (CharSequence)"entrycostcompany") && !ErCostCenterUtil.checkCompanyMode((IFormView)this.getView().getParentView())) {
                model.setValue(name, e.getChangeSet()[0].getOldValue(), rowIndex);
            }
            return;
        }
        switch (name) {
            case "entrycostdept": {
                DynamicObject costCompany = (DynamicObject)model.getValue("entrycostcompany");
                if (costCompany == null) {
                    costCompany = (DynamicObject)pModel.getValue("costcompany");
                }
                DynamicObject company = (DynamicObject)pModel.getValue("company");
                CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, newValue, (Object)costCompany, (Object)company);
                Long costCompanyID = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
                if (!StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"3")) {
                    if (!ErCostCenterUtil.checkCompanyMode((IFormView)this.getView().getParentView())) {
                        model.setValue("entrycostcompany", (Object)costCompanyID, rowIndex);
                    }
                } else if (rowIndex == 0 && (index == null && expenseEntryRowCount == 0 || index != null && index == 0)) {
                    pModel.setValue("costdept", newValue);
                    pModel.updateCache();
                }
                if (StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"2") && (Objects.equals(index, 0) || expenseEntryRowCount <= 0) && rowIndex == 0) {
                    pModel.setValue("costdept", newValue);
                    if (!ErCostCenterUtil.checkCompanyMode((IFormView)this.getView().getParentView())) {
                        pModel.setValue("costcompany", (Object)costCompanyID);
                    }
                    pModel.updateCache();
                    this.processWhenFirstCostCompayChanged(costCompanyID, rowIndex);
                }
                this.checkExpenseItem((DynamicObject)newValue, rowIndex);
                boolean isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)ErCommonUtils.getPk((Object)pModel.getValue("company"))));
                if (isModeOne) break;
                if ("er_contractbill".equals(this.getView().getEntityId())) {
                    ErCostCenterUtil.setCostCenterByCostDept((IFormView)this.getView(), (String)"expenseentryentity1", (DynamicObject)((DynamicObject)newValue), (int)rowIndex, (int)-1);
                    break;
                }
                ErCostCenterUtil.setCostCenterByCostDept((IFormView)this.getView(), (String)"expenseentryentity", (DynamicObject)((DynamicObject)newValue), (int)rowIndex, (int)-1);
                break;
            }
            case "entrycostcompany": {
                DynamicObject curCompany;
                if (!Objects.equals(index, 0) && expenseEntryRowCount > 0 || !StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"2") || rowIndex != 0) break;
                pModel.setValue("costcompany", newValue);
                pModel.updateCache();
                this.processWhenFirstCostCompayChanged(ErCommonUtils.getPk((Object)newValue), rowIndex);
                AmountChangeUtil.updateExpenseDetailAmountLabelForMob((IFormView)this.getView(), (IDataModel)this.getModel());
                Object value = pModel.getValue("costcompany");
                Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)value, (Object)newValue);
                Long oldCurrency = ErCommonUtils.getPk((Object)model.getValue("currency"));
                if (!oldCurrency.equals(baseCurrencyId) && this.getModel().getProperty("expenseentryentity") != null) {
                    String bindDataKey = "ErDailyReimburseExpenseAddEdit-" + this.getView().getEntityId();
                    if (this.getPageCache().get(bindDataKey) == null) {
                        this.getView().close();
                    }
                }
                if ((curCompany = (DynamicObject)this.getView().getModel().getValue("company")) == null) {
                    model.setValue("company", this.getView().getParentView().getModel().getValue("company"));
                }
                ErCostCenterUtil.entryCostCompanyChange((IFormView)this.getView());
                break;
            }
            case "entrycostcenter": 
            case "std_entrycostcenter": {
                boolean isModeOne;
                if (newValue == null || newValue == "" || (isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)ErCommonUtils.getPk((Object)pModel.getValue("company")))))) break;
                ErCostCenterUtil.mobSecondcostEntryCenterChange((IFormView)this.getView(), (Object)newValue, (int)rowIndex);
            }
        }
    }

    protected abstract void checkExpenseItem(DynamicObject var1, int var2);

    @Override
    public abstract String getExpenseEntryName();

    protected void processWhenFirstCostCompayChanged(Long costCompanyID, int rowIndex) {
    }

    private void setCostCompanyEnable(Object company, int index) {
        String enableCostCompanyEdit = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"enablecostcompanyedit");
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)enableCostCompanyEdit)) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"entrycostcompany"});
        } else {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"entrycostcompany"});
        }
    }
}

