/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mob.costcompany;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.web.util.TempCheckExpenseItemUtils;
import kd.fi.er.formplugin.mob.costcompany.AbstractSecondPageCostCompanyMobPlugin;
import org.apache.commons.lang3.StringUtils;

public class SecondPageCostCompanyMobPlugin
extends AbstractSecondPageCostCompanyMobPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reimburser"});
        this.addClickListeners(new String[]{"pubreimburser"});
        if (this.getView().getParentView() != null && this.getView().getParentView().getModel() != null) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            String number = parentModel.getDataEntityType().getName();
            BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl("expenseitem");
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept"));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        block4 : switch (propName) {
            case "reimburser": 
            case "pubreimburser": {
                IDataModel pModel = this.getView().getParentView().getModel();
                String costOrgHeadShow = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
                if (StringUtils.equals((CharSequence)"1", (CharSequence)costOrgHeadShow) || propValue == null) {
                    return;
                }
                if (!((Boolean)this.getModel().getValue("ismultireimburser")).booleanValue()) break;
                Long companyId = ErCommonUtils.getPk((Object)pModel.getValue("company"));
                int multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)companyId);
                switch (multiReimburser) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        DynamicObjectCollection reimburserEntry = ((DynamicObject)propValue).getDynamicObjectCollection("entryentity");
                        Optional<DynamicObject> item = reimburserEntry.stream().filter(row -> !row.getBoolean("ispartjob")).findFirst();
                        item.ifPresent(dyn -> this.getModel().setValue("entrycostdept", (Object)dyn.getDynamicObject("dpt"), valueSet[0].getRowIndex()));
                        break block4;
                    }
                }
                DynamicObjectCollection reimburserEntry = ((DynamicObject)propValue).getDynamicObjectCollection("entryentity");
                List validDpts = reimburserEntry.stream().filter(row -> {
                    long dptId = row.getDynamicObject("dpt").getLong("id");
                    List allSubordinateOrgs = null;
                    if (multiReimburser == 3) {
                        allSubordinateOrgs = OrgUnitServiceHelper.getSubOrgLimitLevel(Collections.singletonList(companyId), (int)1, (boolean)true);
                    }
                    if (multiReimburser == 4) {
                        allSubordinateOrgs = OrgUnitServiceHelper.getSubOrgLimitLevel(Collections.singletonList(dptId), (int)1, (boolean)true);
                    }
                    if (allSubordinateOrgs != null && !allSubordinateOrgs.isEmpty()) {
                        Map allSubordinateOrgsMap = BusinessDataServiceHelper.loadFromCache((Object[])allSubordinateOrgs.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
                        List<String> excludePattren = Arrays.asList("1", "2");
                        return dptId == companyId || allSubordinateOrgsMap.values().stream().filter(org -> !excludePattren.contains(org.getDynamicObject("orgpattern").getString("patterntype"))).map(ErCommonUtils::getPk).collect(Collectors.toSet()).contains(companyId);
                    }
                    return dptId == companyId || OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)dptId).stream().collect(Collectors.toSet()).contains(companyId);
                }).collect(Collectors.toList());
                Map<Boolean, List<DynamicObject>> groupByIspartDeptMap = validDpts.stream().collect(Collectors.partitioningBy(row -> row.getBoolean("ispartjob")));
                if (!groupByIspartDeptMap.get(false).isEmpty()) {
                    this.getModel().setValue("entrycostdept", (Object)groupByIspartDeptMap.get(false).get(0).getDynamicObject("dpt"), valueSet[0].getRowIndex());
                    return;
                }
                if (groupByIspartDeptMap.get(true).isEmpty()) break;
                Optional<DynamicObject> dptOp = groupByIspartDeptMap.get(true).stream().sorted(Comparator.comparing(row -> row.getDynamicObject("dpt").getLong("id"))).findFirst();
                this.getModel().setValue("entrycostdept", (Object)dptOp.get().getDynamicObject("dpt"), valueSet[0].getRowIndex());
                return;
            }
        }
    }

    @Override
    public String getExpenseEntryName() {
        return "expenseentryentity";
    }

    @Override
    public String getExpenseItemKey() {
        return "expenseitem";
    }

    @Override
    protected void processWhenFirstCostCompayChanged(Long costCompanyID, int rowIndex) {
        String itemFrom;
        IDataModel model = this.getModel();
        if (model.getProperty("itemfrom") != null && StringUtils.equals((CharSequence)(itemFrom = (String)model.getValue("itemfrom", rowIndex)), (CharSequence)ItemFrom.InvoiceCloud.getValue()) && !KingdeeInvoiceCloudConfig.isEnabled((long)costCompanyID)) {
            this.getView().close();
        }
    }

    @Override
    protected void checkExpenseItem(DynamicObject costDept, int rowIndex) {
        TempCheckExpenseItemUtils.checkExpenseItemDaily((DynamicObject)costDept, (IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
    }
}

