/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.servicehelper.TrialOrgServiceHelper;
import kd.fi.er.business.utils.ChangeMainOrgUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplierInfoMobPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    private static String BILLTYPE = "billtype";
    private static String APPLIER_ID = "applierId";
    public static final String SWITCH_MAIN_ORG = "switchmainorg";
    public static final String SWITCH_TRIP_TYPE = "switchtriptype";
    private static String CHANGEAPPLIER = "changeapplier";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save"});
        BasedataEdit userEdit = (BasedataEdit)this.getView().getControl("applier");
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        boolean isloan;
        Long curUserId = CommonServiceHelper.getCurrentUserID();
        Long curCompanyId = CommonServiceHelper.getCompanyIdByUserId((Long)curUserId);
        String billtype = (String)this.getModel().getValue("formid");
        if (billtype.equals("er_tripreqbill") && (isloan = ((Boolean)this.getModel().getValue("isloan")).booleanValue())) {
            billtype = "er_loanbill";
        }
        if (CoreBaseBillServiceHelper.isDefaultApplierSelectRangeType((Long)curCompanyId)) {
            this.toDefaultUserSelectView(paramBeforeF7SelectEvent, billtype);
        } else {
            paramBeforeF7SelectEvent.setCancel(true);
            this.toUserSelectList(billtype);
        }
    }

    private void toDefaultUserSelectView(BeforeF7SelectEvent paramBeforeF7SelectEvent, String billtype) {
        FormShowParameter userShow = paramBeforeF7SelectEvent.getFormShowParameter();
        userShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_switchapplier_mb"));
        userShow.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u4eba\u5458\u53ca\u90e8\u95e8", (String)"ApplierInfoMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        userShow.setCustomParam(BILLTYPE, (Object)billtype);
        userShow.setFormId("er_switchapplier_mb");
    }

    private void toUserSelectList(String billtype) {
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setFormId("bos_moblist");
        showParameter.setBillFormId("er_applier_select_mb");
        showParameter.setHasRight(true);
        showParameter.setF7Style(2);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_applier_select_mb"));
        Object applier = this.getModel().getValue("applier");
        Long applierId = applier == null ? Long.valueOf(0L) : (Long)((DynamicObject)applier).getPkValue();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        DynamicObject dept = this.getModel().getDataEntity(true).getDynamicObject("org");
        Long deptId = dept == null ? Long.valueOf(0L) : (Long)dept.getPkValue();
        customParam.put(APPLIER_ID, applierId);
        customParam.put(BILLTYPE, billtype);
        customParam.put("org", deptId);
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get("mscantype"))) {
            customParam.put("mscantype", "mscantype");
        }
        showParameter.setCustomParams(customParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        String mscanType;
        Label orgLabel;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView pview = this.getView().getParentView();
        IDataModel pModel = pview.getModel();
        DynamicObject applier = (DynamicObject)pModel.getValue("applier");
        DynamicObject company = (DynamicObject)pModel.getValue("company");
        DynamicObject dept = (DynamicObject)pModel.getValue("org");
        model.setValue("applier", applier == null ? null : applier.getPkValue());
        model.setValue("applierpositionstr", pModel.getValue("applierpositionstr"));
        model.setValue("org", dept == null ? null : dept.getPkValue());
        model.setValue("company", company == null ? null : company.getPkValue());
        model.setValue("tel", pModel.getValue("tel"));
        DynamicObject org = (DynamicObject)model.getValue("org");
        String orgName = "";
        if (org != null) {
            orgName = org.getString("name");
        }
        if ((orgLabel = (Label)this.getView().getControl("label_orgname")) != null) {
            orgLabel.setText(orgName);
        }
        if (!StringUtils.isEmpty((CharSequence)(mscanType = (String)pview.getFormShowParameter().getCustomParam("mscantype")))) {
            this.getPageCache().put("mscantype", "mscantype");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        this.getModel().setDataChanged(false);
        switch (key) {
            case "btn_save": {
                String billtype = this.getView().getParentView().getEntityId();
                String confirmMessage = ChangeMainOrgUtil.confirmMessage((IDataModel)this.getModel(), (IFormView)this.getView());
                MessageBoxOptions messageBoxOptions = MessageBoxOptions.OKCancel;
                String comfirmKey = SWITCH_MAIN_ORG;
                if (StringUtils.isNotBlank((CharSequence)confirmMessage)) {
                    this.getView().showConfirm(confirmMessage, messageBoxOptions, new ConfirmCallBackListener(comfirmKey, (IFormPlugin)this));
                    return;
                }
                if (!ErEntityTypeUtils.isReimCtlApplyBill((String)billtype)) {
                    DynamicObject payer;
                    IFormView pView = this.getView().getParentView();
                    DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
                    String isgetaccountcurrency = "0";
                    if (this.getModel().getValue("company") != null) {
                        Long companyId = (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue();
                        isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)companyId);
                    }
                    if (pView != null && "1".equals(isgetaccountcurrency) && (ErEntityTypeUtils.isDailyLoanBill((String)pView.getEntityId()) || ErEntityTypeUtils.isDailyReimburseBill((String)pView.getEntityId()) || ErEntityTypeUtils.isTripReimburseBill((String)pView.getEntityId()) || ErEntityTypeUtils.isTripReqBill((String)pView.getEntityId()) || "er_tripreimbill_grid".equals(pView.getEntityId())) && (payer = PayeeServiceHelper.getDefaultAccount((Long)((Long)applier.getPkValue()))) != null && payer.get("currency") == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u4eba\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\u7684\u5e01\u79cd\u3002", (String)"ApplierInfoMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                    if (pView != null && ErEntityTypeUtils.isTripReimburseBill((String)pView.getEntityId())) {
                        Long oldCompanyId = ErCommonUtils.getPk((Object)pView.getModel().getValue("company"));
                        Long newCompanyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                        Long userId = (Long)((DynamicObject)this.getModel().getValue("applier")).getPkValue();
                        if (!TripReimOpenTypeUtils.isSameType((IFormView)pView, (Long)userId, (Long)oldCompanyId, (Long)newCompanyId)) {
                            confirmMessage = ResManager.loadKDString((String)"\u5207\u6362\u7533\u8bf7\u4eba\u540e\uff0c\u7533\u8bf7\u4eba\u516c\u53f8\u7684\u5dee\u65c5\u62a5\u9500\u5355\u586b\u5355\u754c\u9762\u4e0e\u5f53\u524d\u754c\u9762\u4e0d\u540c\uff0c\u7cfb\u7edf\u5c06\u9000\u51fa\u5f53\u524d\u754c\u9762\uff0c\u6253\u5f00\u65b0\u754c\u9762\u3002", (String)"ApplierInfoMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                            messageBoxOptions = MessageBoxOptions.OK;
                            comfirmKey = SWITCH_TRIP_TYPE;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)confirmMessage)) {
                        this.getView().showConfirm(confirmMessage, messageBoxOptions, new ConfirmCallBackListener(comfirmKey, (IFormPlugin)this));
                        break;
                    }
                    this.clickOk();
                    break;
                }
                this.clickOk();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (SWITCH_MAIN_ORG.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.clickOk();
        } else if (SWITCH_TRIP_TYPE.equals(event.getCallBackId())) {
            this.clickOk();
        }
        if (CHANGEAPPLIER.equalsIgnoreCase(event.getCallBackId()) && event.getResult() != MessageBoxResult.Yes) {
            IFormView pview = this.getView().getParentView();
            pview.getModel().setDataChanged(false);
            pview.close();
            this.getView().close();
        }
    }

    private void clickOk() {
        Boolean isTrialorg = TrialOrgServiceHelper.trialControl((String)TrialOrgServiceHelper.getFunction((IFormView)this.getView().getParentView()), null, (Long)this.getModel().getDataEntity(true).getDynamicObject("company").getLong("id"), (IFormView)this.getView());
        if (isTrialorg.booleanValue()) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        paramMap.put("applier", model.getValue("applier"));
        paramMap.put("applierpositionstr", model.getValue("applierpositionstr"));
        paramMap.put("tel", model.getValue("tel"));
        paramMap.put("company", model.getValue("company"));
        paramMap.put("org", model.getValue("org"));
        this.getView().returnDataToParent(paramMap);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("er_switchapplier_mb".equals(actionId) || StringUtils.equals((CharSequence)"er_applier_select_mb", (CharSequence)actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Object applier = returnData.get("applier");
                Object dept = returnData.get("dept");
                Object company = returnData.get("company");
                if (dept == null || company == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ApplierInfoMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                Object position = returnData.get("position");
                this.getModel().setValue("applier", applier);
                this.getModel().setValue("org", dept);
                this.getModel().setValue("company", company);
                this.getModel().setValue("applierpositionstr", position);
            }
            this.getView().updateView();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName = e.getProperty().getName()) {
            case "applier": {
                DynamicObject applier = (DynamicObject)propValue;
                Long applierid = (Long)applier.getPkValue();
                Map userInfo = CommonServiceHelper.getUserMap((Long)applierid);
                DynamicObject dpt = (DynamicObject)userInfo.get("org");
                if (null == dpt) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ApplierInfoMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long deptId = dpt.getLong("id");
                model.setValue("org", (Object)deptId);
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)deptId);
                model.setValue("company", (Object)companyId);
                model.setValue("costdept", (Object)deptId);
                String position = (String)userInfo.get("applierpositionstr");
                model.setValue("applierpositionstr", (Object)position);
                model.setValue("tel", userInfo.get("tel"));
            }
        }
    }
}

