/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.invoicecloud.util.InvoicePackageUtil;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.util.DataCopyUtils;
import kd.fi.er.formplugin.util.FormOperateUtil;
import org.apache.commons.lang.StringUtils;

public class CoreBaseBillEdit
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(CoreBaseBillEdit.class);
    private static String[] costCenterIds = new String[]{"std_costcenter", "std_entrycostcenter", "travelcostcenter", "sdstd_entrycostcenter", "std_entrycostcenter_crule"};
    public static final String DEFAULT_BANK_URL = "/icons/pc/other/Yen_60_60.png";
    private static final String MTOOLBARAP = "mtoolbarap";
    private String isShareStr;
    protected IPageCache pageCache;

    public void initialize() {
        super.initialize();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object isShare = billShowParameter.getCustomParams().get("isShare");
        logger.info("param isShare in tripreimbursebill is:" + isShare);
        this.pageCache = this.getPageCache();
        if (isShare != null) {
            this.pageCache.put("isShare", String.valueOf(isShare));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long currentUserID;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get("consignorId") != null) {
            currentUserID = Long.valueOf(pageCache.get("consignorId"));
            pageCache.remove("consignorId");
        } else {
            RequestContext requestContext = RequestContext.get();
            currentUserID = Long.valueOf(requestContext.getUserId());
        }
        Map billMap = StringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("package_import_pc"))) ? InvoicePackageUtil.createNewData((Map)this.getView().getFormShowParameter().getCustomParams()) : CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        Map custom = this.getView().getFormShowParameter().getCustomParams();
        Object parameterStr = custom.get("userInfo");
        if (parameterStr != null && StringUtils.isNotBlank((String)parameterStr.toString())) {
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)JSON.parseObject((String)parameterStr.toString(), UserCurrentDeptInfo.class);
            billMap = CoreBaseBillServiceHelper.createNewData((Long)userInfo.getUserId(), (Long)userInfo.getDeptId());
        }
        CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
        CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
        ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)false);
        model.setValue("origin", (Object)2);
        if (!ErCostCenterUtil.checkCostOrg((AbstractFormPlugin)this, (String)"6")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain", MTOOLBARAP});
        }
        CommonServiceHelper.setMulWayToVisible((IDataModel)this.getModel(), (IFormView)this.getView());
        CommonServiceHelper.setIsMulTravelers((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setFundingOrg();
        DataCopyUtils.setOriginValue((IFormView)this.getView());
    }

    private void setFundingOrg() {
        IDataModel model = this.getModel();
        Object costCompany = model.getValue("costcompany");
        if (this.isNeedToSetFundingOrg() && costCompany != null) {
            logger.info("\u5f00\u59cb\u8bbe\u7f6e\u652f\u4ed8\u516c\u53f8");
            DynamicObject fundingCompany = CoreBaseBillServiceHelper.getFundingOrg((DynamicObject)((DynamicObject)costCompany));
            model.setValue("paycompany", (Object)fundingCompany);
        }
    }

    protected boolean isNeedToSetFundingOrg() {
        return true;
    }

    protected DynamicObject customerGetFundingOrg() {
        return null;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        CommonServiceHelper.setMulWayToVisible((IDataModel)this.getModel(), (IFormView)this.getView());
        CommonServiceHelper.setIsMulTravelers((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DataCopyUtils.afterCopyBill((IDataModel)this.getModel(), (IFormView)this.getView());
        CommonServiceHelper.setMulWayToVisible((IDataModel)this.getModel(), (IFormView)this.getView());
        CommonServiceHelper.setIsMulTravelers((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    protected boolean initAccount() {
        int accRowCount = this.getModel().getEntryRowCount("accountentry");
        String billStatus = "";
        Object statusObj = this.getModel().getValue("billstatus");
        if (statusObj instanceof String) {
            billStatus = (String)statusObj;
        }
        return accRowCount == 0 && (StringUtils.equals((String)"A", (String)billStatus) || StringUtils.equals((String)"D", (String)billStatus));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "applier": {
                this.applierChange(model, propValue);
                break;
            }
            case "company": {
                CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
                break;
            }
            case "org": {
                this.deptChange((DynamicObject)propValue);
                break;
            }
            case "istravelers": {
                TripBillTravelerUtils.initGetTravelerDefaultValue((IDataModel)model);
                if (((Boolean)propValue).booleanValue()) break;
                CoreBaseBillServiceHelper.refreshEntryCostOrgByHeadCostOrg((IDataModel)model);
                break;
            }
            case "costdept": {
                this.costDeptChange(model, propValue);
                break;
            }
            case "costcompany": {
                this.costCompanyChange((DynamicObject)propValue);
                this.setFundingOrg();
                break;
            }
            case "tripamount": 
            case "currency": {
                this.tripAmountChange(model);
                this.initaccbalamount();
                break;
            }
            case "std_costcenter": {
                if (propValue == null || propValue == "" || !ErCostCenterUtil.isLeafCostCenter((Object)propValue)) break;
                ErCostCenterUtil.costCenterChangeForTrip((IFormView)this.getView(), (Object)propValue);
            }
        }
    }

    protected void deptChange(DynamicObject dept) {
        int showType;
        Long newCompanyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)dept.getPkValue()));
        if (TripBillTravelerUtils.needRecoverTravels((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()), (Long)newCompanyId)) {
            TripBillTravelerUtils.initGetTravelerDefaultValue((IDataModel)this.getModel());
        }
        if (newCompanyId != null && (showType = ErCommonUtils.getExpenseAssumeShowTypes((long)newCompanyId)) == 2) {
            DynamicObjectCollection tripEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
            int entryRowCount = this.getModel().getEntryRowCount("tripentry");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObjectCollection entryEntrys;
                if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)tripEntrys.get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", j, i)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", j, i)), (IDataModel)this.getModel());
                    this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, j, i);
                }
            }
        }
    }

    protected void applierChange(IDataModel model, Object propValue) {
        this.initaccbalamount();
        TripBillTravelerUtils.initGetTravelerDefaultValue((IDataModel)model);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        for (String costCenterId : costCenterIds) {
            BasedataEdit costcenter = (BasedataEdit)this.getControl(costCenterId);
            if (costcenter == null) continue;
            costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    protected void costCompanyChange(DynamicObject cotsCompany) {
        IDataModel model = this.getModel();
        Object company = model.getValue("company");
        if (company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
        if (showType == 1 || showType == 3) {
            DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            int entryRowCount = model.getEntryRowCount("tripentry");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObjectCollection entryEntrys;
                model.setValue("entrycostcompany", (Object)cotsCompany, i);
                if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)tripEntrys.get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    model.setValue("travelcostcompany", (Object)cotsCompany, j, i);
                }
            }
        }
    }

    protected void costDeptChange(IDataModel model, Object propValue) {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
        model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
        boolean isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        DynamicObject costDept = (DynamicObject)propValue;
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
        boolean isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue())));
        if (!isNotRelated && isModeOne) {
            if (showType == 3) {
                if (model.getEntryRowCount("tripentry") > 0) {
                    model.setValue("entrycostdept", propValue, 0);
                }
                return;
            }
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            model.setValue("costcompany", (Object)costCompanyId);
            if (showType == 1) {
                int tripCount = model.getEntryRowCount("tripentry");
                for (int i = 0; i < tripCount; ++i) {
                    DynamicObjectCollection entryEntrys;
                    model.setValue("entrycostcompany", (Object)costCompanyId, i);
                    model.setValue("entrycostdept", (Object)costDept, i);
                    if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)model.getEntryEntity("tripentry").get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                    for (int j = 0; j < entryEntrys.size(); ++j) {
                        model.setValue("travelcostcompany", (Object)costCompanyId, j, i);
                        model.setValue("travelcostdept", (Object)costDept, j, i);
                        Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", j, i)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", j, i)), (IDataModel)this.getModel());
                        this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, j, i);
                    }
                }
            }
        } else {
            int tripCount = model.getEntryRowCount("tripentry");
            for (int i = 0; i < tripCount; ++i) {
                DynamicObjectCollection entryEntrys;
                if (isModeOne) {
                    model.setValue("entrycostcompany", (Object)costCompany, i);
                }
                model.setValue("entrycostdept", (Object)costDept, i);
                if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)model.getEntryEntity("tripentry").get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    model.setValue("travelcostcompany", (Object)costCompany, j, i);
                    model.setValue("travelcostdept", (Object)costDept, j, i);
                    Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", j, i)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", j, i)), (IDataModel)this.getModel());
                    this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, j, i);
                }
            }
        }
        if (!isModeOne) {
            ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)true);
        }
    }

    protected BigDecimal refreshTotalAmount(String entryField, String entryAmountField, String totalAmountField) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(entryField);
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal tripAmount = (BigDecimal)model.getValue(entryAmountField, i);
            totalAmount = totalAmount.add(tripAmount);
        }
        if (totalAmountField != null) {
            model.setValue(totalAmountField, (Object)totalAmount);
        }
        return totalAmount;
    }

    protected void tripAmountChange(IDataModel model) {
        this.refreshTotalAmount(model, "tripentry", "tripamount", "amount");
    }

    protected BigDecimal refreshTotalAmount(IDataModel model, String entryField, String entryAmountField, String totalAmountField) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        int entryRowCount = model.getEntryRowCount(entryField);
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal tripAmount = (BigDecimal)model.getValue(entryAmountField, i);
            totalAmount = totalAmount.add(tripAmount);
        }
        model.setValue(totalAmountField, (Object)totalAmount);
        if (model.getProperty("approveamount") != null) {
            model.setValue("approveamount", (Object)totalAmount);
        }
        return totalAmount;
    }

    public void afterBindData(EventObject e) {
        Object paycompany;
        IDataModel model = this.getModel();
        this.initUserInfo(model);
        this.pageCache = this.getPageCache();
        this.isShareStr = this.pageCache.get("isShare");
        if (this.isShareStr != null && this.isShareStr.trim().equals("1")) {
            logger.info("is in sharing afterBindData method!" + this.isShareStr);
            String formid = String.valueOf(model.getValue("formid"));
            if (ErEntityTypeUtils.isTripReqBill((String)formid)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MTOOLBARAP});
            } else if (ErEntityTypeUtils.isTripReimburseBill((String)formid)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MTOOLBARAP, "flexpanelap10"});
            }
            this.getView().setStatus(OperationStatus.VIEW);
        }
        String billStatus = (String)model.getValue("billstatus");
        if (FormOperateUtil.isCopyOperate((EventObject)e) && StringUtils.equalsIgnoreCase((String)billStatus, (String)"A")) {
            DataCopyUtils.handleData((IDataModel)this.getModel(), (IFormView)this.getView());
        }
        this.hideBillHead(this.getView());
        if (this.getView().getParentView() != null) {
            logger.info("\u7236\u4eb2\u9875\u9762\u662f:" + this.getView().getParentView().getEntityId());
            this.hideBillHead(this.getView().getParentView());
        }
        this.initaccbalamount();
        if (model.getDataEntity().getDataEntityState().isPushChanged() && this.isNeedToSetFundingOrg() && (paycompany = model.getValue("paycompany")) == null) {
            this.setFundingOrg();
        }
        CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
    }

    private void hideBillHead(IFormView view) {
        if (CommonServiceHelper.isSCENE((IFormView)view)) {
            logger.info("\u9690\u85cf\u7533\u8bf7\u4eba\u9762\u677f>>>>>>>>");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_applierinfo"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap41"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        }
    }

    private void initaccbalamount() {
        String FLEX_NOREPAY = "flex_norepay";
        try {
            BigDecimal loanBalance;
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (applier == null || currency == null || !StringUtils.isNotBlank((String)billStatus)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_NOREPAY});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_NOREPAY});
            String sign = currency.getString("sign");
            sign = sign == null ? "\u00a5" : sign;
            int amtprecision = currency.getInt("amtprecision");
            if (amtprecision == 0) {
                amtprecision = 2;
            }
            if ((loanBalance = LoanBalanceServiceHelper.getPersonalLoanBalance((Long)((Long)applier.getPkValue()), (Long)currency.getLong("id"))).compareTo(BigDecimal.ZERO) == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_NOREPAY});
                return;
            }
            loanBalance = loanBalance.setScale(amtprecision, 4);
            Label loanBalanceLabel = (Label)this.getControl("lab_norepayamount");
            loanBalanceLabel.setText(sign + AmountUtils.getThousandthFormat((Long)ErCommonUtils.getPk((Object)applier), (int)amtprecision, (BigDecimal)loanBalance));
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_NOREPAY});
        }
    }

    protected void initUserInfo(IDataModel model) {
        this.pageCache = this.getPageCache();
        this.isShareStr = this.pageCache.get("isShare");
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        String applierStr = "";
        String applierPicUrl = "";
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        logger.info("initUserInfo`s first value:" + applierStr + applierPicUrl);
        if (this.isShareStr != null && this.isShareStr.trim().equals("1")) {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object billId = billShowParameter.getPkId();
            logger.info("billPkId:" + billId);
            if (billId != null) {
                QFilter qFilter;
                String formid = String.valueOf(this.getModel().getValue("formid"));
                DynamicObject billInfo = QueryServiceHelper.queryOne((String)formid, (String)"applier.id,applier.name,applier.picturefield", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", billId)});
                if (billInfo != null) {
                    applierStr = billInfo.getString("applier.name");
                    applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)billInfo.getLong("applier.id"));
                }
                logger.info("initUserInfo`s thisApplier value:" + billInfo);
            }
        }
        logger.info("initUserInfo`s second value:" + applierStr + applierPicUrl);
        ((Label)this.getControl("label_appiler")).setText(applierStr);
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
    }

    public void ishaveAccountEntry(IDataModel model, IFormView view) {
        DynamicObjectCollection accountEntrys = model.getEntryEntity("accountentry");
        if (accountEntrys.size() <= 0 || ((DynamicObject)accountEntrys.get(0)).get("payername") == null || StringUtils.isBlank((String)((DynamicObject)accountEntrys.get(0)).get("payername").toString())) {
            view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap_bank"});
            view.setVisible(Boolean.valueOf(true), new String[]{"labelap_addpayer", "btn_change"});
        } else {
            Control imageap_logo;
            Control control;
            view.setVisible(Boolean.valueOf(false), new String[]{"labelap_addpayer"});
            view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap_bank"});
            DynamicObject accountEntry = (DynamicObject)accountEntrys.get(0);
            String payerAccount = accountEntry.getString("payeraccount");
            DynamicObject payer = accountEntry.getDynamicObject("payer");
            String bankUrl = DEFAULT_BANK_URL;
            if (payer != null && !StringUtils.isEmpty((String)payer.getString("banklogo"))) {
                bankUrl = payer.getString("banklogo");
            }
            if ((control = this.getControl("lable_payeraccount02")) instanceof Label) {
                ((Label)this.getControl("lable_payeraccount02")).setText(payerAccount);
            }
            if ((imageap_logo = this.getControl("imageap_logo")) instanceof Image) {
                ((Image)this.getControl("imageap_logo")).setUrl(bankUrl);
            }
        }
    }

    protected Boolean refreshIsCurrency(IDataModel model) {
        Boolean iscurrency = (Boolean)model.getValue("iscurrency");
        if (!iscurrency.booleanValue()) {
            iscurrency = CommonServiceHelper.initCurrency();
        }
        return iscurrency;
    }

    protected void setChangeAppilerInfo(IDataModel model, Map<String, Object> paraMap) {
        model.setValue("applier", ErCommonUtils.getObjectValue((Object)paraMap.get("applier")));
        model.setValue("applierpositionstr", paraMap.get("applierpositionstr"));
        model.setValue("tel", paraMap.get("tel"));
    }

    protected void orgChanged(IDataModel model, Map<String, Object> paraMap) {
        model.setValue("org", ErCommonUtils.getObjectValue((Object)paraMap.get("org")));
        model.setValue("company", ErCommonUtils.getObjectValue((Object)paraMap.get("company")));
        model.setValue("costdept", ErCommonUtils.getObjectValue((Object)paraMap.get("org")));
        Long dept = (Long)ErCommonUtils.getObjectValue((Object)paraMap.get("org"));
        model.setValue("costcompany", (Object)CoreBaseBillServiceHelper.getAccountOrgId((Long)dept));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("ok".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (!(this.getView() instanceof ListView)) {
                this.getModel().setDataChanged(false);
            }
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_tripreimappilerinfo".equalsIgnoreCase(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            HashMap returnMap = (HashMap)closedCallBackEvent.getReturnData();
            Long companyId = ErCommonUtils.getPk(returnMap.get("company"));
            if (companyId == 0L) {
                return;
            }
            boolean ismultravelers = SystemParamterUtil.getIsMulTravelers((long)companyId);
            if (!ismultravelers) {
                this.getModel().setValue("istravelers", (Object)ismultravelers);
            }
            this.getModel().setValue("ismultravelers", (Object)ismultravelers);
        }
    }
}

