/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.CarTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;

public class DailyVehicleMobPlugin
extends AbstractMobBillPlugIn {
    private static Log logger = LogFactory.getLog(DailyVehicleMobPlugin.class);
    private static int VEHICLE_COUNT = 2;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_change"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey().toLowerCase()) {
            case "btn_change": {
                String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
                CommonViewControlUtil.changeApplier(entityName, (IFormPlugin)this, this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_daily_applier_mb".equalsIgnoreCase(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            this.setApplierInfo(this.getModel(), map);
            this.setDeptInfo(this.getModel(), map);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map map = CoreBaseBillServiceHelper.createNewData((Long)RequestContext.get().getCurrUserId());
        CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)map);
        CoreBaseBillServiceHelper.initObjByMap((Object)this.getModel(), (Map)map);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        String applierStr = "";
        String applierPicUrl = "";
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        logger.info("initUserInfo`s first value:" + applierStr + applierPicUrl);
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        switch (key) {
            case "submit": {
                BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
                if (billShowParameter.getBillStatus().getValue() != BillOperationStatus.ADDNEW.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.SUBMIT.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.EDIT.getValue()) break;
                if (parentView != null && parentView.getEntityId().startsWith("er_addnew_dialog_daily")) {
                    view.getParentView().close();
                    view.sendFormAction(view.getParentView());
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("formId", "er_dailyvehiclebill");
                paramMap.put("templateId", "bos_moblist");
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("need_refresh", "Y");
                paramMap.put("customParam", customParam);
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
            }
        }
    }

    private void setLabelText(Map<String, Object> map) {
        DynamicObject applierobj = (DynamicObject)this.getModel().getValue("applier");
        String applierStr = applierobj.getLocaleString("name").getLocaleValue();
        Label applierName = (Label)this.getControl("label_appiler");
        applierName.setText(applierStr);
        Label labelPhone = (Label)this.getControl("label_phone");
        labelPhone.setText((String)map.get("tel"));
        String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applierobj.getPkValue()));
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "vehicletype": 
            case "startdate": 
            case "vehicledate": 
            case "enddate": {
                if (null == propValue) break;
                Date startdate = this.getModel().getDataEntity(true).getDate("startdate");
                Date enddate = this.getModel().getDataEntity(true).getDate("enddate");
                String vehicletype = this.getModel().getDataEntity(true).getString("vehicletype");
                if (null != vehicletype && CarTypeEnum.HOVERTIME.getCode().equals(vehicletype) && null != startdate && null != enddate) {
                    Long dates = CommonServiceHelper.calcVehicleDays((Date)startdate, (Date)enddate);
                    this.getModel().setValue("vehiclenumber", (Object)(dates * (long)VEHICLE_COUNT));
                }
                if (startdate != null || enddate != null || !CarTypeEnum.HOVERTIME.getCode().equals(vehicletype)) break;
                this.getModel().setValue("vehiclenumber", (Object)VEHICLE_COUNT);
            }
        }
    }

    private void setApplierInfo(IDataModel model, Map paraMap) {
        DynamicObject applier = (DynamicObject)paraMap.get("applier");
        model.setValue("applier", applier == null ? null : applier.getPkValue());
        model.setValue("applierpositionstr", paraMap.get("applierpositionstr"));
        model.setValue("tel", paraMap.get("tel"));
        String applierStr = "";
        String applierPicUrl = "";
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        logger.info("initUserInfo`s first value:" + applierStr + applierPicUrl);
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
    }

    protected void setDeptInfo(IDataModel model, Map<String, Object> map) {
        DynamicObject org = (DynamicObject)map.get("org");
        DynamicObject company = (DynamicObject)map.get("company");
        Long orgId = 0L;
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        Long companyId = 0L;
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        model.setValue("org", (Object)orgId);
        model.setValue("costcompany", (Object)CoreBaseBillServiceHelper.getAccountOrgId((boolean)true, (Long)orgId));
        model.setValue("company", (Object)companyId);
        model.setValue("costdept", (Object)orgId);
    }
}

