/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.common.ControlMethodEnum;
import org.apache.commons.lang3.StringUtils;

public class ErReimburseDetailMobPlugin
extends AbstractMobFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btn_save"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        String ordernumArr = (String)mapCustomParam.get("ordernum");
        String orderFormIdArr = (String)mapCustomParam.get("orderformid");
        if (null == ordernumArr || null == orderFormIdArr) {
            return;
        }
        String[] ordernums = ordernumArr.split(",");
        String[] orderFormIds = orderFormIdArr.split(",");
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("orderentry", ordernums.length);
        for (int i = 0; i < ordernums.length; ++i) {
            String overDesc;
            String ordernum = ordernums[i];
            String orderFormId = orderFormIds[i];
            Object currencyIdObj = mapCustomParam.get("currencyId");
            String string = overDesc = mapCustomParam.get("overdesc") == null ? "" : (String)mapCustomParam.get("overdesc");
            if (StringUtils.isEmpty((CharSequence)ordernum) || StringUtils.isEmpty((CharSequence)orderFormId) || currencyIdObj == null) {
                return;
            }
            Long currencyId = null;
            if (currencyIdObj instanceof Long) {
                currencyId = (Long)currencyIdObj;
            } else if (currencyIdObj instanceof Integer) {
                currencyId = ((Integer)currencyIdObj).longValue();
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7236\u9875\u9762\u4f20\u9012\u8fc7\u6765\u7684\u5e01\u79cd(currencyId)\u6570\u636e\u7c7b\u578b\u4e3a: %s, \u76ee\u524d\u6ca1\u6709\u8003\u8651\u5230\u6b64\u79cd\u60c5\u51b5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"ErReimburseDetailMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), currencyIdObj.getClass().getName()));
                return;
            }
            if (orderFormId != null && Arrays.asList("er_hotelbill", "er_planebill", "er_vehiclebill", "er_trainbill", "er_mealbill").contains(orderFormId)) {
                IErDao orderDao = ErDaoFactory.getInstance((String)orderFormId);
                DynamicObject order = orderDao.queryOne(new QFilter("ordernum", "=", (Object)ordernum));
                if (order == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7c7b\u578b\uff1a%1$s\uff0c\u8ba2\u5355\u53f7\uff1a%2$s\u3002\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u3002", (String)"ErReimburseDetailMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), orderFormId, ordernum));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)overDesc)) {
                    model.setValue("overdesc", (Object)overDesc, i);
                }
                model.setValue("currency", (Object)currencyId, i);
                this.initOrder(model, order, orderFormId, i, mapCustomParam);
                if (mapCustomParam.get("isControl") == null) continue;
                this.findVehicleStandardOverExpenseItem(model, i, mapCustomParam);
                continue;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u9009\u5b9a\u7684\u8ba2\u5355\u7c7b\u578b\u4e3a%s\uff0c\u76ee\u524d\u7cfb\u7edf\u53ea\u652f\u6301\u673a\u7968\u8ba2\u5355\u3001\u9152\u5e97\u8ba2\u5355\u3001\u7528\u8f66\u8ba2\u5355\u3001\u706b\u8f66\u8ba2\u5355\u3002", (String)"ErReimburseDetailMobPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]), orderFormId));
        }
    }

    private void initOrder(IDataModel model, DynamicObject orderInfo, String orderformid, int index, Map<String, Object> mapCustomParam) {
        model.setValue("orderformid", (Object)orderformid, index);
        if (orderInfo != null) {
            Object totalamount = orderInfo.get("totalamount");
            String orderNum = orderInfo.getString("orderNum");
            String orderstatus = orderInfo.getString("orderstatus");
            if (StringUtils.isNotEmpty((CharSequence)orderstatus)) {
                orderstatus = orderformid + "_" + orderstatus;
            }
            String overDescFromParentPage = (String)model.getValue("overdesc", index);
            if ("er_planebill".equalsIgnoreCase(orderformid)) {
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u673a\u7968", (String)"ErReimburseDetailMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                Date takeofftime = orderInfo.getDate("takeofftime");
                Date landingtime = orderInfo.getDate("landingtime");
                String fromcityname = orderInfo.getString("fromcityname");
                String tocityname = orderInfo.getString("tocityname");
                String airlinename = orderInfo.getString("airlinename");
                String flightno = orderInfo.getString("flightno");
                model.setValue("takeofftime", (Object)takeofftime, index);
                model.setValue("landingtime", (Object)landingtime, index);
                model.setValue("fromcityname", (Object)fromcityname, index);
                model.setValue("tocityname", (Object)tocityname, index);
                model.setValue("airlinename", (Object)airlinename, index);
                model.setValue("flightno", (Object)flightno, index);
                if (StringUtils.isBlank((CharSequence)overDescFromParentPage) && ControlMethodEnum.DESC_CONTROL.getValue().equalsIgnoreCase("" + mapCustomParam.get("vehicleConType"))) {
                    model.setValue("overdesc", orderInfo.get("overdesc"), index);
                }
            }
            if ("er_hotelbill".equalsIgnoreCase(orderformid)) {
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u9152\u5e97", (String)"ErReimburseDetailMobPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                String hotelname = orderInfo.getString("hotelname");
                Object roomcount = orderInfo.get("roomcount");
                Date checkindate = orderInfo.getDate("checkindate");
                Date checkoutdate = orderInfo.getDate("checkoutdate");
                String hoteladdress = orderInfo.getString("hoteladdress");
                model.setValue("startdate", (Object)checkindate, index);
                model.setValue("enddate", (Object)checkoutdate, index);
                model.setValue("hotelname", (Object)hotelname, index);
                model.setValue("hoteladdress", (Object)hoteladdress, index);
                Long nightcount = CommonServiceHelper.calcHotelNightDays((Date)checkindate, (Date)checkoutdate);
                model.setValue("nightcount", (Object)String.format(ResManager.loadKDString((String)"%s\u665a   /", (String)"ErReimburseDetailMobPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), nightcount), index);
                model.setValue("roomcount", (Object)String.format(ResManager.loadKDString((String)"%s\u95f4", (String)"ErReimburseDetailMobPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]), roomcount), index);
                if (StringUtils.isBlank((CharSequence)overDescFromParentPage) && ControlMethodEnum.DESC_CONTROL.getValue().equalsIgnoreCase("" + mapCustomParam.get("tripstandcontype"))) {
                    model.setValue("overdesc", orderInfo.get("overdesc"), index);
                }
            }
            if ("er_vehiclebill".equalsIgnoreCase(orderformid)) {
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u7528\u8f66", (String)"ErReimburseDetailMobPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                model.setValue("departaddress", orderInfo.get("departaddress"), index);
                model.setValue("arriveaddress", orderInfo.get("arriveaddress"), index);
                model.setValue("usetime", orderInfo.get("usetime"), index);
                model.setValue("usetimel", orderInfo.get("usetime"), index);
                model.setValue("cityname", orderInfo.get("cityname"), index);
            }
            if ("er_trainbill".equalsIgnoreCase(orderformid)) {
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u706b\u8f66", (String)"ErReimburseDetailMobPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                model.setValue("fromcityname", orderInfo.get("departaddress"), index);
                model.setValue("tocityname", orderInfo.get("arriveaddress"), index);
                model.setValue("takeofftime", (Object)orderInfo.getDate("departtime"), index);
                model.setValue("landingtime", (Object)orderInfo.getDate("arrivetime"), index);
                model.setValue("vendorname", orderInfo.get("vendorname"), index);
                model.setValue("trainseat", orderInfo.get("trainseat"), index);
            }
            if ("er_mealbill".equalsIgnoreCase(orderformid)) {
                int orderentryCount = this.getModel().getEntryRowCount("orderentry");
                CardEntry cardEntry = (CardEntry)this.getView().getControl("orderentry");
                if (cardEntry != null) {
                    for (int i = 0; i < orderentryCount; ++i) {
                        cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardentryflexpanelap", "carcardentry", "traincardentry", "cardentryflexpanelap7"});
                    }
                }
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u7528\u9910", (String)"ErReimburseDetailMobPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                model.setValue("mealcityname", orderInfo.get("mealcityname"), index);
                model.setValue("shopaddress", orderInfo.get("shopaddress"), index);
                model.setValue("mealtime", (Object)orderInfo.getDate("mealtime"), index);
                model.setValue("mealtimel", (Object)orderInfo.getDate("mealtime"), index);
                model.setValue("mealtotalamount", totalamount, index);
            }
            model.setValue("totalamount", totalamount, index);
            model.setValue("orderNum", (Object)orderNum, index);
            model.setValue("orderstatus", (Object)orderstatus, index);
        }
    }

    private void findVehicleStandardOverExpenseItem(IDataModel model, int index, Map<String, Object> mapCustomParam) {
        Boolean isControl = (Boolean)mapCustomParam.get("isControl");
        Boolean checkCabinIsOver = false;
        if (isControl.booleanValue()) {
            checkCabinIsOver = (Boolean)mapCustomParam.get("checkCabinIsOver");
        }
        model.setValue("iscontrol", (Object)isControl, index);
        model.setValue("checkcabinisover", (Object)checkCabinIsOver, index);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IDataModel pModel = this.getView().getParentView().getModel();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btn_save")) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map mapCustomParam = showParameter.getCustomParams();
            if (null == mapCustomParam.get("index")) {
                return;
            }
            int index = (Integer)mapCustomParam.get("index");
            String overdesc = (String)model.getValue("overdesc");
            if (overdesc != null) {
                pModel.setValue("overdesc", (Object)overdesc, index);
            }
            this.getView().close();
        }
    }
}

