/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.Pair;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEnhancedConvertReportUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.Recorder;
import kd.fi.er.formplugin.botp.up.service.BotpDrawServiceStdImpl;
import kd.fi.er.formplugin.daily.mobile.common.ExpenseEntryMobPlugin;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;

public class ErReimburseUpRequestMobPlugin
extends AbstractMobFormPlugin
implements IBillPlugin {
    private static final String LOAN = "loan";
    private static final String APPLY = "apply";
    private static final String fromId = "er_reimbursebill_upreq_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flex_add_apply", "vectorap_add_apply", "lab_delete_offapply", "lab_done_offapply"});
        this.addClickListeners(new String[]{"flex_arow11", "vectorap11", "lab_delete_writeoff", "lab_done_writeoff", "lab_draw_loan"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("vectorap_add_apply".equals(key) || "flex_add_apply".equals(key)) {
            this.openUpBillList(APPLY);
        } else if ("flex_arow11".equals(key) || "vectorap11".equals(key) || "lab_draw_loan".equals(key)) {
            String detailtype;
            String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
            boolean isOpen = true;
            if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && "2".equals(applyprojectbillRelated) && "biztype_project".equals(detailtype = (String)this.getModel().getValue("detailtype"))) {
                isOpen = PublicBillUtil.checkProjectNo((IFormView)this.getView());
            }
            if (isOpen) {
                this.openUpBillList(LOAN);
            }
        } else if ("lab_delete_offapply".equals(key)) {
            ErReimburseUpRequestMobPlugin.hiddenOrShowApply(this.getModel(), this.getView(), true);
        } else if ("lab_done_offapply".equals(key)) {
            ErReimburseUpRequestMobPlugin.hiddenOrShowApply(this.getModel(), this.getView(), false);
        } else if ("lab_delete_writeoff".equals(key)) {
            ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), true);
        } else if ("lab_done_writeoff".equals(key)) {
            ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals("writeoffapply")) {
            int insertRow = e.getInsertRow();
            CardEntry accountCard = (CardEntry)this.getControl("writeoffapply");
            accountCard.setChildVisible(false, insertRow, new String[]{"image_delete_apply"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (fromId.equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            HashMap<String, ListSelectedRowCollection> resultMap = null;
            if (returnData instanceof Map) {
                resultMap = (HashMap<String, ListSelectedRowCollection>)closedCallBackEvent.getReturnData();
            } else {
                ListSelectedRowCollection collection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (collection == null || collection.size() == 0) {
                    return;
                }
                resultMap = new HashMap<String, ListSelectedRowCollection>();
                resultMap.put(collection.get(0).getFormID(), collection);
            }
            BotpDrawServiceStdImpl drawService = new BotpDrawServiceStdImpl(this.getModel(), this.getView());
            ArrayList<DynamicObject> dataEntitysDyn = new ArrayList<DynamicObject>();
            ArrayList<ConvertOperationResult> convertResults = new ArrayList<ConvertOperationResult>(10);
            Recorder existFail = new Recorder((Object)new Pair((Object)false, (Object)new DrawArgs()));
            for (Map.Entry<String, ListSelectedRowCollection> entry : resultMap.entrySet()) {
                List<DynamicObject> drawResult = drawService.draw(entry, convertResults, (Recorder<Pair<Boolean, DrawArgs>>)existFail);
                dataEntitysDyn.addAll(drawResult);
            }
            if (((Boolean)((Pair)existFail.getRecord()).getKey()).booleanValue()) {
                ErEnhancedConvertReportUtil.showEnhancedConvertReport(convertResults, (DrawArgs)((DrawArgs)((Pair)existFail.getRecord()).getValue()), (IFormView)this.getView());
            }
            if (!dataEntitysDyn.isEmpty()) {
                drawService.paintWriteOffMoney(dataEntitysDyn);
                ErReimburseUpRequestMobPlugin.hiddenOrShowApply(this.getModel(), this.getView(), false);
                ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
                this.hiddenOrShowFee(false);
                this.calculateTotalApplyAmount();
                ExpenseEntryMobPlugin.refreshAmount(this.getModel(), this.getView());
                if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
                    PublicBillUtil.refreshWriteOffInfo((IDataModel)this.getModel());
                }
                this.getView().updateView("writeoffmoney");
            }
            if (this.getModel().getEntryRowCount("expenseentryentity") > 0) {
                CommonViewControlUtil.expensePageRules(this.getModel(), this.getView());
            }
        }
    }

    private void calculateTotalApplyAmount() {
        DynamicObjectCollection writeoffapplys = this.getModel().getDataEntity().getDynamicObjectCollection("writeoffapply");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (DynamicObject d : writeoffapplys) {
            bigDecimal = bigDecimal.add(d.getBigDecimal("expebalanceamount"));
        }
        Label label = (Label)this.getView().getControl("label_offapply_amount");
        DynamicObject currency = (DynamicObject)this.getModel().getDataEntity().get("currency");
        if (currency == null) {
            return;
        }
        String sign = currency.getString("sign");
        int amtprecision = currency.getInt("amtprecision");
        if (label != null) {
            label.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)sign, (BigDecimal)bigDecimal, (int)amtprecision));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ErReimburseUpRequestMobPlugin.hiddenOrShowApply(this.getModel(), this.getView(), false);
        ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
        this.calculateTotalApplyAmount();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("writeoffapply")) {
            WriteOffMoneyUtils.changeApproveAmount((IDataModel)this.getModel());
            this.calculateTotalApplyAmount();
            int writeoffapplyEntrySize = this.getModel().getEntryRowCount("writeoffapply");
            for (int i = 0; i < writeoffapplyEntrySize; ++i) {
                this.getView().updateView("reimbursedamount", i);
                this.getView().updateView("reimbursedcurramount", i);
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        if (e.getEntryProp().getName().equals("writeoffapply")) {
            this.calculateTotalApplyAmount();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (source instanceof DeleteEntry && "deleteentryoffapply".equalsIgnoreCase(operateKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("writeoffapply");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("writeoffapply", entryCurrentRowIndex);
            if (entryRowEntity != null) {
                args.setCancel(true);
                Object sourceApplyBillId2 = entryRowEntity.get("sourceapplybillid");
                this.getModel().deleteEntryRow("writeoffapply", entryCurrentRowIndex);
                Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)"er_dailyapplybill", (Long[])new Long[]{Long.valueOf((String)sourceApplyBillId2)});
                HashSet hashSet = (HashSet)findTargetBills.get("er_dailyloanbill");
                if (hashSet != null) {
                    for (Object sourceApplyBillId2 : hashSet) {
                        this.deleteEntryBySourceBillId("writeoffmoney", "sourcebillid", sourceApplyBillId2);
                    }
                }
                WriteOffMoneyUtils.changeApproveAmount((IDataModel)this.getModel());
            }
        }
    }

    private void deleteEntryBySourceBillId(String entryName, String sourcebillName, Object sourcebillid) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        ArrayList deleteIndex = Lists.newArrayList();
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!sourcebillid.toString().equals(((DynamicObject)entryEntity.get(i)).get(sourcebillName))) continue;
            deleteIndex.add(i);
        }
        if (!deleteIndex.isEmpty()) {
            this.getModel().deleteEntryRows(entryName, deleteIndex.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    private void openUpBillList(String drawSourceType) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(fromId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        customParams.put("applierId", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
        customParams.put("orgId", ErCommonUtils.getPk((Object)this.getModel().getValue("org")));
        customParams.put("currency", ErCommonUtils.getPk((Object)this.getModel().getValue("currency")));
        customParams.put("companyId", companyId);
        customParams.put("writeofftype", this.getModel().getValue("writeofftype"));
        String sourceEntity = this.getSourceEntity(drawSourceType);
        customParams.put("drawSourceEntity", sourceEntity);
        customParams.put("ids", this.getExistIds(sourceEntity));
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> getExistIds(String drawSourceType) {
        if ("er_dailyapplybill".equals(drawSourceType)) {
            DynamicObjectCollection writeoffapplys = this.getModel().getEntryEntity("writeoffapply");
            return writeoffapplys.stream().map(e -> e.getLong("sourceapplyentryid")).collect(Collectors.toList());
        }
        if ("er_dailyloanbill".equals(drawSourceType)) {
            DynamicObjectCollection writeoffapplys = this.getModel().getEntryEntity("writeoffmoney");
            return writeoffapplys.stream().map(e -> e.getLong("sourceentryid")).collect(Collectors.toList());
        }
        if ("er_dailyloanbill,er_tripreqbill".equals(drawSourceType)) {
            DynamicObjectCollection writeoffapplys = this.getModel().getEntryEntity("writeoffmoney");
            return writeoffapplys.stream().map(e -> e.getLong("sourceentryid")).collect(Collectors.toList());
        }
        return null;
    }

    private String getSourceEntity(String drawSourceType) {
        if (APPLY.equals(drawSourceType)) {
            return "er_dailyapplybill";
        }
        if (LOAN.equals(drawSourceType)) {
            String billType = this.getModel().getDataEntity(true).getDynamicObjectType().getName();
            if (ErEntityTypeUtils.isPublicReimburseBill((String)billType)) {
                return "er_dailyloanbill";
            }
            return "er_dailyloanbill,er_tripreqbill";
        }
        return null;
    }

    public static void hiddenOrShowApply(IDataModel model, IFormView view, boolean show) {
        ErReimburseUpRequestMobPlugin.hiddenOrShow(model, view, show, "writeoffapply", "lab_done_offapply", "lab_delete_offapply", "image_delete_apply");
    }

    public static void hiddenOrShowWriteOff(IDataModel model, IFormView view, boolean show) {
        ErReimburseUpRequestMobPlugin.hiddenOrShow(model, view, show, "writeoffmoney", "lab_done_writeoff", "lab_delete_writeoff", "image_delete_writeoff");
    }

    public static void hiddenOrShow(IDataModel model, IFormView view, boolean show, String entryName, String labDoneName, String labDeleteName, String imageDelName) {
        if (model.getProperty(entryName) == null) {
            return;
        }
        int accountEntrySize = model.getEntryRowCount(entryName);
        CardEntry accountCard = (CardEntry)view.getControl(entryName);
        if (show) {
            view.setVisible(Boolean.TRUE, new String[]{labDoneName});
            view.setVisible(Boolean.FALSE, new String[]{labDeleteName});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{labDoneName});
            view.setVisible(Boolean.TRUE, new String[]{labDeleteName});
        }
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            accountCard.setChildVisible(show, rowIndex, new String[]{imageDelName});
        }
    }

    private void hiddenOrShowFee(boolean show) {
        int accountEntrySize = this.getModel().getEntryRowCount("accountentry");
        CardEntry accountCard = (CardEntry)this.getControl("accountentry");
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            accountCard.setChildVisible(show, rowIndex, new String[]{"imageaccount_delete"});
        }
    }
}

