/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.cloudhub.CloudHubAppServiceHelper;
import kd.fi.er.business.servicehelper.ApproveRecoderServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;

public class GroupChatDialogPlugin
extends AbstractMobFormPlugin
implements ClickListener {
    private static Log logger = LogFactory.getLog(GroupChatDialogPlugin.class);
    public static final String BACKGROUNDFLEX = "backgroundflex";
    public static final String PALACEHOLDERFLEX = "palaceholderflex";
    public static final String HANDOUTREDENVELOPE = "handoutredenvelope";
    public static final String CHAT = "chat";
    public static final String TRA = "tra";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BACKGROUNDFLEX, PALACEHOLDERFLEX, HANDOUTREDENVELOPE, CHAT});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "chat": {
                this.createGroupChat(CHAT);
                break;
            }
            case "handoutredenvelope": {
                this.createGroupChat(HANDOUTREDENVELOPE);
                break;
            }
            case "palaceholderflex": 
            case "backgroundflex": {
                this.rebackTripReport();
            }
        }
    }

    public void createGroupChat(String chatType) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List userOpenidList = (List)parameter.getCustomParams().get("user_openid_list");
        String title = "";
        String content = "";
        String cellContent = "";
        String pkId = "";
        String formId = "";
        if (chatType.equals(HANDOUTREDENVELOPE)) {
            title = ResManager.loadKDString((String)"\u7ea2\u5305\u6170\u95ee", (String)"GroupChatDialogPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
            content = ResManager.loadKDString((String)"\u4f60\u6709\u4e00\u6761\u672a\u8bfb\u7684\u7ea2\u5305\u653b\u7565\u3002", (String)"GroupChatDialogPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
            cellContent = ResManager.loadKDString((String)"\u4f60\u6709\u4e00\u6761\u672a\u8bfb\u7684\u7ea2\u5305\u653b\u7565\u3002", (String)"GroupChatDialogPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
            pkId = "er_sharefrom_handout";
            formId = "er_sharefrom_handout";
        } else if (chatType.equals(CHAT)) {
            title = ResManager.loadKDString((String)"\u51fa\u5dee\u6170\u95ee", (String)"GroupChatDialogPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
            content = ResManager.loadKDString((String)"\u522b\u8d76\u8def\uff0c\u53bb\u611f\u53d7\u8def", (String)"GroupChatDialogPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
            cellContent = ResManager.loadKDString((String)"\u522b\u8d76\u8def\uff0c\u53bb\u611f\u53d7\u8def", (String)"GroupChatDialogPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
            pkId = "er_sharefrom_chat";
            formId = "er_sharefrom_chat";
        }
        this.shareFormOrBillToYZJ(title, content, cellContent, pkId, formId, userOpenidList);
    }

    public void shareFormOrBillToYZJ(String title, String content, String cellContent, String pkId, String formId, List<String> userOpenidList) {
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        Map YZJAppInfo = CloudHubAppServiceHelper.getAppInfoByNumber((String)TRA);
        Object appId = YZJAppInfo.get("appid");
        Object appName = YZJAppInfo.get("name");
        if (StringUtils.isBlank(appId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4e91\u4e4b\u5bb6\u4eba\u4eba\u5dee\u65c5\uff08tra\uff09\u7684APPID\u3002", (String)"GroupChatDialogPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        HashMap mData = new HashMap();
        mData.put("appId", appId);
        mData.put("lightAppId", appId);
        mData.put("appName", appName);
        mData.put("title", title);
        mData.put("content", content);
        mData.put("selected", userOpenidList);
        mData.put("webpageUrl", ApproveRecoderServiceHelper.getWebpageUrl((String)formId, (String)pkId));
        mData.put("cellContent", cellContent);
        mData.put("sharedObject", "all");
        mData.put("formid", formId);
        mData.put("pkid", pkId);
        mData.put("callBackUrl", "");
        mData.put("thumbData", "");
        yzj.yzjInterface("share", mData);
    }

    public void rebackTripReport() {
        if (!this.getView().getFormShowParameter().getParentFormId().equals("er_trip_report")) {
            FormModel formModel = new FormModel("er_trip_report", ResManager.loadKDString((String)"\u62a5\u544a", (String)"GroupChatDialogPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true);
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        } else {
            this.getView().close();
        }
    }
}

