/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.ai.util.AIPlatformUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.common.model.trip.TripReimburseOpenType;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang3.StringUtils;

public class HomeAddNewDialogPlugin
extends AbstractFormPlugin
implements ClickListener {
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();
    private static final String K_YUNROBOT = "mbmenuitem_yunrobot";
    private static final String FLOATBUTTONAP_ADDNEW = "floatbuttonap_addnew";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String url = "/icons/mobile/shortcut_entrance/icon_loan_for_business_80_80_l.png";
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("imageKey", url);
        String language = ResManager.getLanguage();
        if (!"zh_CN".equals(language) && !"zh_TW".equals(language)) {
            this.getView().updateControlMetadata("mbmenuitem_loanbill", item);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
        this.addClickListeners(new String[]{FLOATBUTTONAP_ADDNEW, K_YUNROBOT});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long mainCompany = CommonServiceHelper.getCompanyIdByUserId((Long)CommonServiceHelper.getCurrentUserID());
        if (mainCompany != null && SystemParamterUtil.isUseLittleKApp((Long)mainCompany)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{K_YUNROBOT});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{K_YUNROBOT});
        }
        this.setTripReimMenu();
    }

    private void setTripReimMenu() {
        String tripReimType = SystemParamterUtil.getTripReimburseTypeByCurrentUser();
        if (StringUtils.equals((CharSequence)tripReimType, (CharSequence)"card")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mbmenuitem_reimbursement"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"menu_tripreim_grid"});
        } else if (StringUtils.equals((CharSequence)tripReimType, (CharSequence)"grid")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mbmenuitem_reimbursement"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"menu_tripreim_grid"});
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (sourceKey.equalsIgnoreCase(FLOATBUTTONAP_ADDNEW)) {
            this.getView().close();
        } else if (sourceKey.equalsIgnoreCase(K_YUNROBOT)) {
            AIPlatformUtil.invokeAIRobot((IFormView)this.getView());
        } else {
            MainPageModel mainPageModel = controlMap.get(sourceKey);
            if (mainPageModel != null) {
                FormModel formModel;
                if ("mbmenuitem_loanbill".equals(sourceKey)) {
                    String loanbillName = FormMetadataCache.getFormConfig((String)"er_tripreqbill_mob").getCaption().getLocaleValue();
                    formModel = new FormModel(mainPageModel.getFormId(), String.format(ResManager.loadKDString((String)"%1$s(\u501f)", (String)"HomeAddNewDialogPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), loanbillName), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue(), mainPageModel.getCustomParam());
                } else {
                    formModel = new FormModel(mainPageModel.getFormId(), null, mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue(), mainPageModel.getCustomParam());
                }
                mainPageModel.getCustomParam().put("checkRightAppId", "tra");
                FormShowParameter formShowParameter = formModel.getFormShowParameter();
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formModel.getFormId()));
                if (formShowParameter.getAppId() == null) {
                    formShowParameter.setAppId("18XD+/5EDN8X");
                }
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        UserCurrentDeptInfo userInfo;
        String tripOpenType;
        String btnKey;
        MainPageModel mainPageModel;
        String actionId = event.getActionId();
        if (("er_tripreimbursebill_mob".equals(actionId) || "er_tripreim_grid_mb".equals(actionId)) && event.getReturnData() instanceof UserCurrentDeptInfo && (mainPageModel = controlMap.get(btnKey = TripReimburseOpenType.getTripReimburseOpenType((String)(tripOpenType = TripReimOpenTypeUtils.getTripReimburseOpenType((Long)(userInfo = (UserCurrentDeptInfo)event.getReturnData()).getOldCompanyId(), (Long)userInfo.getCompanyId(), (Long)userInfo.getUserId()))).getMobBtn())) != null) {
            FormModel formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue(), (Map)Maps.newHashMap((Map)mainPageModel.getCustomParam()));
            formModel.getCustomParam().put("checkRightAppId", "tra");
            formModel.getCustomParam().put("userInfo", JSON.toJSONString((Object)userInfo));
            FormShowParameter formShowParameter = formModel.getFormShowParameter();
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formModel.getFormId()));
            if (formShowParameter.getAppId() == null) {
                formShowParameter.setAppId("18XD+/5EDN8X");
            }
            this.getView().showForm(formShowParameter);
        }
    }

    static {
        HashMap<String, String> customParam1 = new HashMap<String, String>();
        customParam1.put("appId", "18XD+/5EDN8X");
        controlMap.put("mbmenuitem_reimbursement", new MainPageModel("er_tripreimbursebill_mob", null, "6", false, customParam1));
        HashMap<String, Object> customParam2 = new HashMap<String, Object>();
        customParam2.put("isloan", Boolean.FALSE);
        customParam2.put("appId", "18XD+/5EDN8X");
        controlMap.put("mbmenuitem_tripresquest", new MainPageModel("er_tripreqbill_mob", null, "6", false, customParam2));
        HashMap<String, Object> customParam3 = new HashMap<String, Object>();
        customParam3.put("isloan", Boolean.TRUE);
        customParam3.put("appId", "18XD+/5EDN8X");
        controlMap.put("mbmenuitem_loanbill", new MainPageModel("er_tripreqbill_mob", null, "6", false, customParam3));
        controlMap.put(FLOATBUTTONAP_ADDNEW, null);
        HashMap<String, String> tripReimGridParam = new HashMap<String, String>();
        tripReimGridParam.put("appId", "18XD+/5EDN8X");
        controlMap.put("menu_tripreim_grid", new MainPageModel("er_tripreim_grid_mb", null, "6", false, tripReimGridParam));
    }
}

