/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.YzjShareDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.IntegralServiceHelper;
import kd.fi.er.common.ShowPageUtils;

public class IntegralboardPagePlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private Log logger = LogFactory.getLog(IntegralboardPagePlugin.class);
    private static int myRank = 1;
    private static int myPrasiecount = 0;
    private static int myPrasieTotalcount = 0;
    private static int myYearScore = 0;

    public void initialize() {
        this.addClickListeners(new String[]{"on", "off", "myon", "myoff", "flex_viewintegralrule", "labelap_viewintegralrule", "image_viewintegralrule", "cardentry_ispraise", "cardentry_mypraise"});
        AbstractGrid mygrid = (AbstractGrid)this.getView().getControl("entryentity_my");
        mygrid.addRowClickListener((RowClickEventListener)this);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity1");
        grid.addRowClickListener((RowClickEventListener)this);
        Container control = (Container)this.getControl("flex_viewintegralrule");
        String language = ResManager.getLanguage();
        if (!language.equals("zh_CN")) {
            String url = "/images/mobile/business_pic/image_banner_best_l.png";
            control.setBackgroundImg(url);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long curUserId = CommonServiceHelper.getCurrentUserID();
        if (!StringUtils.isBlank(this.getView().getFormShowParameter().getCustomParams().get("shareUserId"))) {
            curUserId = (Long)this.getView().getFormShowParameter().getCustomParams().get("shareUserId");
        }
        this.refreshIntegral(curUserId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity1");
        IDataModel model = this.getModel();
        int index = grid.getEntryState().getFocusRow();
        Long userId = null;
        if (index != -1) {
            DynamicObject user = (DynamicObject)model.getValue("user", index);
            userId = (Long)user.getPkValue();
        }
        int myIndex = model.getEntryCurrentRowIndex("entryentity_my");
        Long curUserId = CommonServiceHelper.getCurrentUserID();
        switch (key) {
            case "myon": {
                model.setValue("myispraise", (Object)"0", myIndex);
                IntegralServiceHelper.deletePraiseRecord((long)curUserId, (long)userId);
                IntegralServiceHelper.insertUserScore((Long)curUserId, (int)0, (boolean)false, (boolean)true);
                IntegralServiceHelper.deletePraiseIntegralRercord((long)userId);
                break;
            }
            case "myoff": {
                model.setValue("myispraise", (Object)"1", myIndex);
                IntegralServiceHelper.insertPraiseRecord((long)curUserId, (long)userId);
                IntegralServiceHelper.insertUserScore((Long)curUserId, (int)0, (boolean)true, (boolean)false);
                IntegralServiceHelper.insertPraiseIntegralRercord((Long)userId);
                break;
            }
            case "on": {
                if (curUserId.equals(userId)) {
                    model.setValue("ismy", (Object)true, index);
                    this.ChoooseMyEntryRow();
                    break;
                }
                model.setValue("ispraise", (Object)"0", index);
                IntegralServiceHelper.deletePraiseRecord((long)curUserId, (long)userId);
                IntegralServiceHelper.insertUserScore((Long)userId, (int)0, (boolean)false, (boolean)true);
                IntegralServiceHelper.deletePraiseIntegralRercord((long)userId);
                break;
            }
            case "off": {
                if (curUserId.equals(userId)) {
                    model.setValue("ismy", (Object)true, index);
                    this.ChoooseMyEntryRow();
                    break;
                }
                model.setValue("ispraise", (Object)"1", index);
                IntegralServiceHelper.insertPraiseRecord((long)curUserId, (long)userId);
                IntegralServiceHelper.insertUserScore((Long)userId, (int)0, (boolean)true, (boolean)false);
                IntegralServiceHelper.insertPraiseIntegralRercord((Long)userId);
                break;
            }
            case "labelap_viewintegralrule": 
            case "flex_viewintegralrule": 
            case "image_viewintegralrule": {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("formId", "er_integralrule_m");
                paramMap.put("formName", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u89c4\u5219", (String)"IntegralboardPagePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                paramMap.put("formType", "5");
                ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
                break;
            }
        }
        this.refreshIntegral(curUserId);
        this.getView().updateView();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.shareBillToYZJ();
    }

    public void entryRowClick(RowClickEvent arg0) {
        String key;
        CardEntry source = (CardEntry)arg0.getSource();
        switch (key = source.getKey()) {
            case "entryentity_my": {
                this.ChoooseMyEntryRow();
                break;
            }
            case "entryentity1": {
                this.ChoooseEntryRows();
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    private void ChoooseMyEntryRow() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_myintegralview");
        paramMap.put("formName", ResManager.loadKDString((String)"\u6211\u7684\u4e3b\u9875", (String)"IntegralboardPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        paramMap.put("formType", "5");
        paramMap.put("needCallBack", Boolean.TRUE);
        HashMap<String, Comparable<Boolean>> mapCustomParam = new HashMap<String, Comparable<Boolean>>();
        mapCustomParam.put("isMyView", Boolean.valueOf(true));
        mapCustomParam.put("myPrasieTotalcount", Integer.valueOf(myPrasieTotalcount));
        mapCustomParam.put("myYearScore", Integer.valueOf(myYearScore));
        paramMap.put("customParam", mapCustomParam);
        ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
    }

    private void ChoooseEntryRows() {
        Long curUserId;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity1");
        int index = grid.getEntryState().getFocusRow();
        DynamicObject focusUser = (DynamicObject)this.getModel().getValue("user", index);
        Long focusUserId = (Long)focusUser.getPkValue();
        if (focusUserId.compareTo(curUserId = CommonServiceHelper.getCurrentUserID()) == 0) {
            this.ChoooseMyEntryRow();
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_myintegralview");
        paramMap.put("formName", ResManager.loadKDString((String)"\u6211\u7684\u4e3b\u9875", (String)"IntegralboardPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        paramMap.put("formType", "5");
        paramMap.put("needCallBack", Boolean.TRUE);
        HashMap<String, Comparable<Boolean>> mapCustomParam = new HashMap<String, Comparable<Boolean>>();
        mapCustomParam.put("isMyView", Boolean.valueOf(false));
        mapCustomParam.put("index", Integer.valueOf(index));
        paramMap.put("customParam", mapCustomParam);
        ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_myintegralview".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.ChoooseMyEntryRow();
        }
    }

    private String getCallBackUrl() {
        String formid = this.getView().getFormShowParameter().getFormId();
        String callBackUrl = "";
        RequestContext requestContext = RequestContext.get();
        String clientUrl = requestContext.getClientUrl();
        int last = clientUrl.lastIndexOf("/form/invokeAction.do");
        if (last <= 0) {
            last = clientUrl.lastIndexOf("/form/batchInvokeAction.do");
        }
        if (last > 0) {
            clientUrl = clientUrl.substring(0, last);
            callBackUrl = clientUrl + "/auth/yzjChatCallbackAction.do?";
            if (!"".equalsIgnoreCase(formid) && !StringUtils.isBlank((CharSequence)formid)) {
                callBackUrl = callBackUrl + "&formId=" + formid;
            }
            if (requestContext.getUserId() != null) {
                String pkid = requestContext.getUserId();
                callBackUrl = callBackUrl + "&pkId=" + pkid;
            }
        }
        return callBackUrl;
    }

    private void refreshIntegral(long curUserId) {
        DynamicObjectCollection entrys;
        this.logger.info("\u52a0\u8f7d\u79ef\u5206\u5217\u8868\u6570\u636e curUserId:" + curUserId);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection myEntry = (DynamicObjectCollection)dataEntity.get("entryentity_my");
        if (!myEntry.isEmpty()) {
            myEntry.clear();
        }
        if (!(entrys = (DynamicObjectCollection)dataEntity.get("entryentity1")).isEmpty()) {
            entrys.clear();
        }
        this.getView().updateView();
        long Orgid = UserServiceHelper.getUserMainOrgId((long)curUserId);
        ArrayList<Long> Orgids = new ArrayList<Long>();
        Orgids.add(Orgid);
        List subOrgIds = OrgUnitServiceHelper.getSubOrgLimitLevel(Orgids, (int)1, (boolean)true);
        List allUserList = UserServiceHelper.getAllUsersOfOrg((List)subOrgIds, (boolean)false);
        StringBuilder userIdsBuffer = new StringBuilder(String.valueOf(curUserId));
        StringBuilder noteBuffer = new StringBuilder("?");
        Map praiseCountMap = null;
        DynamicObjectCollection scoreDynamicObjects = IntegralServiceHelper.getPraiseUserDataSet((List)allUserList, (Long)curUserId);
        if (scoreDynamicObjects != null && !scoreDynamicObjects.isEmpty()) {
            int loopIdx = 0;
            for (DynamicObject obj : scoreDynamicObjects) {
                Long uid = obj.getLong("user");
                if (++loopIdx > 50) continue;
                userIdsBuffer.append(",");
                userIdsBuffer.append(uid);
                noteBuffer.append(",?");
            }
        }
        praiseCountMap = IntegralServiceHelper.getUserCurrentDayPraiseCountMap((String)userIdsBuffer.toString(), (StringBuilder)noteBuffer);
        if (scoreDynamicObjects != null && !scoreDynamicObjects.isEmpty()) {
            int newEntrySize = scoreDynamicObjects.size() > 50 ? 50 : scoreDynamicObjects.size();
            model.batchCreateNewEntryRow("entryentity1", newEntrySize);
            for (int i = 0; i < newEntrySize; ++i) {
                DynamicObject scoreDynamicObject = (DynamicObject)scoreDynamicObjects.get(i);
                long userId = scoreDynamicObject.getLong("user");
                if (curUserId == userId) {
                    myRank = i + 1;
                }
                int rank = i + 1;
                model.setValue("ranking", (Object)rank, i);
                model.setValue("avatar", (Object)scoreDynamicObject.getString("avatar"), i);
                model.setValue("nikename", (Object)scoreDynamicObject.getString("name"), i);
                model.setValue("user", (Object)userId, i);
                int praisecount = this.getUserPraiseCount(praiseCountMap, userId);
                if (praisecount > 0) {
                    model.setValue("isPraise", (Object)"1", i);
                } else {
                    model.setValue("isPraise", (Object)"0", i);
                }
                model.setValue("praisecount", (Object)praisecount, i);
                model.setValue("yearscore", (Object)scoreDynamicObject.getString("yearscore"), i);
            }
        }
        try {
            String myAvatar;
            DynamicObject myScore = IntegralServiceHelper.getMyScoreList((Long)curUserId);
            if (myScore == null) {
                DynamicObject userDynamicObject = CommonServiceHelper.getObjById((String)"bos_user", (Long)curUserId);
                myAvatar = userDynamicObject.getString("picturefield");
                if (scoreDynamicObjects != null) {
                    myRank = scoreDynamicObjects.size() + 1;
                }
            } else {
                myAvatar = myScore.getString("user.picturefield");
                myYearScore = myScore.getInt("yearscore");
                myPrasieTotalcount = myScore.getInt("praisecount");
            }
            myPrasiecount = this.getUserPraiseCount(praiseCountMap, curUserId);
            int myIndex = model.createNewEntryRow("entryentity_my");
            model.setValue("myranking", (Object)myRank, myIndex);
            model.setValue("myavatar", (Object)myAvatar, myIndex);
            model.setValue("myyearscore", (Object)myYearScore, myIndex);
            model.setValue("mypraisecount", (Object)myPrasiecount, myIndex);
            model.setValue("myuser", (Object)curUserId, myIndex);
            if (myPrasiecount > 0) {
                model.setValue("myisPraise", (Object)"1", myIndex);
            } else {
                model.setValue("myisPraise", (Object)"0", myIndex);
            }
        }
        catch (Exception e) {
            this.logger.error("IntegralboardPagePlugin>>>", (Throwable)e);
        }
    }

    private void shareBillToYZJ() {
        RequestContext requestContext;
        String clientUrl;
        int last;
        this.getView().addService(YzjShareDataModel.class, (Object)new YzjShareDataModel());
        String title = this.getView().getFormShowParameter().getFormConfig().getCaption().toString();
        String formid = this.getView().getFormShowParameter().getFormId();
        String formUrl = "";
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String pkid = "";
        if (!StringUtils.isBlank((CharSequence)showParameter.getFormId())) {
            pkid = showParameter.getFormId();
        }
        if ((last = (clientUrl = (requestContext = RequestContext.get()).getClientUrl()).lastIndexOf("/form/invokeAction.do")) <= 0) {
            last = clientUrl.lastIndexOf("/form/batchInvokeAction.do");
        }
        if (last > 0) {
            clientUrl = clientUrl.substring(0, last);
            formUrl = clientUrl + "/mobile.html?ierpanchor=form/" + formid;
            if (!"".equalsIgnoreCase(pkid) && !StringUtils.isBlank((CharSequence)pkid)) {
                formUrl = formUrl + "/?pkId=" + pkid;
            }
        }
        DynamicObject myScore = IntegralServiceHelper.getMyScoreList((Long)CommonServiceHelper.getCurrentUserID());
        int yearscore = 0;
        if (myScore != null) {
            yearscore = myScore.getInt("yearscore");
        }
        String content = String.format(ResManager.loadKDString((String)"\u6211\u7684\u79ef\u5206\u662f%s,\u4f4e\u78b3\u51fa\u5dee,\u6211\u4e3a\u81ea\u5df1\u5e26\u76d0,\u5feb\u5230\u7897\u91cc\u6765\u70b9\u8d5e~", (String)"IntegralboardPagePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), yearscore);
        String webpageUrl = formUrl;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put("content", content);
        map.put("webpageUrl", webpageUrl);
        map.put("cellContent", content);
        map.put("callBackUrl", this.getCallBackUrl());
        map.put("formid", formid);
        map.put("pkId", CommonServiceHelper.getCurrentUserID());
        map.put("shareUserId", CommonServiceHelper.getCurrentUserID());
        this.getPageCache().put("yzjShareData", SerializationUtils.toJsonString(map));
        for (Map.Entry entry : map.entrySet()) {
            this.getView().getFormShowParameter().setCustomParam((String)entry.getKey(), entry.getValue());
        }
        this.logger.info("the integralboard share flag infos of webpageUrl is" + webpageUrl);
    }

    private int getUserPraiseCount(Map<Long, Integer> praiseCountMap, Long userId) {
        int count = 0;
        if (null != praiseCountMap) {
            count = praiseCountMap.getOrDefault(userId, 0);
        }
        return count;
    }
}

