/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgListSelectMobPlugin
extends AbstractMobFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"orgctrl"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String applierId = (String)this.getView().getFormShowParameter().getCustomParam("applierId");
        if (applierId == null) {
            applierId = RequestContext.get().getUserId();
        }
        this.initOrgList(applierId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("orgentity");
        String orgId = (String)this.getModel().getValue("orgid", rowIndex);
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("orgId", orgId);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void initOrgList(String applierId) {
        QFilter filter = new QFilter("user.id", "=", (Object)Long.parseLong(applierId));
        Map userpositions = BusinessDataServiceHelper.loadFromCache((String)"bos_userposition", (String)"org,position", (QFilter[])filter.toArray());
        this.getModel().deleteEntryData("orgentity");
        for (DynamicObject item : userpositions.values()) {
            String orgId = item.getString("org.id");
            String orgName = item.getString("org.name");
            Map companyInfo = OrgUnitServiceHelper.getCompanyfromOrg((Long)Long.parseLong(orgId));
            String companyName = "";
            if (companyInfo != null) {
                companyName = companyInfo.get("name").toString();
            }
            orgName = orgName + " / " + companyName;
            int rowIndex = this.getModel().createNewEntryRow("orgentity");
            this.getModel().setValue("orgname", (Object)orgName, rowIndex);
            this.getModel().setValue("orgid", (Object)orgId, rowIndex);
        }
        this.getView().updateView("orgentity");
    }
}

