/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.mobile.BaseTemplateList;

public class PayerList
extends BaseTemplateList
implements ClickListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_edit", "btn_delete", "btn_addbank", "btn_notdefault", "btn_default", "btn_edit", "labelap_addbankcard"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof MobileListShowParameter && !((MobileListShowParameter)formShowParameter).isLookUp()) {
            Long userId = CommonServiceHelper.getCurrentUserID();
            BillList list = (BillList)this.getControl("billlistap");
            QFilter qFilter = new QFilter("creator", "=", (Object)userId);
            qFilter = qFilter.or("payer", "=", (Object)userId);
            qFilter = qFilter.or("userid.FBASEDATAID", "=", (Object)userId);
            Object applierId = formShowParameter.getCustomParam("applierId");
            if (applierId != null && userId.compareTo(Long.valueOf(applierId.toString())) != 0) {
                qFilter = qFilter.or("creator", "=", applierId);
                qFilter = qFilter.or("payer", "=", applierId);
                qFilter = qFilter.or("userid.FBASEDATAID", "=", applierId);
            }
            qFilter = qFilter.and("enable", "=", (Object)"1");
            list.setFilter(qFilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ListSelectedRowCollection allRowCollection = ((BillList)this.getControl("billlistap")).getCurrentListAllRowCollection();
        boolean visiableFlag = allRowCollection != null && allRowCollection.size() > 0;
        this.getView().setVisible(Boolean.valueOf(visiableFlag), new String[]{"billlistap", "mobfiltersortap", "btn_addbank"});
        this.getView().setVisible(Boolean.valueOf(!visiableFlag), new String[]{"nocardflex"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Long currentId = CommonServiceHelper.getCurrentUserID();
        BillList list = (BillList)this.getControl("billlistap");
        switch (key) {
            case "btn_delete": {
                long payerId = (Long)list.getSelectedRows().get(0).getPrimaryKeyValue();
                DynamicObject payerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)payerId, (String)"er_payeer", (String)"creator.id");
                String creator = payerInfo.getString("creator_id");
                if (creator.equals(currentId.toString())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u975e\u8be5\u6536\u6b3e\u4fe1\u606f\u7684\u521b\u5efa\u8005\uff0c\u8bf7\u8054\u7cfb\u521b\u5efa\u4eba\u6216\u7ba1\u7406\u5458\u3002", (String)"PayerList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Long currentUserId = CommonServiceHelper.getCurrentUserID();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BillList list = (BillList)this.getControl("billlistap");
        switch (key) {
            case "btn_default": {
                long curPayInfoPkID = (Long)list.getSelectedRows().get(0).getPrimaryKeyValue();
                this.changePayerDefault(currentUserId, Boolean.FALSE, curPayInfoPkID);
                list.refresh();
                break;
            }
            case "btn_notdefault": {
                long curPayInfoPkID = (Long)list.getSelectedRows().get(0).getPrimaryKeyValue();
                DynamicObject payerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)curPayInfoPkID, (String)"er_payeer", (String)"creator.id,payer");
                Long psyerId = payerInfo.getLong("payer_id");
                if (this.changePayerDefault(currentUserId, Boolean.TRUE, curPayInfoPkID)) {
                    PayeeServiceHelper.changeIsDefaultPayers((Long)psyerId, (Object)curPayInfoPkID);
                }
                list.refresh();
                break;
            }
            case "btn_addbank": 
            case "labelap_addbankcard": {
                String isloopup;
                paramMap.put("formId", "er_payeer_mob");
                paramMap.put("formName", ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f", (String)"PayerList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                paramMap.put("formType", "8");
                HashMap<String, String> mapCustomParam = new HashMap<String, String>();
                mapCustomParam.put("MUTEX_OPER_KEY", "add");
                if (customParams.size() > 0 && "true".equals(isloopup = (String)customParams.get("isloopup"))) {
                    mapCustomParam.put("isloopup", "true");
                }
                paramMap.put("customParam", mapCustomParam);
                paramMap.put("needCallBack", Boolean.TRUE);
                ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
            }
        }
    }

    private boolean changePayerDefault(Long currentUserId, Boolean isDefault, Long curPayInfoPkID) {
        List defaultAccts;
        DynamicObject payeeob = BusinessDataServiceHelper.loadSingleFromCache((Object)curPayInfoPkID, (String)"er_payeer", (String)"id,creator,payer,isdefault,isemployee");
        if (!payeeob.getBoolean("isemployee")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u804c\u5458\u7684\u6536\u6b3e\u4fe1\u606f\u4e0d\u80fd\u8bbe\u7f6e\u6210\u9ed8\u8ba4\u3002", (String)"PayerList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long creatorId = payeeob.getLong("creator_id");
        Long payerId = payeeob.getLong("payer_id");
        if ((creatorId.equals(currentUserId) || payerId.equals(currentUserId)) && !payerId.equals(currentUserId) && !(defaultAccts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)payerId, (Object)curPayInfoPkID, (boolean)false)).isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5df2\u5b58\u5728\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\uff0c\u65e0\u6cd5\u518d\u8bbe\u7f6e\u3002", (String)"PayeeEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (currentUserId.equals(creatorId) || currentUserId.equals(payerId)) {
            payeeob.set("isdefault", (Object)isDefault);
            SaveServiceHelper.update((DynamicObject)payeeob);
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672c\u4eba\u6216\u672c\u4eba\u7ef4\u62a4\u7684\u8d26\u53f7\u624d\u80fd\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayerList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_payeer_mob".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
        }
    }
}

