/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.dailybiz.DailyReimCreateOrderEntrysUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class PublicReimBillOrderMobileEdit
extends AbstractBillPlugIn {
    private static final String DELETE_EXPENSE_ENTRY_IDS = "DELETE_EXPENSE_ENTRY_IDS_MOB";
    private static final Log logger = LogFactory.getLog(PublicReimBillOrderMobileEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"image_order"});
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity".equals(entryName)) {
            IDataModel model = this.getModel();
            int[] rowIndexs = e.getRowIndexs();
            ArrayList<Long> deleteIDS = new ArrayList<Long>(rowIndexs.length);
            for (int rowIndex : rowIndexs) {
                Long id = ErCommonUtils.getPk((Object)model.getEntryRowEntity(entryName, rowIndex));
                deleteIDS.add(id);
            }
            ActionLocalCache.get().put(DELETE_EXPENSE_ENTRY_IDS, deleteIDS);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity".equals(entryName)) {
            IDataModel model = this.getModel();
            List deleteIds = (List)ActionLocalCache.get().getDefaultIfNull(DELETE_EXPENSE_ENTRY_IDS, new ArrayList());
            if (deleteIds.size() > 0) {
                ArrayList<Integer> needDeleteRows = new ArrayList<Integer>();
                DynamicObjectCollection orderEntries = model.getEntryEntity("orderentry");
                for (int i = 0; i < orderEntries.size(); ++i) {
                    DynamicObject orderEntry = (DynamicObject)orderEntries.get(i);
                    Long ordexpenseentryid = orderEntry.getLong("ordexpenseentryid");
                    if (!deleteIds.contains(ordexpenseentryid)) continue;
                    needDeleteRows.add(i);
                }
                model.deleteEntryRows("orderentry", needDeleteRows.stream().mapToInt(Integer::intValue).toArray());
            }
            BigDecimal monthSettleAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)"expenseentryentity", (String)"tripbookcuramount");
            model.setValue("monthsettleamount", (Object)monthSettleAmount);
        }
    }

    public void click(EventObject evt) {
        Control ctl;
        super.click(evt);
        if (evt.getSource() instanceof Control && StringUtils.equalsIgnoreCase((CharSequence)(ctl = (Control)evt.getSource()).getKey(), (CharSequence)"image_order")) {
            IDataModel model = this.getModel();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
            int index = model.getEntryCurrentRowIndex("expenseentryentity");
            paramMap.put("formId", "er_reimbursedetail_mb");
            paramMap.put("formName", ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u6708\u7ed3\u5206\u5f55\u8be6\u60c5", (String)"PublicReimBillOrderMobileEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            paramMap.put("formType", "5");
            paramMap.put("needCallBack", Boolean.TRUE);
            DynamicObject expenseEntryRow = model.getEntryRowEntity("expenseentryentity", index);
            DynamicObjectCollection orderEntrys = model.getEntryEntity("orderentry");
            Map orderMap = DailyReimCreateOrderEntrysUtil.getRelationOrderMap((DynamicObjectCollection)orderEntrys, (Long)ErCommonUtils.getPk((Object)expenseEntryRow));
            mapCustomParam.put("ordernum", orderMap.getOrDefault("orderNum", ""));
            mapCustomParam.put("currencyId", ErCommonUtils.getPk((Object)expenseEntryRow.getDynamicObject("entrycurrency")));
            mapCustomParam.put("orderformid", orderMap.getOrDefault("orderFormid", ""));
            paramMap.put("customParam", mapCustomParam);
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }
}

