/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class TripBooknavigationEdit
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(TripBooknavigationEdit.class);
    protected static final String[] tripControlIds = new String[]{"bee_domair", "bee_intair", "bee_train", "bee_car", "flex_beecar", "flex_beetrain", "bee_hotel", "corp_domair", "corp_hotel", "corp_car", "corp_train", "travelnoone_domair", "travelnoone_hotel", "travelnoone_car", "travelnoone_train"};
    protected static final String[] didiControlIds = new String[]{"didi_car", "flexpanelapdidicar", "flex_didicar", "didi_home"};
    protected static final String[] dtgControlIds = new String[]{"dtg_home", "dtg_plane_in", "dtg_plane_out", "dtg_hotel_in", "dtg_hotel_out", "dtg_car", "dtg_train"};
    protected static final String[] aliControlIds = new String[]{"ali_home", "ali_plane", "ali_hotel", "ali_car", "ali_train", "ali_list"};
    protected static final String[] qControlIds = new String[]{"qicheng_home", "qicheng_domair", "qicheng_intair", "qicheng_domhotel", "qicheng_car", "qicheng_train"};
    protected static final String[] meiyaControlIds = new String[]{"meiya_home", "meiya_plane", "meiya_hotel", "meiya_train", "meiya_list"};

    public void registerListener(EventObject e) {
        this.addClickListeners(tripControlIds);
        this.addClickListeners(didiControlIds);
        this.addClickListeners(dtgControlIds);
        this.addClickListeners(aliControlIds);
        this.addClickListeners(qControlIds);
        this.addClickListeners(meiyaControlIds);
        this.addClickListeners(new String[]{"gaode_car"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        logger.info("Click key is: " + key);
        if (Arrays.asList(tripControlIds).contains(key) || Arrays.asList(dtgControlIds).contains(key) || Arrays.asList(aliControlIds).contains(key) || Arrays.asList(qControlIds).contains(key) || Arrays.asList(meiyaControlIds).contains(key)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map paraMap = parameter.getCustomParams();
            HashMap<String, Object> tmpParamMap = new HashMap<String, Object>(paraMap.size());
            tmpParamMap.putAll(paraMap);
            tmpParamMap.put("key", key);
            tmpParamMap.put("isPC", false);
            tmpParamMap.put("formId", "er_externalsystem");
            tmpParamMap.put("formName", ResManager.loadKDString((String)"\u5546\u65c5", (String)"TripBooknavigationEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            tmpParamMap.put("formType", "5");
            TripCommonUtil.openTripPage((IFormView)this.getView(), tmpParamMap);
        } else if (Arrays.asList(didiControlIds).contains(key)) {
            Map paramMap = CommonServiceHelper.getUserMap((Long)CommonServiceHelper.getCurrentUserID());
            paramMap.put("view", this.getView());
            paramMap.put("businessType", "car");
            ITripService tripService = TripServiceFactory.getTripService((String)"DiDiTripService");
            tripService.login(paramMap);
        } else if ("gaode_car".equals(key)) {
            TripCommonUtil.openFieldMappingLogin((IFormView)this.getView(), (String)key, (String)Supplier.GAODE.name());
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean isCancel = TripCommonUtil.validateBizInfo((String)key, (IFormView)this.getView());
        evt.setCancel(isCancel);
        if (!isCancel) {
            String server = "";
            DynamicObjectCollection servers = null;
            boolean loginExternalPlat = false;
            if (key != null && key.startsWith("corp")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.XIECHENG.name());
                server = Supplier.XIECHENG.name();
            } else if (key != null && key.contains("travelnoone")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.CHAILVYIHAO.name());
                server = Supplier.CHAILVYIHAO.name();
            } else if (key != null && key.contains("didi")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.DIDI.name());
                server = Supplier.DIDI.name();
                loginExternalPlat = true;
            } else if (key != null && key.contains("gaode")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.GAODE.name());
                server = Supplier.GAODE.name();
                loginExternalPlat = true;
            } else if (Arrays.asList(dtgControlIds).contains(key)) {
                servers = TripUserGrantUtils.getServers((String)Supplier.TONGCHENG.name());
                server = Supplier.TONGCHENG.name();
                loginExternalPlat = true;
            } else if (Arrays.asList(aliControlIds).contains(key)) {
                servers = TripUserGrantUtils.getServers((String)Supplier.ALI.name());
                server = Supplier.ALI.name();
                loginExternalPlat = true;
            } else if (Arrays.asList(qControlIds).contains(key)) {
                servers = TripUserGrantUtils.getServers((String)Supplier.QICHENG.name());
                server = Supplier.QICHENG.name();
                loginExternalPlat = true;
            } else if (Arrays.asList(meiyaControlIds).contains(key)) {
                servers = TripUserGrantUtils.getServers((String)Supplier.MEIYA.name());
                server = Supplier.MEIYA.name();
                loginExternalPlat = true;
            }
            if (CollectionUtils.isNotEmpty((Collection)servers)) {
                boolean grant = TripUserGrantUtils.judgeIsOpenPage((DynamicObjectCollection)servers);
                if (grant) {
                    TripUserGrantUtils.openRemindPage((boolean)Boolean.FALSE, (IFormView)this.getView(), (boolean)Boolean.FALSE, (String)server, (IFormPlugin)this, (String)(loginExternalPlat ? "true" : "false"));
                }
                evt.setCancel(grant);
            }
        }
    }

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        TripCommonUtil.controlBusinessTrealPanleHiding((IFormView)this.getView());
    }

    public void showPage(FormModel formModel) {
        if (formModel == null) {
            return;
        }
        String formId = formModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripBooknavigationEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }
}

