/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.CarTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.mobile.DailyVehicleSelectPlugin;
import kd.fi.er.formplugin.mobile.TripReqSelectPlugin;

public class TripCartypeSelectPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static Log logger = LogFactory.getLog(TripCartypeSelectPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.showData();
    }

    private void showData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String number = (String)parameter.getCustomParams().get("number");
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("server", "=", (Object)number);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype", (QFilter[])new QFilter[]{qA, qB});
        if (null != objectDynamicObjectMap) {
            int i = 0;
            for (DynamicObject dynamice : objectDynamicObjectMap.values()) {
                model.batchCreateNewEntryRow("entryentity", 1);
                model.setValue("vehicletypename", (Object)dynamice.getString("name"), i);
                model.setValue("cartype", (Object)dynamice.getString("vehicletype"), i);
                model.setValue("vehicletype", (Object)dynamice.getString("number"), i);
                model.setValue("number", (Object)number, i);
                ++i;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        List<Map<String, Object>> bills;
        IDataModel model = ((CardEntry)evt.getSource()).getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String key = (String)parameter.getCustomParams().get("key");
        String number = (String)parameter.getCustomParams().get("number");
        String cartype = (String)model.getValue("cartype");
        String vehicletype = (String)model.getValue("vehicletype");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("showType", ShowType.Modal);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("key", key);
        paramMap.put("customParam", customParam);
        if (cartype.equals(CarTypeEnum.TRAVEL.getCode())) {
            bills = TripReqSelectPlugin.getData(number, true);
            this.openReqTripList(paramMap, customParam, bills, number, cartype);
        }
        if (cartype.equals(CarTypeEnum.DAILY.getCode()) || cartype.equals(CarTypeEnum.HOVERTIME.getCode())) {
            bills = DailyVehicleSelectPlugin.getData(cartype, number);
            this.openReqTripList(paramMap, customParam, bills, number, cartype);
        }
        if (cartype.equals(CarTypeEnum.OVERTIME.getCode())) {
            HashMap<String, Boolean> travelnoCustomParam = new HashMap<String, Boolean>();
            travelnoCustomParam.put("isPC", false);
            travelnoCustomParam.put("employeeNumber", (Boolean)UserServiceHelper.getUserInfoByID((long)Long.parseLong(RequestContext.get().getUserId())).get("number"));
            if (Supplier.ZHONGXING.name().equals(number)) {
                TripCommonUtil.openURL((String)"bee", (String)"car", travelnoCustomParam, (IFormView)this.getView());
                return;
            }
            if (Supplier.XIECHENG.name().equals(number)) {
                TripCommonUtil.openURL((String)"corp", (String)"car", travelnoCustomParam, (IFormView)this.getView());
                return;
            }
            TripCommonUtil.openURL((String)number, (String)"car", travelnoCustomParam, (IFormView)this.getView());
        }
    }

    private void openReqTripList(Map<String, Object> paramMap, Map<String, Object> customParam, List<Map<String, Object>> bills, String number, String cartype) {
        if (!(bills == null || bills.isEmpty() || bills.size() <= 1 && number.equals(Supplier.CHAILVYIHAO.name()))) {
            paramMap.put("needCallBack", true);
            if (CarTypeEnum.TRAVEL.getCode().equals(cartype)) {
                paramMap.put("formId", "er_tripreq_sel");
            } else if (CarTypeEnum.DAILY.getCode().equals(cartype) || CarTypeEnum.HOVERTIME.getCode().equals(cartype)) {
                paramMap.put("formId", "er_dailyvehicle_sel");
            }
            customParam.put("bills", bills);
            ShowPageUtils.showMobileForm(paramMap, (AbstractFormPlugin)this);
        } else if (bills != null && bills.size() == 1 && number.equals(Supplier.CHAILVYIHAO.name())) {
            Map paraMap = new HashMap();
            if (CarTypeEnum.TRAVEL.getCode().equals(cartype)) {
                paraMap = TripCommonUtil.getBusinessSectionInfo((Long)Long.parseLong(bills.get(0).get("id").toString()));
            } else if (CarTypeEnum.DAILY.getCode().equals(cartype) || CarTypeEnum.HOVERTIME.getCode().equals(cartype)) {
                paraMap = TripCommonUtil.getBusinessSectionInfoByDaily((Long)Long.parseLong(bills.get(0).get("id").toString()));
            }
            HashMap<String, Boolean> travelnoCustomParam = new HashMap<String, Boolean>();
            travelnoCustomParam.put("isPC", false);
            travelnoCustomParam.put("employeeNumber", (Boolean)UserServiceHelper.getUserInfoByID((long)Long.parseLong(RequestContext.get().getUserId())).get("number"));
            travelnoCustomParam.putAll(paraMap);
            TripCommonUtil.openURL((String)number, (String)"car", travelnoCustomParam, (IFormView)this.getView());
        } else if (bills == null || bills.isEmpty()) {
            paramMap.put("needCallBack", true);
            if (CarTypeEnum.TRAVEL.getCode().equals(cartype)) {
                paramMap.put("formId", "er_tripreq_create");
            }
            if (CarTypeEnum.DAILY.getCode().equals(cartype) || CarTypeEnum.HOVERTIME.getCode().equals(cartype)) {
                paramMap.put("formId", "er_dailyvehicle_create");
            }
            ShowPageUtils.showMobileForm(paramMap, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() instanceof Map) {
            Map ret = (Map)closedCallBackEvent.getReturnData();
            this.getView().returnDataToParent((Object)ret);
            this.getView().close();
        }
    }
}

