/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ai.util.AIPlatformUtil;
import kd.bos.bill.MobileFormPosition;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.IntegralServiceHelper;
import kd.fi.er.business.trip.overtime.TripOrderBillOvertimeHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang.StringUtils;

public class TripMainPagePlugin
extends AbstractFormPlugin {
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();
    private static final Log logger = LogFactory.getLog(TripMainPagePlugin.class);
    public static final int INTEGRALSCORE = 10;
    private static final String ER_APP_ID = "18XD+/5EDN8X";
    private static final String FLEX_HEADER = "flex_header";
    private static final String FLEX_TRIPIMG = "flex_tripimg";
    private int myRank = 1;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
        this.addClickListeners(new String[]{"mnutriprequest", "mnutripreimbur", "flex_oustangding", "flex_waiting", "imag_help", FLEX_HEADER, "mnutripreimburgrid", "wf_mobile"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter p = (FormShowParameter)e.getSource();
        if (p.getAppId() == null) {
            p.setAppId("tra");
        }
    }

    public void afterBindData(EventObject e) {
        boolean b = TripUserGrantUtils.checkServerAuth((IFormView)this.getView(), (String)"", (boolean)false);
        if (!b) {
            this.checkOvertimeOrderBill();
        }
        this.setFlexHeader();
        this.setTripReimMenu();
    }

    private void setTripReimMenu() {
        String tripReimType = SystemParamterUtil.getTripReimburseTypeByCurrentUser();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)tripReimType, (CharSequence)"card")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mnutripreimbur"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"mnutripreimburgrid"});
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)tripReimType, (CharSequence)"grid")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mnutripreimbur"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"mnutripreimburgrid"});
        }
    }

    private void setFlexHeader() {
        Long mainCompany = CommonServiceHelper.getCompanyIdByUserId((Long)CommonServiceHelper.getCurrentUserID());
        Control header_banner = this.getControl(FLEX_HEADER);
        if (header_banner != null && mainCompany != null && SystemParamterUtil.isUseLittleKApp((Long)mainCompany)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_TRIPIMG});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_HEADER});
        }
    }

    private void checkOvertimeOrderBill() {
        TripOrderBillOvertimeHelper helper = new TripOrderBillOvertimeHelper();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List overtimeOrderBill = helper.getOrderToRemind(userId);
        if (!overtimeOrderBill.isEmpty()) {
            HashMap<String, Integer> customParam = new HashMap<String, Integer>();
            customParam.put("count", overtimeOrderBill.size());
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", "er_overtime_remind");
            MobileFormShowParameter showParameter = (MobileFormShowParameter)FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setPosition(MobileFormPosition.Bottom);
            showParameter.setCustomParams(customParam);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "er_overtime_remind");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        FormModel formModel = null;
        HashMap<String, Object> customParamMap = new HashMap<String, Object>();
        MainPageModel mainPageModel = controlMap.get(key);
        boolean flag = TripCommonUtil.isCurrentUserLeader((Long)CommonServiceHelper.getCurrentUserID());
        if (FLEX_TRIPIMG.equals(key)) {
            formModel = flag ? new FormModel("er_trip_report", ResManager.loadKDString((String)"\u8db3\u8ff9", (String)"TripMainPagePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), "5") : new FormModel("er_timeline", ResManager.loadKDString((String)"\u4e2a\u4eba\u8db3\u8ff9", (String)"TripMainPagePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5");
        } else if (FLEX_HEADER.equalsIgnoreCase(key)) {
            AIPlatformUtil.invokeAIRobot((IFormView)this.getView());
        } else if (mainPageModel != null) {
            formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue());
        }
        if ("mmutirptips".equals(key)) {
            formModel = new FormModel("er_triptiplist", ResManager.loadKDString((String)"\u5dee\u65c5\u8d34\u58eb", (String)"TripMainPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5");
        }
        if ("mnutriprequest".equals(key)) {
            this.showMobList("er_tripreqbill", "er_tripreqlisttemplate", customParamMap, null);
        }
        if ("flex_waiting".equals(key)) {
            customParamMap.put("tabKey", "noReimburse");
            this.showMobList("er_tripreqbill", "er_tripreqlisttemplate", customParamMap, ResManager.loadKDString((String)"\u5f85\u62a5\u9500", (String)"TripMainPagePlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if ("mnutripreimbur".equals(key)) {
            this.showMobList("er_tripreimbursebill", "er_tripreimbilltemplate", null, null);
        }
        if ("flex_oustangding".equals(key)) {
            this.showMobList(this.getTripReimburseMobFormId(), "er_tripreimbilltemplate", null, null);
        }
        if (StringUtils.equals((String)key, (String)"mnutripreimburgrid")) {
            this.showMobList("er_tripreim_grid_mb", "er_tripreimbilltemplate", null, null);
        }
        if ("imag_help".equals(key)) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", "er_todotips");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callBackName");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
        if ("wf_mobile".equals(key)) {
            String clientFullContextPath = RequestContext.get().getClientFullContextPath();
            String suffixUrl = "mobile.html#/form/wf_mobilelist_mob";
            String url = clientFullContextPath + suffixUrl;
            HashMap<String, String> custom_param = new HashMap<String, String>();
            custom_param.put("url", url);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formType", "5");
            paramMap.put("formId", "er_wfmobilelist_mb");
            paramMap.put("customParam", custom_param);
            paramMap.put("needCallBack", Boolean.FALSE);
            paramMap.put("formName", ResManager.loadKDString((String)"\u5ba1\u6279\u5f85\u529e", (String)"ErMainPagePlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
        if (formModel == null) {
            return;
        }
        String formId = formModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripMainPagePlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private void showMobList(String billFormId, String formId, Map<String, Object> paraMap, String Caption) {
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId(ER_APP_ID);
        if (Caption != null) {
            showParameter.setCaption(Caption);
        }
        if (paraMap != null) {
            showParameter.setCustomParams(paraMap);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        this.initNotReimburse();
        String actionId = e.getActionId();
        if ("er_addNew_dialog".equalsIgnoreCase(actionId)) {
            if (e.getReturnData() != null) {
                FormModel formModel = (FormModel)e.getReturnData();
                if (formModel == null) {
                    return;
                }
                String formId = formModel.getFormId();
                if (StringUtils.isEmpty((String)formId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripMainPagePlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = formModel.getFormShowParameter();
                if (formShowParameter.getAppId() == null) {
                    formShowParameter.setAppId(ER_APP_ID);
                }
                FormShowParameter viewFormShowParameter = this.getView().getFormShowParameter();
                viewFormShowParameter.setAppId(ER_APP_ID);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
            }
        } else if ("er_overtime_remind".equalsIgnoreCase(actionId)) {
            this.overtimeRemindClosedCallBack(e);
        }
    }

    private void overtimeRemindClosedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null && "go".equals(returnData.toString())) {
            HashMap<String, Boolean> customParam = new HashMap<String, Boolean>();
            customParam.put("isRealTime", true);
            customParam.put("isOverdue", true);
            ShowPageUtils.showPage((FormModel)new FormModel("er_vieworder", ResManager.loadKDString((String)"\u67e5\u770b\u8ba2\u5355", (String)"TripMainPagePlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, customParam), (AbstractFormPlugin)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = CommonServiceHelper.getCurrentUserID();
        int count = IntegralServiceHelper.isFirstEnterApp((Long)userId);
        if (count == 0) {
            IntegralServiceHelper.insertUserScore((Long)userId, (int)10, (boolean)false, (boolean)false);
            IntegralServiceHelper.insertFirstEnterIntegralRescord((Long)userId);
        }
        this.initNotReimburse();
        ArrayList<String> avatarList = new ArrayList<String>();
        Long curUserId = CommonServiceHelper.getCurrentUserID();
        try {
            String avatarListOne;
            long Orgid = UserServiceHelper.getUserMainOrgId((long)curUserId);
            logger.info("TripMainPagePlugin afterCreateNewData Orgid:" + Orgid + "_curUserId:" + curUserId);
            ArrayList<Long> Orgids = new ArrayList<Long>();
            Orgids.add(Orgid);
            List subOrgIds = OrgUnitServiceHelper.getSubOrgLimitLevel(Orgids, (int)1, (boolean)true);
            List allUserList0 = UserServiceHelper.getAllUsersOfOrg((List)subOrgIds, (boolean)false);
            DynamicObjectCollection scoreDynamicObjects = IntegralServiceHelper.getPraiseUserDataSet((List)allUserList0, (Long)curUserId);
            int loginCount = IntegralServiceHelper.ishaveMyId((Long)CommonServiceHelper.getCurrentUserID());
            logger.info("TripMainPagePlugin afterCreateNewData loginCount:" + loginCount);
            String myYearScore = "0";
            if (loginCount == 0) {
                this.myRank = scoreDynamicObjects.size() + 1;
            } else {
                DynamicObject myScore = IntegralServiceHelper.getMyScoreList((Long)curUserId);
                myYearScore = myScore.getString("yearscore");
                if (scoreDynamicObjects != null && !scoreDynamicObjects.isEmpty()) {
                    logger.info("TripMainPagePlugin afterCreateNewData scoreDynamicObjects.size:" + scoreDynamicObjects.size());
                    int i = 0;
                    for (DynamicObject scoreDynamicObject : scoreDynamicObjects) {
                        Long uid = scoreDynamicObject.getLong("user");
                        if (i < 3) {
                            String avatarStr = scoreDynamicObject.getString("avatar");
                            if (StringUtils.isNotBlank((String)avatarStr) && !avatarStr.startsWith("http")) {
                                avatarStr = UrlService.getImageFullUrl((String)avatarStr);
                            }
                            avatarList.add(avatarStr);
                        }
                        if (curUserId.equals(uid)) {
                            this.myRank = i + 1;
                        }
                        ++i;
                    }
                }
            }
            logger.info("TripMainPagePlugin afterCreateNewData avatarList.size:" + avatarList.size());
            ((Label)this.getControl("labelap_myintegrerankv")).setText(this.myRank + "");
            ((Label)this.getControl("labelap_lowcarbonintegrv")).setText(myYearScore);
            if (avatarList.size() >= 3) {
                avatarListOne = (String)avatarList.get(0);
                String avatarListTwo = (String)avatarList.get(1);
                String avatarListThird = (String)avatarList.get(2);
                ((Image)this.getControl("image_avatar")).setUrl(avatarListOne);
                ((Image)this.getControl("image_avatartwo")).setUrl(avatarListTwo);
                ((Image)this.getControl("image_avatarthrid")).setUrl(avatarListThird);
            } else if (avatarList.size() == 2) {
                avatarListOne = (String)avatarList.get(0);
                String avatarListTwo = (String)avatarList.get(1);
                ((Image)this.getControl("image_avatar")).setUrl(avatarListOne);
                ((Image)this.getControl("image_avatartwo")).setUrl(avatarListTwo);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"image_avatarthrid", "image_no3"});
            } else if (avatarList.size() == 1) {
                avatarListOne = (String)avatarList.get(0);
                ((Image)this.getControl("image_avatar")).setUrl(avatarListOne);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"image_avatarthrid", "image_avatartwo", "image_no3", "image_no2"});
            }
            if (StringUtils.equals((String)this.getView().getEntityId(), (String)"er_mainpage")) {
                this.setRankAndDays();
            }
        }
        catch (SQLException e1) {
            logger.error("TripMainPagePlugin>>>", (Throwable)e1);
        }
    }

    protected void initNotReimburse() {
        DynamicObject dept;
        Map countMap = CommonServiceHelper.getNotReimburseCountUsedByEmPage((Long)CommonServiceHelper.getCurrentUserID());
        int tripNotReimburseCount = (Integer)countMap.get("tripNotReimburseCount");
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        logger.info("er outstandingamount userId:" + currentUserID);
        String amountStr = "0.00";
        BigDecimal amount = CommonServiceHelper.getTripReimburseOutStandingAmount((Long)currentUserID);
        Map userMap = CommonServiceHelper.getUserMap((Long)currentUserID);
        Label labelap_watingv = (Label)this.getView().getControl("labelap_watingv");
        Label labelap_outstandingv = (Label)this.getView().getControl("labelap_outstandingv");
        DynamicObject currency = null;
        labelap_watingv.setText(tripNotReimburseCount + "");
        if (userMap != null && (dept = (DynamicObject)userMap.get("org")) != null && (currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Long)((Long)dept.getPkValue()))) != null) {
            AmountFormatsUtil.setAmountLabel((Label)labelap_outstandingv, (DynamicObject)currency, (BigDecimal)amount);
        }
    }

    private void setRankAndDays() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"flex_trip"});
        view.setVisible(Boolean.valueOf(true), new String[]{"labelap"});
    }

    protected String getTripReimburseMobFormId() {
        return ErStdConfig.isEnableGridStyleInTripReimMob() ? "er_tripreim_grid_mb" : "er_tripreimbursebill";
    }

    static {
        controlMap.put(FLEX_TRIPIMG, new MainPageModel("er_timeline", ResManager.loadKDString((String)"\u4e2a\u4eba\u8db3\u8ff9", (String)"TripMainPagePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("mmutirptips", new MainPageModel("er_triptiplist", ResManager.loadKDString((String)"\u5dee\u65c5\u8d34\u58eb", (String)"TripMainPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TripMainPagePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
        controlMap.put("flexp_lowintegral2", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("flex_lowcarbonintegre", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_myintegrerankv", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("flex_myintegrerank", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_lowcarbonintegrv", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_myintegrerank", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_lowcarbonintegre", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("image_avatarthrid", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("image_avatartwo", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("image_avatar", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206\u699c", (String)"TripMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
    }
}

