/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.util.EntryCopyUtil;
import kd.fi.er.formplugin.web.TripEntryEdit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TripReimburseConsumcordPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(TripEntryEdit.class);
    private static final String[] requiredProps = new String[]{"from", "to", "startdate", "enddate", "vehicles", "travelers", "tripexpenseitem"};
    private static final String[] requiredSTDProps = new String[]{"overdesc"};
    protected static final String[] STDCTRL_ATTRIBUTE = new String[]{"5", "1", "2", "4", "7"};
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};
    protected static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};
    private static final String KEY_SUBMIT = "submit";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String INVOICE_HEAD_ENTRY = "invoiceentry";
    private static final String INVOICE_ITEM_ENTRY = "invoiceitementry";
    private static final String TRIPEXPENSEACTIONID = "showEspenseItem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addexpenseitem", "btn_save", "imageap_delete", "labelap_edit", "labelap_done", "image_invoice"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        MulBasedataEdit travelersF7 = (MulBasedataEdit)this.getControl("travelers");
        DynamicObject company = (DynamicObject)this.getView().getParentView().getModel().getValue("company");
        DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        TripBillTravelerUtils.getF7FilterInfo((DynamicObject)company, (DynamicObject)org, (BasedataEdit)travelersF7);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        int status = (Integer)mapCustomParam.get("status");
        IDataModel pModel = this.getView().getParentView().getModel();
        if (status == 1 && pModel.getDataEntity().getDataEntityType().getName().equals(this.getView().getEntityId())) {
            e.setDataEntity((Object)pModel.getDataEntity());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object tocity;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        model.setValue("billstatus", parentModel.getValue("billstatus"));
        model.setValue("automapinvoice", parentModel.getValue("automapinvoice"));
        model.setValue("editentry", (Object)"0");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap_done"});
        Map mapCustomParam = this.getView().getFormShowParameter().getCustomParams();
        Integer status = null;
        if (mapCustomParam != null) {
            Object applier;
            Object index = mapCustomParam.get("index");
            if (index != null) {
                this.getPageCache().put("parentViewTripIndex", index.toString());
            }
            status = (Integer)mapCustomParam.get("status");
            Object currency = mapCustomParam.get("currency");
            if (currency != null) {
                model.setValue("currency", (Object)Long.valueOf(currency.toString()));
            }
            if ((applier = mapCustomParam.get("applier")) != null) {
                model.setValue("applier", (Object)Long.valueOf(applier.toString()));
            }
        }
        Long companyId = ErCommonUtils.getPk((Object)parentModel.getValue("company"));
        model.setValue("company", (Object)companyId);
        model.setValue("costcompany", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("costcompany")));
        boolean iscurrencyshowintripentry = !DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel()) && SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        model.setValue("iscurrencyshowintripentry", (Object)iscurrencyshowintripentry);
        model.setValue("ismulwayto", parentModel.getValue("ismulwayto"));
        CommonServiceHelper.setMulWayToVisible((IDataModel)parentModel, (IFormView)this.getView());
        model.setValue("istravelers", parentModel.getValue("istravelers"));
        model.setValue("travelerssamestd", parentModel.getValue("travelerssamestd"));
        this.getModel().setValue("bizdate", parentView.getModel().getValue("bizdate"));
        if (status != null && status == 0) {
            this.initNewTripentryInfo(model, parentModel, mapCustomParam);
        } else if (status != null && status == 1) {
            this.updateTripentryInfo(model, parentModel, mapCustomParam, companyId);
        }
        if (mapCustomParam != null && null != (tocity = mapCustomParam.get("to"))) {
            Long cityId = Long.parseLong(tocity.toString());
            model.setValue("from", (Object)cityId, 0);
        }
        AmountChangeUtil.updateExpenseDetailAmountLabelForMob((IFormView)this.getView(), (IDataModel)model);
        this.setExpenseEntryLableCount();
        this.copyInvoiceFromParentToChildPage(this.getView().getParentView().getModel(), model);
    }

    private void updateTripentryInfo(IDataModel model, IDataModel parentModel, Map<String, Object> mapCustomParam, Long companyId) {
        DynamicObjectCollection ptrip = (DynamicObjectCollection)parentModel.getDataEntity(true).get("tripentry");
        Object indexObj = mapCustomParam.get("index");
        if (indexObj == null) {
            return;
        }
        int index = Integer.parseInt(indexObj.toString());
        DynamicObject viewTrip = (DynamicObject)ptrip.get(index);
        DynamicObject tripCurrency = (DynamicObject)viewTrip.get("tripcurrency");
        if (null == tripCurrency) {
            tripCurrency = (DynamicObject)parentModel.getValue("currency");
            viewTrip.set("tripcurrency", parentModel.getValue("currency"));
            viewTrip.set("tripexchangerate", (Object)BigDecimal.ONE);
            AmountChangeUtil.updateExpenseDetailAmountLabelForMob((IFormView)this.getView(), (IDataModel)model);
        }
        DynamicObjectCollection trip = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("tripentry");
        trip.clear();
        EntryCopyUtil.copyEntry2TargetColl((DynamicObjectCollection)trip, (DynamicObject)viewTrip);
        if (CollectionUtils.isNotEmpty((Collection)trip)) {
            ((DynamicObject)trip.get(0)).set("seq", (Object)1);
        }
        DynamicObject tripEntryCol = (DynamicObject)trip.get(0);
        int tripday = tripEntryCol.getInt("tripday");
        int entryCountIndex = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryCountIndex; ++i) {
            model.setValue("daycount", (Object)tripday, i, 0);
            model.setValue("entrycurrency", model.getValue("entrycurrency", i, 0), i, 0);
        }
    }

    private void initNewTripentryInfo(IDataModel model, IDataModel parentModel, Map<String, Object> mapCustomParam) {
        boolean iscurrency = (Boolean)parentModel.getValue("iscurrency");
        model.setValue("iscurrency", (Object)iscurrency);
        int tripRowIndex = model.createNewEntryRow("tripentry");
        Object tocity = mapCustomParam.get("to");
        if (null == tocity) {
            Long cityId = ((IMobileView)this.getView()).getCurrentCityId();
            model.setValue("from", (Object)cityId, tripRowIndex);
        }
        DynamicObject costDept = (DynamicObject)parentModel.getValue("costdept");
        DynamicObject costCompany = (DynamicObject)parentModel.getValue("costcompany");
        model.setValue("entrycostdept", (Object)ErCommonUtils.getPk((Object)costDept), tripRowIndex);
        model.setValue("entrycostcompany", (Object)ErCommonUtils.getPk((Object)costCompany), tripRowIndex);
        Long[] applierIds = new Long[]{ErCommonUtils.getPk((Object)parentModel.getValue("applier"))};
        model.setValue("travelers", (Object)applierIds, tripRowIndex);
        model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("currency")), tripRowIndex);
        String vehicles = (String)model.getValue("vehicles", tripRowIndex);
        Object company = model.getValue("company");
        if (company == null) {
            model.setValue("company", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("company")));
        }
        CoreBaseBillServiceHelper.mulTripVehicle((IDataModel)model, (String)vehicles, (int)tripRowIndex);
        CoreBaseBillServiceHelper.addDefaultTripExpenseEntry((IDataModel)model, (int)tripRowIndex);
        DynamicObject dataEntity = model.getDataEntity(true);
        long companyId = dataEntity.getLong("company_id");
        String tripStandardControlMethod = SystemParamterUtil.getTripStandardControlLevel((long)companyId).getValue();
        String vehicleConType = SystemParamterUtil.getVehicleStdControlLevel((long)companyId).getValue();
        DynamicObjectCollection tripEntryColl = dataEntity.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection detailColl = ((DynamicObject)tripEntryColl.get(tripRowIndex)).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < detailColl.size(); ++i) {
            model.setValue("ispassentry", (Object)Boolean.FALSE, i, tripRowIndex);
            DynamicObject tripExpItem = ((DynamicObject)detailColl.get(i)).getDynamicObject("expenseitem");
            if (tripExpItem != null) {
                String attribute = tripExpItem.getString("attribute");
                if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
                    model.setValue("controlmethod", (Object)tripStandardControlMethod, i, tripRowIndex);
                } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) {
                    model.setValue("controlmethod", (Object)vehicleConType, i, tripRowIndex);
                }
            }
            model.setValue("trip2travelers", (Object)((DynamicObject)tripEntryColl.get(tripRowIndex)).getDynamicObjectCollection("travelers"), i, tripRowIndex);
        }
        ErCostCenterUtil.initEntryCostCenter((IDataModel)this.getModel(), (String)"tripentry", (int)tripRowIndex, (int)-1);
    }

    public void afterBindData(EventObject e) {
        Object date;
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        boolean isQueryBudget = (Boolean)mapCustomParam.get("isquerybudget");
        BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), isQueryBudget);
        this.setBudgetShow(0);
        IDataModel model = this.getModel();
        Boolean iscurency = this.refreshEntryCurrency(model);
        model.setValue("iscurrency", (Object)iscurency);
        if (mapCustomParam != null && null != (date = mapCustomParam.get("enddate"))) {
            model.setValue("startdate", date, 0);
        }
        int entryCountIndex = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryCountIndex; ++i) {
            DynamicObject tripexpense = (DynamicObject)model.getValue("expenseitem", i);
            this.isExpenseIsPassEntry(model, i, tripexpense);
        }
        this.setTripExenseItemIcon();
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
        this.setExpenseEntryLableCount();
        if (model.getEntryEntity("entryentity").stream().anyMatch(v -> "2".equals(v.getString("settlementtype")))) {
            this.getView().setEnable(Boolean.FALSE, ((Integer)mapCustomParam.get("index")).intValue(), new String[]{"tripcurrency"});
        }
        ShowPageUtils.setMobilePageFormStatus((IFormView)this.getView());
        this.vehicleVisible();
        if (model.getEntryRowCount("entryentity") == 0) {
            // empty if block
        }
        this.setTripDateControl();
        ErMobWorkFlowOtherViewEditUtils.setWorkFlowEditView((IFormView)this.getView(), (Map)mapCustomParam, (IDataModel)model, (int)4);
    }

    private void setBudgetShow(int rowIndex) {
        CardEntry tripCardEntry = (CardEntry)this.getControl("tripentry");
        if (tripCardEntry != null) {
            if (BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)parentView.getModel().getValue("company")), (String)"budgeMsgControl");
                    if (StringUtils.isNotEmpty((String)budgeMsgValue)) {
                        if ("0".equals(budgeMsgValue)) {
                            tripCardEntry.setChildVisible(true, rowIndex, new String[]{"budgetamount"});
                            tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
                        } else if ("1".equals(budgeMsgValue)) {
                            tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                            tripCardEntry.setChildVisible(true, rowIndex, new String[]{"budgetmsg"});
                        }
                    } else {
                        tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                        tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
                    }
                } else {
                    tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                    tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
                }
            } else {
                tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                tripCardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
            }
        }
    }

    private void setTripDateControl() {
        Object company = this.getView().getParentView().getModel().getValue("company");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)SystemParamterUtil.getTripReimDateSelectRange((Long)ErCommonUtils.getPk((Object)company)), (CharSequence)"0")) {
            DateEdit startDate = (DateEdit)this.getControl("startdate");
            DateEdit endDate = (DateEdit)this.getControl("enddate");
            LocalDate now = LocalDate.now();
            startDate.setMaxDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
            endDate.setMaxDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
        }
    }

    protected void vehicleVisible() {
        String vihicleKey = null;
        vihicleKey = !this.readOnly() && this.getVihicleFromStdConfig() ? "vehicles" : "vehicle";
        CardEntry tripentry = (CardEntry)this.getControl("tripentry");
        for (int i = 0; i < this.getModel().getEntryRowCount("tripentry"); ++i) {
            tripentry.setChildVisible(false, i, new String[]{vihicleKey});
        }
    }

    protected boolean readOnly() {
        IFormView parentView = this.getView().getParentView();
        return parentView != null && !"A".equals(parentView.getModel().getValue("billstatus")) && !"D".equals(parentView.getModel().getValue("billstatus"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentIndex = valueSet[0].getParentRowIndex();
        switch (propName) {
            case "startdate": {
                if (propValue != null && model.getValue("triphappendate") == null) {
                    model.setValue("triphappendate", propValue);
                }
                this.changeTripDay(rowIndex);
                break;
            }
            case "enddate": {
                this.changeTripDay(rowIndex);
                break;
            }
            case "vehicles": {
                CoreBaseBillServiceHelper.refreshVehicleRelateEntry((IDataModel)model, (String)((String)propValue), (int)rowIndex);
                DynamicObjectCollection currItemEntry = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(rowIndex)).getDynamicObjectCollection("entryentity");
                if (currItemEntry == null || currItemEntry.size() <= 0) break;
                for (int i = 0; i < currItemEntry.size(); ++i) {
                    this.getView().updateView("expenseitem", i, rowIndex);
                }
                break;
            }
            case "tripexpenseitem": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || propValue == null) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), rowIndex);
                break;
            }
            case "std_project": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), rowIndex);
                break;
            }
            case "vehicle": {
                if (!this.getVihicleFromStdConfig()) break;
                this.getModel().setValue("vehicles", propValue);
                break;
            }
            case "std_entrycostcenter": {
                DynamicObject company;
                String selectMode;
                if (propValue == null || propValue == "" || !ErCostCenterUtil.isLeafCostCenter((Object)propValue) || "0".equals(selectMode = ErCommonUtils.getCostOrgUseMode((Long)((Long)(company = (DynamicObject)model.getValue("company")).getPkValue())))) break;
                ErCostCenterUtil.costEntryCenterChangeForTripMob((IFormView)this.getView(), (Object)propValue, (int)rowIndex);
                break;
            }
            case "expenseitem": {
                if (propValue == null) break;
                this.setCurrentExpenseItemIcon(rowIndex, parentIndex, (Long)((DynamicObject)propValue).getPkValue());
            }
        }
        if ("entrycostcompany".equals(propName) || "entrycostdept".equals(propName) || "triphappendate".equals(propName) || "tripexpenseitem".equals(propName)) {
            this.handleExpenseEntry(rowIndex);
        }
    }

    private void handleExpenseEntry(int tripIndex) {
        DynamicObject trip = this.getModel().getEntryRowEntity("tripentry", tripIndex);
        DynamicObject tripEntryCostcompany = trip.getDynamicObject("entrycostcompany");
        DynamicObject tripEntryCostdept = trip.getDynamicObject("entrycostdept");
        Date tripEntryHappendate = trip.getDate("triphappendate");
        DynamicObject tripEntryExpenseitem = trip.getDynamicObject("tripexpenseitem");
        Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)tripEntryExpenseitem, (DynamicObject)tripEntryCostdept, (IDataModel)this.getView().getParentView().getModel());
        trip.getDynamicObjectCollection("entryentity").forEach(v -> {
            v.set("travelcostcompany", (Object)tripEntryCostcompany);
            v.set("travelcostdept", (Object)tripEntryCostdept);
            v.set("travelhappendate", (Object)tripEntryHappendate);
            v.set("travelexpenseitem", (Object)tripEntryExpenseitem);
            v.set("travelquotactldept_id", (Object)quotaCtrlDeptId);
        });
    }

    protected boolean getVihicleFromStdConfig() {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)ErStdConfig.get((String)"notMultiVehicles"), (CharSequence)"true");
    }

    private void changeTripDay(int tripEntryIndex) {
        IDataModel model = this.getModel();
        Date startDate = (Date)model.getValue("startdate", tripEntryIndex);
        Date endDate = (Date)model.getValue("enddate", tripEntryIndex);
        Long tripDays = CommonServiceHelper.calcDays((Date)startDate, (Date)endDate);
        model.setValue("tripday", (Object)tripDays, tripEntryIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        int stauts = (Integer)mapCustomParam.get("status");
        IFormView pView = this.getView().getParentView();
        IDataModel pModel = pView.getModel();
        switch (key) {
            case "btn_addexpenseitem": {
                if (!this.requiredProps(model, requiredProps)) {
                    return;
                }
                if (this.checkTripArea(model)) {
                    return;
                }
                DynamicObject company = (DynamicObject)pModel.getValue("company");
                Long companyId = company == null ? Long.valueOf(0L) : (Long)company.getPkValue();
                int curIndex = model.getEntryCurrentRowIndex("entryentity");
                mapCustomParam.put("curIndex", curIndex);
                this.openTripExpneseF7SelectView(mapCustomParam, companyId);
                break;
            }
            case "btn_save": {
                if (!this.requiredProps(model, requiredProps)) {
                    return;
                }
                if (this.checkTripArea(model)) {
                    return;
                }
                if (!this.isAllTripItemHasValue()) {
                    return;
                }
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection tripEntryDOs = dataEntity.getDynamicObjectCollection("tripentry");
                Boolean confirm = Boolean.FALSE;
                for (DynamicObject dobjet : tripEntryDOs) {
                    Object to;
                    Object from = dobjet.get("from");
                    if (!from.equals(to = dobjet.get("to"))) continue;
                    confirm = Boolean.TRUE;
                }
                if (confirm.booleanValue()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u51fa\u53d1\u5730\u4e0e\u76ee\u7684\u5730\u76f8\u540c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TripReimburseConsumcordPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                    break;
                }
                this.clickOk(model, mapCustomParam, stauts, pView, pModel);
                break;
            }
            case "labelap_edit": {
                model.setValue("editentry", (Object)"1");
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap_done"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap_edit"});
                break;
            }
            case "imageap_delete": {
                model.setValue("editentry", (Object)"2");
                break;
            }
            case "labelap_done": {
                model.setValue("editentry", (Object)"3");
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap_done"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap_edit"});
            }
        }
    }

    private boolean checkTripArea(IDataModel model) {
        if (this.getModel().getDataEntity().getBoolean("isopentripstd") && (ErBillStatusEnum.A.name().equalsIgnoreCase((String)model.getValue("billstatus")) || ErBillStatusEnum.D.name().equalsIgnoreCase((String)model.getValue("billstatus")))) {
            return !this.requiredProps(model, new String[]{"tripentryarea"});
        }
        return false;
    }

    protected void openTripExpneseF7SelectView(Map<String, Object> mapCustomParam, Long companyId) {
        TripReimburseConsumcordPlugin.openTripExpneseF7SelectView((IFormPlugin)this, this.getView(), mapCustomParam, companyId, TRIPEXPENSEACTIONID);
    }

    public static void openTripExpneseF7SelectView(IFormPlugin plugin, IFormView view, Map<String, Object> mapCustomParam, Long companyId, String callBackActionId) {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.setBillFormId("er_tripexpenseitem");
        parameter.setFormId("bos_moblisttabf7");
        parameter.setCustomParams(mapCustomParam);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setLookUp(true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        String selectExpensePros = "id,number,longnumber,expenseitemicon,isdefault,isvactax,ctrltype";
        QFilter qA = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)companyId);
        DynamicObjectCollection expenseItems = QueryServiceHelper.query((String)"er_tripexpenseitem", (String)selectExpensePros, (QFilter[])new QFilter[]{qA, bdFilter});
        List list = expenseItems.stream().map(d -> d.get("id")).collect(Collectors.toList());
        listFilterParameter.getQFilters().add(new QFilter("id", "in", (Object)list.toArray()));
        parameter.setListFilterParameter(listFilterParameter);
        parameter.setCloseCallBack(new CloseCallBack(plugin, callBackActionId));
        parameter.setAppId("18XD+/5EDN8X");
        parameter.setHasRight(true);
        view.showForm((FormShowParameter)parameter);
    }

    private void clickOk(IDataModel model, Map<String, Object> mapCustomParam, int stauts, IFormView pView, IDataModel pModel) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int tripcurrentRowIndex = 0;
        long firstPageCurrencyId = ErCommonUtils.getPk((Object)pModel.getValue("currency"));
        long secondPageCurrencyId = ErCommonUtils.getPk((Object)model.getValue("currency"));
        DynamicObjectCollection trip = (DynamicObjectCollection)model.getDataEntity(true).get("tripentry");
        DynamicObjectCollection ptrip = (DynamicObjectCollection)pModel.getDataEntity(true).get("tripentry");
        if (firstPageCurrencyId != secondPageCurrencyId && ptrip.isEmpty()) {
            pView.updateView();
            this.getView().sendFormAction(pView);
            this.getView().close();
            return;
        }
        ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
        if (stauts == 0) {
            this.copyInvoiceFromChildToParentPage(model, pModel);
            EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)ptrip, (DynamicObjectCollection)trip);
            this.refreshTotalAmount(pModel, "tripentry", "tripamount", "amount");
            String pageId = pView.getPageId();
            RedisModelCache redisModelCache = new RedisModelCache(null, this.getModel().getDataEntityType(), pageId);
            redisModelCache.storeAll(this.getModel().getDataEntity(true));
            pView.setVisible(Boolean.FALSE, new String[]{"next"});
            pView.setVisible(Boolean.TRUE, new String[]{"tbmain", "save", KEY_SUBMIT, "tripentry", "flexpanel_mytrip", "listcard_tripentry", "listcardviewap", "btn_addsection"});
            this.getView().sendFormAction(pView);
            pView.updateView();
            int pEntryRowCount = pModel.getEntryRowCount("tripentry");
            tripcurrentRowIndex = pEntryRowCount - 1;
        } else if (stauts == 1) {
            tripcurrentRowIndex = Integer.parseInt(mapCustomParam.get("index").toString());
            pModel.setValue("enddate", model.getValue("enddate"), tripcurrentRowIndex);
            this.copyInvoiceFromChildToParentPage(model, pModel);
            EntryCopyUtil.updateColl2TargetColl((DynamicObjectCollection)ptrip, (DynamicObjectCollection)trip, (int)tripcurrentRowIndex);
            String pageId = pView.getPageId();
            RedisModelCache redisModelCache = new RedisModelCache(null, this.getModel().getDataEntityType(), pageId);
            redisModelCache.storeAll(this.getModel().getDataEntity(true));
            pView.setVisible(Boolean.FALSE, new String[]{"next"});
            pView.setVisible(Boolean.TRUE, new String[]{"tbmain", "save", KEY_SUBMIT, "tripentry", "flexpanel_mytrip", "listcard_tripentry", "btn_addsection"});
            pView.updateView();
            this.getView().sendFormAction(pView);
        }
        map.put("tripcurrentRowIndex", tripcurrentRowIndex);
        map.put("tripentryarea", model.getValue("tripentryarea"));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private boolean isAllTripItemHasValue() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection tripEntryDOs = dataEntity.getDynamicObjectCollection("tripentry");
        if (tripEntryDOs == null || tripEntryDOs.isEmpty()) {
            logger.info("\u884c\u7a0b\u5206\u5f55\u4e3a\u7a7a");
            return true;
        }
        DynamicObjectCollection tripItemEntryDOs = ((DynamicObject)tripEntryDOs.get(0)).getDynamicObjectCollection("entryentity");
        if (tripEntryDOs == null || tripItemEntryDOs.isEmpty()) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u4e8c\u7ea7\u5206\u5f55\u4e3a\u7a7a");
            return true;
        }
        LinkedList emptyTripItemRowIndexs = Lists.newLinkedList();
        for (int i = 0; i < tripItemEntryDOs.size(); ++i) {
            DynamicObject tripItemEntryDO = (DynamicObject)tripItemEntryDOs.get(i);
            Object tripItemDO = tripItemEntryDO.get("expenseitem");
            if (tripItemDO != null) continue;
            emptyTripItemRowIndexs.add(i + 1);
        }
        if (emptyTripItemRowIndexs.isEmpty()) {
            return true;
        }
        logger.info("\u8fd9\u4e9b\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e0a\u7684\u5dee\u65c5\u9879\u76ee\u4e3a\u7a7a:" + org.apache.commons.lang3.StringUtils.join((Iterable)emptyTripItemRowIndexs, (String)","));
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u4e0a\u7684\u5dee\u65c5\u9879\u76ee\u3002", (String)"TripReimburseConsumcordPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), org.apache.commons.lang3.StringUtils.join((Iterable)emptyTripItemRowIndexs, (String)",")));
        return false;
    }

    private void copyInvoiceFromChildToParentPage(IDataModel model, IDataModel pModel) {
        DynamicObjectCollection invoiceHeadEntry = model.getDataEntity(true).getDynamicObjectCollection(INVOICE_HEAD_ENTRY);
        DynamicObjectCollection pInvoiceHeadEntry = pModel.getDataEntity(true).getDynamicObjectCollection(INVOICE_HEAD_ENTRY);
        DynamicObjectCollection invoiceItemEntry = model.getDataEntity(true).getDynamicObjectCollection(INVOICE_ITEM_ENTRY);
        DynamicObjectCollection pInvoiceItemEntry = pModel.getDataEntity(true).getDynamicObjectCollection(INVOICE_ITEM_ENTRY);
        DynamicObjectCollection invoiceandexpense = model.getDataEntity(true).getDynamicObjectCollection("invoiceandexpense");
        DynamicObjectCollection pinvoiceandexpense = pModel.getDataEntity(true).getDynamicObjectCollection("invoiceandexpense");
        pInvoiceHeadEntry.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)pInvoiceHeadEntry, (DynamicObjectCollection)invoiceHeadEntry);
        pInvoiceItemEntry.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)pInvoiceItemEntry, (DynamicObjectCollection)invoiceItemEntry);
        pinvoiceandexpense.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)pinvoiceandexpense, (DynamicObjectCollection)invoiceandexpense);
    }

    private void copyInvoiceFromParentToChildPage(IDataModel pModel, IDataModel model) {
        DynamicObjectCollection invoiceHeadEntry = model.getDataEntity(true).getDynamicObjectCollection(INVOICE_HEAD_ENTRY);
        DynamicObjectCollection pInvoiceHeadEntry = pModel.getDataEntity(true).getDynamicObjectCollection(INVOICE_HEAD_ENTRY);
        DynamicObjectCollection invoiceItemEntry = model.getDataEntity(true).getDynamicObjectCollection(INVOICE_ITEM_ENTRY);
        DynamicObjectCollection pInvoiceItemEntry = pModel.getDataEntity(true).getDynamicObjectCollection(INVOICE_ITEM_ENTRY);
        DynamicObjectCollection invoiceMergeEntry = model.getDataEntity(true).getDynamicObjectCollection("invoicemerge");
        DynamicObjectCollection pinvoiceMergeEntry = pModel.getDataEntity(true).getDynamicObjectCollection("invoicemerge");
        DynamicObjectCollection invoiceandexpense = model.getDataEntity(true).getDynamicObjectCollection("invoiceandexpense");
        DynamicObjectCollection pinvoiceandexpense = pModel.getDataEntity(true).getDynamicObjectCollection("invoiceandexpense");
        invoiceHeadEntry.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)invoiceHeadEntry, (DynamicObjectCollection)pInvoiceHeadEntry);
        invoiceItemEntry.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)invoiceItemEntry, (DynamicObjectCollection)pInvoiceItemEntry);
        invoiceMergeEntry.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)invoiceMergeEntry, (DynamicObjectCollection)pinvoiceMergeEntry);
        invoiceandexpense.clear();
        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)invoiceandexpense, (DynamicObjectCollection)pinvoiceandexpense);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IDataModel model = this.getModel();
        int curEntryIndex = 0;
        if (TRIPEXPENSEACTIONID.equalsIgnoreCase(closedCallBackEvent.getActionId()) || "er_tripexpenseitem".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                DynamicObject selectExpenseitem;
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                long expenseitemId = 0L;
                if (returnData.size() > 0) {
                    expenseitemId = Long.parseLong(returnData.get(0).getPrimaryKeyValue().toString());
                }
                if ((selectExpenseitem = CommonServiceHelper.getObjById((String)"er_tripexpenseitem", (Long)expenseitemId)) == null) {
                    return;
                }
                model.batchCreateNewEntryRow("entryentity", 1);
                curEntryIndex = model.getEntryRowCount("entryentity") - 1;
                this.fillEntryEntityData(model, selectExpenseitem, curEntryIndex);
                model.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"), curEntryIndex);
                this.getView().updateView("pic", curEntryIndex);
                this.getView().updateView("expenseitem", curEntryIndex);
                this.getView().setEnable(Boolean.FALSE, curEntryIndex, new String[]{"expenseitem"});
                this.isExpenseIsPassEntry(model, curEntryIndex, selectExpenseitem);
                boolean ispassentry = (Boolean)model.getValue("ispassentry", curEntryIndex);
                if (ispassentry) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("formId", "er_tripreimexpenseitem_m");
                    paramMap.put("formName", ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6", (String)"TripReimburseConsumcordPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    paramMap.put("formType", "5");
                    paramMap.put("needCallBack", Boolean.TRUE);
                    HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
                    mapCustomParam.put("iscurrency", this.refreshEntryCurrency(model));
                    mapCustomParam.put("expenseitem", expenseitemId);
                    mapCustomParam.put("index", curEntryIndex);
                    mapCustomParam.put("taxrate", model.getValue("taxrate", curEntryIndex));
                    mapCustomParam.put("entrycurrency", ErCommonUtils.getPk((Object)model.getValue("entrycurrency", curEntryIndex)));
                    mapCustomParam.put("exchangerate", model.getValue("exchangerate", curEntryIndex));
                    mapCustomParam.put("detailquotetype", model.getValue("detailquotetype", curEntryIndex));
                    mapCustomParam.put("status", 0);
                    paramMap.put("customParam", mapCustomParam);
                    ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
                }
            }
        } else if (this.getExpenseEditForm().equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            curEntryIndex = (Integer)closedCallBackEvent.getReturnData();
            DynamicObject expenseItem = (DynamicObject)model.getValue("expenseitem", curEntryIndex);
            Boolean isPass = this.isExpenseIsPassEntry(model, curEntryIndex, expenseItem);
            model.setValue("ispassentry", (Object)isPass, curEntryIndex);
            this.getView().updateView("entryentity", curEntryIndex);
        }
        AmountChangeUtil.updateExpenseDetailAmountLabelForMob((IFormView)this.getView(), (IDataModel)model);
        this.setExpenseEntryLableCount();
        this.getModel().setValue("editentry", (Object)0);
    }

    private void setTripExenseItemIcon() {
        DynamicObjectCollection tripEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (int i = 0; i < tripEntrys.size(); ++i) {
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
            DynamicObjectCollection entryEntitys = tripEntry.getDynamicObjectCollection("entryentity");
            for (int entryEntityIndex = 0; entryEntityIndex < entryEntitys.size(); ++entryEntityIndex) {
                DynamicObject entryEntity = (DynamicObject)entryEntitys.get(entryEntityIndex);
                DynamicObject tripExpenseItemDO = entryEntity.getDynamicObject("expenseitem");
                if (tripExpenseItemDO == null) continue;
                DynamicObject tripExpenseItemDOFromDB = BusinessDataServiceHelper.loadSingleFromCache((Object)tripExpenseItemDO.getPkValue(), (String)"er_tripexpenseitem", (String)"expenseitemicon");
                logger.info("loadSingleFromCache\uff1a" + tripExpenseItemDOFromDB);
                this.getModel().setValue("pic", (Object)tripExpenseItemDOFromDB.getString("expenseitemicon"), entryEntityIndex, i);
            }
        }
    }

    private void setCurrentExpenseItemIcon(int rowIndex, int parentIndex, Long tripExpenseId) {
        DynamicObject tripExpenseItemDOFromDB = BusinessDataServiceHelper.loadSingleFromCache((Object)tripExpenseId, (String)"er_tripexpenseitem", (String)"expenseitemicon");
        logger.info("loadSingleFromCache\uff1a" + tripExpenseItemDOFromDB);
        this.getModel().setValue("pic", (Object)tripExpenseItemDOFromDB.getString("expenseitemicon"), rowIndex, parentIndex);
        this.getView().updateView("pic", rowIndex, parentIndex);
    }

    private void fillEntryEntityData(IDataModel model, DynamicObject selectExpenseitem, int index) {
        boolean isCurrencyShowinTripentry;
        DynamicObject tripentry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0);
        model.setValue("expenseitem", selectExpenseitem.getPkValue(), index);
        model.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"), index);
        int curTripIndex = model.getEntryCurrentRowIndex("tripentry");
        model.setValue("daycount", model.getValue("tripday", curTripIndex), index);
        model.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"), index);
        TripReimburseServiceHelper.whenTripItemChanged((IDataModel)model, (DynamicObject)selectExpenseitem, (int)index, (int)curTripIndex);
        boolean bl = isCurrencyShowinTripentry = !DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel()) && SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        if (isCurrencyShowinTripentry) {
            DynamicObject tripCurrency = tripentry.getDynamicObject("tripcurrency");
            model.setValue("entrycurrency", (Object)ErCommonUtils.getPk((Object)tripCurrency), index);
            BigDecimal tripexchangerate = tripentry.getBigDecimal("tripexchangerate");
            model.setValue("exchangerate", (Object)tripexchangerate, index);
            String tripquotetype = (String)ObjectUtils.defaultIfNull((Object)tripentry.getString("tripquotetype"), (Object)"0");
            model.setValue("detailquotetype", (Object)tripquotetype, index);
        } else {
            model.setValue("entrycurrency", model.getValue("currency"), index);
            model.setValue("exchangerate", (Object)BigDecimal.ONE, index);
            model.setValue("detailquotetype", (Object)BigDecimal.ZERO, index);
        }
        model.setValue("trip2travelers", (Object)tripentry.getDynamicObjectCollection("travelers"), index);
        model.setValue("triparea", (Object)tripentry.getDynamicObject("tripentryarea"), index);
        DynamicObject tripEntryCostcompany = tripentry.getDynamicObject("entrycostcompany");
        DynamicObject tripEntryCostdept = tripentry.getDynamicObject("entrycostdept");
        Date tripEntryHappendate = tripentry.getDate("triphappendate");
        DynamicObject tripEntryExpenseitem = tripentry.getDynamicObject("tripexpenseitem");
        Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)tripEntryExpenseitem, (DynamicObject)tripEntryCostdept, (IDataModel)this.getView().getParentView().getModel());
        model.setValue("travelcostcompany", (Object)tripEntryCostcompany, index);
        model.setValue("travelcostdept", (Object)tripEntryCostdept, index);
        model.setValue("travelhappendate", (Object)tripEntryHappendate, index);
        model.setValue("travelexpenseitem", (Object)tripEntryExpenseitem, index);
        model.setValue("travelquotactldept", (Object)quotaCtrlDeptId, index);
    }

    private Boolean refreshEntryCurrency(IDataModel model) {
        boolean iscurrency = (Boolean)model.getValue("iscurrency");
        if (!iscurrency) {
            iscurrency = CommonServiceHelper.initCurrency();
        }
        int entryRows = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryRows; ++i) {
            model.setValue("isMulticurrency", (Object)iscurrency, i);
        }
        return iscurrency;
    }

    protected BigDecimal refreshTotalAmount(IDataModel model, String entryField, String entryAmountField, String totalAmountField) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObjectCollection entrys = model.getEntryEntity(entryField);
        for (DynamicObject entry : entrys) {
            BigDecimal tripAmount = entry.getBigDecimal(entryAmountField);
            totalAmount = totalAmount.add(tripAmount);
        }
        model.setValue(totalAmountField, (Object)totalAmount);
        if (model.getProperty("approveamount") != null) {
            model.setValue("approveamount", (Object)totalAmount);
        }
        if (model.getProperty("encashamount") != null) {
            model.setValue("encashamount", (Object)totalAmount);
        }
        return totalAmount;
    }

    private void setExpenseEntryLableCount() {
        Label eicount = (Label)this.getView().getControl("eicount");
        int count = this.getModel().getEntryRowCount("entryentity");
        eicount.setText("(" + count + ")");
    }

    public void entryRowClick(RowClickEvent arg0) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        if (!this.requiredProps(this.getModel(), requiredProps)) {
            return;
        }
        if (this.checkTripArea(model)) {
            return;
        }
        int selectedRowIndex = arg0.getRow();
        this.choooseEntryRow(selectedRowIndex);
        boolean needdropin = false;
        DynamicObject expenseEntryRow = this.getModel().getEntryRowEntity("entryentity", selectedRowIndex);
        if (expenseEntryRow != null) {
            String ordernum = expenseEntryRow.getString("ordernum");
            String orderformid = expenseEntryRow.getString("orderformid");
            if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{orderformid, ordernum})) {
                needdropin = true;
            }
            DynamicObject expenseitem = expenseEntryRow.getDynamicObject("expenseitem");
            this.isExpenseIsPassEntry(model, selectedRowIndex, expenseitem);
        }
        if (expenseEntryRow != null && "2".equals(expenseEntryRow.getString("settlementtype")) && needdropin) {
            DynamicObject dynamicObject = expenseEntryRow.getDynamicObject("expenseitem");
            if (dynamicObject == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dynamicObject.getString("attribute"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5dee\u65c5\u9879\u76ee\u3002", (String)"TripReimburseConsumcordPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
            paramMap.put("formId", "er_reimbursedetail_mb");
            paramMap.put("formName", ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u8d39\u7528\u660e\u7ec6\u6708\u7ed3\u5206\u5f55\u8be6\u60c5", (String)"TripReimburseConsumcordPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            paramMap.put("formType", "5");
            paramMap.put("needCallBack", Boolean.TRUE);
            IPageCache pageCache = this.getPageCache();
            mapCustomParam.put("ordernum", expenseEntryRow.get("ordernum"));
            mapCustomParam.put("currencyId", expenseEntryRow.getDynamicObject("entrycurrency").getPkValue());
            mapCustomParam.put("orderformid", expenseEntryRow.get("orderformid"));
            mapCustomParam.put("vehicleConType", pageCache.get("vehicleConType"));
            mapCustomParam.put("index", selectedRowIndex);
            mapCustomParam.put("overdesc", expenseEntryRow.getString("overdesc"));
            boolean isOpendStd = dataEntity.getBoolean("isopentripstd");
            mapCustomParam.put("isControl", isOpendStd);
            if (isOpendStd) {
                boolean isOver = "1".equals(expenseEntryRow.getString("isover"));
                mapCustomParam.put("checkCabinIsOver", isOver);
            }
            paramMap.put("customParam", mapCustomParam);
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    private void choooseEntryRow(int selectIndex) {
        HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
        DynamicObjectCollection tripentrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripentrys == null || tripentrys.isEmpty()) {
            return;
        }
        DynamicObject tripentry = (DynamicObject)tripentrys.get(this.getModel().getEntryCurrentRowIndex("tripentry"));
        DynamicObjectCollection entrys = tripentry.getDynamicObjectCollection("entryentity");
        if (entrys == null || entrys.isEmpty()) {
            return;
        }
        DynamicObject selectEntry = (DynamicObject)entrys.get(selectIndex);
        Boolean iscurrency = (Boolean)this.getView().getParentView().getModel().getValue("iscurrency");
        boolean ispassentry = selectEntry.getBoolean("ispassentry");
        String invoiceno_entry = selectEntry.getString("invoiceno_entry");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoiceno_entry)) {
            ispassentry = true;
        }
        String settlementtype = selectEntry.getString("settlementtype");
        boolean hasOrder = false;
        String ordernum = selectEntry.getString("ordernum");
        String orderformid = selectEntry.getString("orderformid");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ordernum) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orderformid)) {
            hasOrder = true;
        }
        if ("2".equalsIgnoreCase(settlementtype) && hasOrder) {
            ispassentry = false;
        }
        if (selectEntry.getDynamicObject("expenseitem") == null) {
            ispassentry = false;
        }
        if (!ispassentry) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", this.getExpenseEditForm());
        paramMap.put("formName", ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6", (String)"TripReimburseConsumcordPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        paramMap.put("formType", "5");
        paramMap.put("needCallBack", Boolean.TRUE);
        Object parentIndex = this.getView().getFormShowParameter().getCustomParam("index");
        mapCustomParam.put("index", selectIndex);
        mapCustomParam.put("parentIndex", parentIndex);
        mapCustomParam.put("status", 1);
        Object company = this.getModel().getValue("company");
        if (company != null) {
            Long pkValue = (Long)((DynamicObject)company).getPkValue();
            mapCustomParam.put("company", pkValue.toString());
        }
        mapCustomParam.put("iscurrency", iscurrency);
        mapCustomParam.put("entrycurrency", ErCommonUtils.getPk((Object)selectEntry.getDynamicObject("entrycurrency")));
        mapCustomParam.put("exchangerate", selectEntry.getBigDecimal("exchangerate"));
        mapCustomParam.put("offset", selectEntry.getBoolean("offset"));
        mapCustomParam.put("wbsrcbilltype", selectEntry.getString("wbsrcbilltype"));
        mapCustomParam.put("invoiceno", selectEntry.getString("invoiceno_entry"));
        mapCustomParam.put("automapinvoice", this.getModel().getValue("automapinvoice"));
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParams = showParameter.getCustomParams();
        ErMobWorkFlowOtherViewEditUtils.setWorkFlowParams(mapCustomParam, (Map)mapCustomParams);
        paramMap.put("customParam", mapCustomParam);
        ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
    }

    protected String getExpenseEditForm() {
        return "er_tripreimexpenseitem_m";
    }

    protected boolean requiredProps(IDataModel model, String[] props) {
        for (String propName : props) {
            IDataEntityProperty property = model.getProperty(propName);
            Object propValue = model.getValue(propName);
            if (propValue != null && (!(property instanceof MulBasedataProp) || ((MulBasedataDynamicObjectCollection)propValue).size() != 0)) continue;
            String displayNameStr = null;
            try {
                LocaleString displayName = (LocaleString)property.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)property, new Object[0]);
                displayNameStr = displayName.getLocaleValue();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error((Throwable)e);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"TripReimburseConsumcordPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), displayNameStr));
            return false;
        }
        return true;
    }

    private boolean isExpenseIsPassEntry(IDataModel model, int index, DynamicObject tripexpense) {
        if (tripexpense == null) {
            return false;
        }
        Boolean isCurrency = CommonServiceHelper.initCurrency();
        String attribute = tripexpense.getString("attribute");
        boolean isvactax = tripexpense.getBoolean("isvactax");
        boolean isOpenStd = (Boolean)this.getModel().getValue("isopentripstd");
        if (isOpenStd && Arrays.asList(STDCTRL_ATTRIBUTE).contains(attribute) || attribute.equals("2") || isvactax || isCurrency.booleanValue() || attribute.equals("6") || attribute.equals("1")) {
            model.setValue("ispassentry", (Object)Boolean.TRUE, index, 0);
            return true;
        }
        return false;
    }

    public void beforeClick(BeforeClickEvent evt) {
        boolean hasNullTripItem;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)"btn_save") && (hasNullTripItem = model.getDataEntity(true).getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).anyMatch(entryEntity -> entryEntity.getDynamicObject("expenseitem") == null))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5dee\u65c5\u9879\u76ee\u3002", (String)"TripReimburseConsumcordPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)KEY_SUBMIT, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation(KEY_SUBMIT, operateOption);
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"ok", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map mapCustomParam = showParameter.getCustomParams();
            int stauts = (Integer)mapCustomParam.get("status");
            this.clickOk(this.getModel(), mapCustomParam, stauts, this.getView().getParentView(), this.getView().getParentView().getModel());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)name, (CharSequence)"entryentity")) {
            this.setExpenseEntryLableCount();
            if (((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity").size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap_done", "labelap_edit"});
            }
            this.getView().updateView("entryentity");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)name, (CharSequence)"entryentity")) {
            this.setExpenseEntryLableCount();
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap_edit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap_done"});
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)((String)this.getModel().getValue("editentry")), (CharSequence)"2") && ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity").size() == 1) {
                this.getModel().setValue("editentry", (Object)0);
            }
        }
    }
}

