/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class TripReimburseEntryOrderInfo
extends AbstractMobFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"labelap_change", "labelap_cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        String billNo = (String)mapCustomParam.get("billNo");
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        String orderformid = null;
        DynamicObjectCollection orderInfos = null;
        DynamicObject orderInfo = null;
        IDataModel model = this.getModel();
        if ("er_unconfirmbillinfo".equalsIgnoreCase(parentFormId)) {
            ArrayList<String> orderformidList = new ArrayList<String>(4);
            orderformidList.add("er_hotelbill");
            orderformidList.add("er_planebill");
            orderformidList.add("er_vehiclebill");
            long currUserId = RequestContext.get().getCurrUserId();
            boolean isReimburse = (Boolean)mapCustomParam.get("isReimburse");
            QFilter filters = new QFilter("isreimburse", "=", (Object)isReimburse).and("totalamount", "!=", (Object)BigDecimal.ZERO).and("totalamount", "!=", (Object)ConvertUtil.getOrderAmountInit());
            QFilter filterProducttype = new QFilter("producttype", "!=", (Object)"2");
            QFilter filterServicefeePaytype = new QFilter("servicefeepaytype", "!=", (Object)"2");
            HashMap orderFormIdAndQfilterMap = Maps.newHashMapWithExpectedSize((int)16);
            orderformidList.forEach(formId -> {
                QFilter sourceBookedFilter = new QFilter("sourcebookedid", "=", (Object)currUserId);
                QFilter planeAndHotelFilter = new QFilter("sourcetravelerid", "=", (Object)currUserId);
                QFilter vehicleAndTrainFilter = new QFilter("passeger", "=", (Object)currUserId);
                QFilter[] qFilters = null;
                sourceBookedFilter.clearNests();
                switch (formId) {
                    case "er_hotelbill": {
                        qFilters = new QFilter[]{sourceBookedFilter.or(planeAndHotelFilter), filterServicefeePaytype, filters};
                        break;
                    }
                    case "er_planebill": {
                        qFilters = new QFilter[]{sourceBookedFilter.or(planeAndHotelFilter), filterProducttype, filters};
                        break;
                    }
                    case "er_vehiclebill": {
                        qFilters = new QFilter[]{sourceBookedFilter.or(vehicleAndTrainFilter), filterServicefeePaytype, filters, new QFilter("vehicletype", "=", (Object)"2")};
                    }
                }
                orderFormIdAndQfilterMap.put(formId, qFilters);
            });
            int currencyId = (Integer)mapCustomParam.get("currencyId");
            for (int i = 0; i < orderformidList.size(); ++i) {
                orderformid = (String)orderformidList.get(i);
                orderInfos = StringUtils.isBlank((String)billNo) ? CommonServiceHelper.getTripOrderNotReimburse((String)orderformid, (QFilter[])((QFilter[])orderFormIdAndQfilterMap.get(orderformid))) : CommonServiceHelper.getTripOrderByNumber((String)orderformid, (String)billNo, (boolean)isReimburse);
                int initIndex = 0;
                int initOrderCount = orderInfos.size();
                if ((initOrderCount += (initIndex += model.getEntryRowCount("orderentry"))) <= 0) continue;
                int orderIndex = 0;
                for (int index = initIndex; index < initOrderCount; ++index) {
                    orderInfo = (DynamicObject)orderInfos.get(orderIndex);
                    ++orderIndex;
                    model.createNewEntryRow("orderentry");
                    model.setValue("currency", (Object)Long.parseLong(String.valueOf(currencyId)), index);
                    model.setValue("isReimburse", (Object)isReimburse, index);
                    this.initOrder(model, orderInfo, orderformid, index);
                }
            }
        }
    }

    private void initOrder(IDataModel model, DynamicObject orderInfo, String orderformid, int index) {
        model.setValue("orderformid", (Object)orderformid, index);
        if (orderInfo != null) {
            Object totalamount = orderInfo.get("totalamount");
            String orderNum = orderInfo.getString("orderNum");
            String orderstatus = orderInfo.getString("orderstatus");
            if ("er_planebill".equalsIgnoreCase(orderformid)) {
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u673a\u7968\u8ba2\u5355\u7f16\u53f7", (String)"TripReimburseEntryOrderInfo_0", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                Date takeofftime = orderInfo.getDate("takeofftime");
                Date landingtime = orderInfo.getDate("landingtime");
                String fromcityname = orderInfo.getString("fromcityname");
                String tocityname = orderInfo.getString("tocityname");
                String airlinename = orderInfo.getString("airlinename");
                String flightno = orderInfo.getString("flightno");
                model.setValue("takeofftime", (Object)takeofftime, index);
                model.setValue("landingtime", (Object)landingtime, index);
                model.setValue("fromcityname", (Object)fromcityname, index);
                model.setValue("tocityname", (Object)tocityname, index);
                model.setValue("airlinename", (Object)airlinename, index);
                model.setValue("flightno", (Object)flightno, index);
            }
            if ("er_hotelbill".equalsIgnoreCase(orderformid)) {
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u9152\u5e97\u8ba2\u5355\u7f16\u53f7", (String)"TripReimburseEntryOrderInfo_1", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                String hotelname = orderInfo.getString("hotelname");
                hotelname = hotelname.length() > 15 ? hotelname.substring(0, 10) + "..." : hotelname;
                Object roomcount = orderInfo.get("roomcount");
                Date checkindate = orderInfo.getDate("checkindate");
                Date checkoutdate = orderInfo.getDate("checkoutdate");
                String hoteladdress = orderInfo.getString("hoteladdress");
                hoteladdress = hoteladdress.length() > 15 ? hoteladdress.substring(0, 15) + "..." : hoteladdress;
                model.setValue("startdate", (Object)checkindate, index);
                model.setValue("enddate", (Object)checkoutdate, index);
                model.setValue("hotelname", (Object)hotelname, index);
                model.setValue("hoteladdress", (Object)hoteladdress, index);
                Long nightcount = CommonServiceHelper.calcHotelNightDays((Date)checkindate, (Date)checkoutdate);
                model.setValue("nightcount", (Object)String.format(ResManager.loadKDString((String)"%1$s\u665a   /", (String)"TripReimburseEntryOrderInfo_8", (String)"fi-er-formplugin", (Object[])new Object[0]), nightcount), index);
                model.setValue("roomcount", (Object)String.format(ResManager.loadKDString((String)"%1$s\u95f4", (String)"TripReimburseEntryOrderInfo_9", (String)"fi-er-formplugin", (Object[])new Object[0]), roomcount), index);
            }
            if ("er_vehiclebill".equalsIgnoreCase(orderformid)) {
                Date usetime0 = orderInfo.getDate("usetime");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (usetime0 != null) {
                    String time = sdf.format(usetime0);
                    model.setValue("usetime", (Object)time, index);
                    model.setValue("usetimel", (Object)usetime0, index);
                }
                model.setValue("title", (Object)ResManager.loadKDString((String)"\u7528\u8f66\u8ba2\u5355\u7f16\u53f7", (String)"TripReimburseEntryOrderInfo_4", (String)"fi-er-formplugin", (Object[])new Object[0]), index);
                model.setValue("departaddress", orderInfo.get("departaddress"), index);
                model.setValue("arriveaddress", orderInfo.get("arriveaddress"), index);
                model.setValue("cityname", orderInfo.get("cityname"), index);
            }
            model.setValue("totalamount", totalamount, index);
            model.setValue("orderNum", (Object)orderNum, index);
            model.setValue("orderstatus", (Object)orderstatus, index);
            model.setValue("server", (Object)orderInfo.getString("server"), index);
            model.setValue("oriordernum", (Object)orderInfo.getString("parentordernum"), index);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        String orderformid = (String)model.getValue("orderformid");
        switch (key) {
            case "labelap_change": {
                if (Supplier.ZHONGXING.name().equals(model.getValue("server"))) {
                    if ("er_hotelbill".endsWith(orderformid)) {
                        this.showPage(new FormModel("er_externalsystem", ResManager.loadKDString((String)"\u9000\u6539\u7b7e", (String)"TripReimburseEntryOrderInfo_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, TripReimburseEntryOrderInfo.getZteSsoOrderParameter("hotelorder")));
                        break;
                    }
                    this.showPage(new FormModel("er_externalsystem", ResManager.loadKDString((String)"\u9000\u6539\u7b7e", (String)"TripReimburseEntryOrderInfo_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, TripReimburseEntryOrderInfo.getZteSsoOrderParameter("domairorder")));
                    break;
                }
                if (Supplier.XIECHENG.name().equals(model.getValue("server"))) {
                    this.gotoCTripUI(model, orderformid);
                    break;
                }
                if (!Supplier.CHAILVYIHAO.name().equals(model.getValue("server"))) break;
                this.gotoTravelNoOneTirpList();
                break;
            }
            case "labelap_cancel": {
                if (Supplier.ZHONGXING.name().equals(model.getValue("server"))) {
                    if ("er_hotelbill".endsWith(orderformid)) {
                        this.showPage(new FormModel("er_externalsystem", ResManager.loadKDString((String)"\u9000\u8ba2", (String)"TripReimburseEntryOrderInfo_6", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, TripReimburseEntryOrderInfo.getZteSsoOrderParameter("hotelorder")));
                        break;
                    }
                    this.showPage(new FormModel("er_externalsystem", ResManager.loadKDString((String)"\u9000\u8ba2", (String)"TripReimburseEntryOrderInfo_6", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, TripReimburseEntryOrderInfo.getZteSsoOrderParameter("domairorder")));
                    break;
                }
                if (Supplier.XIECHENG.name().equals(model.getValue("server"))) {
                    this.gotoCTripUI(model, orderformid);
                    break;
                }
                if (!Supplier.CHAILVYIHAO.name().equals(model.getValue("server"))) break;
                this.gotoTravelNoOneTirpList();
                break;
            }
        }
    }

    private void gotoCTripUI(IDataModel model, String orderformid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if ("er_hotelbill".endsWith(orderformid)) {
            params.put("businessType", "hotel");
            params.put("site", "Hotel");
        } else if ("er_planebill".endsWith(orderformid)) {
            params.put("businessType", "domair");
            params.put("site", "Flight");
        } else if ("er_vehiclebill".endsWith(orderformid)) {
            params.put("businessType", "car");
            params.put("site", "CarSD");
        } else if ("er_trainbill".endsWith(orderformid)) {
            params.put("businessType", "train");
            params.put("site", "Train");
        }
        params.put("orderNumber", model.getValue("oriordernum"));
        params.put("employeeNumber", UserServiceHelper.getUserInfoByID((long)Long.parseLong(RequestContext.get().getUserId())).get("number"));
        params.put("view", this.getView());
        params.put("isPC", Boolean.FALSE);
        params.put("tohtml", "logindetail.html");
        ITripService tripService = TripServiceFactory.getTripService((String)"CTripService");
        tripService.login(params);
    }

    private void showPage(FormModel formModel) {
        if (formModel == null) {
            return;
        }
        String formId = formModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripReimburseEntryOrderInfo_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private static Map<String, Object> getZteSsoOrderParameter(String businessType) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("externalInvokeClass", "kd.fi.er.business.externalsystem.BeeToCInvoke");
        customParam.put("businessType", businessType);
        ORM orm = ORM.create();
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)CommonServiceHelper.getCurrentUserID())};
        DynamicObject userObject = orm.queryOne("bos_user", qFilters1);
        customParam.put("employeeNumber", userObject.get("number").toString());
        customParam.put("isPC", Boolean.FALSE);
        return customParam;
    }

    private void gotoTravelNoOneTirpList() {
        HashMap params = new HashMap();
        params.put("employeeNumber", UserServiceHelper.getUserInfoByID((long)Long.parseLong(RequestContext.get().getUserId())).get("number"));
        params.put("view", this.getView());
        params.put("isPC", Boolean.FALSE);
        params.put("businessType", "orderlist");
        ITripService tripService = TripServiceFactory.getTripService((String)"TTripService");
        tripService.login(params);
    }

    public boolean match(DynamicObject orderBill, DynamicObject setting) {
        return orderBill.getString("server").equals(setting.getString("isp"));
    }
}

