/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.IFormController;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.common.model.trip.TripReimburseOpenType;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class TripReimburseList
extends CoreBaseBillListNew {
    private static Log log = LogFactory.getLog(TripReimburseList.class);
    private static final String CLOSE_CLOSE_KEY = "listNewOperationCreateBill";
    private static final List<String> todoStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E1", "F"}));
    private static final List<String> didStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"E2", "G", "H", "I"}));
    private static final MobileListStateInfo todoStateInfo = new MobileListStateInfo("todotab", todoStateList, new MultiLang(TripReimburseList.getAuditMsg(), "TripReimburseList_0", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", didStateList, new MultiLang(TripReimburseList.getCompleteMsg(), "TripReimburseList_1", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)2);

    public TripReimburseList() {
        super(stateInfoList);
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"doingtab"});
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        super.contextMenuClick(e);
        log.info("new:log\u4e91\u4e4b\u5bb6ItemKey\uff1a" + e.getItemKey());
        if (StringUtils.equalsIgnoreCase((String)e.getItemKey().toLowerCase(), (String)"new_tripreimburse")) {
            log.info("contextMenuClick:new_tripreimburse");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("formId", "er_tripreimbursebill_mob");
            paramMap.put("formName", ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"TripReimburseList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            paramMap.put("formType", "6");
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.setCancel(true);
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("EntityName", this.getEntityName());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_approvalrecord");
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSE_CLOSE_KEY));
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSE_CLOSE_KEY.equals(actionId)) {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.operate.New", "listoperation");
            CloseCallBackWraper closeCallBackWraper = new CloseCallBackWraper(this.getView().getPageId(), closeCallBack, this.getModel().getDataEntity().getPkValue(), true);
            IFormController srv = (IFormController)this.getView().getService(IFormController.class);
            srv.formClosedCallBack(closeCallBackWraper);
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)closedCallBackEvent.getReturnData();
            if (userInfo == null) {
                return;
            }
            String tripOpenType = TripReimOpenTypeUtils.getTripReimburseOpenType((Long)userInfo.getOldCompanyId(), (Long)userInfo.getCompanyId(), (Long)userInfo.getUserId());
            String formId = TripReimburseOpenType.getTripReimburseOpenType((String)tripOpenType).getMobFormId();
            FormModel formModel = new FormModel(formId, ResManager.loadKDString((String)"\u65b0\u5efa\u5dee\u65c5\u62a5\u9500", (String)"TripReimburseList_4", (String)"fi-er-formplugin", (Object[])new Object[0]), "6", true, (Map)Maps.newHashMap());
            formModel.getCustomParam().put("checkRightAppId", "tra");
            formModel.getCustomParam().put("appId", "18XD+/5EDN8X");
            formModel.getCustomParam().put("userInfo", JSON.toJSONString((Object)userInfo));
            FormShowParameter formShowParameter = formModel.getFormShowParameter();
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CLOSE_KEY));
            if (formShowParameter.getAppId() == null) {
                formShowParameter.setAppId("18XD+/5EDN8X");
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private static String getAuditMsg() {
        return ResManager.loadKDString((String)"\u62a5\u9500\u4e2d", (String)"TripReimburseList_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"TripReimburseList_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(todoStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

