/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.business.utils.TripReimburseTypeControlUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.common.ExpenseBaseMobPlugin;
import kd.fi.er.formplugin.daily.web.util.TempEncashAmountUtils;
import kd.fi.er.formplugin.mobile.CoreBaseBillEdit;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TripReqBillEdit
extends CoreBaseBillEdit
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(TripReqBillEdit.class);
    private static final String R_ACCCURRENCY = "raccountcurrency";
    private static final String R_ACCEXCHANGERATE = "raccexchangerate";
    private static final String R_ORI_RECEIVEAMOUNT = "rorireceiveamount";
    private Boolean flag = Boolean.TRUE;
    private static final String DEL_TRIPENTRY_CHECK = "deltripentrycheck";

    @Override
    public void initialize() {
        IFormView view = this.getView();
        if (view.getParentView() != null) {
            String billPageId = view.getPageId();
            IPageCache parentPageCache = (IPageCache)view.getParentView().getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_next", "btn_change", "btn_addsection", "labelap_addpayer", "labelap_edit", "labelap_done", "next", "toreimburse", "imageap_delete"});
        AbstractGrid grid = (AbstractGrid)this.getControl("tripentry");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        Boolean isLoan = (Boolean)model.getValue("isloan");
        switch (propName) {
            case "applier": 
            case "istravelers": {
                TripBillTravelerUtils.initGetTravelerDefaultValue((IDataModel)model);
                break;
            }
            case "amount": {
                BigDecimal amount = (BigDecimal)propValue;
                if (!isLoan.booleanValue()) break;
                model.setValue("loanamount", (Object)amount);
                int accountEntryCount = model.getEntryRowCount("accountentry");
                BigDecimal oriReceiveAmount = null;
                if (accountEntryCount != 1) break;
                String isgetaccountcurrency = "0";
                if (this.getModel().getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
                }
                if (!"0".equals(isgetaccountcurrency) && (!"1".equals(isgetaccountcurrency) || this.getModel().getValue("accountcurrency", 0) == null)) break;
                model.setValue("receiveamount", (Object)amount, 0);
                if (this.isSingleSectionCurrency(model)) {
                    oriReceiveAmount = this.refreshTotalAmount("tripentry", "triporiamount", null);
                    TempEncashAmountUtils.triploan_refshAccCurrency((IDataModel)model, (IFormView)this.getView());
                    TempEncashAmountUtils.triploan_refreshTripInfo((IDataModel)model, (IFormView)this.getView());
                } else {
                    oriReceiveAmount = amount;
                }
                if ("1".equals(isgetaccountcurrency) && model.getValue("accountcurrency") != null) {
                    BigDecimal accexchangerate = (BigDecimal)model.getValue("accexchangerate", 0);
                    DynamicObject currency = (DynamicObject)model.getValue("accountcurrency", 0);
                    oriReceiveAmount = AmountUtils.getOriAmount((BigDecimal)amount, (BigDecimal)accexchangerate, (int)currency.getInt("amtprecision"), (String)((String)model.getValue("accquotetype", 0)));
                }
                model.setValue("orireceiveamount", (Object)oriReceiveAmount, 0);
                model.setValue("oriaccnotpayamount", (Object)oriReceiveAmount, 0);
                model.setValue("accnotpayamount", (Object)amount, 0);
                this.flag = false;
                model.setValue(R_ORI_RECEIVEAMOUNT, (Object)oriReceiveAmount);
                this.flag = true;
                break;
            }
            case "bizdate": 
            case "company": {
                this.refreshRepaymentDate();
                break;
            }
            case "costcompany": {
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                break;
            }
            case "raccountcurrency": {
                DynamicObject raccCurrency = (DynamicObject)propValue;
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                BigDecimal exchangeRate = BigDecimal.ONE;
                if (raccCurrency == null || currency == null) break;
                long sourceCurrencyId = raccCurrency.getLong("id");
                long targetCurrencyId = currency.getLong("id");
                long companyId = (Long)model.getValue("company_Id");
                Object costCompany = model.getValue("costcompany");
                Map exchangeRateFromSysParams = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)costCompany, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Object)model);
                exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateFromSysParams.get("exchangeRate")), (Object)BigDecimal.ONE);
                this.getModel().setValue(R_ACCEXCHANGERATE, (Object)exchangeRate);
                BigDecimal oriloanAmount = (BigDecimal)this.getModel().getValue(R_ORI_RECEIVEAMOUNT);
                oriloanAmount = oriloanAmount == null ? BigDecimal.ZERO : oriloanAmount;
                BigDecimal receiveamount = oriloanAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), 5);
                model.setValue("loanamount", (Object)receiveamount);
                break;
            }
            case "rorireceiveamount": {
                if (!this.flag.booleanValue()) break;
                BigDecimal oriloanAmount = (BigDecimal)propValue;
                BigDecimal raccexchangeRate = (BigDecimal)model.getValue(R_ACCEXCHANGERATE);
                if (raccexchangeRate == null) {
                    raccexchangeRate = BigDecimal.ONE;
                }
                BigDecimal receiveamount = oriloanAmount.multiply(raccexchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), 5);
                model.setValue("loanamount", (Object)receiveamount);
                break;
            }
            case "raccexchangerate": {
                boolean isloan = (Boolean)model.getValue("isloan");
                this.getModel().setValue("editentry", (Object)"0");
                if (!isloan) {
                    return;
                }
                BigDecimal exchangeRate = (BigDecimal)propValue;
                if (exchangeRate == null || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                    exchangeRate = BigDecimal.ONE;
                }
                BigDecimal loanAmount = (BigDecimal)model.getValue("loanamount");
                DynamicObject racCountCurrency = (DynamicObject)model.getValue("accountcurrency", 0);
                String currencyTemp = "";
                if (racCountCurrency != null) {
                    currencyTemp = String.valueOf(racCountCurrency.getPkValue());
                }
                DynamicObjectCollection tripCollection = model.getEntryEntity("tripentry");
                BigDecimal orireceiveAmount = BigDecimal.ZERO;
                boolean isSameCurrency = true;
                for (DynamicObject tripRow : tripCollection) {
                    DynamicObject tripCurrency = tripRow.getDynamicObject("tripcurrency");
                    String currencyPk = String.valueOf(tripCurrency.getPkValue());
                    if (currencyTemp.equalsIgnoreCase(currencyPk)) {
                        orireceiveAmount = orireceiveAmount.add(tripRow.getBigDecimal("triporiamount"));
                        continue;
                    }
                    isSameCurrency = false;
                    break;
                }
                this.flag = Boolean.FALSE;
                if (isSameCurrency) {
                    model.setValue(R_ORI_RECEIVEAMOUNT, (Object)orireceiveAmount);
                } else {
                    orireceiveAmount = loanAmount.divide(exchangeRate, 2, 5);
                    model.setValue(R_ORI_RECEIVEAMOUNT, (Object)orireceiveAmount);
                }
                this.flag = Boolean.TRUE;
            }
        }
    }

    protected boolean isSingleSectionCurrency(IDataModel model) {
        return TempEncashAmountUtils.isSingleSectionCurrency((IDataModel)model);
    }

    private void addSection() {
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("tripentry");
        if (null != entryEntity && entryEntity.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryEntity.size() - 1);
            Long to = dynamicObject.getLong("to_id");
            Object enddate = dynamicObject.get("enddate");
            customMap.put("to", to);
            customMap.put("enddate", enddate);
        }
        this.setVehicleVisible();
        Long companyId = (Long)model.getValue("company_id");
        Long currencyId = (Long)model.getValue("currency_id");
        customMap.put("companyId", companyId);
        customMap.put("currencyId", currencyId);
        customMap.put("isquerybudget", (Boolean)model.getValue("isquerybudget"));
        this.showForm("er_tripreqsection_mb", customMap);
    }

    private void setVehicleVisible() {
        String vihicleKey = null;
        vihicleKey = this.getVihicleFromStdConfig() ? "vehicles" : "vehicle";
        CardEntry tripentry = (CardEntry)this.getControl("tripentry");
        int tripentryLen = this.getModel().getEntryRowCount("tripentry");
        for (int i = 0; i < tripentryLen; ++i) {
            tripentry.setChildVisible(false, i, new String[]{vihicleKey});
        }
    }

    protected boolean getVihicleFromStdConfig() {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)ErStdConfig.get((String)"notMultiVehicles"), (CharSequence)"true");
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        model.setValue("editentry", (Object)"0");
        IFormView view = this.getView();
        Boolean isloan = (Boolean)model.getValue("isloan");
        if (isloan.booleanValue()) {
            this.ishaveAccountEntry(model, view);
            DynamicObjectCollection accEntry = model.getEntryEntity("accountentry");
            if (accEntry.size() > 0) {
                model.setValue(R_ACCCURRENCY, (Object)ErCommonUtils.getPk((Object)((DynamicObject)accEntry.get(0)).get("accountcurrency")));
                model.setValue(R_ACCEXCHANGERATE, ((DynamicObject)accEntry.get(0)).get("accexchangerate"));
                model.setValue(R_ORI_RECEIVEAMOUNT, ((DynamicObject)accEntry.get(0)).get("orireceiveamount"));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey().toLowerCase()) {
            case "next": 
            case "btn_addsection": {
                this.addSection();
                break;
            }
            case "labelap_addpayer": 
            case "btn_change": {
                FormShowParameter param = this.getView().getFormShowParameter();
                param.setAppId("18XD+/5EDN8X");
                param.setHasRight(true);
                Map map = param.getCustomParams();
                Boolean isloan = map.size() > 0 ? (Boolean)map.get("isloan") : (Boolean)this.getModel().getValue("isloan");
                HashMap<String, Object> pra = new HashMap<String, Object>();
                pra.put("isloan", isloan);
                pra.put("billtype", this.getModel().getDataEntity().getDataEntityType().getName());
                this.showForm("er_tripreimappilerinfo", pra);
                break;
            }
            case "labelap_edit": {
                this.getModel().setValue("editentry", (Object)"1");
                this.getView().updateView();
                break;
            }
            case "imageap_delete": {
                this.getModel().setValue("editentry", (Object)"2");
                break;
            }
            case "labelap_done": {
                this.getModel().setValue("editentry", (Object)"3");
                this.getView().updateView();
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        this.getModel().setValue("editentry", (Object)"0");
        FormShowParameter param = this.getView().getFormShowParameter();
        Map map = param.getCustomParams();
        Boolean isloan = (Boolean)map.get("isloan");
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        isloan = BooleanUtils.toBooleanDefaultIfNull((Boolean)isloan, (boolean)false);
        model.setValue("isloan", (Object)isloan);
        Boolean isCurrency = this.refreshIsCurrency(model);
        model.setValue("iscurrency", (Object)isCurrency);
        view.setVisible(Boolean.valueOf(false), new String[]{"save", "submit", "mytripflex", "flexpanelap2", "loanflex"});
    }

    private void refreshRepaymentDate() {
        this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
    }

    @Override
    protected boolean isNeedToSetFundingOrg() {
        Boolean loan = TempEncashAmountUtils.isLoan((IDataModel)this.getModel(), (IFormView)this.getView());
        logger.info("\u662f\u5426\u9700\u8981\u8bbe\u7f6e\u652f\u4ed8\u516c\u53f8" + loan);
        return loan;
    }

    @Override
    public void afterBindData(EventObject e) {
        int count;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Boolean isloan = (Boolean)model.getValue("isloan");
        if (isloan.booleanValue() && this.initAccount()) {
            CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)model);
            this.ishaveAccountEntry(model, view);
            this.refreshRepaymentDate();
        }
        if ((count = model.getEntryRowCount("tripentry")) == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap_edit", "labelap_done", "flex_attachment"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap_edit", "labelap_done", "flex_attachment"});
        }
        Boolean isDrawPreViewBill = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isDrawPreViewBill");
        if (isDrawPreViewBill != null && isDrawPreViewBill.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toreimburse", "mtoolbarap"});
            return;
        }
        CommonServiceHelper.setUnsubmitToVisible((IDataModel)model, (IFormView)view, (String)"unsubmit");
        CoreBaseBillServiceHelper.setValueVhc((IDataModel)this.getModel());
        this.setVehicleVisible();
    }

    private void refreshPlanDays() {
        IDataModel model = this.getModel();
        DynamicObjectCollection tripEntrys = model.getEntryEntity("tripentry");
        List startdateList = tripEntrys.stream().map(tripEntry -> tripEntry.getDate("startdate")).collect(Collectors.toList());
        List enddateList = tripEntrys.stream().map(tripEntry -> tripEntry.getDate("enddate")).collect(Collectors.toList());
        logger.info("startdateList:" + startdateList + "--enddateList:" + enddateList);
        if (startdateList.contains(null) || enddateList.contains(null)) {
            return;
        }
        int planDays = TripBillTravelerUtils.getPlayDays(startdateList, enddateList, (DynamicObjectCollection)tripEntrys);
        model.setValue("plandays", (Object)Integer.toString(planDays));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IDataModel model = this.getModel();
        Boolean isloan = (Boolean)model.getValue("isloan");
        Object[] parma = new Object[]{this.getView(), closedCallBackEvent.getReturnData()};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_BEFORECLOSEDCALLBACK, (Object[])new Object[]{TripReqBillEdit.class, closedCallBackEvent.getActionId(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if ("er_tripreqsection_mb".equalsIgnoreCase(closedCallBackEvent.getActionId()) && boo.booleanValue()) {
            this.tripAmountChange(model);
            BigDecimal totalAmount = (BigDecimal)model.getValue("amount");
            if (isloan.booleanValue()) {
                model.setValue("loanamount", (Object)totalAmount);
                DynamicObjectCollection tripentry = model.getEntryEntity("tripentry");
                if (tripentry.size() > 0) {
                    DynamicObject currencytemp = ((DynamicObject)tripentry.get(0)).getDynamicObject("tripcurrency");
                    if (!this.isSingleSectionCurrency(model)) {
                        currencytemp = (DynamicObject)model.getValue("currency");
                    }
                    model.setValue(R_ACCCURRENCY, (Object)ErCommonUtils.getPk((Object)currencytemp));
                }
            } else {
                Boolean isCurrency = (Boolean)model.getValue("iscurrency");
                if (!isCurrency.booleanValue()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{R_ACCCURRENCY});
                }
            }
            IFormView thisView = this.getView();
            thisView.setVisible(Boolean.TRUE, new String[]{"save", "submit"});
            thisView.setVisible(Boolean.FALSE, new String[]{"next"});
            thisView.setVisible(Boolean.TRUE, new String[]{"mytripflex", "flexpanelap2", "btn_addsection", "loanflex"});
            this.setTripEntryCompanyAndDept();
            this.refreshPlanDays();
            TempEncashAmountUtils.triploan_refshAccCurrency((IDataModel)model, (IFormView)this.getView());
            TempEncashAmountUtils.triploan_refreshTripInfo((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("er_tripreimappilerinfo".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean b = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                b.set(p.beforeClosedCallBack(TripReqBillEdit.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), closedCallBackEvent.getReturnData()}));
                return null;
            });
            if (b.get() && closedCallBackEvent.getReturnData() != null) {
                Map paraMap = (Map)closedCallBackEvent.getReturnData();
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                DynamicObject applier = (DynamicObject)paraMap.get("applier");
                if (applier != null) {
                    pageCache.put("consignorId", applier.getPkValue().toString());
                }
                this.setChangeAppilerInfo(model, paraMap);
                this.orgChanged(model, paraMap);
                this.initUserInfo(this.getModel());
                if (isloan.booleanValue()) {
                    this.ishaveAccountEntry(this.getModel(), this.getView());
                    ExpenseBaseMobPlugin.changeAppilerinfoAndAccInfo(this.getModel(), this.getView());
                }
                this.getView().updateView();
            }
            pluginProxy.callReplace(p -> {
                p.afterClosedCallBack(TripReqBillEdit.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), closedCallBackEvent.getReturnData()});
                return null;
            });
        }
        ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AFTERCLOSEDCALLBACK, (Object[])new Object[]{TripReqBillEdit.class, closedCallBackEvent.getActionId(), Boolean.FALSE, parma});
    }

    private void setTripEntryCompanyAndDept() {
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "tripentry": {
                this.tripAmountChange(model);
                BigDecimal totalAmount = (BigDecimal)model.getValue("amount");
                this.refreshTotalAmount("tripentry", "tripaccappamount", "encashamount");
                Boolean isloan = (Boolean)model.getValue("isloan");
                if (isloan.booleanValue()) {
                    model.setValue("loanamount", (Object)totalAmount);
                }
                this.getView().updateView();
                break;
            }
            case "accountentry": {
                this.refshAccCurrency(this.getModel());
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button ctl = (Button)source;
            String opKey = ctl.getOperationKey();
            Boolean isDrawPreViewBill = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isDrawPreViewBill");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)opKey, (CharSequence)"unsubmit") || org.apache.commons.lang3.StringUtils.equals((CharSequence)opKey, (CharSequence)"toreimburse")) {
                if (isDrawPreViewBill != null && isDrawPreViewBill.booleanValue()) {
                    evt.setCancel(true);
                }
                return;
            }
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)opKey, (CharSequence)"reimburse")) {
                DynamicObject tripreqbillInfo = this.getModel().getDataEntity();
                int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)tripreqbillInfo.getDynamicObject("company")), (String)"reqbilltoreimbursecount");
                if (reqbilltoreimbursecount == 0 && BillRelateUtils.existReimburse((DynamicObject)tripreqbillInfo, (IFormView)this.getView())) {
                    evt.setCancel(true);
                    return;
                }
                ArrayList<DynamicObject> reqBillList = new ArrayList<DynamicObject>();
                reqBillList.add(tripreqbillInfo);
                String warningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStrByReq(reqBillList);
                if (StringUtils.isNotBlank((String)warningStr)) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(warningStr);
                    return;
                }
            }
        }
        if (evt.getSource() instanceof Image && "imageap_delete".equals(((Image)evt.getSource()).getKey())) {
            this.getView().getPageCache().put(DEL_TRIPENTRY_CHECK, "true");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "save": 
            case "submit": {
                Boolean isloan = (Boolean)model.getValue("isloan");
                Object value = model.getValue("payer");
                Object payerName = this.getModel().getValue("payername");
                if (isloan.booleanValue() && value == null && payerName == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u3002", (String)"TripReqBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.cancel = true;
                }
                DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
                for (DynamicObject tripentry : tripEntrys) {
                    BigDecimal tripamount = tripentry.getBigDecimal("tripamount");
                    BigDecimal triporiamount = tripentry.getBigDecimal("triporiamount");
                    if (!isloan.booleanValue() || tripamount == null || tripamount.compareTo(BigDecimal.ZERO) != 0 || triporiamount == null || triporiamount.compareTo(BigDecimal.valueOf(1.0E-5)) >= 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u884c\u7a0b\u91d1\u989d\u3002", (String)"TripReqBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.refreshPlanDays();
                DynamicObjectCollection accountentry = model.getEntryEntity("accountentry");
                if (accountentry.size() != 0) {
                    DynamicObject payObject = ((DynamicObject)accountentry.get(0)).getDynamicObject("payer");
                    if (payObject != null && payerName != null || !isloan.booleanValue() || !operateKey.equals("submit")) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u3002", (String)"TripReqBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.cancel = true;
                    break;
                }
                if (!isloan.booleanValue() || !operateKey.equals("submit")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u3002", (String)"TripReqBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                break;
            }
            case "reimburse": {
                Push push = (Push)args.getSource();
                String formId = TripReimburseTypeControlUtils.getTripReqBillReimType((List)Lists.newArrayList((Object[])new Long[]{(Long)this.getModel().getDataEntity().getPkValue()}), (boolean)true);
                push.getOption().setVariableValue("botp_push_target_bill_mobformid", formId);
                TripReimburseTypeControlUtils.setTripReqBillReimType((List)Lists.newArrayList((Object[])new Long[]{(Long)this.getModel().getDataEntity().getPkValue()}));
            }
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        model.deleteEntryData("tripchangehistoryentry");
        model.setValue("ischange", (Object)Boolean.FALSE);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        switch (key) {
            case "submit": {
                if (!result.isSuccess()) break;
                IFormView view = this.getView();
                if (view.getParentView() != null) {
                    view.getParentView().close();
                    view.sendFormAction(this.getView().getParentView());
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
                paramMap.put("formId", view.getEntityId());
                paramMap.put("appId", "18XD+/5EDN8X");
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("need_refresh", "Y");
                paramMap.put("customParam", customParam);
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "unsubmit": {
                DynamicObjectCollection accEntry;
                IDataModel model = this.getModel();
                Boolean isloan = (Boolean)model.getValue("isloan");
                if (isloan.booleanValue() && (accEntry = model.getEntryEntity("accountentry")).size() > 0) {
                    model.setValue(R_ACCCURRENCY, (Object)ErCommonUtils.getPk((Object)((DynamicObject)accEntry.get(0)).get("accountcurrency")));
                    model.setValue(R_ACCEXCHANGERATE, ((DynamicObject)accEntry.get(0)).get("accexchangerate"));
                    model.setValue(R_ORI_RECEIVEAMOUNT, ((DynamicObject)accEntry.get(0)).get("orireceiveamount"));
                }
                this.getModel().setValue("editentry", (Object)"3");
                this.getView().updateView();
            }
        }
    }

    private void showForm(String fid, Map<?, ?> CustomParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", fid);
        paramMap.put("customParam", CustomParam);
        paramMap.put("needCallBack", Boolean.TRUE);
        Object[] parma = new Object[]{this.getView(), this.getModel(), paramMap};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, (Object[])new Object[]{TripReqBillEdit.class, fid, Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (boo.booleanValue()) {
            ShowPageUtils.showMobileBill(paramMap, (AbstractFormPlugin)this);
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
        this.ChoooseEntryRow();
    }

    private void ChoooseEntryRow() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("tripentry");
        int index = grid.getEntryState().getFocusRow();
        HashMap<String, Object> CustomParam = new HashMap<String, Object>();
        CustomParam.put("entryedit", "entryedit");
        CustomParam.put("index", index);
        CustomParam.put("isquerybudget", (Boolean)this.getModel().getValue("isquerybudget"));
        ShowPageUtils.setFormStatusToCustomParam(CustomParam, (IFormView)this.getView());
        this.showForm("er_tripreqsection_mb", CustomParam);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if ("tripentry".equals(name) && Boolean.parseBoolean(this.getView().getPageCache().get(DEL_TRIPENTRY_CHECK))) {
            this.getView().getPageCache().remove(DEL_TRIPENTRY_CHECK);
            if (e.getRowIndexs().length > 0 && !collection.isEmpty()) {
                Long id = (Long)this.getModel().getDataEntity(true).getPkValue();
                for (int i = 0; i < e.getRowIndexs().length; ++i) {
                    int index = e.getRowIndexs()[i];
                    Long entryid = (Long)((DynamicObject)collection.get(index)).getPkValue();
                    if (!TripCommonUtil.checkTripExistOrder((Long)id, (Long)entryid)) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7a0b\u5b58\u5728\u5173\u8054\u7684\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"TripReqBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    protected void refshAccCurrency(IDataModel model) {
        TempEncashAmountUtils.triploan_refshAccCurrency((IDataModel)model, (IFormView)this.getView());
    }
}

