/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileFormPosition;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimburseTypeControlUtils;
import kd.fi.er.business.utils.TripReqBillUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;
import org.apache.commons.lang.StringUtils;

public class TripReqList
extends CoreBaseBillListNew {
    private static final String CONFIRM_AFTERTRIPCHANGE = "confrimtripchange";
    private static Log log = LogFactory.getLog(TripReqList.class);
    private static final List<String> todoStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D"}));
    private static final List<String> doingStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"E", "F", "G"}));
    private static final List<String> didStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"H", "I"}));
    private static final MobileListStateInfo todoStateInfo = new MobileListStateInfo("todotab", todoStateList, new MultiLang(TripReqList.getApplyMsg(), "TripReqList_0", "fi-er-formplugin"));
    private static final MobileListStateInfo doingStateInfo = new MobileListStateInfo("doingtab", doingStateList, new MultiLang(TripReqList.getAuditedMsg(), "TripReqList_1", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", didStateList, new MultiLang(TripReqList.getCompleteMsg(), "TripReqList_2", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)3);

    public TripReqList() {
        super(stateInfoList);
    }

    public void initialize() {
        super.initialize();
        Image image = (Image)this.getControl("imageap");
        String url = "/icons/mobile/label/label_loan_72_36_l.png";
        String language = ResManager.getLanguage();
        if (!language.equals("zh_CN") && !language.equals("zh_TW")) {
            image.setUrl(url);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isNoReimburse()) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("doingtab");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap"});
        }
    }

    private boolean isNoReimburse() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String tabKeyPara = (String)parameter.getCustomParams().get("tabKey");
        return tabKeyPara != null && tabKeyPara.equals("noReimburse");
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isNoReimburse()) {
            QFilter noReimburseFilter = CommonServiceHelper.getNoReimburseFilter((QFilter)CommonUtilHelper.getSpecialDataPermissionFilter(this.getView(), this.getEntityName()));
            e.getQFilters().add(noReimburseFilter);
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean emParameter = TripSyncConfigUtil.getBoolean((String)"Reservation_ personnel_range");
        if (emParameter) {
            List metaItems = new ArrayList();
            IFormView view = this.getView();
            if (view instanceof ListView) {
                ListView listView = (ListView)view;
                String billFormId = listView.getBillFormId();
                try {
                    metaItems = TripReqBillUtil.getMetaItems((String)billFormId);
                }
                catch (Exception ex) {
                    metaItems = new ArrayList();
                    log.error("Line 150", (Throwable)ex);
                }
            }
            Boolean existProp = TripReqBillUtil.judgeIsExistProp(metaItems, (String)"multitravelers");
            if (e.getSpecialDataPermQFilter() != null && existProp.booleanValue()) {
                QFilter qf = new QFilter("multitravelers.fbasedataid_id", "=", (Object)userId);
                e.getSpecialDataPermQFilter().or(qf);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reimbursebtn", "book"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRowCollection = list.getSelectedRows();
        Long billId = null;
        if (listSelectedRowCollection.size() > 0) {
            billId = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
            DynamicObject tripreqbillInfo = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_tripreqbill", (String)"isloan,tripentry.id,iscurrency,billno,istravelers,tripcurrency,company");
            switch (key) {
                case "reimbursebtn": {
                    Object LoanCheckType;
                    String loanType;
                    int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)tripreqbillInfo.getDynamicObject("company")), (String)"reqbilltoreimbursecount");
                    if (reqbilltoreimbursecount == 0) {
                        if (BillRelateUtils.existReimburse((DynamicObject)tripreqbillInfo, (IFormView)this.getView())) {
                            evt.setCancel(true);
                            return;
                        }
                        ArrayList<DynamicObject> reqBillList = new ArrayList<DynamicObject>();
                        reqBillList.add(tripreqbillInfo);
                        String warningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStrByReq(reqBillList);
                        if (StringUtils.isNotBlank((String)warningStr)) {
                            evt.setCancel(true);
                            this.getView().showTipNotification(warningStr);
                            return;
                        }
                    }
                    DynamicObject company = tripreqbillInfo.getDynamicObject("company");
                    Long companyid = OrgUnitServiceHelper.getRootOrgId();
                    if (company != null) {
                        companyid = company.getLong("id");
                    }
                    String string = loanType = (LoanCheckType = ErCommonUtils.getLoanCheckType((long)companyid)) == null ? "1" : LoanCheckType.toString();
                    if (!StringUtils.equals((String)loanType, (String)"1")) break;
                    DynamicObjectCollection tripEntry = tripreqbillInfo.getDynamicObjectCollection("tripentry");
                    HashSet<Object> tripCurrencySet = new HashSet<Object>();
                    for (DynamicObject tripEntryItem : tripEntry) {
                        Object tripCurrency = tripEntryItem.get("tripcurrency");
                        tripCurrencySet.add(tripCurrency);
                    }
                    if (tripCurrencySet.size() <= 1) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u5e01\u79cd\u51fa\u5dee\u7533\u8bf7\u501f\u6b3e\u5355\u7684\u62a5\u9500\uff0c\u8bf7\u4f7f\u7528PC\u7aef\u64cd\u4f5c\u3002", (String)"TripReqList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRowCollection = list.getSelectedRows();
        if (listSelectedRowCollection.size() > 0) {
            switch (key) {
                case "book": {
                    Long billId = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
                    Map custParaMap = TripCommonUtil.getBusinessSectionInfo((Long)billId);
                    if (null != custParaMap && null != custParaMap.get("isloan") && ((Boolean)custParaMap.get("isloan")).booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u501f\u6b3e\u5355\u4e0d\u5141\u8bb8\u9884\u8ba2\uff0c\u8bf7\u586b\u5199\u51fa\u5dee\u7533\u8bf7\u5355\u8fdb\u884c\u9884\u8ba2\u3002", (String)"TripReqBillBookList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    boolean isExistEnbleServer = TripCommonUtil.getEnbleServer();
                    Set trialTripBusniessOrgSet = TripCommonUtil.getTrialTripBusniessOrgSet();
                    if (!isExistEnbleServer) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripReqList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (trialTripBusniessOrgSet != null && trialTripBusniessOrgSet.size() == 1 && trialTripBusniessOrgSet.contains(false)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u672a\u5f00\u901a\u5546\u65c5\u9884\u8ba2\u8bd5\u70b9\u529f\u80fd\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"TripReqList_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (custParaMap == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u884c\u7a0b\u4fe1\u606f\u9519\u8bef\u3002", (String)"TripReqList_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    custParaMap.put("applyBillId", billId);
                    this.showDialog("er_booknavigation", custParaMap);
                }
            }
        }
    }

    private void showDialog(String fid, Map<String, Object> custParaMap) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", fid);
        MobileFormShowParameter showParameter = (MobileFormShowParameter)FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPosition(MobileFormPosition.Bottom);
        showParameter.setCustomParams(custParaMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callBackName");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        super.contextMenuClick(e);
        log.info("new:log\u4e91\u4e4b\u5bb6ItemKey\uff1a" + e.getItemKey());
        HashMap<String, Boolean> mapCustomParam = new HashMap<String, Boolean>();
        if (e.getItemKey().toLowerCase().equals("new_tripreq")) {
            log.info("contextMenuClick:new_tripreq");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formId", "er_tripreqbill_mob");
            paramMap.put("formName", ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"TripReqList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            paramMap.put("formType", "6");
            mapCustomParam.put("isloan", false);
            paramMap.put("customParam", mapCustomParam);
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        } else if (e.getItemKey().toLowerCase().equals("new_tripreqloan")) {
            log.info("contextMenuClick:new_tripreqloan");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formId", "er_tripreqbill_mob");
            paramMap.put("formName", ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7(\u501f)", (String)"TripReqList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            paramMap.put("formType", "6");
            mapCustomParam.put("isloan", true);
            paramMap.put("customParam", mapCustomParam);
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.setCancel(true);
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("EntityName", this.getEntityName());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_approvalrecord");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"isloan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (((Boolean)dynamicObject.get("isloan")).booleanValue()) {
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s(\u501f)", (String)"HomeAddNewDialogPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue()));
        } else {
            formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Push) {
            Push push = (Push)source;
            if (StringUtils.equals((String)push.getOperateKey(), (String)"pushreimburse")) {
                List selectedIds = args.getListSelectedData().stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
                if (TripReimburseTypeControlUtils.companyIsSame(selectedIds)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u51fa\u5dee\u7533\u8bf7\u5355\u7684\u7533\u8bf7\u4eba\u516c\u53f8\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TripReqList_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String formId = TripReimburseTypeControlUtils.getTripReqBillReimType(selectedIds, (boolean)true);
                push.getOption().setVariableValue("botp_push_target_bill_mobformid", formId);
                TripReimburseTypeControlUtils.setTripReqBillReimType(selectedIds);
            }
        } else if ("tripchange".equals(((AbstractOperate)source).getOperateKey()) && !((FormOperate)source).getOption().tryGetVariableValue(CONFIRM_AFTERTRIPCHANGE, new RefObject())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tripchange", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u884c\u7a0b\u53d8\u66f4\u540e\uff0c\u6570\u636e\u65e0\u6cd5\u6062\u590d\u5230\u539f\u884c\u7a0b\u3002\u662f\u5426\u786e\u8ba4\u53d8\u66f4\uff1f", (String)"TripReqList_10", (String)"fi-er-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("tripchange".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(CONFIRM_AFTERTRIPCHANGE, "true");
            OperationResult operationResult = this.getView().invokeOperation("tripchange", operateOption);
            if (operationResult.isSuccess()) {
                MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                Long billId = (Long)((MobileListView)this.getView()).getFocusRowPkId();
                String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                customParam.put("FormId", formId);
                customParam.put("Status", 1);
                customParam.put("EntityName", this.getEntityName());
                customParam.put("billId", billId);
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                formShowParameter.setCustomParams(customParam);
                formShowParameter.setFormId("er_approvalrecord");
                formShowParameter.setCaption(mobparameter.getFormConfig().getCaption().getLocaleValue());
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private static String getApplyMsg() {
        return ResManager.loadKDString((String)"\u7533\u8bf7\u4e2d", (String)"TripReqList_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getAuditedMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"TripReqList_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"TripReqList_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(todoStateInfo);
        stateInfoList.add(doingStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

