/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;

public class TripTipsListPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static final String DATE = "date";
    private static final String WEATHER_ICON = "icon";
    private static final String TEMPERATURE_RANGE = "range";
    private static final String WEATHER_TYPE = "weathertype";
    private static final String BACKMAINPAGE = "backmainpage";
    public static final String TIPCARD = "onetip";
    public static final String FROMCITYNAME = "fromcityname";
    public static final String TOCITYNAME = "tocityname";
    public static final String AIRLINENAME = "airlinename";
    public static final String FLIGHTNO = "flightno";
    public static final String TAKEOFFTIME = "takeofftime";
    public static final String TAKEOFFTIME_L = "takeofftimel";
    public static final String LANDINGTIME_L = "landingtimel";
    public static final String LANDINGTIME = "landingtime";
    public static final String TAKEOFFPORTNAME = "takeoffportname";
    public static final String LANDINGPORTNAME = "landingportname";

    private static String getWENXINTISHI() {
        String tip = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"TripTipsListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
        return String.format("%1$s%2$s%3$s", ",", tip, ":");
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BACKMAINPAGE});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(TIPCARD);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.showAllTips();
    }

    public void showAllTips() {
        RequestContext requestContext = RequestContext.get();
        String currentId = requestContext.getUserId();
        QFilter filterByUser = new QFilter("sourcetravelerid", "=", (Object)Long.valueOf(currentId));
        QFilter filterByState = new QFilter("ticketstatus", "=", (Object)"UNUSED");
        QFilter filterByTime = new QFilter(TAKEOFFTIME, ">=", (Object)new Date());
        String selectItem = "oabillnum,fromcityname,tocityname,airlinename,flightno,takeofftime,landingtime,takeoffportname,landingportname";
        QFilter[] filters = new QFilter[]{filterByUser, filterByState, filterByTime};
        String orderBys = "takeofftime asc";
        DynamicObject[] tripTipsData = BusinessDataServiceHelper.load((String)"er_planebill", (String)selectItem, (QFilter[])filters, (String)orderBys);
        if (tripTipsData.length == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultflexpanelap"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultflexpanelap"});
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(TIPCARD, tripTipsData.length);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
        for (int i = 0; i < tripTipsData.length; ++i) {
            StringBuilder planeInfo = new StringBuilder();
            DynamicObject temp = tripTipsData[i];
            String fromCityName = temp.getString(FROMCITYNAME);
            String toCityName = temp.getString(TOCITYNAME);
            String airLineName = temp.getString(AIRLINENAME);
            String flightno = temp.getString(FLIGHTNO);
            Date takeOffTime = temp.getDate(TAKEOFFTIME);
            Date landingTime = temp.getDate(LANDINGTIME);
            String takeofftime = df.format(takeOffTime);
            String takeOffPortName = temp.getString(TAKEOFFPORTNAME);
            String landingPortName = temp.getString(LANDINGPORTNAME);
            model.setValue(FROMCITYNAME, (Object)fromCityName, i);
            model.setValue(TOCITYNAME, (Object)toCityName, i);
            model.setValue(AIRLINENAME, (Object)airLineName, i);
            model.setValue(FLIGHTNO, (Object)flightno, i);
            model.setValue(TAKEOFFTIME, (Object)takeOffTime, i);
            model.setValue(TAKEOFFTIME_L, (Object)takeOffTime, i);
            model.setValue(LANDINGTIME, (Object)landingTime, i);
            model.setValue(LANDINGTIME_L, (Object)landingTime, i);
            model.setValue(TAKEOFFPORTNAME, (Object)takeOffPortName, i);
            model.setValue(LANDINGPORTNAME, (Object)landingPortName, i);
            planeInfo.append(takeofftime);
            planeInfo.append(airLineName);
            planeInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u98de\u5f80%2%s", (String)"TripTipsListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), flightno, toCityName));
            model.setValue("ishide", (Object)"1", i);
            planeInfo.append(",");
            planeInfo.append(TripTipsListPlugin.getWENXINTISHI());
            model.setValue("tripinfo", (Object)planeInfo, i);
            model.setValue("weathernotice", (Object)"", i);
            this.getView().updateView();
        }
    }

    private void clickEntry() {
    }

    public void click(EventObject evt) {
        ShowPageUtils.showPage((FormModel)new FormModel("er_mainpage", ResManager.loadKDString((String)"\u9996\u9875", (String)"TripTipsListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "11"), (AbstractFormPlugin)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        this.clickEntry();
    }
}

