/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.pool.ExpensePoolUtil;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpensePoolConvertTripGridStylePlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("formgroup");
        e.addSrcField("startdate");
        e.addSrcField("tripfrom");
        e.addSrcField("tripto");
        e.addSrcField("tripcheckindate");
        e.addSrcField("tripdeparturedate");
        e.addSrcField("tripcityfield");
        e.addSrcField("expenseitem.attribute");
        e.addSrcField("formid");
        e.addSrcField("happendate");
        e.addSrcField("currency");
        e.addSrcField("applier");
        e.addSrcField("costdept");
        e.addSrcField("costcompany");
        e.addSrcField("bdproject");
        e.addSrcField("expenseitem");
        e.addSrcField("expenseitemedit");
        e.addSrcField("triparea");
        e.addSrcField("tripmulseatgrade");
        e.addSrcField("trip2mulwayto");
        e.addSrcField("description");
        e.addSrcField("descriptiondescription");
        e.addSrcField("id");
        e.addSrcField("invoiceno_entry");
        e.addSrcField("expenseamount");
        e.addSrcField("taxrate");
        e.addSrcField("orientryamount");
        e.addSrcField("taxamount");
        e.addSrcField("airportconstructionfee");
        e.addSrcField("org");
        e.addSrcField("company");
        e.addSrcField("applierpositionstr");
        e.addSrcField("tel");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        Map fldProperties = e.getFldProperties();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ExtendedDataEntity[] targetItemEntrys = e.getTargetExtDataEntitySet().FindByEntityKey("entryentity");
        ExtendedDataEntity[] invoiceEntry = e.getTargetExtDataEntitySet().FindByEntityKey("invoiceentry");
        ExtendedDataEntity[] targetInvoiceItemEntry = e.getTargetExtDataEntitySet().FindByEntityKey("invoiceitementry");
        this.setAndGetSelectedRowEntryId(billDataEntitys);
        this.setAndGetSelectedRowEntryId(targetItemEntrys);
        this.setAndGetSelectedRowEntryId(invoiceEntry);
        this.setAndGetSelectedRowEntryId(targetInvoiceItemEntry);
        long idCount = Arrays.stream(billDataEntitys).flatMap(billDataEntity -> ((List)billDataEntity.getValue("ConvertSource")).stream()).count();
        long[] ids = DB.genLongIds((String)"t_er_reimburseentry", (int)((int)idCount));
        int idIndex = 0;
        for (ExtendedDataEntity billDataEntity2 : billDataEntitys) {
            DynamicObject targetBill = billDataEntity2.getDataEntity();
            targetBill.getDataEntityState().setPushChanged(true);
            List srcBills = (List)billDataEntity2.getValue("ConvertSource");
            DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
            Set expenseItemId = srcBills.stream().map(record -> (Long)((DynamicProperty)fldProperties.get("expenseitem")).getValue(record)).filter(item -> item != null).collect(Collectors.toSet());
            ExpensePoolUtil.convertPreHandleDate((List)srcBills, (Map)fldProperties);
            Set validateItem = ExpensePoolUtil.validateTripExpenseitem((Long)targetBill.getLong(this.getEntryIdName("company")), expenseItemId);
            srcBills.stream().filter(record -> ((DynamicProperty)fldProperties.get("expenseitem")).getValue(record) != null && !validateItem.contains(((DynamicProperty)fldProperties.get("expenseitem")).getValue(record))).forEach(record -> ((DynamicProperty)fldProperties.get("expenseitem")).setValue(record, null));
            if (this.getOpType() == ConvertOpType.Push) {
                this.initHeadData(targetBill, fldProperties, srcBills);
                targetTripEntrys.clear();
                DynamicObject tripEntry = targetTripEntrys.addNew();
                tripEntry.set("seq", (Object)1);
                Object item2 = ((DynamicProperty)fldProperties.get("expenseitemedit")).getValue(srcBills.get(0));
                boolean isValid = ExpensePoolUtil.validExpenseItem((Object)item2, (Long)((Long)((DynamicProperty)fldProperties.get("company")).getValue(srcBills.get(0))), (Long)((Long)((DynamicProperty)fldProperties.get("costdept")).getValue(srcBills.get(0))), (String)"er_tripreimbursebill");
                tripEntry.set("tripexpenseitem_id", isValid ? item2 : null);
                targetBill.set("headexpenseitem_id", tripEntry.get("tripexpenseitem_id"));
            }
            targetTripEntrys.removeIf(row -> row.get("seq") == null || row.getInt("seq") > 1);
            Map<Long, List<Long>> allRecordSeatGrade = this.findMulBaseData(srcBills, fldProperties, "tripmulseatgrade", "t_er_poolmulseatgrade", "fid", new String[]{"fbasedataid"});
            Map<Long, List<Long>> allRecordMulWayTo = this.findMulBaseData(srcBills, fldProperties, "trip2mulwayto", "t_er_pooltrip2mulwayto", "fid", new String[]{"fbasedataid"});
            if (ErCommonUtils.getExpenseAssumeShowTypes((long)targetBill.getLong("company_id")) == 1) {
                srcBills.stream().forEach(record -> {
                    ((DynamicProperty)fldProperties.get("costdept")).setValue(record, targetBill.get(this.getEntryIdName("costdept")));
                    ((DynamicProperty)fldProperties.get("costcompany")).setValue(record, targetBill.get(this.getEntryIdName("costcompany")));
                });
            }
            for (DynamicObject record2 : srcBills) {
                DynamicObject newRow = ((DynamicObject)targetTripEntrys.get(0)).getDynamicObjectCollection("entryentity").addNew();
                this.initEntryEntity(fldProperties, record2, newRow);
                this.setMulBaseData(fldProperties, (DynamicObject)targetTripEntrys.get(0), record2, "trip2travelers", "applier", newRow, null);
                this.setMulBaseData(fldProperties, (DynamicObject)targetTripEntrys.get(0), record2, "mulseatgrade", "tripmulseatgrade", newRow, allRecordSeatGrade);
                this.setMulBaseData(fldProperties, (DynamicObject)targetTripEntrys.get(0), record2, "trip2mulwayto", "trip2mulwayto", newRow, allRecordMulWayTo);
                newRow.set("id", (Object)ids[idIndex++]);
                newRow.set("seq", (Object)((DynamicObject)targetTripEntrys.get(0)).getDynamicObjectCollection("entryentity").size());
                DynamicObjectCollection entry_lk = newRow.getDynamicObjectCollection("entryentity_lk");
                DynamicObject linkRow = new DynamicObject(entry_lk.getDynamicObjectType());
                Long sourceTableId = EntityMetadataCache.loadTableDefine((String)"er_expense_recordbill", (String)"er_expense_recordbill").getTableId();
                linkRow.set("seq", (Object)1);
                linkRow.set("entryentity_lk_stableid", (Object)sourceTableId);
                linkRow.set("entryentity_lk_sbillid", ((DynamicProperty)fldProperties.get("id")).getValue((Object)record2));
                linkRow.set("entryentity_lk_sid", ((DynamicProperty)fldProperties.get("id")).getValue((Object)record2));
                entry_lk.add((Object)linkRow);
            }
            this.genInvoiceRelation(targetBill);
        }
    }

    protected void initHeadData(DynamicObject targetBill, Map<String, DynamicProperty> srcfldPro, List<DynamicObject> srcBills) {
        long currUserId = RequestContext.get().getCurrUserId();
        targetBill.set(this.getEntryIdName("applier"), this.getValueByConvert("applier", srcfldPro, srcBills.get(0)));
        targetBill.set("tel", this.getValueByConvert("tel", srcfldPro, srcBills.get(0)));
        targetBill.set("applierpositionstr", this.getValueByConvert("applierpositionstr", srcfldPro, srcBills.get(0)));
        targetBill.set(this.getEntryIdName("org"), this.getValueByConvert("org", srcfldPro, srcBills.get(0)));
        targetBill.set(this.getEntryIdName("company"), this.getValueByConvert("company", srcfldPro, srcBills.get(0)));
        targetBill.set(this.getEntryIdName("costdept"), this.getValueByConvert("costdept", srcfldPro, srcBills.get(0)));
        targetBill.set(this.getEntryIdName("costcompany"), this.getValueByConvert("costcompany", srcfldPro, srcBills.get(0)));
        Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)targetBill.get(this.getEntryIdName("company")), (Object)targetBill.get(this.getEntryIdName("costcompany")));
        targetBill.set(this.getEntryIdName("currency"), (Object)currencyId);
        targetBill.set(this.getEntryIdName("creator"), (Object)currUserId);
        targetBill.set("billstatus", (Object)"A");
        Set applierSet = srcBills.stream().map(record -> ErCommonUtils.getPk((Object)((DynamicProperty)srcfldPro.get("applier")).getValue(record))).collect(Collectors.toSet());
        Set currencySet = srcBills.stream().map(record -> ErCommonUtils.getPk((Object)((DynamicProperty)srcfldPro.get("currency")).getValue(record))).collect(Collectors.toSet());
        currencySet.add(ErCommonUtils.getPk((Object)targetBill.get(this.getEntryIdName("currency"))));
        targetBill.set("istravelers", (Object)(applierSet.size() > 1 ? 1 : 0));
        String isgetaccountcurrency = "0";
        if (this.getEntryIdName("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)targetBill.getLong(this.getEntryIdName("company")));
        }
        targetBill.set("iscurrency", (Object)(currencySet.size() > 1 || CommonServiceHelper.initCurrency() != false || StringUtils.equals((CharSequence)"1", (CharSequence)isgetaccountcurrency) ? 1 : 0));
        boolean ismultravelers = SystemParamterUtil.getIsMulTravelers((long)targetBill.getLong(this.getEntryIdName("company")));
        targetBill.set("ismultravelers", (Object)(ismultravelers || targetBill.getBoolean("istravelers") ? 1 : 0));
        targetBill.set("headproject_id", srcfldPro.get("bdproject").getValue((Object)srcBills.get(0)));
        targetBill.set("billkind", (Object)"1");
    }

    protected void initEntryEntity(Map<String, DynamicProperty> srcfldPro, DynamicObject record, DynamicObject newRow) {
        newRow.set(this.getEntryIdName("travelcostdept"), this.getValueByConvert("costdept", srcfldPro, record));
        newRow.set(this.getEntryIdName("travelcostcompany"), this.getValueByConvert("costcompany", srcfldPro, record));
        newRow.set(this.getEntryIdName("expenseitem"), this.getValueByConvert("expenseitem", srcfldPro, record));
        newRow.set("trip2startdate", this.getValueByConvert("tripcheckindate", srcfldPro, record));
        newRow.set("trip2enddate", this.getValueByConvert("tripdeparturedate", srcfldPro, record));
        newRow.set("comment", this.getValueByConvert("description", srcfldPro, record));
        Long dayCount = CommonServiceHelper.calcDays((Date)newRow.getDate("trip2startdate"), (Date)newRow.getDate("trip2enddate"));
        newRow.set("daycount", (Object)BigDecimal.valueOf(dayCount));
        DynamicObject item = null;
        if (this.getValueByConvert("expenseitem", srcfldPro, record) != null) {
            item = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripexpenseitem", (String)"id,attribute", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)this.getValueByConvert("expenseitem", srcfldPro, record)))});
        }
        if (item == null || StringUtils.equalsAny((CharSequence)item.getString("attribute"), (CharSequence[])new CharSequence[]{"0", "1", "5", "6"})) {
            srcfldPro.get("tripfrom").setValue((Object)record, this.getValueByConvert("tripcityfield", srcfldPro, record));
            srcfldPro.get("tripto").setValue((Object)record, this.getValueByConvert("tripcityfield", srcfldPro, record));
        }
        newRow.set("wbsrcbilltype", (Object)"er_expense_recordbill");
        newRow.set(this.getEntryIdName("trip2from"), this.getValueByConvert("tripfrom", srcfldPro, record));
        newRow.set(this.getEntryIdName("trip2to"), this.getValueByConvert("tripto", srcfldPro, record));
        newRow.set(this.getEntryIdName("triparea"), this.getValueByConvert("triparea", srcfldPro, record));
        newRow.set(this.getEntryIdName("entrycurrency"), this.getValueByConvert("currency", srcfldPro, record));
        newRow.set("orientryamount", this.getValueByConvert("expenseamount", srcfldPro, record));
        newRow.set("taxrate", this.getValueByConvert("taxrate", srcfldPro, record));
        newRow.set("taxamount", this.getValueByConvert("taxamount", srcfldPro, record));
        newRow.set("notaxamount", this.getValueByConvert("notaxamount", srcfldPro, record));
        newRow.set("airportconstructionfee", this.getValueByConvert("airportconstructionfee", srcfldPro, record));
        newRow.set("wbsrcbillid", this.getValueByConvert("id", srcfldPro, record));
        newRow.set("invoiceno_entry", this.getValueByConvert("invoiceno_entry", srcfldPro, record));
        newRow.set("itemfrom", (Object)(StringUtils.isEmpty((CharSequence)((String)newRow.get("invoiceno_entry"))) ? "0" : "1"));
    }

    private void setMulBaseData(Map<String, DynamicProperty> srcfldPro, DynamicObject tripEntryRow, DynamicObject record, String tarEntryName, String srcEntryName, DynamicObject newRow, Map<Long, List<Long>> mulBaseDataMap) {
        DynamicObjectCollection mulBaseDatas = null;
        Object pkObj = srcfldPro.get(srcEntryName).getValue((Object)record);
        if (pkObj != null) {
            Long pk = Long.valueOf(pkObj.toString());
            if (mulBaseDataMap == null) {
                mulBaseDatas = ExpensePoolUtil.generateMultiPropValues((DynamicObject)tripEntryRow, (DynamicObject)newRow, (String)tarEntryName, Stream.of(pk).collect(Collectors.toList()));
            } else if (mulBaseDataMap.containsKey(pk)) {
                mulBaseDatas = ExpensePoolUtil.generateMultiPropValues((DynamicObject)tripEntryRow, (DynamicObject)newRow, (String)tarEntryName, mulBaseDataMap.get(pk));
            }
            newRow.set(tarEntryName, mulBaseDatas);
        }
    }

    private Object getValueByConvert(String propName, Map<String, DynamicProperty> srcfldPro, DynamicObject record) {
        DynamicProperty property = srcfldPro.get(propName);
        if (property == null) {
            return null;
        }
        Object value = property.getValue((Object)record);
        if (value instanceof Long && (Long)value == 0L) {
            return null;
        }
        return property.getValue((Object)record);
    }

    private String getEntryIdName(String entryName) {
        return entryName + "_id";
    }

    private Map<Long, List<Long>> findMulBaseData(List<DynamicObject> srcBills, Map<String, DynamicProperty> srcfldPro, String entryName, String tableName, String pkId, String[] fields) {
        final HashMap<Long, List<Long>> mulMap = new HashMap<Long, List<Long>>();
        String field = Arrays.stream(fields).collect(Collectors.joining(","));
        String sql = "select %s, %s from %s where %s   in  (%s) ";
        String params = srcBills.stream().map(record -> (String)((DynamicProperty)srcfldPro.get(entryName)).getValue(record)).filter(pk -> pk != null).collect(Collectors.joining(","));
        sql = String.format(sql, pkId, field, tableName, pkId, params);
        if (!StringUtils.isEmpty((CharSequence)params)) {
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long pkId = Long.valueOf(resultSet.getString("fid"));
                        Long baseDataId = resultSet.getLong("fbasedataid");
                        List baseDatas = (List)mulMap.get(pkId);
                        if (baseDatas != null) {
                            baseDatas.add(baseDataId);
                            continue;
                        }
                        ArrayList<Long> list = new ArrayList<Long>(3);
                        list.add(baseDataId);
                        mulMap.put(pkId, list);
                    }
                    return null;
                }
            });
        }
        return mulMap;
    }

    private void genInvoiceRelation(DynamicObject targetBill) {
        DynamicObjectCollection detailEntry = ((DynamicObject)targetBill.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        Map<Long, List<DynamicObject>> srcRecordIdMapRow = detailEntry.stream().filter(row -> row.getLong("wbsrcbillid") != 0L).collect(Collectors.groupingBy(row -> row.getLong("wbsrcbillid")));
        DynamicObjectCollection invoiceEntry = targetBill.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceItemEntry = targetBill.getDynamicObjectCollection("invoiceitementry");
        DynamicObjectCollection expenseMapInvoice = targetBill.getDynamicObjectCollection("invoiceandexpense");
        Map<Long, List<DynamicObject>> srcRecordIdMapInvoiceItemRow = invoiceItemEntry.stream().collect(Collectors.groupingBy(row -> row.getLong("itementryid")));
        Map<Long, List<DynamicObject>> srcRecordIdMapInvoiceRow = invoiceEntry.stream().collect(Collectors.groupingBy(row -> row.getLong("invoicesrcbillid")));
        srcRecordIdMapRow.entrySet().stream().forEach(entry -> {
            Long srcRecordId = (Long)entry.getKey();
            List invoiceItemRows = (List)srcRecordIdMapInvoiceItemRow.get(srcRecordId);
            if (invoiceItemRows != null) {
                Map<Long, List<DynamicObject>> Invoices = ((List)srcRecordIdMapInvoiceRow.get(srcRecordId)).stream().collect(Collectors.groupingBy(row -> row.getLong("invoicesrcentryid")));
                invoiceItemRows.stream().forEach(itemRow -> {
                    Object expenseRowPK = ((DynamicObject)((List)entry.getValue()).get(0)).getPkValue();
                    Object invoiceRowPk = ((DynamicObject)((List)Invoices.get(itemRow.getLong("invoiceheadentryid"))).get(0)).getPkValue();
                    itemRow.set("itementryid", expenseRowPK);
                    itemRow.set("invoiceheadentryid", invoiceRowPk);
                    DynamicObject newRow = expenseMapInvoice.addNew();
                    newRow.set("expenseentryid", expenseRowPK);
                    newRow.set("expenseentryid", invoiceRowPk);
                });
            }
        });
    }

    private void setAndGetSelectedRowEntryId(ExtendedDataEntity[] itemRows) {
        if (ArrayUtils.isEmpty((Object[])itemRows)) {
            return;
        }
        long[] ids = ORM.create().genLongIds(itemRows[0].getDataEntity().getDataEntityType(), itemRows.length);
        for (int i = 0; i < itemRows.length; ++i) {
            Long pkid = (Long)itemRows[i].getDataEntity().getPkValue();
            if (pkid != null && pkid != 0L) continue;
            itemRows[i].setValue("id", (Object)ids[i]);
        }
    }
}

