/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.pool.botp.model.BotpDrawParam;
import kd.fi.er.model.FormModel;

public class RecordDrawReimburMobFormPlugin
extends AbstractMobBillPlugIn {
    private static final String RECORDPOOLDRAW = "recordpooldraw";
    private static final String RECORDLIST = "er_expense_list_card_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RECORDPOOLDRAW});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "recordpooldraw": {
                this.openSelectRecordList();
            }
        }
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            Boolean isCurrency = (Boolean)this.getModel().getValue("iscurrency");
            if (isCurrency.booleanValue()) {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                String entityId = this.getView().getEntityId();
                if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                    int expEntryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
                    for (int index = 0; index < expEntryRowCount; ++index) {
                        DynamicObject entryCurrency = (DynamicObject)this.getModel().getValue("entrycurrency", index);
                        BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate", index);
                        if (entryCurrency == null || currency.getPkValue() == entryCurrency.getPkValue() || BigDecimal.ONE.compareTo(exchangerate) == 0) continue;
                        BigDecimal amount = (BigDecimal)this.getModel().getValue("expenseamount", index);
                        this.getModel().setValue("expenseamount", (Object)BigDecimal.ZERO, index);
                        this.getModel().setValue("expenseamount", (Object)amount, index);
                    }
                }
            }
            if (this.getModel().getEntryEntity("expenseentryentity").getDynamicObjectType().getProperties().get((Object)"wbsrcbilltype") != null) {
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("expenseentryentity");
                for (int index = 0; index < entryColl.size(); ++index) {
                    DynamicObject entryItem = (DynamicObject)entryColl.get(index);
                    String srcType = entryItem.getString("wbsrcbilltype");
                    if (!ErEntityTypeUtils.isExpenseRecordBill((String)srcType) && !ErEntityTypeUtils.isTripRecordBill((String)srcType)) continue;
                    BigDecimal amount = (BigDecimal)this.getModel().getValue("expenseamount", index);
                    this.getModel().setValue("expenseamount", (Object)BigDecimal.ZERO, index);
                    this.getModel().setValue("expenseamount", (Object)amount, index);
                }
            }
            this.refreshAccount();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnObj;
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)RECORDLIST) && (returnObj = closedCallBackEvent.getReturnData()) instanceof BotpDrawParam) {
            BotpDrawParam bdp = (BotpDrawParam)returnObj;
            this.drawRecordToDaily(bdp);
        }
    }

    private void openSelectRecordList() {
        BotpDrawParam bdp = new BotpDrawParam();
        bdp.setSourceEntityNumber("er_expense_recordbill");
        bdp.setTargetEntityNumber("er_dailyreimbursebill");
        DynamicObjectCollection itemColl = this.getModel().getEntryEntity("expenseentryentity");
        Set<Long> srcRecordId = itemColl.stream().map(item -> item.getLong("wbsrcbillid")).collect(Collectors.toSet());
        bdp.setSrcSelectedRecordId(srcRecordId);
        FormModel formModel = new FormModel(RECORDLIST, ResManager.loadKDString((String)"\u9009\u62e9\u8d39\u7528\u8bb0\u5f55", (String)"RecordDrawReimburMobFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true);
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RECORDLIST));
        formShowParameter.setCustomParam("botpDrawParam", (Object)bdp);
        formShowParameter.setCustomParam("checkRightAppId", (Object)"exp");
        if (formShowParameter.getAppId() == null) {
            formShowParameter.setAppId("18X6P1ZSXS44");
        }
        this.getView().showForm(formShowParameter);
    }

    private void drawRecordToDaily(BotpDrawParam bdp) {
        ListSelectedRowCollection selectedRowsColl = bdp.getSelectedRowsColl();
        String sourceEntityNumber = bdp.getSourceEntityNumber();
        String targetEntityNumber = bdp.getTargetEntityNumber();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)targetEntityNumber)) {
            targetEntityNumber = "er_dailyreimbursebill";
        }
        DrawArgs drawArgs = BotpDrawServiceUtil.buildDrawArgs((String)sourceEntityNumber, (String)targetEntityNumber, (IFormView)this.getView(), (ListSelectedRowCollection)selectedRowsColl);
        drawArgs.setAppId("18X6P1ZSXS44");
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)drawArgs);
        ArrayList resultList = new ArrayList();
        if (result.isSuccess()) {
            BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, resultList, (BillEntityType)((BillEntityType)this.getModel().getDataEntityType()));
        }
        if (!resultList.isEmpty()) {
            ((IBillModel)this.getModel()).push(resultList.get(0));
            this.getModel().getDataEntity(true);
            IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            RedisModelCache modelCache = new RedisModelCache(refProvider, (MainEntityType)((BillEntityType)this.getModel().getDataEntityType()), this.getView().getPageId());
            modelCache.release();
        }
        this.getView().updateView();
    }

    protected void refreshAccount() {
        IDataModel model = this.getModel();
        String writeOffType = null;
        model.beginInit();
        writeOffType = (String)model.getValue("writeofftype");
        WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
        WriteOffMoneyUtils.writeOffMoney((IDataModel)model, (String)writeOffType, (IFormView)this.getView());
        if (WriteOffTypeEnum.ORGI_WO.getValue().equalsIgnoreCase(writeOffType)) {
            int i;
            if (model.getEntryRowCount("writeoffmoney") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffmoney"); ++i) {
                    BigDecimal woAmount = (BigDecimal)model.getValue("accloanamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woAmount, (String)"curraccloanamount", (String)"loanexchangerate", (String)"writeoffquotetype", (int)i);
                }
            }
            if (model.getEntryRowCount("writeoffapply") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffapply"); ++i) {
                    BigDecimal woApplyAmount = (BigDecimal)model.getValue("reimbursedamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woApplyAmount, (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"writeoffapplyquotetype", (int)i);
                }
            }
        }
        model.endInit();
        CommonUtilHelper.setWriteOffAmountLable(model, this.getView(), new boolean[0]);
        BigDecimal totalOffsetAmount = ReimburseUtils.sumOffsetAmount((IDataModel)model, (IFormView)this.getView());
        model.setValue("totaloffsetamount", (Object)totalOffsetAmount);
        WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)writeOffType, (IFormView)this.getView());
        CommonViewControlUtil.expensePageRules(model, this.getView());
        CommonViewControlUtil.setExpenseAmount(model, this.getView());
        if (model.getProperty("payamount") != null) {
            WriteOffMoneyUtils.showPayAmount((IDataModel)model, (Label)((Label)this.getControl("label_account_amount")));
        }
    }
}

