/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.mobile;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;

public class ExpensePoolTripInfoBillMobPlugin
extends AbstractMobBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView pView = this.getView().getParentView();
        IDataModel pvModel = pView.getModel();
        model.setValue("tripfrom", pvModel.getValue("tripfrom"));
        model.setValue("tripto", pvModel.getValue("tripto"));
        model.setValue("startdate", pvModel.getValue("startdate"));
        model.setValue("trippassenger", pvModel.getValue("trippassenger"));
        model.setValue("tripmulseatgrade", pvModel.getValue("tripmulseatgrade"));
        model.setValue("tripcheckindate", pvModel.getValue("tripcheckindate"));
        model.setValue("tripdeparturedate", pvModel.getValue("tripdeparturedate"));
        model.setValue("tripcityfield", pvModel.getValue("tripcityfield"));
        model.setValue("triparea", pvModel.getValue("triparea"));
        model.setValue("expenseitem", pvModel.getValue("expenseitem"));
        model.setValue("happendate", pvModel.getValue("happendate"));
        model.setValue("airportconstructionfee", pvModel.getValue("airportconstructionfee"));
        String vehicle = pvModel.getValue("vehicle").toString();
        if (vehicle.equals("6")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"triparea", "tripcityfield", "checkin_out_flex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"trip_flex", "startdate", "tripmulseatgrade", "trippassenger", "happendate"});
        } else if (vehicle.equals("5") || vehicle.equals("0")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"trip_flex", "checkin_out_flex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"trippassenger", "tripmulseatgrade", "triparea", "expenseitem", "airportconstructionfee", "startdate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"triparea", "tripcityfield", "checkin_out_flex", "happendate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"trip_flex", "startdate", "tripmulseatgrade", "trippassenger"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mbaritemap"});
        BasedataEdit mulSeatGrade = (BasedataEdit)this.getView().getControl("tripmulseatgrade");
        mulSeatGrade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IFormView pView = this.getView().getParentView();
        if (pView == null) {
            return;
        }
        IDataModel pvModel = pView.getModel();
        DynamicObject expenseitem = (DynamicObject)pvModel.getValue("expenseitem");
        if (expenseitem == null) {
            return;
        }
        String attribute = expenseitem.getString("attribute");
        FormShowParameter userShow = beforeF7SelectEvent.getFormShowParameter();
        userShow.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5ea7\u4f4d\u7b49\u7ea7", (String)"ExpensePoolTripInfoBillMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        ArrayList listQF = Lists.newArrayList();
        QFilter bdFilter = new QFilter("attribute", "=", (Object)attribute);
        listQF.add(bdFilter);
        ((ListShowParameter)userShow).setListFilterParameter(new ListFilterParameter((List)listQF, (String)null));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "mbaritemap": {
                this.clickOk();
            }
        }
    }

    private void clickOk() {
        this.getView().getModel().setDataChanged(false);
        IDataModel model = this.getModel();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("tripfrom", model.getValue("tripfrom"));
        returnMap.put("tripto", model.getValue("tripto"));
        returnMap.put("startdate", model.getValue("startdate"));
        returnMap.put("trippassenger", model.getValue("trippassenger"));
        returnMap.put("tripmulseatgrade", (DynamicObjectCollection)model.getValue("tripmulseatgrade"));
        returnMap.put("tripcheckindate", model.getValue("tripcheckindate"));
        returnMap.put("tripdeparturedate", model.getValue("tripdeparturedate"));
        returnMap.put("tripcityfield", model.getValue("tripcityfield"));
        returnMap.put("triparea", model.getValue("triparea"));
        returnMap.put("happendate", model.getValue("happendate"));
        returnMap.put("airportconstructionfee", model.getValue("airportconstructionfee"));
        this.getView().returnDataToParent(returnMap);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel dataModel = this.getModel();
        switch (propName = e.getProperty().getName()) {
            case "taxamount": {
                this.whenTaxAmountChanged();
                break;
            }
            case "expenseamount": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "taxrate": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "tripcityfield": {
                DynamicObject tripCityFieId = (DynamicObject)propValue;
                if (tripCityFieId == null) break;
                Long tripCityPkId = (Long)tripCityFieId.getPkValue();
                MainEntityType tripCityType = dataModel.getDataEntityType();
                String orgPropTripCity = ((BasedataProp)tripCityType.getProperty("triparea")).getOrgProp();
                ErCommonUtils.getPk((Object)dataModel.getValue(orgPropTripCity));
                ErTripStdServiceImp erTripStdService = new ErTripStdServiceImp();
                DynamicObject tripCityArea = erTripStdService.getTripAreaByCityIdAndCompanyId(tripCityPkId, ErCommonUtils.getPk((Object)dataModel.getValue(orgPropTripCity)));
                if (tripCityArea == null) break;
                dataModel.setValue("triparea", tripCityArea.getPkValue());
                break;
            }
            case "tripfrom": {
                break;
            }
            case "triparea": {
                Object tripfrom = dataModel.getValue("triparea");
                break;
            }
        }
    }

    private void whenTaxAmountChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmountAppOri = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal taxAmount = (BigDecimal)dataModel.getValue("taxamount");
        BigDecimal noTaxAmount = expenseAmountAppOri.subtract(taxAmount);
        dataModel.beginInit();
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        dataModel.endInit();
        this.getView().updateView("orientryamount");
    }

    private void whenTaxRateOrExpenseAppAmoutChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal expenseTaxrate = (BigDecimal)dataModel.getValue("taxrate");
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)dataModel.getValue("currency");
        int precision = expenseCurrencyDO.getInt("amtprecision");
        BigDecimal airportConstructionAmount = (BigDecimal)dataModel.getValue("airportconstructionfee");
        BigDecimal taxAmount = expenseAmount.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        BigDecimal noTaxAmount = expenseAmount.subtract(taxAmount);
        dataModel.setValue("taxamount", (Object)taxAmount);
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        this.getView().updateView("taxamount");
        this.getView().updateView("orientryamount");
    }
}

