/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.common;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class BeforeProjectTypeF7FilterEdit
extends AbstractBillPlugIn {
    private static final String EXPENSEITEM_ID = "expenseitem.id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.projectTypeF7Filter();
    }

    private void projectTypeF7Filter() {
        BasedataEdit bizTypeF7 = (BasedataEdit)this.getControl("projecttype");
        if (bizTypeF7 == null) {
            return;
        }
        bizTypeF7.addBeforeF7SelectListener(event -> {
            String formId = this.getView().getEntityId();
            DynamicObject entityObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
            Object pk = null;
            pk = entityObject == null ? Long.valueOf(0L) : entityObject.getPkValue();
            ListShowParameter bizTypeF7Param = (ListShowParameter)event.getFormShowParameter();
            bizTypeF7Param.getTreeFilterParameter().getQFilters().add(new QFilter("relbill.fbasedataid_id", "=", pk));
            bizTypeF7Param.getListFilterParameter().getQFilters().add(new QFilter("relbill.fbasedataid_id", "=", pk));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "projecttype": {
                DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
                if (!props.containsKey((Object)"expenseentryentity")) break;
                int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
                for (int i = 0; i < entryRowCount; ++i) {
                    DynamicObject expenseitem = (DynamicObject)this.getModel().getValue("expenseitem", i);
                    DynamicObject projecttype = (DynamicObject)this.getModel().getValue("projecttype");
                    boolean boo = ContractUtil.checkExpenseItemByProjecttype((DynamicObject)projecttype, (DynamicObject)expenseitem);
                    if (!boo) {
                        this.getModel().setValue("expenseitem", null, i);
                    }
                    if (this.getModel().getValue("expenseitem", i) == null || boo) continue;
                    this.getModel().setValue("taxrate", (Object)0, i);
                }
                break;
            }
            case "costcompany": {
                DynamicObject number;
                DynamicObject projecttype = (DynamicObject)this.getModel().getValue("projecttype");
                DynamicObject newObj = (DynamicObject)propValue;
                if (projecttype == null || newObj == null || (number = this.checkProjectTypeByCostompny((Long)newObj.getPkValue(), projecttype.getString("number"))) != null) break;
                this.getModel().setValue("projecttype", null);
                break;
            }
        }
    }

    public DynamicObject checkProjectTypeByCostompny(Long costCompany, String projectTypeNumber) {
        QFilter rangFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_projecttype", (Long)costCompany);
        rangFilter.and(new QFilter("number", "=", (Object)projectTypeNumber));
        String formId = this.getView().getEntityId();
        DynamicObject entityObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
        rangFilter.and(new QFilter("relbill.fbasedataid_id", "=", (Object)ErCommonUtils.getPk((Object)entityObject)));
        DynamicObject projectTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"er_projecttype", (String)"id,entryentity.expenseitem,enable", (QFilter[])new QFilter[]{rangFilter});
        return projectTypeDy;
    }
}

