/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.common;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.formplugin.mobile.amount.query.AmountQueryAndReimburseForMobUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ChangedAccountByPayer
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(ChangedAccountByPayer.class);
    public static final Map<String, String> PAYERTYPE;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object billPayerType = this.getModel().getValue("billpayertype");
        if (StringUtils.equals((String)billPayerType.toString(), (String)"bos_user")) {
            IDataModel model = this.getModel();
            this.autoBringBillPayer(model);
            PublicBillUtil.refreshAccountEntry((IDataModel)model);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        IDataModel model = this.getModel();
        int rowIndex = valueSet[0].getRowIndex();
        Object detailType = model.getValue("detailtype");
        Object billPayerType = model.getValue("billpayertype");
        Boolean isFilterSup = Boolean.FALSE;
        switch (propName) {
            case "billpayerid": {
                if (model.getEntryRowCount("accountentry") <= 1) {
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && model.getEntryRowCount("accountentry") == 1) {
                        Long billpayerid = ErCommonUtils.getPk((Object)model.getValue("billpayerid"));
                        Long supplier = ErCommonUtils.getPk((Object)model.getValue("supplier", 0));
                        BigDecimal orireceiveamount = (BigDecimal)model.getValue("orireceiveamount", 0);
                        if (!("bd_supplier".equals(model.getValue("billpayertype").toString()) && "bd_supplier".equals(model.getValue("payertype", 0).toString()) && billpayerid != null && billpayerid.equals(supplier) && BigDecimal.ZERO.compareTo(orireceiveamount) != 0)) {
                            if (propValue != null) {
                                this.billPayerChange((DynamicObject)propValue);
                            } else {
                                AmountQueryAndReimburseForMobUtils.clearEntry(model, "accountentry");
                            }
                        }
                    } else if (propValue != null) {
                        this.billPayerChange((DynamicObject)propValue);
                    } else {
                        AmountQueryAndReimburseForMobUtils.clearEntry(model, "accountentry");
                    }
                }
                if (model.getEntryEntity("contractentry").size() > 0) {
                    HashSet setparts = new HashSet();
                    Long contractsid = (Long)model.getValue("contractsid", 0);
                    DynamicObject supplierOrCustomer = BusinessDataServiceHelper.loadSingle((String)"er_contractbill", (String)"contractpartyentry.contractparty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)contractsid)});
                    if (supplierOrCustomer != null) {
                        setparts.addAll(supplierOrCustomer.getDynamicObjectCollection("contractpartyentry").stream().map(v -> ((DynamicObject)v.get("contractparty")).getPkValue()).collect(Collectors.toSet()));
                        if (propValue != null && !setparts.contains(((DynamicObject)propValue).getPkValue())) {
                            model.deleteEntryData("contractentry");
                        }
                    }
                }
                if (oldValue == null || (Long)((DynamicObject)oldValue).getPkValue() == 0L) break;
                Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                isFilterSup = SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
                this.deleteExpenseLogic(detailType.toString(), isFilterSup);
                this.deleteWriteoffEntryLogic();
                break;
            }
            case "billpayertype": {
                if (model.getEntryRowCount("accountentry") <= 1) {
                    AmountQueryAndReimburseForMobUtils.clearEntry(model, "accountentry");
                }
                Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                isFilterSup = SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
                this.deleteExpenseLogic(detailType.toString(), isFilterSup);
                this.deleteWriteoffEntryLogic();
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                int precision = currency.getInt("amtprecision");
                String sign = currency.getString("sign");
                sign = sign == null ? "\u00a5" : sign;
                Label loanBalanceLabel = (Label)this.getView().getControl("lab_totalbillpayeramount");
                loanBalanceLabel.setText(sign + " " + new BigDecimal("0").setScale(precision));
                if (model.getProperty("billpayeramount") != null) {
                    model.setValue("billpayeramount", (Object)BigDecimal.ZERO);
                }
                this.getView().updateView("lab_totalbillpayeramount");
                if (!StringUtils.equals((String)billPayerType.toString(), (String)"bos_user")) break;
                this.autoBringBillPayer(model);
                break;
            }
            case "applier": {
                if (!StringUtils.equals((String)billPayerType.toString(), (String)"bos_user")) break;
                model.beginInit();
                this.autoBringBillPayer(model);
                model.endInit();
                this.getView().updateView("billpayerid");
                break;
            }
            case "accountcurrency": {
                Map exchangeRateMap = AmountChangeUtil.refreshEnrtyExchangeRate((IDataModel)model, (IFormView)this.getView(), (DynamicObject)((DynamicObject)propValue));
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                String accQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateMap.get("quoteType")), (Object)"0");
                if (model.getProperty("accquotetype") != null) {
                    model.setValue("accquotetype", (Object)accQuoteType, rowIndex);
                }
                BigDecimal accexchangerate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                model.setValue("accexchangerate", (Object)accexchangerate, rowIndex);
                break;
            }
            case "costcompany": {
                DynamicObject billpayer = (DynamicObject)this.getModel().getValue("billpayerid");
                if (billpayer == null) break;
                ChangedAccountByPayer.setTotalbillPayeramountLab(this.getModel(), this.getView(), billpayer);
                break;
            }
            case "relationcontract": {
                if (oldValue == null || propValue == null) break;
                model.deleteEntryData("expenseentryentity");
                model.deleteEntryData("accountentry");
                model.deleteEntryData("contractentry");
            }
        }
    }

    private void billPayerChange(DynamicObject propValue) {
        IDataModel model = this.getModel();
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        AmountQueryAndReimburseForMobUtils.clearEntry(model, "accountentry");
        if (this.isNeedToAddARowByPayer()) {
            return;
        }
        int rowIndex = model.createNewEntryRow("accountentry");
        DynamicObject payMode = PayeeServiceHelper.getDefaultPayMode();
        if (model.getValue("paymode", rowIndex) == null) {
            model.setValue("paymode", (Object)ErCommonUtils.getPk((Object)payMode), rowIndex);
        }
        if ((this.getView() instanceof MobileBillView || this.getView() instanceof MobileFormView) && (model.getValue("payername", rowIndex) == null || StringUtils.isBlank((String)model.getValue("payername", rowIndex).toString()))) {
            PayerTypeEnum payerTypeEnum;
            String payertype;
            String string = payertype = model.getValue("payertype", rowIndex) != null ? model.getValue("payertype", rowIndex).toString() : "";
            if (!StringUtils.isBlank((String)payertype) && (payerTypeEnum = PayerTypeEnum.getValue((String)payertype)) != null) {
                String payerName;
                DynamicObject payer = null;
                switch (payerTypeEnum) {
                    case SUPPLIER: {
                        payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)model, (String)"supplier", (int)rowIndex);
                        break;
                    }
                    case CUSTOMER: {
                        payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)model, (String)"customer", (int)rowIndex);
                        break;
                    }
                    case CASORG: {
                        payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)model, (String)"casorg", (int)rowIndex);
                    }
                }
                if (payer != null && !StringUtils.isBlank((String)(payerName = payer.getString("name")))) {
                    model.setValue("payername", (Object)StringUtils.abbreviate((String)payerName, (int)100), rowIndex);
                }
            }
        }
        DynamicObjectCollection expCollection = model.getEntryEntity("expenseentryentity");
        if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && "0".equals(isgetaccountcurrency)) {
            Set entrycurrency = expCollection.stream().map(v -> v.get("entrycurrency")).collect(Collectors.toSet());
            if (entrycurrency.size() == 1) {
                model.setValue("accountcurrency", ((DynamicObject)entrycurrency.iterator().next()).getPkValue(), 0);
            } else {
                model.setValue("accountcurrency", ((DynamicObject)model.getValue("currency")).getPkValue(), 0);
            }
            BigDecimal expenseamount = AmountChangeUtil.sumAmountBy((Collection)expCollection, (String)"expeapprovecurramount");
            model.setValue("receiveamount", (Object)expenseamount, 0);
            AmountChangeUtil.setReciveAmount((IFormView)this.getView(), (IDataModel)model, (BigDecimal)expenseamount, (String)"0");
        }
        ChangedAccountByPayer.setTotalbillPayeramountLab(model, this.getView(), propValue);
    }

    public static void setTotalbillPayeramountLab(IDataModel model, IFormView view, DynamicObject billpayer) {
        DynamicObject currency;
        String sign;
        BigDecimal totalbalanceamount = BigDecimal.ZERO;
        if (billpayer != null) {
            if (model.getValue("costcompany") == null) {
                return;
            }
            Long costcompanyid = (Long)((DynamicObject)model.getValue("costcompany")).getPkValue();
            String sql = "select  sum(t.fBalanceAmount) BalanceAmount  from t_er_prepaybill  t   where  fbillpayerid = " + (Long)billpayer.getPkValue() + " and FCostCompanyID=" + costcompanyid;
            totalbalanceamount = (BigDecimal)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    BigDecimal balanceamount = BigDecimal.ZERO;
                    while (resultSet.next()) {
                        if (resultSet.getBigDecimal("BalanceAmount") == null) continue;
                        balanceamount = balanceamount.add(resultSet.getBigDecimal("BalanceAmount"));
                    }
                    return balanceamount;
                }
            });
        }
        sign = (sign = (currency = (DynamicObject)model.getValue("currency")).getString("sign")) == null ? "\u00a5" : sign;
        totalbalanceamount = totalbalanceamount.setScale(currency.getInt("amtprecision"), 4);
        Label loanBalanceLabel = (Label)view.getControl("lab_totalbillpayeramount");
        loanBalanceLabel.setText(sign + totalbalanceamount);
        view.updateView("lab_totalbillpayeramount");
    }

    protected boolean isNeedToAddARowByPayer() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean flag = false;
        if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
            Object detailType = model.getValue("detailtype");
            String relationcontract = SystemParamterUtil.getRelationContract((Long)ErCommonUtils.getPk((Object)model.getValue("company")));
            if (StringUtils.equals((String)detailType.toString(), (String)"biztype_contract") && "0".equals(relationcontract) || StringUtils.equalsIgnoreCase((String)detailType.toString(), (String)"biztype_contractestimate")) {
                flag = true;
            }
        }
        return flag;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String entityId = view.getEntityId();
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        if ("accountentry".equalsIgnoreCase(entryName)) {
            if (this.isCopyEntryRowInvoke()) {
                return;
            }
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            DynamicObject paymode = PayeeServiceHelper.getDefaultPayMode();
            if (rowDataEntities.length > 0) {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    String detailType;
                    int rowIndex = rowDataEntity.getRowIndex();
                    DynamicObject currency = (DynamicObject)model.getValue("currency");
                    if (model.getValue("paymode", rowIndex) == null) {
                        model.setValue("paymode", paymode == null ? null : paymode.getPkValue(), rowIndex);
                    }
                    if (!StringUtils.equalsIgnoreCase((String)(detailType = model.getValue("detailtype").toString()), (String)"biztype_contract")) {
                        model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
                    }
                    model.beginInit();
                    model.setValue("payertype", (Object)PAYERTYPE.get(model.getValue("billpayertype").toString()), rowIndex);
                    model.endInit();
                    view.updateView("payertype", rowIndex);
                    if (!this.adjustToJudgle(rowIndex)) continue;
                    DynamicObject billpayer = (DynamicObject)model.getValue("billpayerid");
                    if (billpayer != null) {
                        String billpayertype;
                        switch (billpayertype = (String)model.getValue("billpayertype")) {
                            case "bd_supplier": 
                            case "bd_customer": 
                            case "bos_org": {
                                AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)((String)model.getValue("billpayertype")), (Long)((Long)billpayer.getPkValue()));
                                if (accountInfo != null) {
                                    PublicReimbursePayerAcctUtils.fillBankInfo((IDataModel)model, (AccountInfo)accountInfo, (Integer)rowIndex);
                                }
                                if (StringUtils.equalsIgnoreCase((String)"bd_supplier", (String)billpayertype)) {
                                    model.setValue("supplier", billpayer.getPkValue(), rowIndex);
                                } else if (StringUtils.equalsIgnoreCase((String)"bos_org", (String)billpayertype)) {
                                    model.setValue("casorg", billpayer.getPkValue(), rowIndex);
                                } else {
                                    model.setValue("customer", billpayer.getPkValue(), rowIndex);
                                }
                                if ("1".equals(isgetaccountcurrency) && accountInfo != null) {
                                    Long tragCurrencyId = ErCommonUtils.getPk((Object)(accountInfo.getCurrency() == null ? null : accountInfo.getCurrency()));
                                    model.setValue("accountcurrency", (Object)tragCurrencyId, rowIndex);
                                }
                                if (model.getValue("payername", rowIndex) != null && !StringUtils.isBlank((String)model.getValue("payername", rowIndex).toString()) || billpayer.getLocaleString("name").getLocaleValue() == null) break;
                                model.setValue("payername", (Object)StringUtils.abbreviate((String)billpayer.getLocaleString("name").getLocaleValue().trim(), (int)100), rowIndex);
                                break;
                            }
                            case "bos_user": {
                                List defaultAccts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)((Long)billpayer.getPkValue()), (Object)model.getDataEntity().getPkValue(), (boolean)false);
                                model.beginInit();
                                model.setValue("payer", billpayer.getPkValue(), rowIndex);
                                model.setValue("payertype", (Object)PAYERTYPE.get((String)model.getValue("billpayertype")), rowIndex);
                                model.endInit();
                                if (defaultAccts.size() > 0) {
                                    CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)rowIndex, (DynamicObject)((DynamicObject)defaultAccts.get(0)));
                                } else {
                                    model.setValue("payer", null, 0);
                                    model.setValue("payername", null, 0);
                                    model.setValue("payeraccount", null, 0);
                                    model.setValue("payeraccountname", null, 0);
                                    model.setValue("payerbank", null, 0);
                                }
                                view.updateView("detailtype", rowIndex);
                            }
                        }
                    } else {
                        model.setValue("payer", null, 0);
                        model.setValue("payername", null, 0);
                        model.setValue("payeraccount", null, 0);
                        model.setValue("payeraccountname", null, 0);
                        model.setValue("payerbank", null, 0);
                    }
                    if ((DynamicObject)model.getValue("accountcurrency", 0) == null) continue;
                    BigDecimal payAmount = BigDecimal.ZERO;
                    String loanType = "1";
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                        payAmount = (BigDecimal)model.getValue("payamount");
                        loanType = (String)model.getValue("writeofftype");
                    } else if (ErEntityTypeUtils.isDailyLoanBill((String)entityId)) {
                        payAmount = (BigDecimal)model.getValue("approveamount");
                    }
                    if (payAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    AmountChangeUtil.setReciveAmount((IFormView)view, (IDataModel)model, (BigDecimal)payAmount, (String)loanType);
                }
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "contractentry": {
                DynamicObjectCollection expentryEntity;
                DynamicObjectCollection contractEntity = dataModel.getEntryEntity("contractentry");
                if (contractEntity != null && !contractEntity.isEmpty() || (expentryEntity = dataModel.getEntryEntity("expenseentryentity")) == null || expentryEntity.size() <= 0) break;
                for (int i = 0; i < expentryEntity.size(); ++i) {
                    dataModel.setValue("entrycontractno", (Object)"", i);
                    dataModel.setValue("entrycontractname", (Object)"", i);
                }
                break;
            }
        }
    }

    private boolean isCopyEntryRowInvoke() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            String str = stackTraceElement.toString();
            if (str.contains("kd.bos.form.operate.formop.CopyEntryRow.invokeOperation")) {
                return true;
            }
            if (str.contains("kd.bos.mservice.form.FormServiceImpl.invokeMethod")) break;
        }
        return false;
    }

    private boolean adjustToJudgle(int rowIndex) {
        boolean flag = false;
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            String detailType = this.getModel().getDataEntity().getString("detailtype");
            flag = !"1".equals(this.getModel().getValue("relationcontract")) && (StringUtils.equalsIgnoreCase((String)detailType, (String)"biztype_contract") || StringUtils.equalsIgnoreCase((String)detailType, (String)"biztype_contractestimate")) ? true : rowIndex == 0;
        } else {
            flag = rowIndex == 0;
        }
        return flag;
    }

    private void autoBringBillPayer(IDataModel model) {
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        Long applierId = (Long)applier.getPkValue();
        model.setValue("billpayerid", (Object)applierId);
    }

    private void deleteExpenseLogic(String detailType, boolean isFilterSup) {
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        if (isFilterSup && !"biztype_other".equals(dataModel.getValue("detailtype"))) {
            if (StringUtils.equals((String)detailType, (String)"biztype_contract") && PublicBillUtil.deleteExpEntryBypayerChanged((IDataModel)dataModel, (IFormView)view)) {
                dataModel.deleteEntryData("expenseentryentity");
                if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
                    dataModel.deleteEntryData("invoiceentry");
                    log.info("\u5bf9\u516c\u62a5\u9500\u5355\u5207\u6362\u5f80\u6765\u5355\u4f4d\u6e05\u7a7a\u53d1\u7968\u5206\u5f55");
                }
                log.info("\u9884\u4ed8\u5355/\u5bf9\u516c\u62a5\u9500\u5355\u5207\u6362\u5f80\u6765\u5355\u4f4d\u6e05\u7a7a\u8d39\u7528\u660e\u7ec6\u5206\u5f55");
            } else if (StringUtils.equals((String)detailType, (String)"biztype_project") || StringUtils.equals((String)detailType, (String)"biztype_estimate") || StringUtils.equals((String)detailType, (String)"biztype_contractestimate")) {
                dataModel.deleteEntryData("expenseentryentity");
                log.info("\u9884\u4ed8\u5355/\u5bf9\u516c\u62a5\u9500\u5355\u5207\u6362\u5f80\u6765\u5355\u4f4d\u6e05\u7a7a\u8d39\u7528\u660e\u7ec6\u5206\u5f55");
                if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
                    dataModel.deleteEntryData("invoiceentry");
                    log.info("\u5bf9\u516c\u62a5\u9500\u5355\u5207\u6362\u5f80\u6765\u5355\u4f4d\u6e05\u7a7a\u53d1\u7968\u5206\u5f55");
                }
            }
        }
        log.info("\u9884\u4ed8\u5355/\u5bf9\u516c\u62a5\u9500\u5355\u5207\u6362\u5f80\u6765\u5355\u4f4d\u6e05\u7a7a\u5173\u8054\u5408\u540c\u5206\u5f55");
    }

    private void deleteWriteoffEntryLogic() {
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
            DynamicObjectCollection writeOffMoneyEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("writeoffmoney");
            ArrayList prepayEntryIndex = Lists.newArrayList();
            if (writeOffMoneyEntryEntity != null && writeOffMoneyEntryEntity.size() != 0) {
                for (int i = writeOffMoneyEntryEntity.getStartRowIndex(); i < writeOffMoneyEntryEntity.size(); ++i) {
                    if (!StringUtils.equalsIgnoreCase((String)"er_prepaybill", (String)((DynamicObject)writeOffMoneyEntryEntity.get(i)).getString("srcbilltype"))) continue;
                    prepayEntryIndex.add(i);
                }
                int[] removeEntryIndex = prepayEntryIndex.stream().mapToInt(Integer::intValue).toArray();
                Optional.ofNullable(removeEntryIndex).ifPresent(p -> this.getModel().deleteEntryRows("writeoffmoney", p));
            }
        }
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("bd_supplier", "bd_supplier");
        temp.put("bd_customer", "bd_customer");
        temp.put("bos_user", "er_payeer");
        temp.put("bos_org", "bos_org");
        PAYERTYPE = Collections.unmodifiableMap(temp);
    }
}

