/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.common.field.writeoffmoney.ContractProjectWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.WriteOffFields;

public class ContractExpenseEntryEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        boolean isCountByExpense = true;
        switch (propName) {
            case "contractcurrency": {
                if (newValue == null) {
                    this.getModel().beginInit();
                    this.getModel().setValue("contractcurrency", oldValue);
                    this.getModel().endInit();
                    this.getView().updateView("contractcurrency");
                    return;
                }
                DynamicObject contractCurr = (DynamicObject)valueSet[0].getNewValue();
                ContractUtil.refreshEntryValue((IDataModel)this.getModel(), (Object)contractCurr, (String)"entrycurrency");
                ContractUtil.refreshExchangeRate((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)contractCurr, (String)"changerate", (String)"quotetype");
                ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                break;
            }
            case "changerate": {
                Object changeRate = valueSet[0].getNewValue();
                ContractUtil.refreshEntryValue((IDataModel)this.getModel(), (Object)changeRate, (String)"exchangerate");
                break;
            }
            case "exchangerate": {
                ContractUtil.refreshExpCurrAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex, (Boolean)Boolean.TRUE);
                break;
            }
            case "quotetype": {
                Object quoteType = valueSet[0].getNewValue();
                ContractUtil.refreshEntryValue((IDataModel)this.getModel(), (Object)quoteType, (String)"expquotetype");
                break;
            }
            case "expenseamount": {
                if (isCountByExpense) {
                    ContractUtil.refreshHeadAmountByExpense((IDataModel)this.getModel(), (IFormView)this.getView());
                }
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                BigDecimal entryorichangeamount = (BigDecimal)this.getModel().getValue("entryorichangeamount", rowIndex);
                BigDecimal entrycontractamount = (BigDecimal)this.getModel().getValue("entrycontractamount", rowIndex);
                this.getModel().setValue("acexpeapproveamount", (Object)((BigDecimal)newValue).add(entrycontractamount).add(entryorichangeamount), rowIndex);
                ContractUtil.refreshExpTaxAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex, (Boolean)(taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0));
                ContractUtil.refreshExpCurrAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex, (Boolean)Boolean.FALSE);
                ContractUtil.refreshExpPriceWithTax((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
                break;
            }
            case "taxamount": {
                String changetype;
                ContractUtil.refreshOriEntryAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
                if (isCountByExpense) {
                    ContractUtil.refreshBillTaxAmountByExpense((IDataModel)this.getModel(), (IFormView)this.getView());
                }
                if ("B".equals(changetype = (String)this.getModel().getValue("changetype"))) {
                    this.getModel().setValue("actaxamount", (Object)((BigDecimal)newValue), rowIndex);
                    break;
                }
                BigDecimal entrycontracttax = (BigDecimal)this.getModel().getValue("orientrycontracttax", rowIndex);
                BigDecimal changetaxamount = (BigDecimal)this.getModel().getValue("changetaxamount", rowIndex);
                BigDecimal taxamount = (BigDecimal)valueSet[0].getNewValue();
                this.getModel().setValue("actaxamount", (Object)taxamount.add(changetaxamount).add(entrycontracttax), rowIndex);
                break;
            }
            case "taxrate": {
                ContractUtil.refreshExpTaxAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex, (Boolean)true);
                break;
            }
            case "num": {
                ContractUtil.refreshExpPriceWithTax((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        args.getSource();
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
        int rowIndex = rowDataEntity.getRowIndex();
        if (entryName.equals("expenseentryentity")) {
            DynamicObject headCurrency = (DynamicObject)this.getModel().getValue("contractcurrency");
            ContractUtil.refreshEntryValue((IDataModel)this.getModel(), (Object)headCurrency, (String)"entrycurrency");
            Object headChangRate = this.getModel().getValue("changerate");
            Object headQuote = this.getModel().getValue("quotetype");
            this.getModel().setValue("exchangerate", headChangRate, rowIndex);
            this.getModel().setValue("expquotetype", headQuote, rowIndex);
        }
    }
}

