/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;

public class ContractPartEntryAddMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ContractPartEntryAddMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "addcontractpart"});
        ContractUtil.setContractPartF7Filter((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        IDataModel parentModel = formView.getParentView().getModel();
        Object billStatus = parentModel.getValue("billstatus");
        dataModel.setValue("billstatus", billStatus);
        dataModel.setValue("costcompany", parentModel.getValue("costcompany"));
        dataModel.setValue("company", parentModel.getValue("company"));
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        int index = (Integer)formShowParameter.getCustomParam("index");
        if (index != -1) {
            DynamicObjectCollection expenseColl = parentModel.getEntryEntity("contractpartyentry");
            dataModel.beginInit();
            int newRowIndex = MobileEntryUtil.addEntryToModel(dataModel, "contractpartyentry", (DynamicObject)expenseColl.get(index), true);
            dataModel.endInit();
            formView.updateView("contractpartyentry", newRowIndex);
        } else {
            int size = dataModel.getEntryRowCount("contractpartyentry");
            if (size == 2) {
                dataModel.deleteEntryRow("contractpartyentry", 1);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView formView = this.getView();
        IDataModel parentModel = formView.getParentView().getModel();
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        ShowPageUtils.setMobilePageFormStatus((IFormView)formView);
        ContractUtil.setSecondFiledLockAndVisible((String)((String)parentModel.getValue("detailtype")), (String)((String)parentModel.getValue("changetype")), (IDataModel)this.getModel(), (IFormView)formView, (String)"contractpartyentry");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_save": {
                ContractUtil.saveContractPartOrItemByHand((IDataModel)dataModel, (IFormView)formView, (String)"contractpartyentry");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object newValue = valueSet[0].getNewValue();
        IDataModel model = this.getModel();
        switch (propName) {
            case "contractparty": {
                ContractUtil.setTel((IDataModel)this.getModel(), (int)rowIndex);
                break;
            }
            case "partytype": {
                ContractUtil.setTel((IDataModel)this.getModel(), (int)rowIndex);
                break;
            }
            case "signcontract": {
                if ("0".equals((String)newValue)) {
                    model.setValue("partytype", (Object)"bos_org", rowIndex);
                    break;
                }
                if (!"1".equals((String)newValue)) break;
                model.setValue("partytype", (Object)"bd_supplier", rowIndex);
            }
        }
    }
}

