/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.prepay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Draw;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.field.writeoffmoney.PrePayContractWriteOffFields;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.mobile.amount.query.AmountQueryAndReimburseForMobUtils;
import kd.fi.er.formplugin.publicbiz.bill.common.ChangedAccountByPayer;
import org.apache.commons.lang3.StringUtils;

public class PrePayBillEdit
extends AbstractBillPlugIn
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(PrePayBillEdit.class);
    private static final Map<String, String> PAY_TYPE_MAP;
    private static Log logger;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realCardF7 = (BasedataEdit)this.getControl("payer");
        realCardF7.setQFilters(new ArrayList());
        realCardF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                int i = 0;
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("currency", "!=", (Object)i));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshRepaymentDate();
    }

    private void refreshRepaymentDate() {
        if (this.getModel().getProperty("repaymentdate") != null) {
            this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.refreshRepaymentDate();
        this.getPageCache().put("iscopy", "true");
        this.getModel().deleteEntryData("contractentry");
        logger.info("\u590d\u5236\u7684\u6570\u636e\u4e0d\u5e94\u8be5\u5305\u542b\u5173\u8054\u5408\u540c\u5206\u5f55");
    }

    public void afterBindData(EventObject e) {
        String writeOffType;
        DynamicObject billpayer;
        boolean isCopy = this.getPageCache().get("iscopy") != null;
        IDataModel dataModel = this.getModel();
        String relationcontract = "0";
        if (dataModel.getValue("company") != null && dataModel.getProperty("relationcontract") != null) {
            relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            dataModel.setValue("relationcontract", (Object)relationcontract);
        }
        if (dataModel.getDataEntity().getDataEntityState().isPushChanged() && !isCopy) {
            DynamicObject billPayer;
            String detailType = dataModel.getValue("detailtype").toString();
            if (WriteOffMoneyUtils.isContract((IDataModel)this.getModel()) && StringUtils.equalsIgnoreCase((CharSequence)detailType, (CharSequence)"biztype_contract")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"detailtype"});
                DynamicObjectCollection expsCol = dataModel.getEntryEntity("expenseentryentity");
                for (int i = 0; i < expsCol.size(); ++i) {
                    DynamicObject entry = (DynamicObject)expsCol.get(i);
                    BigDecimal expenseamount = entry.getBigDecimal("expenseamount");
                    DynamicObject entrycurrency = entry.getDynamicObject("entrycurrency");
                    dataModel.beginInit();
                    dataModel.setValue("expenseamount", null, i);
                    dataModel.setValue("entrycurrency", null, i);
                    dataModel.endInit();
                    dataModel.setValue("expenseamount", (Object)expenseamount, i);
                    dataModel.setValue("entrycurrency", (Object)entrycurrency, i);
                    if (!"0".equals(relationcontract)) continue;
                    dataModel.setValue("entrycostdept", dataModel.getValue("costdept"), i);
                    dataModel.setValue("entrycostcompany", dataModel.getValue("costcompany"), i);
                }
            } else if ("biztype_project".equals(detailType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"iscurrency"});
            }
            if ((billPayer = (DynamicObject)dataModel.getValue("billpayerid")) != null) {
                this.setAccountEntry(billPayer);
            }
            PublicBillUtil.setExpContactInfo((IDataModel)dataModel, (IFormView)this.getView());
        }
        if (dataModel.getDataEntityType().getProperties().containsKey((Object)"billpayerid") && (billpayer = (DynamicObject)dataModel.getValue("billpayerid")) != null) {
            ChangedAccountByPayer.setTotalbillPayeramountLab(dataModel, this.getView(), billpayer);
        }
        ContractUtil.changeBillHeadContractsconn((IDataModel)dataModel, null);
        if (isCopy) {
            this.getPageCache().remove("iscopy");
        }
        if ("1".equals(writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)dataModel.getValue("company")), (String)"er010"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"contractwriteoff"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"contractcanloanamount"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contractwriteoff"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contractcanloanamount"});
        }
        this.viewControlByAppId(this.getView());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                boolean ispush = (Boolean)dataModel.getValue("ispush");
                String relationcontract = (String)dataModel.getValue("relationcontract");
                if ("1".equals(relationcontract) && !ispush && dataModel.getEntryEntity("contractentry").size() > 0) {
                    RowDataEntity[] rowDataEntities = e.getRowDataEntities();
                    String contractcode = (String)dataModel.getValue("contractcode", 0);
                    String contractname = (String)dataModel.getValue("contractname", 0);
                    if (rowDataEntities.length > 0) {
                        for (RowDataEntity rowDataEntity : rowDataEntities) {
                            int rowIndex = rowDataEntity.getRowIndex();
                            dataModel.setValue("entrycontractno", (Object)contractcode, rowIndex);
                            dataModel.setValue("entrycontractname", (Object)contractname, rowIndex);
                        }
                    }
                }
                ContractUtil.changeBillHeadContractsconn((IDataModel)dataModel, (String)entryName);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                ContractUtil.changeBillHeadContractsconn((IDataModel)dataModel, (String)entryName);
                PublicBillUtil.calPreContractMoney((IDataModel)dataModel, (PrePayContractWriteOffFields)PrePayContractWriteOffFields.getInstance());
                break;
            }
            case "contractentry": {
                DynamicObjectCollection expentryEntity;
                DynamicObjectCollection contractEntity = dataModel.getEntryEntity("contractentry");
                if ((contractEntity == null || contractEntity.isEmpty()) && (expentryEntity = dataModel.getEntryEntity("expenseentryentity")) != null && expentryEntity.size() > 0) {
                    for (int i = 0; i < expentryEntity.size(); ++i) {
                        dataModel.setValue("entrycontractno", (Object)"", i);
                        dataModel.setValue("entrycontractname", (Object)"", i);
                    }
                }
                PublicBillUtil.calPreContractMoney((IDataModel)dataModel, (PrePayContractWriteOffFields)PrePayContractWriteOffFields.getInstance());
            }
        }
    }

    private void setAccountEntry(DynamicObject billPayer) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("accountentry");
        if (rowCount <= 0) {
            return;
        }
        int rowIndex = 0;
        String billpayertype = (String)model.getValue("billpayertype");
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        String payFiledName = PAY_TYPE_MAP.get(billpayertype);
        billpayertype = StringUtils.equals((CharSequence)billpayertype, (CharSequence)"bos_user") ? "er_payeer" : billpayertype;
        AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)billpayertype, (Long)((Long)billPayer.getPkValue()));
        String payerType = (String)model.getValue("payertype", rowIndex);
        if (StringUtils.equals((CharSequence)payerType, (CharSequence)billpayertype)) {
            if (accountInfo != null) {
                PublicReimbursePayerAcctUtils.fillBankInfo((IDataModel)model, (AccountInfo)accountInfo, (Integer)rowIndex);
            }
            model.setValue(payFiledName, billPayer.getPkValue(), rowIndex);
            if ("1".equals(isgetaccountcurrency) && accountInfo != null) {
                Long tragCurrencyId = ErCommonUtils.getPk((Object)(accountInfo.getCurrency() == null ? null : accountInfo.getCurrency()));
                model.setValue("accountcurrency", (Object)tragCurrencyId, rowIndex);
            }
            if (billPayer.getLocaleString("name").getLocaleValue() != null) {
                model.setValue("payername", (Object)billPayer.getLocaleString("name").getLocaleValue().trim(), rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getView().getModel();
        switch (propName) {
            case "detailtype": {
                AmountQueryAndReimburseForMobUtils.clearEntry(model, "expenseentryentity");
                model.deleteEntryData("contractentry");
                if ("biztype_project".equals(propNewValue) || "biztype_contract".equals(propNewValue)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"iscurrency"});
                    model.setValue("iscurrency", (Object)Boolean.TRUE);
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"iscurrency"});
                model.setValue("iscurrency", (Object)Boolean.FALSE);
                break;
            }
            case "loanamount": {
                if (model.getEntryEntity("accountentry").size() != 0) break;
                model.createNewEntryRow("accountentry");
                break;
            }
            case "entrycontractno": {
                String contractno = model.getEntryEntity("expenseentryentity").stream().map(it -> it.getString("entrycontractno")).distinct().collect(Collectors.joining(","));
                DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
                IDataEntityProperty contractsconn = (IDataEntityProperty)properties.get((Object)"contractsconn");
                if (contractsconn == null) break;
                model.setValue("contractsconn", (Object)contractno);
                break;
            }
            case "frameworkcontract": {
                model.deleteEntryData("contractentry");
                DynamicObjectCollection expentryEntity = model.getEntryEntity("expenseentryentity");
                if (expentryEntity.size() <= 0) break;
                for (int i = 0; i < expentryEntity.size(); ++i) {
                    model.setValue("entrycontractno", (Object)"", i);
                    model.setValue("entrycontractname", (Object)"", i);
                }
                break;
            }
            case "expeapproveamount": 
            case "expeapprovecurramount": {
                PublicBillUtil.calPreContractMoney((IDataModel)model, (PrePayContractWriteOffFields)PrePayContractWriteOffFields.getInstance());
                break;
            }
            case "contractwriteoff": {
                PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)model, (BigDecimal)((BigDecimal)propNewValue), (int)rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if (this.isFilterSup() && args.getSource() instanceof Draw && ("draw_project".equalsIgnoreCase(((Draw)args.getSource()).getOperateKey()) || "draw_contract".equalsIgnoreCase(((Draw)args.getSource()).getOperateKey())) && model.getValue("billpayerid") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PrePayBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        switch (operateKey) {
            case "drawunframcontract": 
            case "drawframcontract": {
                if (model.getValue("billpayerid") != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PrePayBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
    }

    private boolean isFilterSup() {
        Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        return SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
    }

    protected void viewControlByAppId(IFormView view) {
        String appId = view.getFormShowParameter().getAppId();
        if (!(view instanceof MobileBillView) && !(view instanceof MobileFormView)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)"exp")) {
                view.setVisible(Boolean.FALSE, new String[]{"detailtype"});
                view.setVisible(Boolean.FALSE, new String[]{"frameworkcontract"});
                view.setVisible(Boolean.FALSE, new String[]{"advconap_contract"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"detailtype"});
                view.setVisible(Boolean.TRUE, new String[]{"frameworkcontract"});
                view.setVisible(Boolean.TRUE, new String[]{"advconap_contract"});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
        }
        if ("1".equals(isgetaccountcurrency)) {
            this.getModel().setValue("iscurrency", (Object)Boolean.TRUE);
        }
    }

    static {
        Map<String, String> temp = Arrays.stream(new String[][]{{"bd_supplier", "supplier"}, {"bd_customer", "customer"}, {"bos_user", "payer"}}).collect(Collectors.toMap(item -> item[0], item -> item[1], (v1, v2) -> v1));
        PAY_TYPE_MAP = Collections.unmodifiableMap(temp);
        logger = LogFactory.getLog(PrePayBillEdit.class);
    }
}

