/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.prepay;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.field.writeoffmoney.PublicContractWriteOffFields;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.common.ExpenseEntryMobPlugin;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.reimburse.ErReimburseBaseBillEdit;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;
import org.apache.commons.lang3.StringUtils;

public class PublicReimburseBillMobFormPlugin
extends AbstractMobBillPlugIn
implements ClickListener {
    private static final String projectFromId = "er_pub_drawproject_mb";
    private static final String contractFromId = "er_draw_contractitem_mb";
    private static final String pubreimcontractFromId = "er_pub_drawcontract_mb";
    private static final String pubpreypayFromId = "er_draw_prepay_mb";
    private static final Log log = LogFactory.getLog(PublicReimburseBillMobFormPlugin.class);
    private static final String PAGE_CACHE_NOT_FIRST_LOAD = "pageCacheNotFirstLoad";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate instanceof Save || operate instanceof Submit) {
            ErReimburseBaseBillEdit.refreshBillHeadAmount(this.getModel());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        this.resetDetailTypeComboItems();
        this.changeVisibleByDetailType();
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            if (dataModel.getDataEntity().getDataEntityState().isPushChanged()) {
                ExpenseEntryMobPlugin.refreshAmount(this.getModel(), this.getView());
            }
            if (this.getView() instanceof MobileBillView) {
                ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
            }
        }
        CommonViewControlUtil.contractPageRule(dataModel, formView, Boolean.FALSE);
    }

    private void resetDetailTypeComboItems() {
        ComboProp comboEditProp;
        IFormView thisview = this.getView();
        ComboEdit comboEdit = (ComboEdit)thisview.getControl("detailtype");
        if (comboEdit != null && (comboEditProp = (ComboProp)comboEdit.getProperty()) != null) {
            ArrayList items = Lists.newArrayList();
            List valueMapItems = comboEditProp.getComboItems();
            if (valueMapItems != null && valueMapItems.size() > 0) {
                for (ValueMapItem item : valueMapItems) {
                    if ("biztype_estimate".equals(item.getValue()) || "biztype_contractestimate".equals(item.getValue()) || !item.isItemVisible()) continue;
                    ComboItem comboItem = new ComboItem();
                    comboItem.setValue(item.getValue());
                    comboItem.setCaption(item.getName());
                    items.add(comboItem);
                }
            }
            comboEdit.setComboItems((List)items);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        if ("detailtype".equalsIgnoreCase(propName)) {
            this.changeVisibleByDetailType();
            String relationcontract = SystemParamterUtil.getRelationContract((Long)ErCommonUtils.getPk((Object)dataModel.getValue("company")));
            if (!("1".equals(relationcontract) && oldValue != null && propValue != null && (StringUtils.equals((CharSequence)oldValue.toString(), (CharSequence)"biztype_contract") && StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)"biztype_other") || StringUtils.equals((CharSequence)oldValue.toString(), (CharSequence)"biztype_other") && StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)"biztype_contract")))) {
                dataModel.deleteEntryData("expenseentryentity");
                dataModel.deleteEntryData("invoiceentry");
                dataModel.deleteEntryData("invoiceitementry");
                dataModel.deleteEntryData("invoiceandexpense");
                dataModel.deleteEntryData("accountentry");
                log.info("\u5207\u6362\u5173\u8054\u4e1a\u52a1\u6e05\u7a7a\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u3001\u53d1\u7968\u5206\u5f55\u3001\u5173\u8054\u5408\u540c\u5206\u5f55\u3001\u6536\u6b3e\u5206\u5f55");
            }
            CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            CommonViewControlUtil.setAmountToLabel(this.getModel(), this.getView(), "accountentry", "receiveamount", "label_account_amount", currency);
        } else if ("applier".equalsIgnoreCase(propName)) {
            this.handleApplierChanged();
        } else if ("frameworkcontract".equalsIgnoreCase(propName)) {
            if (((Boolean)propValue).booleanValue()) {
                view.setVisible(Boolean.TRUE, new String[]{"btn_concontract_add"});
                view.setVisible(Boolean.FALSE, new String[]{"btn_reimcontract_add"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"btn_reimcontract_add"});
                view.setVisible(Boolean.FALSE, new String[]{"btn_concontract_add"});
            }
        } else if ("relationcontract".equalsIgnoreCase(propName)) {
            this.changeVisibleByDetailType();
            CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            CommonViewControlUtil.setAmountToLabel(this.getModel(), this.getView(), "accountentry", "receiveamount", "label_account_amount", currency);
        }
    }

    private void handleApplierChanged() {
        this.getModel().setValue("detailtype", (Object)"biztype_other");
    }

    private void changeVisibleByDetailType() {
        IDataModel model = this.getModel();
        String relationcontract = "0";
        String ispush = (String)model.getValue("ispush");
        Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
        if (model.getValue("company") != null) {
            relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        Object newValue = model.getValue("detailtype");
        IFormView view = this.getView();
        if ("biztype_other".equals(newValue)) {
            view.setVisible(Boolean.FALSE, new String[]{"btn_project_add", "btn_contract_add"});
            view.setVisible(Boolean.TRUE, new String[]{"addexpensebuttonflex", "btn_expense_add"});
            if ("1".equals(relationcontract)) {
                if (!frameworkcontract.booleanValue()) {
                    view.setVisible(Boolean.FALSE, new String[]{"btn_concontract_add"});
                    view.setVisible(Boolean.TRUE, new String[]{"btn_reimcontract_add"});
                } else {
                    view.setVisible(Boolean.TRUE, new String[]{"btn_concontract_add"});
                    view.setVisible(Boolean.FALSE, new String[]{"btn_reimcontract_add"});
                }
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"btn_concontract_add", "btn_reimcontract_add"});
            }
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        } else {
            boolean project = "biztype_project".equals(newValue);
            if ("1".equals(relationcontract)) {
                if (project) {
                    view.setVisible(Boolean.FALSE, new String[]{"addexpensebuttonflex", "btn_expense_add"});
                } else {
                    view.setVisible(Boolean.TRUE, new String[]{"addexpensebuttonflex", "btn_expense_add"});
                }
                if (!frameworkcontract.booleanValue()) {
                    view.setVisible(Boolean.FALSE, new String[]{"btn_concontract_add"});
                    view.setVisible(Boolean.TRUE, new String[]{"btn_reimcontract_add"});
                } else {
                    view.setVisible(Boolean.TRUE, new String[]{"btn_concontract_add"});
                    view.setVisible(Boolean.FALSE, new String[]{"btn_reimcontract_add"});
                }
                view.setVisible(Boolean.FALSE, new String[]{"btn_contract_add"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"addexpensebuttonflex", "btn_expense_add"});
                view.setVisible(Boolean.valueOf(!project), new String[]{"btn_contract_add"});
                view.setVisible(Boolean.FALSE, new String[]{"btn_concontract_add", "btn_reimcontract_add"});
            }
            view.setVisible(Boolean.valueOf(project), new String[]{"btn_project_add"});
            view.setVisible(Boolean.valueOf(!project), new String[]{"flexpanelap2"});
        }
        if ("true".equals(ispush)) {
            view.setVisible(Boolean.FALSE, new String[]{"btn_concontract_add", "btn_reimcontract_add"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_project_add", "btn_contract_add", "btn_concontract_add", "btn_reimcontract_add", "label_conract_delete", "label_contract_done", "lab_draw_prepay"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        if ("btn_project_add".equals(key)) {
            this.addProject(evt);
        } else if ("btn_contract_add".equals(key)) {
            this.addContract(evt);
        } else if ("btn_concontract_add".equals(key) || "btn_reimcontract_add".equals(key)) {
            this.addReimContract(evt);
        } else if ("label_conract_delete".equals(key)) {
            CommonViewControlUtil.contractPageRule(dataModel, formView, Boolean.TRUE);
        } else if ("label_contract_done".equals(key)) {
            CommonViewControlUtil.contractPageRule(dataModel, formView, Boolean.FALSE);
        } else if ("lab_draw_prepay".equals(key)) {
            String detailtype = (String)dataModel.getValue("detailtype");
            if (this.isFilterSup() && dataModel.getValue("billpayerid") == null) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PublicReimburseBotpUpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("biztype_project".equals(detailtype) && "2".equals(ErStdConfig.getApplyprojectbillRelated()) && !PublicBillUtil.checkProjectNo((IFormView)formView)) {
                return;
            }
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(pubpreypayFromId);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
            formView.showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        String name = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (name) {
            case "contractentry": {
                int contractEntrySize = model.getEntryRowCount("contractentry");
                if (contractEntrySize != 0) break;
                CommonViewControlUtil.contractPageRule(model, view, Boolean.FALSE);
                break;
            }
            case "writeoffmoney": {
                CommonUtilHelper.setWriteOffAmountLable(model, view, new boolean[0]);
                break;
            }
        }
    }

    private void addContract(EventObject evt) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        DynamicObjectCollection expCollection = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        Long[] entrySourceIds = null;
        if (expCollection != null) {
            entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong("wbsrcentryid")).distinct().toArray(Long[]::new);
        }
        DynamicObject applier = (DynamicObject)model.getValue("billpayerid");
        if (this.isFilterSup() && applier == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PublicReimburseBillMobFormPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setFormId(contractFromId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId("1GARA29DA8+R");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_contract_bill"));
        customParam.put("entrySourceIds", Arrays.stream(entrySourceIds).toArray());
        customParam.put("sourceFormid", "contractBill");
        customParam.put("costCompany", ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany")));
        customParam.put("company", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        if (applier != null) {
            customParam.put("applierid", applier.get("number"));
        }
        QFilter botpFilter = new QFilter("reimbursableamt", ">", (Object)0);
        botpFilter = botpFilter.and("contract.contractstatus.number", "in", (Object)"04");
        customParam.put("customFilterStr", botpFilter.toSerializedString());
        showParameter.setCustomParams(customParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addProject(EventObject evt) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        DynamicObjectCollection expCollection = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        Long[] entrySourceIds = null;
        if (expCollection != null) {
            entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong("wbsrcentryid")).distinct().toArray(Long[]::new);
        }
        if (this.isFilterSup() && this.getModel().getValue("billpayerid") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PublicReimburseBillMobFormPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            if (evt instanceof BeforeClickEvent) {
                ((BeforeClickEvent)evt).setCancel(true);
            }
            return;
        }
        showParameter.setFormId(projectFromId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_project_bill"));
        showParameter.setAppId("1GARA29DA8+R");
        customParam.put("entrySourceIds", Arrays.stream(entrySourceIds).toArray());
        customParam.put("sourceFormid", "projectBill");
        customParam.put("costCompany", ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany")));
        customParam.put("company", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        customParam.put("applierId", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
        customParam.put("formId", this.getView().getEntityId());
        customParam.put("billpayerid", ErCommonUtils.getPk((Object)this.getModel().getValue("billpayerid")));
        customParam.put("billpayertype", this.getModel().getValue("billpayertype"));
        QFilter ruleFilter = new QFilter("billstatus", "=", (Object)"E");
        ruleFilter = ruleFilter.and("currency", "=", (Object)ErCommonUtils.getPk((Object)model.getValue("currency")));
        customParam.put("customFilterStr", ruleFilter.toSerializedString());
        showParameter.setCustomParams(customParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addReimContract(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        DynamicObjectCollection contractCollection = model.getEntryEntity("contractentry");
        Long[] sourceIds = null;
        Long[] entrySourceIds = null;
        DynamicObject billpayer = (DynamicObject)model.getValue("billpayerid");
        if (billpayer == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PrePayMobEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setFormId(pubreimcontractFromId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId("1GARA29DA8+R");
        if ("btn_concontract_add".equals(key)) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_concontract_bill"));
            customParam.put("frameworkcontract", Boolean.TRUE);
        } else {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_reimcontract_bill"));
            customParam.put("frameworkcontract", Boolean.FALSE);
        }
        if (contractCollection != null) {
            entrySourceIds = (Long[])contractCollection.stream().map(row -> row.getLong("contractsrcentryid")).distinct().toArray(Long[]::new);
            sourceIds = (Long[])contractCollection.stream().map(row -> row.getLong("contractsid")).distinct().toArray(Long[]::new);
        }
        customParam.put("entrySourceIds", Arrays.stream(entrySourceIds).toArray());
        customParam.put("sourceIds", Arrays.stream(sourceIds).toArray());
        customParam.put("sourceFormid", "pubreimcontractBill");
        customParam.put("costCompany", ErCommonUtils.getPk((Object)model.getValue("costcompany")));
        customParam.put("company", ErCommonUtils.getPk((Object)model.getValue("company")));
        customParam.put("applier", ErCommonUtils.getPk((Object)model.getValue("applier")));
        customParam.put("billpayer", ErCommonUtils.getPk((Object)billpayer));
        showParameter.setCustomParams(customParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean isFilterSup() {
        Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        return SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        IDataModel model = this.getModel();
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_project_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            String botpId = "1118651014484977664";
            this.callRleAfterClosedCallBack(model, selectBill, "er_applyprojectbill", botpId, "select_project_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_contract_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            String botpId = "1169498026969047040";
            this.callRleAfterClosedCallBack(model, selectBill, "pmbs_contractpayitem", botpId, "select_contract_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_concontract_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            String botpId = "1584977819061053440";
            this.callRleAfterClosedCallBack(model, selectBill, "er_contractbill", botpId, "select_concontract_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_reimcontract_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            String botpId = "1576896511969905664";
            this.callRleAfterClosedCallBack(model, selectBill, "er_contractbill", botpId, "select_reimcontract_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)pubpreypayFromId)) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            String botpId = "1132478843148526592";
            this.callRleAfterClosedCallBack(model, selectBill, "er_prepaybill", botpId, pubpreypayFromId);
        }
    }

    private void callRleAfterClosedCallBack(IDataModel model, ListSelectedRowCollection selectBill, String entityNumber, String RuleId, String actionId) {
        if (selectBill == null || selectBill.isEmpty()) {
            return;
        }
        DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)entityNumber, (String)model.getDataEntityType().getName(), (IFormView)this.getView(), (ListSelectedRowCollection)selectBill, (String)RuleId);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)4);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (result.isSuccess()) {
            BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, (List)resultList, (BillEntityType)((BillEntityType)model.getDataEntityType()));
        }
        for (DynamicObject bill : resultList) {
            if (actionId.equals("select_contract_bill")) {
                bill.getDynamicObjectCollection("expenseentryentity").stream().forEach(dynamicobject -> {
                    BigDecimal exchangerate = (BigDecimal)dynamicobject.get("exchangerate");
                    if (exchangerate.compareTo(BigDecimal.ZERO) == 0) {
                        dynamicobject.set("exchangerate", (Object)new BigDecimal("1"));
                    }
                    int amtprecision = ((DynamicObject)dynamicobject.get("entrycurrency")).getInt("amtprecision");
                    BigDecimal expenseamount = ((BigDecimal)dynamicobject.get("expenseamount")).multiply((BigDecimal)dynamicobject.get("exchangerate")).setScale(amtprecision, 4);
                    dynamicobject.set("currexpenseamount", (Object)expenseamount);
                    dynamicobject.set("expeapprovecurramount", (Object)expenseamount);
                });
            }
            ((IBillModel)model).push((Object)bill);
        }
        this.getView().updateView();
        DynamicObjectCollection accountEntries = model.getEntryEntity("accountentry");
        if (!accountEntries.isEmpty()) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            Object woType = null;
            if (company != null) {
                woType = ErCommonUtils.getLoanCheckType((long)Long.parseLong(company.getPkValue().toString()));
            }
            if (woType == null || woType.toString().isEmpty()) {
                woType = WriteOffTypeEnum.CURR_WO.getValue();
            }
            WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)model, (String)woType.toString(), (IFormView)this.getView());
        }
        if ("select_concontract_bill".equals(actionId) || "select_reimcontract_bill".equals(actionId) || "select_project_bill".equals(actionId)) {
            PublicBillUtil.setExpContactInfo((IDataModel)model, (IFormView)this.getView());
            PublicBillUtil.writeOffContract((IDataModel)model, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
            String writeOffType = (String)model.getValue("writeofftype");
            if ("1".equals(writeOffType) && model.getEntryRowCount("contractentry") > 0) {
                DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
                for (int i = 0; i < contracts.size(); ++i) {
                    PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)model, (BigDecimal)((DynamicObject)contracts.get(i)).getBigDecimal("contractwriteoff"), (int)i);
                }
            }
            PublicBillUtil.updateContractWriteoffView((IDataModel)model, (IFormView)this.getView());
        }
        if (pubpreypayFromId.equals(actionId)) {
            PublicBillUtil.refreshWriteOffInfo((IDataModel)model);
            ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(model, this.getView(), false);
            this.getView().updateView("writeoffmoney");
        }
    }
}

