/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.project;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ProjectBillEdit
extends AbstractBillPlugIn {
    private static String BAR_TRACKDOWN = "bar_trackdown";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String opType = "";
        IFormView parentview = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentview != null && parentview.getPageCache() != null) {
            opType = parentview.getPageCache().get("changeoOpType");
        }
        if (StringUtils.isBlank((CharSequence)opType)) {
            opType = "pushchange";
        }
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        Boolean isPush = model.getDataEntity().getDataEntityState().isPushChanged();
        String detailType = (String)model.getValue("detailtype");
        if (isPush.booleanValue() && detailType.equalsIgnoreCase("biztype_changebill")) {
            switch (opType) {
                case "pushchange": {
                    model.setValue("changetype", (Object)"A");
                    break;
                }
                case "turnup": {
                    model.setValue("changetype", (Object)"B");
                    break;
                }
                case "turndown": {
                    model.setValue("changetype", (Object)"C");
                    break;
                }
            }
        }
        if (!dataChanged) {
            model.setDataChanged(dataChanged);
        }
        IFormView view = this.getView();
        String billstatus = (String)model.getValue("billstatus");
        if (Objects.equal((Object)"C", (Object)billstatus)) {
            view.setVisible(Boolean.FALSE, new String[]{BAR_TRACKDOWN});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        String detailType = (String)this.getModel().getValue("detailtype");
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("expenseentryentity");
        switch (key) {
            case "deleteentry": {
                if (!detailType.equalsIgnoreCase("biztype_changebill")) break;
                long relationcount = this.getModel().getEntryEntity("expenseentryentity").stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("wbsrcbillno"))).map(o -> o.getString("wbsrcbillno")).count();
                String itemfrom = (String)this.getModel().getValue("itemfrom", currRowIndex);
                if (!StringUtils.equals((CharSequence)itemfrom, (CharSequence)ItemFrom.Relation.getValue())) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u53d8\u66f4\u5355\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ProjectBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "copyentryrow": 
            case "newentry": {
                long relationsize;
                if (!detailType.equalsIgnoreCase("biztype_changebill") || (relationsize = this.getModel().getEntryEntity("expenseentryentity").stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("wbsrcbillno"))).map(o -> o.getString("wbsrcbillno")).distinct().count()) <= 1L) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u5bf9\u4e00\u4e0b\u63a8\u751f\u6210\u7684\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u590d\u5236\u6216\u589e\u884c\u3002", (String)"ProjectBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        String detailType = (String)this.getModel().getValue("detailtype");
        switch (operateKey) {
            case "copyentryrow": {
                if (!detailType.equalsIgnoreCase("biztype_changebill")) break;
                int count = this.getModel().getEntryRowCount("expenseentryentity");
                int copyIndex = count - 1;
                int currIndex = this.getModel().getEntryCurrentRowIndex("expenseentryentity");
                if (copyIndex == 0) {
                    return;
                }
                this.getModel().setValue("entrycostcompany", this.getModel().getValue("entrycostcompany", currIndex), copyIndex);
                this.getModel().setValue("entrycostdept", this.getModel().getValue("entrycostdept", currIndex), copyIndex);
                this.getModel().setValue("entrycurrency", this.getModel().getValue("entrycurrency", currIndex), copyIndex);
                this.getModel().setValue("exchangerate", this.getModel().getValue("exchangerate", currIndex), copyIndex);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        String detailType = (String)model.getValue("detailtype");
        switch (propName) {
            case "taxamount": {
                if (!detailType.equalsIgnoreCase("biztype_changebill") || !ErEntityTypeUtils.isApplyProjectBill((String)this.getView().getEntityId())) break;
                BigDecimal taxamount = (BigDecimal)propValue;
                BigDecimal changetaxamount = (BigDecimal)model.getValue("changetaxamount", rowIndex);
                BigDecimal expapplyprojetaxamount = (BigDecimal)model.getValue("oriexpapplyprotaxamount", rowIndex);
                BigDecimal actaxamount = taxamount.add(changetaxamount).add(expapplyprojetaxamount);
                model.setValue("actaxamount", (Object)actaxamount, rowIndex);
                break;
            }
            case "orientryamount": {
                if (!detailType.equalsIgnoreCase("biztype_changebill") || !ErEntityTypeUtils.isApplyProjectBill((String)this.getView().getEntityId())) break;
                BigDecimal orientryamount = (BigDecimal)propValue;
                BigDecimal expapplyprojetaxamount = (BigDecimal)model.getValue("oriexpapplyprotaxamount", rowIndex);
                BigDecimal entryapplyprojectamount = (BigDecimal)model.getValue("entryapplyprojectamount", rowIndex);
                BigDecimal changeorientryamount = (BigDecimal)model.getValue("changeorientryamount", rowIndex);
                model.setValue("acorientryamount", (Object)orientryamount.add(entryapplyprojectamount).add(changeorientryamount).subtract(expapplyprojetaxamount), rowIndex);
                break;
            }
            case "expeapproveamount": {
                if (!detailType.equalsIgnoreCase("biztype_changebill") || !ErEntityTypeUtils.isApplyProjectBill((String)this.getView().getEntityId())) break;
                BigDecimal expeapproveamount = (BigDecimal)propValue;
                BigDecimal changeorientryamount = (BigDecimal)model.getValue("entryapplyprojectamount", rowIndex);
                BigDecimal entryorichangeamount = (BigDecimal)model.getValue("entryorichangeamount", rowIndex);
                BigDecimal acexpeapproveamount = expeapproveamount.add(changeorientryamount).add(entryorichangeamount);
                model.setValue("acexpeapproveamount", (Object)acexpeapproveamount, rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)acexpeapproveamount, (String)"acexpeapprovecurramount", (String)"exchangerate", (String)"entrycurrency", (String)"expquotetype", (int)rowIndex);
                break;
            }
            case "price": {
                if (!detailType.equalsIgnoreCase("biztype_changebill") || !ErEntityTypeUtils.isApplyProjectBill((String)this.getView().getEntityId())) break;
                BigDecimal price = (BigDecimal)propValue;
                BigDecimal changeorientryamount = (BigDecimal)model.getValue("entryapplyprojectamount", rowIndex);
                BigDecimal changeprice = (BigDecimal)model.getValue("changeprice", rowIndex);
                BigDecimal expapplyprojetaxamount = (BigDecimal)model.getValue("oriexpapplyprotaxamount", rowIndex);
                BigDecimal acprice = price.add(changeprice).add(changeorientryamount).subtract(expapplyprojetaxamount);
                model.setValue("acprice", (Object)acprice, rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)acprice, (String)"accurprice", (String)"exchangerate", (String)"entrycurrency", (String)"expquotetype", (int)rowIndex);
            }
        }
    }
}

