/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.publicreim;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.IEntryMustInput;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbsPublicReimAssetBillEdit
extends AbstractBillPlugIn {
    protected static Log logger = LogFactory.getLog(AbsPublicReimAssetBillEdit.class);
    static final String assetNumber = "09";
    static final String accountNumber = "10";
    static final String IMPORT_ASSET_ITEM_KEY = "importasset";
    static final String IMPORT_ASSET_CLOSE_CALL_BACK = "IMPORT_ASSET_CLOSE_CALL_BACK";
    static final Set<String> importAssetFields = new HashSet<String>(Arrays.asList("asset_name", "asset_model", "asset_unit", "assetpricewithouttax", "asset_quantity", "assetorientryamount", "assettaxrate", "assettaxamount", "asset_isspecialinvoice"));

    boolean isAssetReimburse() {
        Object reimburseType = this.getModel().getValue("reimbursetype");
        return reimburseType != null && StringUtils.equalsIgnoreCase((String)reimburseType.toString(), (String)"asset");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addAssetNumberF7BeforeFilter();
        this.assetCostdeptF7Filter();
    }

    void assetCostdeptF7Filter() {
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
        if (costCompany == null) {
            return;
        }
        Boolean departSharing = (Boolean)ErCommonUtils.getFAParameter((long)ErCommonUtils.getPk((Object)costCompany), (String)"depart_sharing");
        if (departSharing == null) {
            departSharing = Boolean.FALSE;
        }
        if (departSharing.equals(Boolean.TRUE)) {
            return;
        }
        BasedataEdit assetCostdept = (BasedataEdit)this.getControl("asset_costdept");
        if (assetCostdept != null) {
            assetCostdept.addBeforeF7SelectListener(event -> {
                ArrayList useOrgList = new ArrayList();
                if ("asset_costdept".equals(event.getProperty().getName())) {
                    List<Long> orgIds = Collections.singletonList(Long.valueOf(costCompany.get("id").toString()));
                    List relationOrgList = OrgUnitServiceHelper.getAdminOrgRelation(orgIds, (boolean)true);
                    if (relationOrgList.size() > 0) {
                        useOrgList.addAll(relationOrgList);
                    } else {
                        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"01");
                        QFilter orgFilter = new QFilter("org", "=", costCompany.getPkValue());
                        QFilter[] filters = new QFilter[]{treeTypeFilter, orgFilter};
                        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])filters);
                        if (orgInfo != null) {
                            List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIds, (boolean)true);
                            useOrgList.addAll(allOrgList);
                        }
                    }
                    if (useOrgList.size() > 0) {
                        ListShowParameter cardF7Param;
                        QFilter qFilter = new QFilter("id", "in", useOrgList);
                        if (event.getFormShowParameter() instanceof ListShowParameter) {
                            cardF7Param = (ListShowParameter)event.getFormShowParameter();
                            cardF7Param.getListFilterParameter().getQFilters().add(qFilter);
                            cardF7Param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                        } else if (event.getFormShowParameter() instanceof MobileFormShowParameter) {
                            cardF7Param = (MobileFormShowParameter)event.getFormShowParameter();
                            cardF7Param.setCustomParam("range", useOrgList);
                            cardF7Param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                        }
                    }
                }
            });
        }
    }

    void addAssetNumberF7BeforeFilter() {
        BasedataEdit assetNo;
        IDataModel model = this.getModel();
        Object costcompany = model.getValue("costcompany");
        if (costcompany == null) {
            return;
        }
        BeforeF7SelectListener assetBillSelectFilter = evt -> {
            BasedataProp property = (BasedataProp)evt.getProperty();
            IDataEntityType complexType = property.getComplexType();
            IDataEntityProperty org = (IDataEntityProperty)complexType.getProperties().get((Object)"org");
            QFilter finalFilter = new QFilter("1", "=", (Object)1);
            if (org != null) {
                QFilter accOrgFilter = new QFilter("org.id", "=", (Object)ErCommonUtils.getPk((Object)costcompany));
                finalFilter.and(accOrgFilter);
            }
            evt.addCustomQFilter(finalFilter);
        };
        BasedataEdit entryAssetNo = (BasedataEdit)this.getControl("assetbillno");
        if (entryAssetNo != null) {
            entryAssetNo.addBeforeF7SelectListener(assetBillSelectFilter);
        }
        if ((assetNo = (BasedataEdit)this.getControl("asset_billno")) != null) {
            assetNo.addBeforeF7SelectListener(assetBillSelectFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        model.setValue("reimbursetype", (Object)this.getReimType());
        this.setCurrency();
        this.setAssOrg();
        DynamicObjectCollection assetEntry = model.getEntryEntity("assetentry");
        if (assetEntry != null && assetEntry.size() > 0) {
            for (int i = 0; i < assetEntry.size(); ++i) {
                this.initAssetEntry(i, (DynamicObject)assetEntry.get(i));
                Map quoteTypeAndExchangeRate = AmountChangeUtil.refreshEnrtyExchangeRate((IDataModel)model, (IFormView)this.getView(), (DynamicObject)((DynamicObject)model.getValue("currency")));
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)quoteTypeAndExchangeRate.get("exchangeRate")), (Object)BigDecimal.ONE);
                String accQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)quoteTypeAndExchangeRate.get("quoteType")), (Object)"0");
                model.setValue("assetexpquotetype", (Object)accQuoteType, i);
                model.setValue("assetexchangerate", (Object)exchangeRate, i);
            }
        }
    }

    private String getReimType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customType = formShowParameter.getCustomParam("reimbursetype");
        String type = customType != null ? customType.toString() : (String)this.getModel().getValue("reimbursetype");
        return type;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((String)entryName, (String)"assetentry")) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                this.initAssetEntry(row.getRowIndex(), row.getDataEntity());
            }
        }
    }

    private void initAssetEntry(int currentIndex, DynamicObject dataEntity) {
        IDataModel model = this.getModel();
        Object currency = model.getValue("currency");
        Object costDept = model.getValue("costdept");
        Object bizDate = model.getValue("bizdate");
        if (model.getValue("assetcurrency", currentIndex) == null) {
            model.setValue("assetcurrency", currency, currentIndex);
        }
        if (model.getValue("asset_costdept", currentIndex) == null) {
            model.setValue("asset_costdept", costDept, currentIndex);
        }
        model.setValue("asset_happendate", bizDate, currentIndex);
        dataEntity.set("id", (Object)ORM.create().genLongId(dataEntity.getDataEntityType()));
    }

    void setAssOrg() {
        IDataModel model = this.getModel();
        DynamicObject costcompany = (DynamicObject)model.getValue("costcompany");
        if (costcompany == null) {
            return;
        }
        DynamicObject assetcompany = null;
        boolean isAssetItself = OrgUnitServiceHelper.checkOrgFunction((Long)ErCommonUtils.getPk((Object)costcompany), (String)assetNumber);
        if (isAssetItself) {
            assetcompany = costcompany;
        } else {
            List assetOrg = OrgUnitServiceHelper.getAllToOrg((String)accountNumber, (String)assetNumber, (Long)ErCommonUtils.getPk((Object)costcompany), (boolean)true);
            if (assetOrg.size() == 1) {
                assetcompany = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", assetOrg.get(0))});
            }
        }
        this.getModel().setValue("assetorg", (Object)assetcompany);
    }

    public void afterBindData(EventObject e) {
        if (!this.isAssetReimburse()) {
            return;
        }
        this.setMustInput("assetorg");
        this.showIfImportAssetItem();
    }

    void showIfImportAssetItem() {
    }

    private void setMustInput(String ... controlIds) {
        FieldEdit[] controls;
        for (FieldEdit control : controls = (FieldEdit[])Arrays.stream(controlIds).map(arg_0 -> ((AbsPublicReimAssetBillEdit)this).getControl(arg_0)).toArray(FieldEdit[]::new)) {
            control.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "costcompany": {
                this.setAssOrg();
                this.showIfImportAssetItem();
                break;
            }
            case "iscurrency": {
                if (((Boolean)propNewValue).booleanValue()) break;
                Object currency = model.getValue("currency");
                DynamicObjectCollection assetEntry = model.getDataEntity(true).getDynamicObjectCollection("assetentry");
                if (assetEntry == null || assetEntry.size() <= 0) break;
                for (int i = 0; i < assetEntry.size(); ++i) {
                    model.setValue("assetcurrency", currency, i);
                }
                break;
            }
            case "assetorg": {
                Long assetOrg = ErCommonUtils.getPk((Object)propNewValue);
                DynamicObjectCollection assetEntry = model.getEntryEntity("assetentry");
                for (int i = 0; i < assetEntry.size(); ++i) {
                    DynamicObject useorg;
                    DynamicObject row = (DynamicObject)assetEntry.get(i);
                    DynamicObject assetCat = row.getDynamicObject("asset_cat");
                    if (assetCat == null || Objects.equals(ErCommonUtils.getPk((Object)(useorg = assetCat.getDynamicObject("useorg"))), assetOrg)) continue;
                    model.setValue("asset_cat", null, i);
                }
                break;
            }
            case "assettype": {
                model.deleteEntryData("assetentry");
                this.showIfImportAssetItem();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                String asset = (String)this.getModel().getValue("reimbursetype");
                PluginProxy pluginProxy = PluginProxy.create(IEntryMustInput.class, (String)"FI_ER_ASSETENTRY_MUSTINPUT");
                List result = pluginProxy.callReplace(m -> m.checkAssetEntryMustInput(this.getModel().getDataEntity(true)));
                if (result.size() > 0 && Boolean.FALSE.equals(result.get(0))) {
                    return;
                }
                if (!"asset".equals(asset) || this.getModel().getEntryRowCount("assetentry") != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d44\u4ea7\u4fe1\u606f\u201d\u3002", (String)"PublicReimAssetBillEdit_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    void propertyChange(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "reimbursetype": {
                this.showIfImportAssetItem();
                break;
            }
            case "asset_billno": {
                this.fillAssetEntry(propNewValue, rowIndex);
                break;
            }
            case "asset_quantity": 
            case "assetpricewithouttax": {
                this.countAssetEntryWithOutAmount(rowIndex);
                break;
            }
            case "assetcurrency": {
                if (propNewValue == null) {
                    this.getModel().beginInit();
                    this.getModel().setValue(propName, valueSet[0].getOldValue(), rowIndex);
                    this.getModel().endInit();
                }
                Map quoteTypeAndExchangeRate = AmountChangeUtil.refreshEnrtyExchangeRate((IDataModel)model, (IFormView)this.getView(), (DynamicObject)((DynamicObject)propNewValue));
                model.setValue("assetexpquotetype", quoteTypeAndExchangeRate.get("quoteType"), rowIndex);
                model.setValue("assetexchangerate", quoteTypeAndExchangeRate.get("exchangeRate"), rowIndex);
                break;
            }
            case "assetexchangerate": {
                BigDecimal oriEntryAmount = (BigDecimal)model.getValue("assetorientryamount", rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)oriEntryAmount, (String)"assetcurentryamount", (String)"assetexchangerate", (String)"assetexpquotetype", (int)rowIndex);
                BigDecimal expenseAmount = (BigDecimal)model.getValue("assetexpenseamount", rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)expenseAmount, (String)"assetcurrexpenseamount", (String)"assetexchangerate", (String)"assetexpquotetype", (int)rowIndex);
                break;
            }
            case "assetorientryamount": {
                AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)((BigDecimal)propNewValue), (String)"assetcurentryamount", (String)"assetexchangerate", (String)"assetexpquotetype", (int)rowIndex);
                BigDecimal taxAmount = this.countAssetEntryTaxAmount(rowIndex);
                model.setValue("assettaxamount", (Object)taxAmount, rowIndex);
                this.countAssetEntryAmount(rowIndex);
                break;
            }
            case "assettaxrate": {
                BigDecimal taxAmount = this.countAssetEntryTaxAmount(rowIndex);
                model.setValue("assettaxamount", (Object)taxAmount, rowIndex);
                break;
            }
            case "assettaxamount": {
                this.countAssetEntryAmount(rowIndex);
                break;
            }
            case "assetexpenseamount": {
                AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)((BigDecimal)propNewValue), (String)"assetcurrexpenseamount", (String)"assetexchangerate", (String)"assetexpquotetype", (int)rowIndex);
                break;
            }
            case "assetbillno": {
                this.fillExpEntry(propNewValue, rowIndex);
                break;
            }
            case "pricewithtax": 
            case "assetquantity": {
                this.countExpEntryAmount(rowIndex);
            }
        }
    }

    private void fillAssetEntry(Object carlRealBase, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject cardF7 = (DynamicObject)carlRealBase;
        model.setValue("asset_number", (Object)cardF7.getString("billno"), rowIndex);
        model.setValue("asset_cat", (Object)cardF7.getDynamicObject("assetcat"), rowIndex);
        model.setValue("asset_name", (Object)cardF7.getString("assetname"), rowIndex);
        model.setValue("asset_model", (Object)cardF7.getString("model"), rowIndex);
        model.setValue("asset_storeplace", (Object)cardF7.getDynamicObject("storeplace"), rowIndex);
        model.setValue("asset_costdept", (Object)cardF7.getDynamicObject("headusedept"), rowIndex);
        model.setValue("asset_unit", (Object)cardF7.getDynamicObject("unit"), rowIndex);
        model.setValue("asset_quantity", (Object)cardF7.getBigDecimal("assetamount"), rowIndex);
        model.setValue("asset_user", (Object)cardF7.getDynamicObject("headuseperson"), rowIndex);
    }

    private BigDecimal countAssetEntryTaxAmount(int rowIndex) {
        IDataModel model = this.getModel();
        Object assetCurrency = model.getValue("assetcurrency", rowIndex);
        if (assetCurrency == null) {
            return BigDecimal.ZERO;
        }
        int currencyPrecision = AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)assetCurrency));
        BigDecimal oriEntryAmount = (BigDecimal)model.getValue("assetorientryamount", rowIndex);
        BigDecimal assetTaxRate = ((BigDecimal)model.getValue("assettaxrate", rowIndex)).divide(new BigDecimal(100)).setScale(currencyPrecision, RoundingMode.HALF_UP);
        return oriEntryAmount.multiply(assetTaxRate).setScale(currencyPrecision, RoundingMode.HALF_UP);
    }

    private void countAssetEntryWithOutAmount(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("assetcurrency", rowIndex);
        if (currency == null) {
            return;
        }
        int currencyPrecision = AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)currency));
        BigDecimal priceWithTax = (BigDecimal)model.getValue("assetpricewithouttax", rowIndex);
        BigDecimal quantity = (BigDecimal)model.getValue("asset_quantity", rowIndex);
        model.setValue("assetorientryamount", (Object)priceWithTax.multiply(quantity).setScale(currencyPrecision, RoundingMode.HALF_UP), rowIndex);
    }

    private void countAssetEntryAmount(int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal taxAmount = (BigDecimal)model.getValue("assettaxamount", rowIndex);
        Object assetCurrency = model.getValue("assetcurrency", rowIndex);
        if (assetCurrency == null) {
            return;
        }
        BigDecimal oriEntryAmount = (BigDecimal)model.getValue("assetorientryamount", rowIndex);
        BigDecimal assetExpenseAmount = oriEntryAmount.add(taxAmount).setScale(AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)assetCurrency)), RoundingMode.HALF_UP);
        model.setValue("assetexpenseamount", (Object)assetExpenseAmount, rowIndex);
    }

    private void fillExpEntry(Object carlRealBase, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject cardF7 = (DynamicObject)carlRealBase;
        model.setValue("assetnumber", (Object)cardF7.getString("billno"), rowIndex);
        model.setValue("assetcat", (Object)cardF7.getDynamicObject("assetcat"), rowIndex);
        model.setValue("assetname", (Object)cardF7.getString("assetname"), rowIndex);
        model.setValue("assetmodel", (Object)cardF7.getString("model"), rowIndex);
        model.setValue("assetstoreplace", (Object)cardF7.getDynamicObject("storeplace"), rowIndex);
        model.setValue("entrycostdept", (Object)cardF7.getDynamicObject("headusedept"), rowIndex);
        model.setValue("assetunit", (Object)cardF7.getDynamicObject("unit"), rowIndex);
        model.setValue("assetquantity", (Object)cardF7.getBigDecimal("assetamount"), rowIndex);
    }

    private void countExpEntryAmount(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("assetcurrency", rowIndex);
        int currencyPrecision = AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)currency));
        BigDecimal priceWithTax = (BigDecimal)model.getValue("pricewithtax", rowIndex);
        BigDecimal quantity = (BigDecimal)model.getValue("assetquantity", rowIndex);
        model.setValue("expenseamount", (Object)priceWithTax.multiply(quantity).setScale(currencyPrecision, RoundingMode.HALF_UP), rowIndex);
    }

    void setCurrency() {
    }
}

