/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.publicreim;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.license.LicenseUtils;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.field.writeoffmoney.PublicContractWriteOffFields;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.publicbiz.bill.common.ChangedAccountByPayer;
import org.apache.commons.lang.StringUtils;

public class PublicReimBillEdit
extends AbstractBillPlugIn {
    private static final String pageCacheKey = "selectedPkIds";
    protected static Log logger = LogFactory.getLog(PublicReimBillEdit.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if (StringUtils.equalsIgnoreCase((String)"dhc", (String)appId) && "er_publicreimbursebill".equals(formShowParameter.getFormId())) {
            String menupath = (String)formShowParameter.getCustomParam("menupath");
            if (StringUtils.isNotEmpty((String)menupath) && "dhc_expenseaccounting".equals(menupath)) {
                LicenseUtils.checkLicenseByAppId((PreOpenFormEventArgs)e, (String)"EXP");
            } else if (StringUtils.isNotEmpty((String)menupath) && "dhc_vendorpayment".equals(menupath)) {
                LicenseUtils.checkLicenseByAppId((PreOpenFormEventArgs)e, (String)"CEXP");
            } else {
                LicenseUtils.checkLicenseByAppIds((PreOpenFormEventArgs)e, (String[])new String[]{"EXP", "CEXP"});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        BasedataEdit billpayeridEdit = (BasedataEdit)this.getControl("billpayerid");
        String billpayertype = (String)model.getValue("billpayertype");
        if (billpayeridEdit != null && "bos_org".equals(billpayertype)) {
            billpayeridEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("initOrgFuncId", (Object)"10");
                }
            });
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        if (sourceData.get("iscurrency") != null && ((Boolean)sourceData.get("iscurrency")).booleanValue()) {
            this.getModel().setValue("iscurrency", (Object)true);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterBindData(EventObject e) {
        String relationcontract;
        boolean ischanged;
        block29: {
            boolean dataEntityBoolean;
            DynamicObject dataEntity;
            block27: {
                String detailType;
                IDataModel model;
                block30: {
                    DynamicObjectCollection accCol;
                    block28: {
                        int size;
                        super.afterBindData(e);
                        model = this.getModel();
                        ischanged = model.getDataChanged();
                        this.viewControlByAppId();
                        relationcontract = "0";
                        if (model.getValue("company") != null) {
                            relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
                        }
                        detailType = model.getValue("detailtype").toString();
                        model.setValue("relationcontract", (Object)relationcontract);
                        if ("1".equals(relationcontract) && StringUtils.equalsIgnoreCase((String)detailType, (String)"biztype_contractestimate")) {
                            model.setValue("frameworkcontract", (Object)true);
                        }
                        if (!this.getModel().getDataEntity().getDataEntityState().isPushChanged()) break block27;
                        if (!StringUtils.equalsIgnoreCase((String)detailType, (String)"biztype_project")) break block28;
                        DynamicObjectCollection wentry = model.getEntryEntity("writeoffmoney");
                        if (wentry != null && (size = wentry.size()) > 0) {
                            for (int i = 0; i < size; ++i) {
                                DynamicObject entry = (DynamicObject)wentry.get(i);
                                DynamicObject c = entry.getDynamicObject("sourceexpenseitem");
                                entry.set("sourceexpenseitem", null);
                                entry.set("sourceexpenseitem", (Object)c);
                            }
                        }
                        if ("2".equals(ErStdConfig.getApplyprojectbillRelated())) {
                            model.setValue("isonway", (Object)true);
                        } else {
                            model.setValue("isonway", (Object)false);
                        }
                        this.setExpContactCode(model);
                        break block29;
                    }
                    if (!WriteOffMoneyUtils.isContract((IDataModel)this.getModel())) break block30;
                    Object costCompany = model.getValue("costcompany");
                    Object costDept = model.getValue("costdept");
                    DynamicObjectCollection expCol = model.getEntryEntity("expenseentryentity");
                    ArrayList<Long> selectedPkIds = new ArrayList<Long>();
                    for (int expStartIndex = expCol.getStartRowIndex(); expStartIndex < expCol.size(); ++expStartIndex) {
                        Long srcBillId = ((DynamicObject)expCol.get(expStartIndex)).getLong("contractitem");
                        if (model.getValue("entrycostcompany", expStartIndex) == null) {
                            model.setValue("entrycostcompany", costCompany, expStartIndex);
                        }
                        if (model.getValue("entrycostdept", expStartIndex) == null) {
                            model.setValue("entrycostdept", costDept, expStartIndex);
                        }
                        if (!Objects.equals(srcBillId, 0L)) {
                            selectedPkIds.add(srcBillId);
                        }
                        DynamicObject entrycurrency = ((DynamicObject)expCol.get(expStartIndex)).getDynamicObject("entrycurrency");
                        model.beginInit();
                        model.setValue("entrycurrency", null, expStartIndex);
                        model.endInit();
                        model.setValue("entrycurrency", (Object)entrycurrency, expStartIndex);
                        model.setValue("wbexchangrate", model.getValue("exchangerate", expStartIndex), expStartIndex);
                        model.setValue("wbquotetype", model.getValue("expquotetype", expStartIndex), expStartIndex);
                        BigDecimal expAmount = ((DynamicObject)expCol.get(expStartIndex)).getBigDecimal("expenseamount");
                        BigDecimal appexpAmount = ((DynamicObject)expCol.get(expStartIndex)).getBigDecimal("expeapproveamount");
                        model.beginInit();
                        model.setValue("expenseamount", (Object)0, expStartIndex);
                        model.setValue("expeapproveamount", (Object)0, expStartIndex);
                        model.endInit();
                        model.setValue("expenseamount", (Object)expAmount, expStartIndex);
                        model.setValue("expeapproveamount", (Object)appexpAmount, expStartIndex);
                    }
                    if (selectedPkIds.size() != 0) {
                        IPageCache pageCache = this.getPageCache();
                        String selectedPkIdsInCache = pageCache.get(pageCacheKey);
                        JSONObject jsonObject = new JSONObject();
                        if (selectedPkIdsInCache != null) {
                            Object oldSelectedPkIds = ((HashMap)JSONObject.parseObject((String)selectedPkIdsInCache, HashMap.class)).get(pageCacheKey);
                            if (oldSelectedPkIds instanceof List) {
                                List<Long> diffSelectedPkIds = selectedPkIds.stream().filter(s -> !((List)oldSelectedPkIds).contains(s)).collect(Collectors.toList());
                                this.UpToSrcBill(diffSelectedPkIds, "er_prepaybill");
                                jsonObject.put(pageCacheKey, selectedPkIds);
                                pageCache.put(pageCacheKey, jsonObject.toJSONString());
                            }
                        } else {
                            jsonObject.put(pageCacheKey, selectedPkIds);
                            pageCache.put(pageCacheKey, jsonObject.toJSONString());
                            this.UpToSrcBill(selectedPkIds, "er_prepaybill");
                        }
                        Container advconap = (Container)this.getControl("advconap");
                        if (advconap != null) {
                            if (this.getModel().getEntryRowCount("writeoffmoney") > 0) {
                                advconap.setCollapse(Boolean.FALSE.booleanValue());
                            } else {
                                advconap.setCollapse(Boolean.TRUE.booleanValue());
                            }
                        }
                    }
                    if ((accCol = model.getEntryEntity("accountentry")).size() != 0) {
                        DynamicObject paymode = PayeeServiceHelper.getDefaultPayMode();
                        DynamicObject billpayerid = (DynamicObject)model.getValue("billpayerid");
                        if (accCol.size() == 1) {
                            BigDecimal payamount = (BigDecimal)model.getValue("payamount");
                            AmountChangeUtil.setReciveAmount((IFormView)this.getView(), (IDataModel)model, (BigDecimal)payamount, (String)"0");
                        }
                        for (int accIndex = 0; accIndex < accCol.size(); ++accIndex) {
                            model.setValue("paymode", (Object)paymode, accIndex);
                            model.setValue("supplier", (Object)billpayerid, accIndex);
                            BigDecimal accExchangeRate = ((DynamicObject)accCol.get(accIndex)).getBigDecimal("accexchangerate");
                            if (BigDecimal.ZERO.compareTo(accExchangeRate) != 0) continue;
                            model.setValue("accexchangerate", (Object)BigDecimal.ONE, accIndex);
                        }
                    }
                    break block29;
                }
                if (((String)model.getValue("relationcontract")).equals("1") && StringUtils.equalsIgnoreCase((String)detailType, (String)"biztype_contract") && "true".equals(model.getValue("ispush"))) {
                    boolean dataEntityBoolean2;
                    PublicBillUtil.writeOffContract((IDataModel)this.getModel(), (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                    PublicBillUtil.handlePrePayContract((IDataModel)this.getModel(), (IFormView)this.getView());
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"detailtype"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"add_reimcontract"});
                    dataEntity = this.getModel().getDataEntity();
                    IDataEntityProperty frameworkcontract = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"frameworkcontract");
                    if (frameworkcontract != null && !(dataEntityBoolean2 = dataEntity.getBoolean("frameworkcontract"))) {
                        // empty if block
                    }
                    break block29;
                } else if (((String)model.getValue("relationcontract")).equals("1") && !"true".equals(model.getValue("ispush"))) {
                    this.setExpContactCode(model);
                }
                break block29;
            }
            dataEntity = this.getModel().getDataEntity();
            IDataEntityProperty frameworkcontract = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"frameworkcontract");
            String ispush = (String)this.getModel().getValue("ispush");
            if (frameworkcontract == null || !(dataEntityBoolean = dataEntity.getBoolean("frameworkcontract")) || "true".equals(ispush)) {
                // empty if block
            }
        }
        this.closeContractEntry();
        DynamicObject billpayer = (DynamicObject)this.getModel().getValue("billpayerid");
        if (billpayer != null) {
            ChangedAccountByPayer.setTotalbillPayeramountLab(this.getModel(), this.getView(), billpayer);
        }
        if (this.getModel().getProperty("relationcontract") != null && !this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            this.getModel().setValue("relationcontract", (Object)relationcontract);
        }
        ContractUtil.changeBillHeadContractsconn((IDataModel)this.getModel(), null);
        this.getModel().setDataChanged(ischanged);
    }

    private void closeContractEntry() {
        IFormView view = this.getView();
        if (!(view instanceof MobileBillView) && !(view instanceof MobileFormView)) {
            AdvContainer projectContainer = (AdvContainer)this.getControl("advconap_contract");
            int entryRowCount = this.getModel().getEntryRowCount("contractentry");
            if (entryRowCount < 1) {
                projectContainer.setCollapse(true);
            } else {
                projectContainer.setCollapse(false);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "invoiceentry": {
                PublicBillUtil.calContractInvoiceAmount((IDataModel)this.getModel());
                break;
            }
            case "expenseentryentity": {
                ContractUtil.changeBillHeadContractsconn((IDataModel)this.getModel(), (String)e.getEntryProp().getName());
                PublicBillUtil.refreshWriteEntry((IDataModel)model, (IFormView)this.getView());
                PublicBillUtil.writeOffContract((IDataModel)this.getModel(), (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                PublicBillUtil.updateContractWriteoffView((IDataModel)model, (IFormView)this.getView());
                break;
            }
            case "writeoffmoney": {
                PublicBillUtil.handlePrePayContract((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "contractentry": {
                DynamicObjectCollection expentryEntity;
                if (model.getEntryRowCount("contractentry") == 0 && (expentryEntity = model.getEntryEntity("expenseentryentity")).size() > 0) {
                    for (int i = 0; i < expentryEntity.size(); ++i) {
                        model.setValue("entrycontractno", (Object)"", i);
                        model.setValue("entrycontractname", (Object)"", i);
                    }
                }
                PublicBillUtil.writeOffContract((IDataModel)model, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                PublicBillUtil.updateContractWriteoffView((IDataModel)model, (IFormView)this.getView());
                break;
            }
            case "accountentry": {
                WriteOffMoneyUtils.setIsOnAccount((IFormView)this.getView());
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                String ispush = (String)model.getValue("ispush");
                String detailtype = (String)model.getValue("detailtype");
                Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
                String relationcontract = (String)model.getValue("relationcontract");
                RowDataEntity[] rowDataEntities = e.getRowDataEntities();
                if ("1".equals(relationcontract) && (!"true".equals(ispush) || frameworkcontract.booleanValue() || !frameworkcontract.booleanValue()) && model.getEntryEntity("contractentry").size() > 0) {
                    String contractcode = (String)model.getValue("contractcode", 0);
                    String contractname = (String)model.getValue("contractname", 0);
                    if (rowDataEntities.length > 0) {
                        for (RowDataEntity rowDataEntity : rowDataEntities) {
                            int rowIndex = rowDataEntity.getRowIndex();
                            model.setValue("entrycontractno", (Object)contractcode, rowIndex);
                            model.setValue("entrycontractname", (Object)contractname, rowIndex);
                        }
                    }
                }
                ContractUtil.changeBillHeadContractsconn((IDataModel)model, (String)e.getEntryProp().getName());
                break;
            }
            case "writeoffmoney": {
                PublicBillUtil.handlePrePayContract((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "invoiceentry": {
                String insertCompnameId = this.getPageCache().get("insertcompnameid");
                if (insertCompnameId == null || StringUtils.equals((String)insertCompnameId, (String)"")) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u5165\u53d1\u7968\u7684\u5f00\u7968\u516c\u53f8\u4e0e\u5f53\u524d\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8986\u76d6\u3002", (String)"ImportInvoiceForPubReimPCPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("Confirm", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equals((String)"Confirm", (String)e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            IDataModel model = this.getModel();
            String insertCompnameId = this.getPageCache().get("insertcompnameid");
            model.setValue("billpayerid", (Object)insertCompnameId);
            this.getView().updateView("billpayerid");
        }
        this.getPageCache().remove("insertcompnameid");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IDataModel model;
        String detailType;
        DeleteEntry deleteEntry;
        String operateKey;
        Object source = args.getSource();
        if (source instanceof Donothing) {
            IDataModel model2;
            String detailType2;
            Donothing donothing = (Donothing)source;
            String operateKey2 = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((String)operateKey2, (String)"batchcreateaccount") && (StringUtils.equalsIgnoreCase((String)(detailType2 = (model2 = this.getModel()).getValue("detailtype").toString()), (String)"biztype_contract") || StringUtils.equalsIgnoreCase((String)detailType2, (String)"biztype_contractestimate"))) {
                this.expBatchUpToAccount();
            }
        } else if (source instanceof DeleteEntry && StringUtils.equalsIgnoreCase((String)(operateKey = (deleteEntry = (DeleteEntry)source).getOperateKey()), (String)"deleteentry") && StringUtils.equalsIgnoreCase((String)(detailType = (model = this.getModel()).getValue("detailtype").toString()), (String)"biztype_contract")) {
            IPageCache pageCache = this.getPageCache();
            JSONObject jsonObject = new JSONObject();
            DynamicObjectCollection expColl = model.getEntryEntity("expenseentryentity");
            List selectedPkIds = expColl.stream().map(r -> r.getLong("wbsrcbillid")).collect(Collectors.toList());
            jsonObject.put(pageCacheKey, selectedPkIds);
            pageCache.put(pageCacheKey, jsonObject.toJSONString());
        }
    }

    protected static String getPrepayBillSelectedFields() {
        return String.join((CharSequence)",", "id", "billno", "applier", "description", "bizdate", "billstatus", "currency", "costcompany", "costdept", "billpayertype", "billpayerid", "expenseentryentity.id", "expenseentryentity.expenseitem", "expenseentryentity.entryprojectno", "expenseentryentity.entrycontractno", "expenseentryentity.entrycurrency", "expenseentryentity.exchangerate", "expenseentryentity.orgiexpebalanceamount", "expenseentryentity.expebalanceamount", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid", "entrycostdept", "entrycostcompany");
    }

    private void UpToSrcBill(List<Long> selectedPkIds, String formId) {
        Object[] tgtBillsOfSrc = null;
        logger.info("\u4e0a\u62c9\u5408\u540c\u7684id\uff1a" + selectedPkIds.toString());
        switch (formId) {
            case "er_prepaybill": {
                tgtBillsOfSrc = BusinessDataServiceHelper.load((String)"er_prepaybill", (String)PublicReimBillEdit.getPrepayBillSelectedFields(), (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbillid", "in", selectedPkIds)});
                logger.info("\u6240\u627e\u5230\u7684\u5bf9\u5e94\u7684\u9884\u4ed8\u5355" + Arrays.toString(tgtBillsOfSrc));
                if (tgtBillsOfSrc == null || tgtBillsOfSrc.length == 0) break;
                this.createAndBuildEntry((DynamicObject[])tgtBillsOfSrc, this.getContToPrepayRecordMap());
                break;
            }
        }
    }

    private Map<String, String> getContToPrepayRecordMap() {
        HashMap<String, String> prepayRecordMap = new HashMap<String, String>();
        prepayRecordMap.put("entryId", "expenseentryentity");
        prepayRecordMap.put("tgtFormId", "pmbs_contractpayitem");
        prepayRecordMap.put("tgtEntryId", "pmbs_contractpayitem");
        prepayRecordMap.put("srcOfTgtFormId", "er_prepaybill");
        prepayRecordMap.put("srcOfTgtEntryId", "expenseentryentity");
        return prepayRecordMap;
    }

    private void createAndBuildEntry(DynamicObject[] tgtBillsOfSrc, Map<String, String> recordMap) {
        String entryId = recordMap.get("entryId");
        String tgtFormId = recordMap.get("tgtFormId");
        String tgtEntryId = recordMap.get("tgtEntryId");
        String srcOfTgtFormId = recordMap.get("srcOfTgtFormId");
        String srcOfTgtEntryId = recordMap.get("srcOfTgtEntryId");
        IDataModel model = this.getModel();
        DynamicObjectCollection expColl = model.getEntryEntity("expenseentryentity");
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> mapSourceIdToPublicBills = new HashMap<Long, DynamicObject>();
        for (DynamicObject row : expColl) {
            DynamicObjectCollection linkRows = row.getDynamicObjectCollection(entryId + "_lk");
            for (DynamicObject linkRow : linkRows) {
                Long sourceId = linkRow.getLong(entryId + "_lk_sid");
                if (sourceId.compareTo(Long.valueOf("0")) == 0) continue;
                sourceIds.add(sourceId);
                mapSourceIdToPublicBills.put(sourceId, row);
            }
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)tgtFormId, (String)tgtEntryId, (Long[])sourceIds.toArray(new Long[sourceIds.size()]));
        Long tgtTable = EntityMetadataCache.loadTableDefine((String)srcOfTgtFormId, (String)srcOfTgtEntryId).getTableId();
        TreeMap<Long, DynamicObject> publicreimBillEntryRows = new TreeMap<Long, DynamicObject>();
        for (BFRow targetRow : targetRows) {
            Long sourceEntryId;
            DynamicObject publicReimBill;
            if (tgtTable.compareTo(targetRow.getId().getTableId()) != 0 || (publicReimBill = (DynamicObject)mapSourceIdToPublicBills.get(sourceEntryId = targetRow.getSId().getEntryId())) == null) continue;
            Long targetEntryId = targetRow.getId().getEntryId();
            publicreimBillEntryRows.put(targetEntryId, publicReimBill);
        }
        for (DynamicObject srcBill : tgtBillsOfSrc) {
            String billstatus = srcBill.getString("billstatus");
            if (!"G".equals(billstatus)) continue;
            DynamicObjectCollection srcOfTgtEntrys = srcBill.getDynamicObjectCollection(srcOfTgtEntryId);
            for (int i = 0; i < srcOfTgtEntrys.size(); ++i) {
                DynamicObject srcOfTgtEntry = (DynamicObject)srcOfTgtEntrys.get(i);
                Long srcOfTgtBillExpenseId = (Long)srcOfTgtEntry.getPkValue();
                DynamicObject publicReimburseBill = (DynamicObject)publicreimBillEntryRows.get(srcOfTgtBillExpenseId);
                if (publicReimburseBill == null) continue;
                BigDecimal iexpebalanceAmount = srcOfTgtEntry.getBigDecimal("orgiexpebalanceamount");
                if (iexpebalanceAmount == null || iexpebalanceAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    logger.info("\u9884\u4ed8\u5206\u5f55pk:" + srcOfTgtEntry.getPkValue() + ",\u56e0\u672a\u6838\u9500\u4f59\u989d\u5c0f\u4e8e0\uff0c\u8fc7\u6ee4");
                    continue;
                }
                this.createWriteOffLoanRow(srcOfTgtEntry, tgtTable);
            }
        }
    }

    private void createWriteOffLoanRow(DynamicObject srcOfTgtEntry, Long targetTableId) {
        IDataModel model = this.getModel();
        DynamicObject billEntity = (DynamicObject)srcOfTgtEntry.getParent();
        String billno = billEntity.getString("billno");
        String applierName = billEntity.getDynamicObject("applier").getString("name");
        Date projApplyDate = billEntity.getDate("bizdate");
        String projDescription = billEntity.getString("description");
        String billPayerType = billEntity.getString("billpayertype");
        DynamicObject billPayerId = billEntity.getDynamicObject("billpayerid");
        DynamicObject entrycostdept = srcOfTgtEntry.getDynamicObject("entrycostdept");
        DynamicObject entrycostcompany = srcOfTgtEntry.getDynamicObject("entrycostcompany");
        long wbsrcentryid = srcOfTgtEntry.getLong("wbsrcentryid");
        DynamicObject projCurrency = srcOfTgtEntry.getDynamicObject("entrycurrency");
        DynamicObject projExpenseitem = srcOfTgtEntry.getDynamicObject("expenseitem");
        BigDecimal exchangerate = srcOfTgtEntry.getBigDecimal("exchangerate");
        BigDecimal orgiExpeBalanceAmount = srcOfTgtEntry.getBigDecimal("orgiexpebalanceamount");
        BigDecimal curExpeBalanceAmount = srcOfTgtEntry.getBigDecimal("expebalanceamount");
        int index = model.createNewEntryRow("writeoffmoney");
        model.setValue("sourceentrycostdept", (Object)entrycostdept, index);
        model.setValue("sourceentrycostcompany", (Object)entrycostcompany, index);
        model.setValue("loanbillnov1", (Object)billno, index);
        model.setValue("srcentrywltype", (Object)billPayerType, index);
        model.setValue("srcentrywlunit", (Object)billPayerId, index);
        model.setValue("srcbilltype", (Object)"er_prepaybill", index);
        model.setValue("loanperson", (Object)applierName, index);
        model.setValue("loanapplydatev1", (Object)projApplyDate, index);
        model.setValue("loandescriptionv1", (Object)projDescription, index);
        model.setValue("loancurrency", (Object)projCurrency, index);
        model.setValue("loanexchangerate", (Object)exchangerate, index);
        model.setValue("loanamount", (Object)orgiExpeBalanceAmount, index);
        model.setValue("currloanamount", (Object)curExpeBalanceAmount, index);
        model.setValue("accloanamount", (Object)orgiExpeBalanceAmount, index);
        model.setValue("curraccloanamount", (Object)curExpeBalanceAmount, index);
        model.setValue("sourcebillid", billEntity.getPkValue(), index);
        model.setValue("sourceentryid", srcOfTgtEntry.getPkValue(), index);
        model.setValue("sourcesign", (Object)1);
        model.setValue("sourceexpenseitem", (Object)projExpenseitem, index);
        model.setValue("srcofsrcentryid", (Object)wbsrcentryid, index);
        DynamicObjectCollection offLinkRows = ((DynamicObject)model.getEntryEntity("writeoffmoney").get(index)).getDynamicObjectCollection("writeoffmoney_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("writeoffmoney_lk_stableid", (Object)targetTableId);
        offLinkRow.set("writeoffmoney_lk_sbillid", billEntity.getPkValue());
        offLinkRow.set("writeoffmoney_lk_sid", srcOfTgtEntry.getPkValue());
        offLinkRows.add((Object)offLinkRow);
    }

    protected void viewControlByAppId() {
        IFormView view = this.getView();
        String appId = view.getFormShowParameter().getAppId();
        if (!(view instanceof MobileBillView) && !(view instanceof MobileFormView)) {
            if (StringUtils.equalsIgnoreCase((String)appId, (String)"exp")) {
                view.setVisible(Boolean.FALSE, new String[]{"detailtype"});
                view.setVisible(Boolean.FALSE, new String[]{"advconap_contract"});
                view.setVisible(Boolean.FALSE, new String[]{"frameworkcontract"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"detailtype"});
                view.setVisible(Boolean.TRUE, new String[]{"advconap_contract"});
                view.setVisible(Boolean.TRUE, new String[]{"frameworkcontract"});
            }
        }
        if ("true".equals(ErStdConfig.get((String)"Gdetailtype"))) {
            view.setVisible(Boolean.TRUE, new String[]{"detailtype"});
            view.setVisible(Boolean.TRUE, new String[]{"advconap_contract"});
            view.setVisible(Boolean.TRUE, new String[]{"frameworkcontract"});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        IDataModel model = this.getModel();
        int[] rowIndexs = e.getRowIndexs();
        String detailtype = (String)model.getValue("detailtype");
        if (!StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_other") && StringUtils.equalsIgnoreCase((String)entryProp.getName(), (String)"expenseentryentity")) {
            DynamicObjectCollection expenseEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("expenseentryentity");
            Set<Long> sourceEntryIds = null;
            if (StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_project")) {
                sourceEntryIds = this.getSrcEntryIds(rowIndexs, expenseEntryEntity, "wbsrcentryid");
            }
            if (StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_contract")) {
                sourceEntryIds = this.getSrcEntryIds(rowIndexs, expenseEntryEntity, "wbsrcbillid");
            }
            DynamicObjectCollection writeOffMoneyEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("writeoffmoney");
            ArrayList<Integer> prepayEntryIndex = new ArrayList<Integer>();
            if (writeOffMoneyEntryEntity != null && writeOffMoneyEntryEntity.size() != 0) {
                for (int i = writeOffMoneyEntryEntity.getStartRowIndex(); i < writeOffMoneyEntryEntity.size(); ++i) {
                    if (!StringUtils.equalsIgnoreCase((String)"er_prepaybill", (String)((DynamicObject)writeOffMoneyEntryEntity.get(i)).getString("srcbilltype")) && !StringUtils.equalsIgnoreCase((String)"er_dailyloanbill", (String)((DynamicObject)writeOffMoneyEntryEntity.get(i)).getString("srcbilltype")) || sourceEntryIds == null || !sourceEntryIds.contains(((DynamicObject)writeOffMoneyEntryEntity.get(i)).getLong("srcofsrcentryid"))) continue;
                    prepayEntryIndex.add(i);
                }
                this.removeBySrcEntryIds("writeoffmoney", prepayEntryIndex);
            }
            if (StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_contract")) {
                DynamicObjectCollection accountCollection = this.getModel().getDataEntity().getDynamicObjectCollection("accountentry");
                ArrayList<Integer> contItemEntryIndex = new ArrayList<Integer>();
                if (accountCollection != null && accountCollection.size() != 0) {
                    for (int i = accountCollection.getStartRowIndex(); i < accountCollection.size(); ++i) {
                        if (sourceEntryIds == null || !sourceEntryIds.contains(((DynamicObject)accountCollection.get(i)).getLong("recsrcbillid"))) continue;
                        contItemEntryIndex.add(i);
                    }
                    this.removeBySrcEntryIds("accountentry", contItemEntryIndex);
                }
            }
        }
    }

    private Set<Long> getSrcEntryIds(int[] rowIndexs, DynamicObjectCollection entryEntity, String srcEntryId) {
        HashSet<Long> sourceEntryIds = new HashSet<Long>();
        Arrays.stream(rowIndexs).forEach(index -> Optional.ofNullable(entryEntity.get(index)).ifPresent(row -> sourceEntryIds.add(row.getLong(srcEntryId))));
        return sourceEntryIds;
    }

    private void removeBySrcEntryIds(String collectionId, List<Integer> removeEntryIndexs) {
        int[] removeEntryIndex = removeEntryIndexs.stream().mapToInt(Integer::intValue).toArray();
        Optional.ofNullable(removeEntryIndex).ifPresent(p -> this.getModel().deleteEntryRows(collectionId, p));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "detailtype": {
                if (!("1".equals(model.getValue("relationcontract")) && oldValue != null && propValue != null && (StringUtils.equals((String)oldValue.toString(), (String)"biztype_contract") && StringUtils.equals((String)propValue.toString(), (String)"biztype_other") || StringUtils.equals((String)oldValue.toString(), (String)"biztype_other") && StringUtils.equals((String)propValue.toString(), (String)"biztype_contract")))) {
                    this.entryMaintainRelateEntry((String)propValue, (String)oldValue);
                    model.deleteEntryData("writeoffmoney");
                    model.deleteEntryData("contractentry");
                    logger.info("\u5bf9\u516c\u62a5\u9500\u5355\u5207\u6362\u5173\u8054\u4e1a\u52a1\u65f6\uff0c\u6e05\u7a7a\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u548c\u5173\u8054\u5408\u540c\u5206\u5f55\uff0c\u9700\u8981\u6e05\u7a7a\u51b2\u501f\u6b3e\u5206\u5f55,\u4e0d\u7136\u4f1a\u6709\u810f\u6570\u636e\u3002");
                }
                if (!"1".equals(model.getValue("relationcontract")) || !StringUtils.equalsIgnoreCase((String)((String)propValue), (String)"biztype_contractestimate")) break;
                model.setValue("frameworkcontract", (Object)true);
                break;
            }
            case "expeapproveamount": 
            case "expeapprovecurramount": {
                PublicReimBillEdit.recountWriteBackAmount(model, rowIndex);
                PublicBillUtil.writeOffContract((IDataModel)model, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
                String ispush = (String)model.getValue("ispush");
                if (!frameworkcontract.booleanValue() || "true".equals(ispush) || model.getEntryRowCount("contractentry") <= 0) break;
                ErCommonUtils.updateView((IFormView)this.getView(), (int)0, (String[])new String[]{"contractcurrwriteoff", "contractwriteoff", "contractreimamount", "contractcurrreimamhttount"});
                break;
            }
            case "ispaynow": {
                WriteOffMoneyUtils.setIsOnAccount((IFormView)this.getView());
                break;
            }
            case "billpayertype": 
            case "billpayerid": {
                Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                Boolean isFilterSup = SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
                if ("biztype_other".equals(model.getValue("detailtype")) || !isFilterSup.booleanValue()) break;
                this.entryMaintainRelateEntry();
                Object billpayeridObj = model.getValue("billpayerid");
                Object billpayerid = -1;
                if (billpayeridObj != null) {
                    billpayerid = ((DynamicObject)billpayeridObj).getPkValue();
                }
                Integer billpayeridFinal = billpayerid;
                DynamicObjectCollection writeoffmoney = (DynamicObjectCollection)this.getModel().getValue("writeoffmoney");
                Optional.ofNullable(writeoffmoney).ifPresent(dt -> {
                    if (!StringUtils.equalsIgnoreCase((String)dt.toString(), (String)"biztype_other")) {
                        for (int index = writeoffmoney.size() - 1; index >= 0; --index) {
                            Object srcentrywlunit_id;
                            DynamicObject write = (DynamicObject)writeoffmoney.get(index);
                            String billType = (String)write.get("srcbilltype");
                            if (!ErEntityTypeUtils.isPrePayBill((String)billType) || billpayeridFinal.equals(srcentrywlunit_id = write.get("srcentrywlunit_id"))) continue;
                            this.getModel().deleteEntryRow("writeoffmoney", index);
                        }
                    }
                });
                break;
            }
            case "contractwriteoff": {
                PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)model, (BigDecimal)((BigDecimal)propValue), (int)rowIndex);
                PublicBillUtil.calContractInvoiceAmount((IDataModel)model);
                break;
            }
            case "totalamount": 
            case "invoicecurrency": {
                PublicBillUtil.calContractInvoiceAmount((IDataModel)model);
                break;
            }
            case "frameworkcontract": {
                this.getModel().deleteEntryData("contractentry");
                DynamicObjectCollection expentryEntity = model.getEntryEntity("expenseentryentity");
                if (expentryEntity.size() <= 0) break;
                for (int i = 0; i < expentryEntity.size(); ++i) {
                    model.setValue("entrycontractno", (Object)"", i);
                    model.setValue("entrycontractname", (Object)"", i);
                }
                break;
            }
            case "contractcurrwriteoff": {
                String writeoffType = this.getWriteOffType();
                if (StringUtils.isEmpty((String)writeoffType)) {
                    writeoffType = (String)model.getValue("writeofftype");
                }
                if (!writeoffType.equals(WriteOffTypeEnum.CURR_WO.getValue())) break;
                model.beginInit();
                BigDecimal contractcanamount = (BigDecimal)model.getValue("contractcanamount", rowIndex);
                BigDecimal contractcurrcanamount = (BigDecimal)model.getValue("contractcurrcanamount", rowIndex);
                BigDecimal contractcurrwriteoff = (BigDecimal)propValue;
                if (contractcurrwriteoff.compareTo(contractcurrcanamount) > 0) {
                    model.setValue(propName, oldValue, rowIndex);
                    this.getView().updateView(propName, rowIndex);
                    break;
                }
                if (contractcurrwriteoff.compareTo(contractcurrcanamount) == 0) {
                    model.setValue("contractwriteoff", (Object)contractcanamount, rowIndex);
                } else {
                    BigDecimal contractwriteoff;
                    String cnquotetype = (String)this.getModel().getValue("contractexpquotetype", rowIndex);
                    BigDecimal cnexchangerate = (BigDecimal)model.getValue("contractexpchangerate", rowIndex);
                    DynamicObject contractexpcurrency = (DynamicObject)model.getValue("contractexpcurrency", 0);
                    int amountPrecision = AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)contractexpcurrency));
                    BigDecimal bigDecimal = contractwriteoff = StringUtils.equals((String)"0", (String)cnquotetype) ? contractcurrwriteoff.divide(cnexchangerate, amountPrecision, RoundingMode.HALF_UP) : contractcurrwriteoff.multiply(cnexchangerate).setScale(amountPrecision, RoundingMode.HALF_UP);
                    if (contractwriteoff.compareTo(contractcanamount) > 0) {
                        model.setValue("contractwriteoff", (Object)contractcanamount, rowIndex);
                    } else {
                        model.setValue("contractwriteoff", (Object)contractwriteoff, rowIndex);
                    }
                }
                model.endInit();
                this.getView().updateView("contractcurrwriteoff", rowIndex);
                this.getView().updateView("contractwriteoff", rowIndex);
                break;
            }
            case "curraccloanamount": {
                PublicBillUtil.writeOffContract((IDataModel)model, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                break;
            }
            case "contractreimamount": {
                String writeoffType = this.getWriteOffType();
                if (StringUtils.isEmpty((String)writeoffType)) {
                    writeoffType = (String)model.getValue("writeofftype");
                }
                if (!writeoffType.equals(WriteOffTypeEnum.ORGI_WO.getValue())) break;
                PublicBillUtil.contractreimAmountChange((IDataModel)model, (IFormView)this.getView(), (Object)propValue, (Object)oldValue, (int)rowIndex);
                break;
            }
            case "contractcurrreimamhttount": {
                String writeoffType = this.getWriteOffType();
                if (StringUtils.isEmpty((String)writeoffType)) {
                    writeoffType = (String)model.getValue("writeofftype");
                }
                if (!writeoffType.equals(WriteOffTypeEnum.CURR_WO.getValue())) break;
                PublicBillUtil.contractcurAmountChange((IDataModel)model, (IFormView)this.getView(), (Object)propValue, (Object)oldValue, (int)rowIndex);
                break;
            }
            case "receiveamount": {
                WriteOffMoneyUtils.setIsOnAccount((IFormView)this.getView());
            }
        }
    }

    private void entryMaintainRelateEntry(String newValue, String oldValue) {
        this.deleteEntry(newValue);
        if (StringUtils.equalsIgnoreCase((String)newValue, (String)"biztype_contract") || StringUtils.equalsIgnoreCase((String)newValue, (String)"biztype_contractestimate")) {
            this.getModel().deleteEntryData("accountentry");
        } else if (StringUtils.equalsIgnoreCase((String)oldValue, (String)"biztype_contract") || StringUtils.equalsIgnoreCase((String)oldValue, (String)"biztype_contractestimate")) {
            this.getModel().deleteEntryData("accountentry");
        }
    }

    private void entryMaintainRelateEntry() {
        Object detailType = this.getModel().getValue("detailtype");
        Optional.ofNullable(detailType).ifPresent(dt -> {
            if (!StringUtils.equalsIgnoreCase((String)dt.toString(), (String)"biztype_other")) {
                this.deleteEntry(dt.toString());
            }
        });
    }

    private void deleteEntry(String newValue) {
        IFormView view = this.getView();
        PublicUpBillUtil.deleteEntryByBillpayerChanged((IFormView)view);
        DynamicObjectCollection expenseEntry = this.getModel().getEntryEntity("expenseentryentity");
        if (StringUtils.equalsIgnoreCase((String)newValue, (String)"biztype_other") && expenseEntry.size() == 0 && !(view instanceof MobileBillView) && !(view instanceof MobileFormView)) {
            view.invokeOperation("newentry");
        }
    }

    public static void recountWriteBackAmount(IDataModel model, int index) {
        String quoteType;
        String writeOffType = (String)model.getValue("writeofftype");
        BigDecimal wbExchangRate = (BigDecimal)model.getValue("wbexchangrate", index);
        String string = quoteType = model.getProperty("wbquotetype") == null ? "0" : (String)model.getValue("wbquotetype", index);
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
            BigDecimal amount = (BigDecimal)model.getValue("expeapproveamount", index);
            BigDecimal curAmount = BigDecimal.ZERO;
            if (wbExchangRate.compareTo(BigDecimal.ZERO) != 0) {
                curAmount = org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? amount.multiply(wbExchangRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP) : amount.divide(wbExchangRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP);
            }
            model.setValue("wbamount", (Object)amount, index);
            model.setValue("wbcuramount", (Object)curAmount, index);
        } else {
            BigDecimal curAmount = (BigDecimal)model.getValue("expeapprovecurramount", index);
            model.setValue("wbcuramount", (Object)curAmount, index);
            if (wbExchangRate.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal amount = org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? curAmount.divide(wbExchangRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP) : curAmount.multiply(wbExchangRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP);
                model.setValue("wbamount", (Object)amount, index);
            } else {
                model.setValue("wbamount", (Object)BigDecimal.ZERO, index);
            }
        }
    }

    private void expBatchUpToAccount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection expColl = model.getEntryEntity("expenseentryentity");
        if (expColl.size() != 0) {
            int diff = expColl.size() - model.getEntryEntity("accountentry").size();
            if (diff > 0) {
                model.batchCreateNewEntryRow("accountentry", diff);
            } else {
                model.deleteEntryData("accountentry");
                model.batchCreateNewEntryRow("accountentry", expColl.size());
            }
            DynamicObjectCollection accColl = model.getEntryEntity("accountentry");
            Long tableId = EntityMetadataCache.loadTableDefine((String)"pmbs_contractpayitem", (String)"pmbs_contractpayitem").getTableId();
            for (int i = 0; i < expColl.size(); ++i) {
                long wbSrcBillId = ((DynamicObject)expColl.get(i)).getLong("wbsrcbillid");
                long wbSrcEntryId = ((DynamicObject)expColl.get(i)).getLong("wbsrcentryid");
                String wbSrcBillNo = ((DynamicObject)expColl.get(i)).getString("wbsrcbillno");
                DynamicObject expCurrency = ((DynamicObject)expColl.get(i)).getDynamicObject("entrycurrency");
                BigDecimal expeExchangeRate = ((DynamicObject)expColl.get(i)).getBigDecimal("exchangerate");
                BigDecimal expeApproveAmount = ((DynamicObject)expColl.get(i)).getBigDecimal("expeapproveamount");
                BigDecimal expeApproveCurAmount = ((DynamicObject)expColl.get(i)).getBigDecimal("expeapprovecurramount");
                long contractItemId = ((DynamicObject)expColl.get(i)).getLong("contractitem");
                long comparedSrcId = contractItemId > 0L ? contractItemId : wbSrcBillId;
                long comparedSrcEntryId = contractItemId > 0L ? contractItemId : wbSrcEntryId;
                DynamicObjectCollection accColl_lk = ((DynamicObject)accColl.get(i)).getDynamicObjectCollection("accountentry_lk");
                DynamicObject linkRow = new DynamicObject(accColl_lk.getDynamicObjectType());
                linkRow.set("seq", (Object)1);
                linkRow.set("accountentry_lk_stableid", (Object)tableId);
                linkRow.set("accountentry_lk_sbillid", (Object)comparedSrcId);
                linkRow.set("accountentry_lk_sid", (Object)comparedSrcId);
                accColl_lk.add((Object)linkRow);
                model.setValue("recsrcbillid", (Object)comparedSrcId, i);
                model.setValue("recsrcentryid", (Object)comparedSrcEntryId, i);
                model.setValue("recsrcbillno", (Object)wbSrcBillNo, i);
                model.setValue("accountcurrency", (Object)expCurrency, i);
                model.setValue("accexchangerate", (Object)expeExchangeRate, i);
                model.setValue("orireceiveamount", (Object)expeApproveAmount, i);
                model.setValue("receiveamount", (Object)expeApproveCurAmount, i);
                this.expToAccEntryExtendFields((DynamicObject)expColl.get(i), i);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8d39\u7528\u660e\u7ec6\u3002", (String)"PublicReimBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        EntryGrid expenseEntryGrid = (EntryGrid)this.getControl("expenseentryentity");
        switch (operateKey) {
            case "submit": {
                DynamicObjectCollection invoices = model.getEntryEntity("invoiceentry");
                for (int index = 0; index < invoices.size(); ++index) {
                    DynamicObject invoice = (DynamicObject)invoices.get(index);
                    String invoiceType = invoice.getString("invoicetype");
                    BigDecimal poolReimAmount = invoice.getBigDecimal("poolreimburseamount");
                    boolean ismutilreimburse = invoice.getBoolean("ismutilreimburse");
                    DynamicObject invoicecurrency = invoice.getDynamicObject("invoicecurrency");
                    if ("30".equals(invoiceType) && null == invoicecurrency) {
                        String tip = ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u4fe1\u606f,\u5f62\u5f0f\u53d1\u7968\u53d1\u7968\u5e01\u79cd\u5fc5\u5f55\u3002", (String)"PublicReimBillEdit_9", (String)"fi-er-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(String.format(tip, index + 1));
                        args.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    if (!ismutilreimburse || null != poolReimAmount && BigDecimal.ZERO.compareTo(poolReimAmount) != 0) continue;
                    String tip = ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u4fe1\u606f,\u591a\u6b21\u62a5\u9500\u672c\u6b21\u62a5\u9500\u91d1\u989d\u5fc5\u5f55\u3002", (String)"PublicReimBillEdit_10", (String)"fi-er-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(tip, index + 1));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                break;
            }
            case "drawunframcontract": 
            case "drawframcontract": {
                IPageCache pageCache = this.getPageCache();
                pageCache.put("draw", "isdraw");
                if (model.getValue("billpayerid") != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5f80\u6765\u5355\u4f4d\u3002", (String)"PublicReimBillEdit_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            case "draw_prepay": {
                String detailtype = (String)model.getValue("detailtype");
                String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
                if (!"biztype_project".equals(detailtype) || !"2".equals(applyprojectbillRelated) || PublicBillUtil.checkProjectNo((IFormView)this.getView())) break;
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            case "copyentryrowforred": {
                Boolean expisredoffset = Boolean.FALSE;
                int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
                for (int i = 0; i < selectedExpenseEntryRowsArr.length; ++i) {
                    expisredoffset = (Boolean)model.getValue("expisredoffset", selectedExpenseEntryRowsArr[i]);
                    if (!expisredoffset.booleanValue()) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u4e3a\u7ea2\u51b2\u5206\u5f55\uff0c\u65e0\u6cd5\u518d\u51b2\u9500\u3002", (String)"PublicReimBillEdit_7", (String)"fi-er-formplugin", (Object[])new Object[0]), selectedExpenseEntryRowsArr[i] + 1));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                break;
            }
            case "deleteexpentry": {
                int[] selectedExpenseEntryRows = expenseEntryGrid.getSelectRows();
                for (int i = 0; i < selectedExpenseEntryRows.length; ++i) {
                    Boolean expisredoffset = (Boolean)model.getValue("expisredoffset", selectedExpenseEntryRows[i]);
                    if (expisredoffset.booleanValue()) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u4e3a\u975e\u7ea2\u51b2\u5206\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PublicReimBillEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]), selectedExpenseEntryRows[i] + 1));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                break;
            }
        }
    }

    private void setExpContactCode(IDataModel model) {
        if (((String)model.getValue("relationcontract")).equals("1") && !"true".equals(model.getValue("ispush"))) {
            if (model.getEntryEntity("contractentry").size() == 0) {
                return;
            }
            String contractcode = (String)this.getModel().getValue("contractcode", 0);
            String contractname = (String)this.getModel().getValue("contractname", 0);
            DynamicObjectCollection expsCol = model.getEntryEntity("expenseentryentity");
            if (expsCol.size() > 0) {
                for (int i = 0; i < expsCol.size(); ++i) {
                    model.setValue("entrycontractno", (Object)contractcode, i);
                    model.setValue("entrycontractname", (Object)contractname, i);
                }
            }
        }
    }

    private String getWriteOffType() {
        return this.getPageCache().get("writeOffType");
    }

    protected void expToAccEntryExtendFields(DynamicObject expRow, int rowIndex) {
    }
}

