/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.publicreim;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PublicReimImportAsset
extends AbstractFormPlugin {
    protected static Log logger = LogFactory.getLog(PublicReimImportAsset.class);
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ENTRY_NAME = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject evt) {
        String name;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (name = control.getKey()) {
            case "btn_ok": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_NAME);
                int[] rowIndexes = entryGrid.getSelectRows();
                if (rowIndexes != null && rowIndexes.length > 0) {
                    this.getView().returnDataToParent(this.getAllSelectRows(rowIndexes));
                }
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }

    private Collection<Long> getAllSelectRows(int[] rowIndexes) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)rowIndexes.length);
        for (int i : rowIndexes) {
            list.add((Long)this.getModel().getValue("entryid", i));
        }
        logger.info(String.format("getAllSelectRows: %s", list));
        return list;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel pModel = this.getView().getParentView().getModel();
        IDataModel model = this.getModel();
        DynamicObject pDataEntity = pModel.getDataEntity(true);
        DynamicObjectCollection invoiceItemEntry = pDataEntity.getDynamicObjectCollection("invoiceitementry");
        if (invoiceItemEntry.size() == 0) {
            return;
        }
        Set boundItemIds = pDataEntity.getDynamicObjectCollection("assetandinvoiceitem").stream().map(r -> r.getLong("invoiceitementryid")).collect(Collectors.toSet());
        List invoiceItems = invoiceItemEntry.stream().filter(item -> !boundItemIds.contains(item.get("id"))).collect(Collectors.toList());
        if (invoiceItems.size() == 0) {
            return;
        }
        DynamicObjectCollection invoiceEntry = pDataEntity.getDynamicObjectCollection("invoiceentry");
        HashMap map = Maps.newHashMapWithExpectedSize((int)invoiceEntry.size());
        for (DynamicObject invoiceInfo : invoiceEntry) {
            map.put(invoiceInfo.getLong("id"), invoiceInfo);
        }
        int[] rowIndexes = model.batchCreateNewEntryRow(ENTRY_NAME, invoiceItems.size());
        DynamicObject dataEntity = model.getDataEntity(true);
        Set properties = ((DynamicObject)dataEntity.getDynamicObjectCollection(ENTRY_NAME).get(0)).getDynamicObjectType().getProperties().stream().filter(p -> !p.getName().equalsIgnoreCase("id") && !p.getName().equalsIgnoreCase("seq")).collect(Collectors.toSet());
        Map<String, DynamicObject> invoiceTypes = PublicReimImportAsset.loadInvoiceTypes();
        for (int i : rowIndexes) {
            DynamicObject item2 = (DynamicObject)invoiceItems.get(i);
            Long entryId = item2.getLong("invoiceheadentryid");
            DynamicObject invoiceInfo = (DynamicObject)map.get(entryId);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (item2.getDynamicObjectType().getProperty(name) != null) {
                    model.setValue(name, item2.get(name), i);
                }
                if (invoiceInfo.getDynamicObjectType().getProperty(name) != null) {
                    model.setValue(name, invoiceInfo.get(name), i);
                }
                if (name.equalsIgnoreCase("entryid")) {
                    model.setValue(name, item2.get("id"), i);
                }
                if (!name.equalsIgnoreCase("invoicetype")) continue;
                model.setValue(name, invoiceTypes.get(invoiceInfo.get(name)).get("id"), i);
            }
        }
    }

    private static Map<String, DynamicObject> loadInvoiceTypes() {
        QFilter filter = QFilter.of((String)"enable='1'", (Object[])new Object[0]);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"er_invoicetype", (String)"id,number,name", (QFilter[])filter.toArray());
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(data.size());
        data.forEach(e -> map.put(e.getString("number"), (DynamicObject)e));
        return map;
    }
}

