/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.push;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ApplyWithholdingToReimBotpPlugin
extends AbstractConvertPlugIn {
    private EntryType withholdingEntryType;
    protected DynamicObject[] withholdingBills = null;

    protected static String getWithholdingBillSelectedFields() {
        return String.join((CharSequence)",", "id", "billno", "applier", "description", "bizdate", "billstatus", "currency", "costcompany", "costdept", "expenseentryentity.entrycostdept", "expenseentryentity.entrycostcompany", "expenseentryentity.id", "expenseentryentity.expenseitem", "expenseentryentity.wbsrcbillno", "expenseentryentity.orgiexpebalanceamount", "expenseentryentity.expebalanceamount", "expenseentryentity.reimbursedamount", "expenseentryentity.reimbursedcurramount", "expenseentryentity.entrycurrency", "expenseentryentity.exchangerate", "expenseentryentity.std_entrycostcenter", "expenseentryentity.entrydesc", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid", "expenseentryentity.expquotetype", "wlunit", "wltype", "entrywltype", "entrywlunit", "withholdingtype");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        List selectedRows = e.getSourceRows();
        List pkLists = selectedRows.stream().map(l -> l.get("id")).collect(Collectors.toList());
        this.withholdingBills = BusinessDataServiceHelper.load((String)"er_withholdingbill", (String)ApplyWithholdingToReimBotpPlugin.getWithholdingBillSelectedFields(), (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbillid", "in", pkLists), new QFilter("billstatus", "=", (Object)"E"), new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO), new QFilter("expenseentryentity.expebalanceamount", ">", (Object)BigDecimal.ZERO), new QFilter("iswriteoff", "=", (Object)Boolean.FALSE)});
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        super.afterCreateLink(e);
        ExtendedDataEntity[] expDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey("writeoffapply");
        this.buildWithholdingEntrys(expDataEntities, this.withholdingBills);
    }

    private void buildWithholdingEntrys(ExtendedDataEntity[] entitiesData, DynamicObject[] withholdingBills) {
        this.buildWhEntrys(entitiesData, withholdingBills, "er_withholdingbill");
    }

    private void buildWhEntrys(ExtendedDataEntity[] entitiesData, DynamicObject[] withholdingBills, String withholdingBillFormId) {
        if (entitiesData == null || entitiesData.length < 1 || withholdingBills == null || withholdingBills.length < 1) {
            return;
        }
        this.withholdingEntryType = (EntryType)this.getTgtMainType().getAllEntities().get("withholdingentry");
        ArrayList sourceIds = Lists.newArrayList();
        HashMap<Long, DynamicObject> mapSourceIdToPublicBills = new HashMap<Long, DynamicObject>();
        ArrayList sourceBillIds = Lists.newArrayList();
        for (ExtendedDataEntity entity : entitiesData) {
            DynamicObjectCollection linkRows = entity.getDataEntity().getDynamicObjectCollection("writeoffapply_lk");
            for (DynamicObject linkRow : linkRows) {
                Long sourceBillId;
                Long sourceId = linkRow.getLong("writeoffapply_lk_sid");
                if (sourceId != null && sourceId.compareTo(Long.valueOf("0")) != 0) {
                    sourceIds.add(sourceId);
                    mapSourceIdToPublicBills.put(sourceId, (DynamicObject)entity.getDataEntity().getParent());
                }
                if ((sourceBillId = Long.valueOf(linkRow.getLong("writeoffapply_lk_sbillid"))) == null || sourceBillId.compareTo(Long.valueOf("0")) == 0 || sourceBillIds.contains(sourceBillId)) continue;
                sourceBillIds.add(sourceBillId);
            }
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)this.getSrcMainType().getName(), (String)"expenseentryentity", (Long[])sourceBillIds.toArray(new Long[sourceBillIds.size()]), (Long[])sourceIds.toArray(new Long[sourceIds.size()]), (OperateOption)OperateOption.create());
        Long withholdingBillTableId = EntityMetadataCache.loadTableDefine((String)withholdingBillFormId, (String)"expenseentryentity").getTableId();
        TreeMap<Long, DynamicObject> publicreimBillEntryRows = new TreeMap<Long, DynamicObject>();
        for (BFRow targetRow : targetRows) {
            Long sourceEntryId;
            DynamicObject publicReimBill;
            if (withholdingBillTableId.compareTo(targetRow.getId().getTableId()) != 0 || (publicReimBill = (DynamicObject)mapSourceIdToPublicBills.get(sourceEntryId = targetRow.getSId().getEntryId())) == null) continue;
            Long targetEntryId = targetRow.getId().getEntryId();
            publicreimBillEntryRows.put(targetEntryId, publicReimBill);
        }
        for (DynamicObject srcBill : withholdingBills) {
            DynamicObjectCollection withholdingBillEntrys = srcBill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject withholdingBillEntry : withholdingBillEntrys) {
                Long srcOfTgtBillExpenseId = (Long)withholdingBillEntry.getPkValue();
                DynamicObject publicReimburseBill = (DynamicObject)publicreimBillEntryRows.get(srcOfTgtBillExpenseId);
                if (publicReimburseBill == null) continue;
                DynamicObjectCollection offRows = publicReimburseBill.getDynamicObjectCollection("withholdingentry");
                boolean isExist = false;
                for (DynamicObject row : offRows) {
                    Long sourceentryid = row.getLong("whsrcentryid");
                    Long withholdingBillExpensePk = (Long)withholdingBillEntry.getPkValue();
                    if (sourceentryid == null || withholdingBillExpensePk == null || sourceentryid.compareTo(withholdingBillExpensePk) != 0) continue;
                    isExist = true;
                }
                if (isExist) continue;
                DynamicObject offRow = this.createWithholdinRow(withholdingBillEntry, withholdingBillTableId);
                offRow.set("seq", (Object)(offRows.size() + 1));
                offRows.add((Object)offRow);
            }
        }
    }

    private DynamicObject createWithholdinRow(DynamicObject withholdingBillEntry, Long withholdingBillTableId) {
        DynamicObject entryRow = new DynamicObject((DynamicObjectType)this.withholdingEntryType);
        DynamicObject withholdingBill = (DynamicObject)withholdingBillEntry.getParent();
        String billno = withholdingBill.getString("billno");
        DynamicObject entrycostdept = withholdingBillEntry.getDynamicObject("entrycostdept");
        DynamicObject entrycostcompany = withholdingBillEntry.getDynamicObject("entrycostcompany");
        String applierName = withholdingBill.getDynamicObject("applier").getString("name");
        Date projApplyDate = withholdingBill.getDate("bizdate");
        String projDescription = withholdingBill.getString("description");
        DynamicObject projCurrency = withholdingBillEntry.getDynamicObject("entrycurrency");
        DynamicObject projExpenseitem = withholdingBillEntry.getDynamicObject("expenseitem");
        BigDecimal exchangerate = withholdingBillEntry.getBigDecimal("exchangerate");
        BigDecimal orgiExpeBalanceAmount = withholdingBillEntry.getBigDecimal("orgiexpebalanceamount");
        BigDecimal curExpeBalanceAmount = withholdingBillEntry.getBigDecimal("expebalanceamount");
        String expquotetype = withholdingBillEntry.getString("expquotetype");
        String entrywltype = withholdingBillEntry.getString("entrywltype");
        DynamicObject entrywlunit = withholdingBillEntry.getDynamicObject("entrywlunit");
        entryRow.set("whsrcbilltype", (Object)"er_withholdingbill");
        entryRow.set("whbillpayertype", (Object)entrywltype);
        entryRow.set("whbillpayerid", (Object)entrywlunit);
        entryRow.set("whentrycostdeptid", (Object)entrycostdept);
        entryRow.set("whentrycostcompanyid", (Object)entrycostcompany);
        entryRow.set("withholdingbillno", (Object)billno);
        entryRow.set("whpayername", (Object)applierName);
        entryRow.set("whbizdate", (Object)projApplyDate);
        entryRow.set("whdescription", (Object)projDescription);
        entryRow.set("whcurrency", (Object)projCurrency);
        entryRow.set("whexchangerate", (Object)exchangerate);
        entryRow.set("orgiwhbalanceamount", (Object)orgiExpeBalanceAmount);
        entryRow.set("whbalanceamount", (Object)curExpeBalanceAmount);
        entryRow.set("whbursedamount", (Object)orgiExpeBalanceAmount);
        entryRow.set("whbursedcurramount", (Object)curExpeBalanceAmount);
        entryRow.set("whsrcbillid", withholdingBill.getPkValue());
        entryRow.set("whsrcentryid", withholdingBillEntry.getPkValue());
        entryRow.set("whitemid", (Object)projExpenseitem);
        entryRow.set("whquotetype", (Object)expquotetype);
        entryRow.set("withholdingtype", (Object)withholdingBill.getDynamicObject("withholdingtype"));
        DynamicObjectCollection offLinkRows = entryRow.getDynamicObjectCollection("withholdingentry_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("withholdingentry_lk_stableid", (Object)withholdingBillTableId);
        offLinkRow.set("withholdingentry_lk_sbillid", withholdingBill.getPkValue());
        offLinkRow.set("withholdingentry_lk_sid", withholdingBillEntry.getPkValue());
        offLinkRows.add((Object)offLinkRow);
        return entryRow;
    }
}

