/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.up;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class UpDrawConnContractMobPlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener,
RowClickEventListener {
    private static final String entry = "billlistap";
    private static Log logger = LogFactory.getLog(UpDrawConnContractMobPlugin.class);

    public void initialize() {
        super.initialize();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (ErEntityTypeUtils.isContractBill((String)parentView.getEntityId())) {
            QFilter selectedEntryQfilter = new QFilter("detailtype", "=", (Object)"biztype_applybill").and("billstatus", "in", (Object)new Object[]{"E", "F"});
            DynamicObject applier = (DynamicObject)parentView.getModel().getValue("applier");
            QFilter userF = new QFilter("projectower.FBASEDATAID_id", "in", applier.getPkValue()).or("applier", "=", applier.getPkValue());
            selectedEntryQfilter.and(userF);
            BillList billList = (BillList)this.getControl(entry);
            billList.setFilter(selectedEntryQfilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "confrim", entry});
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList list = (BillList)this.getControl(entry);
        IFormView pView = this.getView().getParentView();
        ArrayList<Integer> selectIndex = new ArrayList<Integer>();
        DynamicObjectCollection existConn = pView.getModel().getEntryEntity("contractrelation");
        ListSelectedRowCollection allRows = list.getCurrentListAllRowCollection();
        if (existConn == null || allRows == null) {
            return;
        }
        List existNos = existConn.stream().map(conn -> (String)conn.get("basedatabillno")).collect(Collectors.toList());
        for (ListSelectedRow row : allRows) {
            int index = row.getRowKey();
            String billNo = row.getBillNo();
            if (!existNos.contains(billNo)) continue;
            selectIndex.add(index);
        }
        int[] indexes = selectIndex.stream().mapToInt(Integer::valueOf).toArray();
        list.selectRows(indexes);
    }

    public void beforeClick(BeforeClickEvent evt) {
        IFormView pView;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("confrim") && (pView = this.getView().getParentView()) != null) {
            pView.getModel().deleteEntryData("contractrelation");
            logger.info("----\u6e05\u7a7a\u5173\u8054\u5408\u540c\u5206\u5f55\u539f\u6709\u6570\u636e----");
            pView.getModel().setValue("contractsconn", (Object)"");
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control menuItem = (Control)evt.getSource();
        switch (key = menuItem.getKey()) {
            case "confrim": {
                BillList list = (BillList)this.getControl(entry);
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                IFormView pView = this.getView().getParentView();
                this.getView().returnDataToParent((Object)selectedRows);
                this.getView().sendFormAction(pView);
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String serch = mobileSearchTextChangeEvent.getText();
        BillList billList = (BillList)this.getControl(entry);
        String searchFile = "contractcode";
        if (StringUtils.isBlank((CharSequence)serch)) {
            billList.refreshData();
        } else {
            billList.getQueryFilterParameter().getQFilters().add(new QFilter(searchFile, "like", (Object)("%" + serch + "%")));
            billList.refreshData();
        }
    }
}

