/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.up;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class UpDrawPrepayList
extends AbstractListPlugin {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCustomParam("ismergerows", (Object)Boolean.FALSE);
    }

    public void setFilter(SetFilterEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            DynamicObject costcompany;
            DynamicObject company;
            String billpayertype;
            DynamicObject billpayerid;
            IDataModel parentModel = parentView.getModel();
            String entityId = parentView.getEntityId();
            DynamicObject applier = (DynamicObject)parentModel.getValue("applier");
            List selectedProjEntryIDs = parentModel.getEntryEntity("writeoffmoney").stream().map(r -> r.getLong("sourceentryid")).collect(Collectors.toList());
            QFilter selectedEntryQfilter = new QFilter("expenseentryentity.id", "not in", selectedProjEntryIDs);
            boolean isCheckingPayBill = ErEntityTypeUtils.isCheckingpayBill((String)entityId);
            if (isCheckingPayBill) {
                billpayerid = (DynamicObject)parentModel.getValue("payer");
                billpayertype = (String)parentModel.getValue("payertype");
                company = (DynamicObject)parentModel.getValue("appliercompany");
                costcompany = (DynamicObject)parentModel.getValue("company");
                ActionLocalCache.get().put("setFilter.entityId", (Object)entityId);
            } else {
                billpayerid = (DynamicObject)parentModel.getValue("billpayerid");
                billpayertype = (String)parentModel.getValue("billpayertype");
                company = (DynamicObject)parentModel.getValue("company");
                costcompany = (DynamicObject)parentModel.getValue("costcompany");
            }
            Set<Long> ids = new HashSet<Long>();
            if (StringUtils.equalsAny((CharSequence)billpayertype, (CharSequence[])new CharSequence[]{"bd_supplier", "bd_customer"})) {
                Long billpayer_masterid;
                Long l = billpayer_masterid = billpayerid != null ? (Long)billpayerid.get("masterid") : null;
                if (billpayer_masterid != null) {
                    ids = QueryServiceHelper.query((String)billpayertype, (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)billpayer_masterid)}).stream().filter(dynamicObject -> dynamicObject.get("id") != null).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
                }
            } else {
                Long billpayer_id = billpayerid != null ? (Long)billpayerid.get("id") : null;
                ids.add(billpayer_id);
            }
            String bindEntityId = this.getView().getPageCache().get("bindEntityId");
            if (isCheckingPayBill) {
                long currencyId = parentModel.getValue("currency") == null ? 0L : ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
                selectedEntryQfilter.and("expenseentryentity.entrycurrency", "=", (Object)currencyId);
                selectedEntryQfilter.and("currency", "=", (Object)currencyId);
            }
            if (ids.size() > 0) {
                if (isCheckingPayBill && ErEntityTypeUtils.isPrePayBill((String)bindEntityId) && SystemParamterUtil.getIsTripUpFilterBySupplier((Long)ErCommonUtils.getPk((Object)company)).booleanValue()) {
                    selectedEntryQfilter.and("billpayerid", "in", ids);
                } else if (!isCheckingPayBill && ErEntityTypeUtils.isPrePayBill((String)bindEntityId)) {
                    selectedEntryQfilter.and("billpayerid", "in", ids);
                }
            }
            if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                String detailtype = (String)parentModel.getValue("detailtype");
                String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
                if ("biztype_project".equals(detailtype) && "2".equals(applyprojectbillRelated)) {
                    selectedEntryQfilter.and("expenseentryentity.wbsrcbilltype", "=", (Object)"er_applyprojectbill");
                    DynamicObjectCollection expenseEntrys = parentModel.getEntryEntity("expenseentryentity");
                    Set projectNoList = expenseEntrys.stream().map(exp -> exp.getString("entryprojectno")).collect(Collectors.toSet());
                    selectedEntryQfilter.and("expenseentryentity.wbsrcbillno", "in", projectNoList);
                }
            }
            QFilter qFilter = PublicUpBillUtil.getPublicUpBillQfilter((Long)ErCommonUtils.getPk((Object)applier), (Long)ErCommonUtils.getPk((Object)company), (Long)ErCommonUtils.getPk((Object)costcompany), (String)"costcompany");
            Optional.ofNullable(qFilter).ifPresent(arg_0 -> ((QFilter)selectedEntryQfilter).and(arg_0));
            e.setSpecialDataPermQFilter(null);
            e.addCustomQFilter(selectedEntryQfilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        BillList source = (BillList)args.getSource();
        String bindEntity = source.getEntityType().getName();
        this.putCacheEntityId(bindEntity);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    private void putCacheEntityId(String bindEntity) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("bindEntityId", bindEntity);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            boolean isSame;
            IListView view = (IListView)this.getView();
            IPageCache pageCache = view.getPageCache();
            String bindEntityId = pageCache.get("bindEntityId");
            if (bindEntityId == null) {
                return;
            }
            if (MetadataServiceHelper.getDataEntityType((String)bindEntityId).getProperty("billpayerid") == null) {
                return;
            }
            ListSelectedRowCollection lists = view.getSelectedRows();
            Long[] enttyIds = null;
            if (lists != null) {
                enttyIds = (Long[])lists.stream().map(row -> row.getEntryPrimaryKeyValue()).distinct().toArray(Long[]::new);
            }
            QFilter entryQfilter = new QFilter("expenseentryentity.id", "in", enttyIds);
            DynamicObjectCollection wlunits = QueryServiceHelper.query((String)bindEntityId, (String)"billpayerid.masterid", (QFilter[])new QFilter[]{entryQfilter});
            boolean bl = isSame = wlunits.stream().map(row -> row.get(0)).distinct().count() == 1L;
            if (!isSame) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UpDrawPrepayList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (wlunits.size() > 0) {
                ErCommonUtils.setDealUnit((IFormView)view.getParentView(), (Long)((Long)((DynamicObject)wlunits.get(0)).get(0)));
            }
        }
    }
}

