/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.up;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;

public class UpDrawPrepayMobList
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener,
RowClickEventListener {
    private static final String entry = "billlistap";
    private static Log logger = LogFactory.getLog(UpDrawPrepayMobList.class);

    public void initialize() {
        super.initialize();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel parentModel = parentView.getModel();
            DynamicObject applier = (DynamicObject)parentModel.getValue("applier");
            List selectedProjEntryIDs = parentModel.getEntryEntity("writeoffmoney").stream().map(r -> r.getLong("sourceentryid")).collect(Collectors.toList());
            QFilter selectedEntryQfilter = new QFilter("expenseentryentity.id", "not in", selectedProjEntryIDs).and("billstatus", "=", (Object)"G").and("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO);
            DynamicObject billpayerid = (DynamicObject)parentModel.getValue("billpayerid");
            String billpayertype = (String)parentModel.getValue("billpayertype");
            Set<Long> ids = new HashSet<Long>();
            if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)billpayertype, (CharSequence[])new CharSequence[]{"bd_supplier", "bd_customer"})) {
                Long billpayer_masterid;
                Long l = billpayer_masterid = billpayerid != null ? (Long)billpayerid.get("masterid") : null;
                if (billpayer_masterid != null) {
                    ids = QueryServiceHelper.query((String)billpayertype, (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)billpayer_masterid)}).stream().filter(dynamicObject -> dynamicObject.get("id") != null).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
                }
            } else {
                Long billpayer_id = billpayerid != null ? (Long)billpayerid.get("id") : null;
                ids.add(billpayer_id);
            }
            if (ids.size() > 0) {
                selectedEntryQfilter.and("billpayerid", "in", ids);
            }
            if (ErEntityTypeUtils.isPublicReimburseBill((String)parentView.getEntityId())) {
                String detailtype = (String)parentModel.getValue("detailtype");
                String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
                if ("biztype_project".equals(detailtype) && "2".equals(applyprojectbillRelated)) {
                    selectedEntryQfilter.and("expenseentryentity.wbsrcbilltype", "=", (Object)"er_applyprojectbill");
                    DynamicObjectCollection expenseEntrys = parentModel.getEntryEntity("expenseentryentity");
                    Set projectNoList = expenseEntrys.stream().map(exp -> exp.getString("entryprojectno")).collect(Collectors.toSet());
                    selectedEntryQfilter.and("expenseentryentity.wbsrcbillno", "in", projectNoList);
                }
            }
            QFilter qFilter = PublicUpBillUtil.getPublicUpBillQfilter((Long)ErCommonUtils.getPk((Object)applier), (Long)ErCommonUtils.getPk((Object)parentModel.getValue("company")), (Long)ErCommonUtils.getPk((Object)parentModel.getValue("costcompany")), (String)"costcompany");
            Optional.ofNullable(qFilter).ifPresent(arg_0 -> ((QFilter)selectedEntryQfilter).and(arg_0));
            BillList billList = (BillList)this.getControl(entry);
            billList.setFilter(selectedEntryQfilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "confrim", "cardflexpanelap8", entry});
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        this.addClickListeners(new String[]{entry});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control menuItem = (Control)evt.getSource();
        switch (key = menuItem.getKey()) {
            case "confrim": {
                BillList list = (BillList)this.getControl(entry);
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                IFormView pView = this.getView().getParentView();
                if (!this.checkUnit(evt, list.getSelectedRows())) break;
                this.getView().returnDataToParent((Object)selectedRows);
                this.getView().sendFormAction(pView);
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String serch = mobileSearchTextChangeEvent.getText();
        BillList billList = (BillList)this.getControl(entry);
        if (StringUtils.isBlank((CharSequence)serch)) {
            billList.refreshData();
        } else {
            billList.getQueryFilterParameter().getQFilters().add(new QFilter("billno", "like", (Object)("%" + serch + "%")).or(new QFilter("description", "like", (Object)("%" + serch + "%"))).or(new QFilter("billpayerid.name", "like", (Object)("%" + serch + "%"))).or(new QFilter("applier.name", "like", (Object)("%" + serch + "%"))));
            billList.refreshData();
        }
    }

    public boolean checkUnit(EventObject evt, ListSelectedRowCollection selectedRows) {
        boolean isSame;
        IFormView view = this.getView();
        String bindEntityId = ((BillList)this.getControl(entry)).getEntityId();
        if (bindEntityId == null) {
            return false;
        }
        if (selectedRows == null || selectedRows.isEmpty()) {
            return true;
        }
        String selectFieIds = "billpayerid";
        Long[] entityIds = (Long[])selectedRows.stream().map(row -> row.getEntryPrimaryKeyValue()).distinct().toArray(Long[]::new);
        QFilter entryQfilter = new QFilter("expenseentryentity.id", "in", (Object)entityIds);
        DynamicObjectCollection wlunits = QueryServiceHelper.query((String)bindEntityId, (String)selectFieIds, (QFilter[])new QFilter[]{entryQfilter});
        boolean bl = isSame = wlunits.stream().map(row -> row.get(0)).distinct().count() == 1L;
        if (!isSame) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UpDrawProjOrContMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (wlunits.size() > 0) {
            ErCommonUtils.setDealUnit((IFormView)view.getParentView(), (Long)((Long)((DynamicObject)wlunits.get(0)).get(0)));
        }
        return true;
    }
}

