/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.up;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;

public class UpDrawProjectList
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(UpDrawProjectList.class);

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCustomParam("ismergerows", (Object)Boolean.FALSE);
    }

    public void setFilter(SetFilterEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String billPayerType;
            QFilter qFilter;
            String formId = parentView.getEntityId();
            IDataModel parentModel = parentView.getModel();
            if (parentModel == null) {
                return;
            }
            String entrysourceId = null;
            DynamicObjectCollection expCollection = null;
            Object bizQFilter = null;
            String detailtype = "";
            String reimbursetype = "";
            Long billpayerid = null;
            Long costCompany = ErCommonUtils.getPk((Object)parentModel.getValue("costcompany"));
            Long company = ErCommonUtils.getPk((Object)parentModel.getValue("company"));
            Long applierId = ErCommonUtils.getPk((Object)parentModel.getValue("applier"));
            Long currency = ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
            boolean isFilterSup = this.isFilterSup(parentView);
            if (ErEntityTypeUtils.isPublicReimburseBill((String)formId)) {
                Object payer = parentView.getModel().getValue("billpayerid");
                if (payer == null && isFilterSup) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"UpDrawProjectList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                billpayerid = ErCommonUtils.getPk((Object)parentModel.getValue("billpayerid"));
                entrysourceId = "wbsrcentryid";
                expCollection = parentModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                detailtype = parentModel.getValue("detailtype") != null ? (String)parentModel.getValue("detailtype") : "";
                reimbursetype = parentModel.getValue("reimbursetype").toString();
            } else if (ErEntityTypeUtils.isPrePayBill((String)formId)) {
                billpayerid = ErCommonUtils.getPk((Object)parentModel.getValue("billpayerid"));
                entrysourceId = "wbsrcentryid";
                expCollection = parentModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
            } else if (parentModel != null && ErEntityTypeUtils.isCostEstimateBill((String)formId)) {
                entrysourceId = "wbsrcentryid";
                expCollection = parentModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
            }
            String finalEntrysourceId = entrysourceId;
            Long[] entrySourceIds = null;
            if (expCollection != null) {
                entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong(finalEntrysourceId)).distinct().toArray(Long[]::new);
            }
            QFilter selectedEntryQfilter = new QFilter("expenseentryentity.id", "not in", entrySourceIds);
            String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
            if (ErEntityTypeUtils.isPublicReimburseBill((String)formId)) {
                if ("biztype_project".equals(detailtype) && !"2".equals(applyprojectbillRelated)) {
                    qFilter = UpDrawProjectList.getOnWayPrepayBillFilter();
                    if (qFilter != null) {
                        selectedEntryQfilter.and(qFilter);
                    }
                    if ((qFilter = UpDrawProjectList.getOnWayLoanBillFilter()) != null) {
                        selectedEntryQfilter.and(qFilter);
                    }
                    if ((qFilter = UpDrawProjectList.getOnWayContractBillFilter()) != null) {
                        selectedEntryQfilter.and(qFilter);
                    }
                }
            } else if (ErEntityTypeUtils.isPrePayBill((String)formId)) {
                selectedEntryQfilter.and(this.getPrePayBillFilter());
                if (!"2".equals(applyprojectbillRelated) && (qFilter = UpDrawProjectList.getOnWayContractBillFilter()) != null) {
                    selectedEntryQfilter.and(qFilter);
                }
            }
            QFilter qFiltertype = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (parentModel.getProperty("billpayertype") != null && (billPayerType = (String)parentModel.getValue("billpayertype")) != null) {
                qFiltertype = new QFilter("expenseentryentity.entrywltype", "=", (Object)billPayerType);
            }
            if (!isFilterSup) {
                qFiltertype = qFiltertype.or(new QFilter("expenseentryentity.entrywltype", "=", (Object)" "));
            }
            Optional.ofNullable(qFiltertype).ifPresent(arg_0 -> ((QFilter)selectedEntryQfilter).and(arg_0));
            RefObject sysParamValue = new RefObject();
            Optional.ofNullable(company).ifPresent(t -> sysParamValue.setValue((Object)SystemParamterUtil.getPublicupbillrange((Long)t)));
            QFilter qFilter2 = PublicUpBillUtil.getPublicUpBill((String)formId, (Long)billpayerid, (Long)applierId, (Long)company, (Long)costCompany, (String)detailtype, (String)reimbursetype, (boolean)this.isFilterSup(parentView));
            qFilter2.and("currency", "=", (Object)currency);
            Optional.ofNullable(qFilter2).ifPresent(arg_0 -> ((QFilter)selectedEntryQfilter).and(arg_0));
            Optional.ofNullable(bizQFilter).ifPresent(arg_0 -> ((QFilter)selectedEntryQfilter).and(arg_0));
            e.setSpecialDataPermQFilter(null);
            e.addCustomQFilter(selectedEntryQfilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        BillList source = (BillList)args.getSource();
        String bindEntity = source.getEntityType().getName();
        this.putCacheEntityId(bindEntity);
        String entityId = parentView.getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"orgiexpebalanceamount", "expebalanceamount,std_project,entrywlunit"});
            view.setVisible(Boolean.valueOf(false), new String[]{"canloanamount", "canloancurramount"});
        }
        view.setVisible(Boolean.valueOf(false), new String[]{"wbsrcbilltype"});
    }

    private void putCacheEntityId(String bindEntity) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("bindEntityId", bindEntity);
    }

    private boolean isFilterSup(IFormView parentView) {
        try {
            Long company = ErCommonUtils.getPk((Object)parentView.getModel().getValue("company"));
            return SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static QFilter getOnWayPrepayBillFilter() {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid", "expenseentryentity.wbsrcbilltype");
        DynamicObject[] prepayBills = BusinessDataServiceHelper.load((String)"er_prepaybill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbilltype", "=", (Object)"er_applyprojectbill"), new QFilter("expenseentryentity.wbsrcbillid", ">", (Object)0)});
        String OnWayCondition = "B,C,E,F";
        List collect = Arrays.stream(prepayBills).filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    public static QFilter getOnWayLoanBillFilter() {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.sourceentryid", "expenseentryentity.sourcebillid");
        DynamicObject[] loanBills = BusinessDataServiceHelper.load((String)"er_dailyloanbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.sourcebillid", ">", (Object)0)});
        String OnWayCondition = "B,C,E,F";
        List collect = Arrays.stream(loanBills).filter(loanBillOnWay -> OnWayCondition.contains(loanBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("sourceentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    private QFilter getPrePayBillFilter() {
        QFilter filter = QFilter.of((String)"expenseentryentity.wbsrcbilltype != detailtype", (Object[])new Object[0]);
        return filter;
    }

    public static QFilter getOnWayContractBillFilter() {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "projectentryentity.id", "projectentryentity.sourcebillid");
        DynamicObject[] prepayBills = BusinessDataServiceHelper.load((String)"er_contractbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("projectentryentity.sourcebillid", ">", (Object)0)});
        String OnWayCondition = "B,C";
        List collect = Arrays.stream(prepayBills).filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("projectentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("sourcebillid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("id", "not in", collect);
        }
        return filter;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            IListView view = (IListView)this.getView();
            IFormView pView = this.getView().getParentView();
            if (pView != null && !ErEntityTypeUtils.isCostEstimateBill((String)pView.getEntityId()) && !ErEntityTypeUtils.isContractBill((String)pView.getEntityId())) {
                boolean isSame;
                IPageCache pageCache = view.getPageCache();
                String bindEntityId = pageCache.get("bindEntityId");
                if (bindEntityId == null) {
                    return;
                }
                ListSelectedRowCollection lists = view.getSelectedRows();
                if (lists.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"UpDrawProjectList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Long[] enttyIds = null;
                if (lists != null) {
                    enttyIds = (Long[])lists.stream().map(row -> row.getEntryPrimaryKeyValue()).distinct().toArray(Long[]::new);
                }
                QFilter entryQfilter = new QFilter("expenseentryentity.id", "in", enttyIds);
                DynamicObjectCollection wlunits = QueryServiceHelper.query((String)bindEntityId, (String)"expenseentryentity.entrywlunit", (QFilter[])new QFilter[]{entryQfilter});
                boolean bl = isSame = wlunits.stream().map(row -> row.get(0)).distinct().count() == 1L;
                if (!isSame) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UpDrawProjectList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (wlunits.size() > 0) {
                    ErCommonUtils.setDealUnit((IFormView)view.getParentView(), (Long)((Long)((DynamicObject)wlunits.get(0)).get(0)));
                }
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }
}

