/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.AmountUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplyProjectBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static Log logger = LogFactory.getLog(ApplyProjectBillWriteBackPlugin.class);
    private Object tarbillid;
    private String tarformid;
    private String detailtype;

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        if (e.getTargetEntity() == null || e.getTargetActiveRow() == null) {
            logger.info("\u53d8\u66f4\u5355\u53cd\u5199>>>>>>>>>>>afterCommitAmount1-return");
            return;
        }
        if (this.tarformid == null) {
            this.tarformid = this.getTargetSubMainType().getName();
        }
        if (this.tarbillid == null) {
            this.tarbillid = e.getTargetActiveRow().getParent() == null ? e.getTargetActiveRow().getPkValue() : ((DynamicObject)e.getTargetActiveRow().getParent()).getPkValue();
        }
        if (this.detailtype == null) {
            this.detailtype = e.getTargetActiveRow().getParent() == null ? (String)e.getTargetActiveRow().get("detailtype") : (String)((DynamicObject)e.getTargetActiveRow().getParent()).get("detailtype");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        logger.info("\u53d8\u66f4\u5355\u53cd\u5199>>>>>>>>>>>afterSaveSourceBill");
        if (this.tarformid == null || this.tarbillid == null) {
            return;
        }
        this.getCurrLinkSetItem();
        if (!"biztype_changebill".equals(this.detailtype)) {
            return;
        }
        logger.info("\u53d8\u66f4\u5355\u53cd\u5199\u5f00\u59cb\uff1a{}" + this.tarbillid + ">>>>>>>>>>>>>>tarformid:" + this.tarformid);
        DynamicObject tarObj = BusinessDataServiceHelper.loadSingle((Object)this.tarbillid, (String)this.tarformid);
        DynamicObject srcDataEntity = e.getSrcDataEntities()[0];
        if (tarObj.getDynamicObjectType().getProperty("detailtype") == null) {
            return;
        }
        Object[] srcObjIds = Arrays.stream(e.getSrcDataEntities()).map(DataEntityBase::getPkValue).toArray();
        List<DynamicObject> srcObjs = Arrays.asList((DynamicObject[])BusinessDataServiceHelper.load((Object[])srcObjIds, (IDataEntityType)tarObj.getDataEntityType()));
        for (DynamicObject srcObj : srcObjs) {
            List<DynamicObject> newEntrys = tarObj.getDynamicObjectCollection("expenseentryentity").stream().filter(t -> StringUtils.equals((CharSequence)t.getString("itemfrom"), (CharSequence)ItemFrom.Manual.getValue())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(newEntrys)) {
                this.writeBackChangeBillNewEntrys(srcObj, newEntrys);
            }
            DynamicObjectCollection projectowers = tarObj.getDynamicObjectCollection("projectower");
            ArrayList<DynamicObject> addprojectowers = new ArrayList<DynamicObject>(5);
            for (DynamicObject projectower : projectowers) {
                DynamicObjectType dynamicObjectType = (DynamicObjectType)projectower.getDataEntityType();
                DynamicObject d = new DynamicObject(dynamicObjectType);
                d.set("fbasedataid", projectower.get("fbasedataid"));
                d.set("fbasedataid_id", projectower.get("fbasedataid_id"));
                addprojectowers.add(d);
            }
            srcObj.set("projectower", addprojectowers);
            int changetimes = srcObj.getInt("changetimes");
            srcObj.set("changetimes", (Object)(changetimes + 1));
        }
        SaveServiceHelper.save((DynamicObject[])srcObjs.toArray(new DynamicObject[0]));
    }

    private void writeBackChangeBillNewEntrys(DynamicObject srcObj, List<DynamicObject> newEntrys) {
        ArrayList<DynamicObject> addEntrys = new ArrayList<DynamicObject>(5);
        BigDecimal changeAmount = BigDecimal.ZERO;
        ArrayList<String> notCopyPropNames = new ArrayList<String>(5);
        notCopyPropNames.add("id");
        notCopyPropNames.add("entryapplyprojectamount");
        notCopyPropNames.add("entrychangeableamount");
        notCopyPropNames.add("expenseamount");
        notCopyPropNames.add("currexpenseamount");
        notCopyPropNames.add("expeapproveamount");
        notCopyPropNames.add("expeapprovecurramount");
        notCopyPropNames.add("taxrate");
        notCopyPropNames.add("taxamount");
        notCopyPropNames.add("orientryamount");
        notCopyPropNames.add("price");
        for (DynamicObject newEntry : newEntrys) {
            EntryType dataEntityType = (EntryType)newEntry.getDataEntityType();
            DynamicObject d = new DynamicObject((DynamicObjectType)dataEntityType);
            for (IDataEntityProperty property : dataEntityType.getProperties()) {
                if (notCopyPropNames.contains(property.getName())) continue;
                d.set(property, newEntry.get(property));
            }
            d.set("seq", (Object)(srcObj.getDynamicObjectCollection("expenseentryentity").size() + addEntrys.size() + 1));
            d.set("canloanamount", newEntry.get("expeapproveamount"));
            d.set("canloancurramount", newEntry.get("expeapprovecurramount"));
            d.set("orgiexpebalanceamount", newEntry.get("expeapproveamount"));
            d.set("expebalanceamount", newEntry.get("expeapprovecurramount"));
            d.set("changetaxamount", newEntry.get("taxamount"));
            d.set("changeorientryamount", newEntry.get("orientryamount"));
            d.set("entryorichangeamount", newEntry.get("expeapproveamount"));
            d.set("entrychangeamount", newEntry.get("expeapprovecurramount"));
            d.set("changeprice", newEntry.get("price"));
            d.set("changecurprice", newEntry.get("curprice"));
            d.set("curprice", (Object)BigDecimal.ZERO);
            d.set("approvetax", (Object)BigDecimal.ZERO);
            d.set("actaxamount", newEntry.get("taxamount"));
            d.set("acorientryamount", newEntry.get("orientryamount"));
            d.set("acexpeapproveamount", newEntry.get("expeapproveamount"));
            d.set("acexpeapprovecurramount", newEntry.get("expeapprovecurramount"));
            d.set("acprice", newEntry.get("price"));
            d.set("accurprice", newEntry.get("curprice"));
            changeAmount = changeAmount.add(newEntry.getBigDecimal("expeapprovecurramount"));
            addEntrys.add(d);
        }
        srcObj.getDynamicObjectCollection("expenseentryentity").addAll(addEntrys);
        srcObj.set("billcanloanamount", (Object)srcObj.getBigDecimal("billcanloanamount").add(changeAmount));
        srcObj.set("balanceamount", (Object)srcObj.getBigDecimal("balanceamount").add(changeAmount));
        srcObj.set("changeamount", (Object)srcObj.getBigDecimal("changeamount").add(changeAmount));
        srcObj.set("acapproveamount", (Object)srcObj.getBigDecimal("acapproveamount").add(changeAmount));
        if (srcObj.containsProperty("notpayamount")) {
            BigDecimal notpayamount = srcObj.getBigDecimal("notpayamount").add(changeAmount);
            srcObj.set("notpayamount", (Object)notpayamount);
            if (srcObj.containsProperty("availableamount") && srcObj.containsProperty("nonpayamount")) {
                srcObj.set("availableamount", (Object)notpayamount.subtract(srcObj.getBigDecimal("nonpayamount")));
            }
        }
        if (srcObj.containsProperty("contractamount")) {
            BigDecimal contractamount = AmountUtils.getEntryAmount((DynamicObjectCollection)srcObj.getDynamicObjectCollection("expenseentryentity"), (String)"expcontractamount");
            srcObj.set("contractamount", (Object)contractamount);
        }
        if (srcObj.containsProperty("cancontractamount")) {
            BigDecimal cancontractamount = AmountUtils.getEntryAmount((DynamicObjectCollection)srcObj.getDynamicObjectCollection("expenseentryentity"), (String)"expcancontractamount");
            srcObj.set("cancontractamount", (Object)cancontractamount);
        }
    }
}

