/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.wb;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import org.apache.commons.lang3.StringUtils;

public class ContractBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static Log logger = LogFactory.getLog(ContractBillWriteBackPlugin.class);
    private Object tarbillid;
    private String tarformid;

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        if (e.getTargetEntity() == null || e.getTargetActiveRow() == null) {
            return;
        }
        if (this.tarformid == null) {
            this.tarformid = this.getTargetSubMainType().getName();
        }
        if (this.tarbillid == null) {
            this.tarbillid = e.getTargetActiveRow().getParent() == null ? e.getTargetActiveRow().getPkValue() : ((DynamicObject)e.getTargetActiveRow().getParent()).getPkValue();
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        if (this.tarformid == null || this.tarbillid == null) {
            return;
        }
        DynamicObject tarObj = BusinessDataServiceHelper.loadSingle((Object)this.tarbillid, (String)this.tarformid);
        if (tarObj.getDynamicObjectType().getProperty("detailtype") == null) {
            return;
        }
        if (!"biztype_changebill".equals(tarObj.getString("detailtype"))) {
            return;
        }
        Object[] srcObjIds = Arrays.stream(e.getSrcDataEntities()).map(DataEntityBase::getPkValue).toArray();
        List<DynamicObject> srcObjs = Arrays.asList((DynamicObject[])BusinessDataServiceHelper.load((Object[])srcObjIds, (IDataEntityType)tarObj.getDataEntityType()));
        logger.info(">>>>>>>>>>>>>>>>>>>>>>>\u5408\u540c\u53d8\u66f4\u53cd\u5199\u5f00\u59cb>>>>>>srcObjs" + srcObjs.size());
        for (DynamicObject srcObj : srcObjs) {
            DynamicObjectCollection tarObjSource;
            DynamicObjectCollection source;
            List<DynamicObject> newEntrys = tarObj.getDynamicObjectCollection("expenseentryentity").stream().filter(t -> StringUtils.equals((CharSequence)t.getString("itemfrom"), (CharSequence)ItemFrom.Manual.getValue())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(newEntrys)) {
                this.writeBackChangeBillNewEntrys(srcObj, newEntrys);
            }
            DynamicObjectCollection projectowers = tarObj.getDynamicObjectCollection("projectower");
            ArrayList<DynamicObject> addprojectowers = new ArrayList<DynamicObject>(5);
            for (DynamicObject projectower : projectowers) {
                DynamicObjectType dynamicObjectType = (DynamicObjectType)projectower.getDataEntityType();
                DynamicObject d = new DynamicObject(dynamicObjectType);
                d.set("fbasedataid", projectower.get("fbasedataid"));
                d.set("fbasedataid_id", projectower.get("fbasedataid_id"));
                addprojectowers.add(d);
            }
            srcObj.set("projectower", addprojectowers);
            int changetimes = srcObj.getInt("changetimes");
            srcObj.set("changetimes", (Object)(changetimes + 1));
            if (tarObj.get("changetype") != null && ("D".equals(tarObj.get("changetype")) || "C".equals(tarObj.get("changetype")))) {
                source = srcObj.getDynamicObjectCollection("termentry");
                source.clear();
                tarObjSource = tarObj.getDynamicObjectCollection("termentry");
                for (DynamicObject item : tarObjSource) {
                    DynamicObjectType dynamicObjectType = (DynamicObjectType)item.getDataEntityType();
                    DynamicObject itemin = new DynamicObject(dynamicObjectType);
                    itemin.set("itemcode", item.get("itemcode"));
                    itemin.set("itemname", item.get("itemname"));
                    itemin.set("itemcontent", item.get("itemcontent"));
                    source.add((Object)itemin);
                }
            }
            if (tarObj.get("changetype") != null && ("D".equals(tarObj.get("changetype")) || "C".equals(tarObj.get("changetype")))) {
                source = srcObj.getDynamicObjectCollection("contractpartyentry");
                source.clear();
                tarObjSource = tarObj.getDynamicObjectCollection("contractpartyentry");
                ArrayList unwriteback = Lists.newArrayList((Object[])new String[]{"id", "srcpartcentryid", "partentryfrom"});
                for (DynamicObject item : tarObjSource) {
                    DynamicObjectType dynamicObjectType = (DynamicObjectType)item.getDataEntityType();
                    DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                    DynamicObject itemin = new DynamicObject(dynamicObjectType);
                    for (IDataEntityProperty property : properties) {
                        if (unwriteback.contains(property.getName())) continue;
                        itemin.set(property.getName(), item.get(property.getName()));
                    }
                    source.add((Object)itemin);
                }
            }
            srcObj.set("parta", tarObj.get("parta"));
            srcObj.set("partatypenew", (Object)tarObj.getString("partatypenew"));
            srcObj.set("partanew", tarObj.get("partanew"));
            srcObj.set("partbtype", (Object)tarObj.getString("partbtype"));
            srcObj.set("partb", tarObj.get("partb"));
            srcObj.set("partother", (Object)tarObj.getString("partother"));
            srcObj.set("partanews", (Object)tarObj.getString("partanews"));
            srcObj.set("partbnews", (Object)tarObj.getString("partbnews"));
        }
        logger.info(">>>>>>>>>>>>>>>>>>>>>>>\u5408\u540c\u53d8\u66f4\u53cd\u5199\u7ed3\u675f>>>>>>srcObjs" + srcObjs.size());
        SaveServiceHelper.save((DynamicObject[])srcObjs.toArray(new DynamicObject[0]));
    }

    private void writeBackChangeBillNewEntrys(DynamicObject srcObj, List<DynamicObject> newEntrys) {
        ArrayList<DynamicObject> addEntrys = new ArrayList<DynamicObject>(5);
        BigDecimal changeAmount = BigDecimal.ZERO;
        BigDecimal changeOriAmount = BigDecimal.ZERO;
        BigDecimal changeorientryamount = BigDecimal.ZERO;
        ArrayList<String> notCopyPropNames = new ArrayList<String>(5);
        notCopyPropNames.add("id");
        notCopyPropNames.add("expenseamount");
        notCopyPropNames.add("currexpenseamount");
        notCopyPropNames.add("entrycontractamount");
        notCopyPropNames.add("entrychangeableamount");
        notCopyPropNames.add("taxrate");
        notCopyPropNames.add("taxamount");
        notCopyPropNames.add("orientryamount");
        for (DynamicObject newEntry : newEntrys) {
            EntryType dataEntityType = (EntryType)newEntry.getDataEntityType();
            DynamicObject d = new DynamicObject((DynamicObjectType)dataEntityType);
            for (IDataEntityProperty property : dataEntityType.getProperties()) {
                if (notCopyPropNames.contains(property.getName())) continue;
                d.set(property, newEntry.get(property));
            }
            d.set("seq", (Object)(srcObj.getDynamicObjectCollection("expenseentryentity").size() + addEntrys.size() + 1));
            d.set("canloanamount", newEntry.get("expenseamount"));
            d.set("canloancurramount", newEntry.get("currexpenseamount"));
            d.set("orgiexpebalanceamount", newEntry.get("expenseamount"));
            d.set("expebalanceamount", newEntry.get("currexpenseamount"));
            d.set("changetaxamount", newEntry.get("taxamount"));
            d.set("changeorientryamount", newEntry.get("orientryamount"));
            d.set("entryorichangeamount", newEntry.get("expenseamount"));
            d.set("entrychangeamount", newEntry.get("currexpenseamount"));
            d.set("actaxamount", newEntry.get("taxamount"));
            d.set("acorientryamount", newEntry.get("orientryamount"));
            BigDecimal acexpeapproveamount = newEntry.getBigDecimal("expenseamount").add(newEntry.getBigDecimal("entryorichangeamount"));
            d.set("acexpeapproveamount", (Object)acexpeapproveamount);
            BigDecimal acexpeapprovecurramount = newEntry.getBigDecimal("currexpenseamount").add(newEntry.getBigDecimal("entrychangeamount"));
            d.set("acexpeapprovecurramount", (Object)acexpeapprovecurramount);
            d.set("taxrate", newEntry.get("taxrate"));
            changeAmount = changeAmount.add(newEntry.getBigDecimal("currexpenseamount"));
            changeOriAmount = changeOriAmount.add(newEntry.getBigDecimal("expenseamount"));
            changeorientryamount = changeorientryamount.add(newEntry.getBigDecimal("orientryamount"));
            addEntrys.add(d);
        }
        logger.info(">>>>>>>>>>>>>>>>>>>>>>>\u5408\u540c\u53d8\u66f4\u53cd\u5199>>>>>>\u589e\u884c \u53d8\u66f4\u91d1\u989d\u672c\u4f4d\u5e01\u4e4b\u548cchangeAmount\uff1a" + changeAmount + " changeorientryamount:" + changeorientryamount);
        srcObj.getDynamicObjectCollection("expenseentryentity").addAll(addEntrys);
        srcObj.set("oricanloanamount", (Object)srcObj.getBigDecimal("oricanloanamount").add(changeOriAmount));
        srcObj.set("billcanloanamount", (Object)srcObj.getBigDecimal("billcanloanamount").add(changeAmount));
        srcObj.set("oribalanceamount", (Object)srcObj.getBigDecimal("oribalanceamount").add(changeOriAmount));
        srcObj.set("balanceamount", (Object)srcObj.getBigDecimal("balanceamount").add(changeAmount));
        srcObj.set("changeamount", (Object)srcObj.getBigDecimal("changeamount").add(changeAmount));
        srcObj.set("orinotpayamount", (Object)srcObj.getBigDecimal("orinotpayamount").add(changeOriAmount));
        srcObj.set("notpayamount", (Object)srcObj.getBigDecimal("notpayamount").add(changeAmount));
        srcObj.set("oriapplyamount", (Object)srcObj.getBigDecimal("oriapplyamount").add(changeOriAmount));
        srcObj.set("applyamount", (Object)srcObj.getBigDecimal("applyamount").add(changeAmount));
        srcObj.set("originalamount", (Object)srcObj.getBigDecimal("originalamount").add(changeorientryamount));
        srcObj.set("invoiceamountremain", (Object)srcObj.getBigDecimal("invoiceamountremain").add(changeAmount));
        if (srcObj.containsProperty("availableamount") && srcObj.containsProperty("nonpayamount")) {
            srcObj.set("availableamount", (Object)srcObj.getBigDecimal("notpayamount").subtract(srcObj.getBigDecimal("nonpayamount")));
        }
        if (srcObj.containsProperty("oriavailableamount") && srcObj.containsProperty("orinonpayamount")) {
            srcObj.set("oriavailableamount", (Object)srcObj.getBigDecimal("orinotpayamount").subtract(srcObj.getBigDecimal("orinonpayamount")));
        }
    }
}

