/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.report.ErAbstractReportList;
import kd.fi.er.formplugin.util.AbstractReportUtil;
import org.apache.commons.lang3.StringUtils;

public class ErLoanBillDsList
extends ErAbstractReportList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)"costcompany.name", (CharSequence)fieldName)) continue;
            AbstractReportUtil.initFilterColumn((FilterColumn)commonFilterColumn, (IFormView)this.getView());
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        long pk = (Long)view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject ds = BusinessDataServiceHelper.loadSingleFromCache((String)view.getBillFormId(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pk)});
        if (ds == null) {
            return;
        }
        String entityId = ds.getString("formid");
        switch (fieldName) {
            case "payamount": {
                args.setCancel(true);
                String appId = view.getFormShowParameter().getAppId();
                if ("exp".equals(appId) || "cexp".equals(appId) || "tra".equals(appId) || "kdem".equals(appId)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u4e91\u4e0b\uff0c\u6ca1\u6709\u67e5\u8be2\u4ed8\u6b3e\u5355\u7684\u6743\u9650\u3002", (String)"ErLoanBillDsList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            case "returnedamount": 
            case "usedamount": {
                args.setCancel(true);
                ArrayList downNodes = new ArrayList(BFTrackerServiceHelper.loadBillLinkDownNodes((String)entityId, (Long[])new Long[]{pk}, (boolean)true).values());
                if (downNodes.size() <= 0) {
                    this.showNotFoundData(null, (IFormView)view);
                    return;
                }
                downNodes.forEach(e -> e.getTNodes().entrySet().removeIf(entry -> !this.bizDownNodeCondi(fieldName, EntityMetadataCache.loadTableDefine((Long)((BFRowId)entry.getKey()).getMainTableId()).getEntityKey())));
                if (downNodes.stream().anyMatch(e -> e.getTNodes().size() == 0) && this.showNotFoundData(null, (IFormView)view)) {
                    return;
                }
                String jsonNodes = SerializationUtils.serializeToBase64(downNodes);
                String type = "lookdown";
                BotpDrawServiceUtil.showRelateBills((String)entityId, (String)ds.getString("billno"), (String)jsonNodes, (String)type, (IFormView)view);
            }
        }
    }

    protected boolean bizDownNodeCondi(String field, String entityId) {
        switch (field) {
            case "returnedamount": {
                return ErEntityTypeUtils.isRepaymentBill((String)entityId);
            }
            case "usedamount": {
                return ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isTripReimburseBill((String)entityId);
            }
            case "payamount": {
                return "cas_paybill".equalsIgnoreCase(entityId) || "cas_agentpaybill".equalsIgnoreCase(entityId);
            }
        }
        return false;
    }
}

