/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.amt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;

public class DeptAmtQueryDetailEntryPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    public void initialize() {
        super.initialize();
    }

    public void entryRowClick(RowClickEvent evt) {
        BigDecimal thisYearUsedAmount = (BigDecimal)this.getModel().getValue("thisYearUsedAmount", evt.getRow());
        if (BigDecimal.ZERO.compareTo(thisYearUsedAmount) < 0) {
            Object value = this.getModel().getValue("datayear", evt.getRow());
            this.showReimburseAmountUseDetail(evt.getRow(), Integer.parseInt(value.toString()));
        }
    }

    private void showReimburseAmountUseDetail(int rowindex, int year) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"EmployeeAmountQueryListMob_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("er_reimctl_usedetail_mb");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        Long deptId = ErCommonUtils.getPk((Object)this.getModel().getValue("deptid", rowindex));
        reimAmountBO.setCompanyId(deptId);
        QuotaCtrlUtil.genQuotaExpItem((QuotaAmountBO)reimAmountBO, (Long)ErCommonUtils.getPk((Object)this.getModel().getValue("expenseitemid", rowindex)));
        ArrayList<String> deptCltList = new ArrayList<String>();
        deptCltList.add("1");
        deptCltList.add("2");
        deptCltList.add("3");
        reimAmountBO.setEmpCtlBill(deptCltList);
        reimAmountBO.setDeptCtlBill(deptCltList);
        reimAmountBO.setHappenYear(Integer.valueOf(year));
        reimAmountBO.setUserOrDeptId(deptId);
        String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)deptId);
        Long currency = ErCommonUtils.getPk((Object)this.getModel().getValue("currency", rowindex));
        QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)currency, (Long)currency);
        showParameter.setCustomParam("isDeptAmount", (Object)true);
        showParameter.setCustomParam("reimAmountQueryBean", (Object)reimAmountBO);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        System.out.println(evt.getSource());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        System.out.println(evt.getSource());
    }

    public void afterCreateNewData(EventObject e) {
        String data;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (data = ReportDataProcessCenter.getData("amt.report.datas", parentView)) != null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            boolean year = formId.endsWith("_year");
            String termField = year ? "totalamount" : "thisTermAmount";
            String balanceField = year ? "thisYearUsedAmount" : "thisTermBalanceAmount";
            List chartDatas = (List)SerializationUtils.fromJsonString((String)data, List.class);
            if (!chartDatas.isEmpty()) {
                this.getModel().beginInit();
                int[] batchCreateNewEntryRow = this.getModel().batchCreateNewEntryRow("entryentity", chartDatas.size());
                for (int rowIndex = 0; rowIndex < chartDatas.size(); ++rowIndex) {
                    this.getModel().setValue("row", (Object)(rowIndex + 1), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("expenseitemname", ((Map)chartDatas.get(rowIndex)).get("expenseitem"), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("expenseitemid", ((Map)chartDatas.get(rowIndex)).get("expenseitemid"), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("reimburseamountctl", ((Map)chartDatas.get(rowIndex)).get("reimburseamountctlmethod"), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("currency", ((Map)chartDatas.get(rowIndex)).get("currency"), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("deptid", ((Map)chartDatas.get(rowIndex)).get("dept"), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("datayear", ((Map)chartDatas.get(rowIndex)).get("datayear"), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("thisterm", ((Map)chartDatas.get(rowIndex)).get(termField), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("thistermbalance", ((Map)chartDatas.get(rowIndex)).get(balanceField), batchCreateNewEntryRow[rowIndex]);
                    this.getModel().setValue("thisyearusedamount", ((Map)chartDatas.get(rowIndex)).get("thisYearUsedAmount"), batchCreateNewEntryRow[rowIndex]);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
    }
}

