/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.amt;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.control.Button;
import kd.bos.form.control.SegmentedControl;
import kd.bos.form.control.events.SegmentedControlSelectEvent;
import kd.bos.form.control.events.SegmentedControlSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptAmtContext;
import kd.fi.er.business.reportmb.datahandler.analysis.amt.DeptAmtReportDataHandler;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.report.mb.util.MBReportUtil;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;

public class DeptAmtQueryPageMobPlugin
extends AbstractMobFormPlugin
implements SegmentedControlSelectListener {
    private static final Log log = LogFactory.getLog(DeptAmtQueryPageMobPlugin.class);
    private static final String YEARFLEX = "yearflex";
    private static final String PERIODFLEX = "periodflex";
    private static final String filterPageId = "er_m_deptamtfilter";
    private List<Map<String, Object>> chartDatas = null;
    private static final String SEGMENTKEY = "segmentKey";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        SegmentedControl segmented = (SegmentedControl)this.getControl("segmented");
        if (segmented != null) {
            segmented.addSegmentedControlSelectListener((SegmentedControlSelectListener)this);
        }
        this.addClickListeners(new String[]{"filterpage", "filterpageicon"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = null;
        if (source instanceof Button) {
            key = ((Button)source).getKey();
        }
        if ("filterpage".equals(key) || "filterpageicon".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(filterPageId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, filterPageId));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (filterPageId.equals(closedCallBackEvent.getActionId())) {
            this.refreshPage();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.initFilterField(parentView);
            this.refreshPage();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("datafilter".equals(e.getProperty().getName())) {
            this.refreshPage();
        }
    }

    private void refreshPage() {
        DeptAmtContext reportCxt = new DeptAmtContext();
        Object dept = this.getModel().getValue("org");
        QFilter orgFilter = new QFilter("dept", "=", (Object)ErCommonUtils.getPk((Object)dept));
        Object expenseitemval = this.getModel().getValue("expenseitemval");
        if (expenseitemval instanceof DynamicObjectCollection && !((DynamicObjectCollection)expenseitemval).isEmpty()) {
            orgFilter.and(new QFilter("expenseitem", "in", ((DynamicObjectCollection)expenseitemval).stream().map(v -> v.get("fbasedataid_id")).collect(Collectors.toList())));
        }
        QFilter dataYearFilter = this.getDataYearFilter(reportCxt);
        QFilter auditFilter = new QFilter("auditstatus", "=", (Object)"1");
        QFilter isreimburseamountctlFilter = new QFilter("expenseitem.isreimburseamountctl", "=", (Object)"2");
        reportCxt.setQFilters(new QFilter[]{orgFilter, auditFilter, dataYearFilter, isreimburseamountctlFilter});
        Future<Object> doHandleProcessInFuture = ReportDataProcessCenter.doHandleProcessInFuture(this.getView(), (AbstractReportContext)reportCxt, "amt.report.datas", new DeptAmtReportDataHandler());
        try {
            this.chartDatas = (List)doHandleProcessInFuture.get();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e1) {
            throw new KDException((Throwable)e1, new ErrorCode("DeptAmtQueryPageMobPlugin", ""), new Object[0]);
        }
        this.selectTab(this.getCurSegmentkey(), true);
    }

    private QFilter getDataYearFilter(DeptAmtContext reportCxt) {
        Object datafilter = this.getModel().getValue("datafilter");
        YearMonth yearMonth = YearMonth.now();
        if ("lm".equals(datafilter)) {
            yearMonth = YearMonth.now().minusMonths(1L);
        }
        if ("ly".equals(datafilter)) {
            yearMonth = yearMonth.minusYears(1L);
        }
        reportCxt.setDataFilter(datafilter);
        return new QFilter("dateyear", "=", (Object)String.valueOf(yearMonth.getYear()));
    }

    private String getCurSegmentkey() {
        String key = this.getPageCache().get(SEGMENTKEY);
        return key == null ? "period" : key;
    }

    private void initFilterField(IFormView parentView) {
        Object dept = parentView.getModel().getValue("org");
        this.getModel().setValue("org", ((DynamicObject)((MulBasedataDynamicObjectCollection)dept).get(0)).get("fbasedataid_id"));
        this.getModel().setValue("currency", parentView.getModel().getValue("currency"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void paintChart(String[] categorys, BigDecimal[] totalData, BigDecimal[] usedData, String totalSeriesName, String usedSeriesName) {
        int i;
        Tuple<BigDecimal, String> autoUnit = MBReportUtil.getUnit(totalData);
        String unit = (String)autoUnit.item2;
        for (i = 0; i < totalData.length; ++i) {
            totalData[i] = MBReportUtil.formatValue(totalData[i], autoUnit);
        }
        for (i = 0; i < usedData.length; ++i) {
            usedData[i] = MBReportUtil.formatValue(usedData[i], autoUnit);
        }
        HashMap labelMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap axisPointer = Maps.newHashMapWithExpectedSize((int)1);
        labelMap.put("show", true);
        Chart chart = (Chart)this.getControl("deptamtchartap");
        chart.setShowTooltip(true);
        chart.setShowTitle(false);
        chart.setShowLegend(true);
        chart.setLegendPropValue("bottom", (Object)0);
        chart.addTooltip("formatter", (Object)String.format("{b} <br/>{a0}: {c0}%1s<br/>{a1}: {c1}%1s", unit, unit));
        chart.addTooltip("trigger", (Object)"axis");
        axisPointer.put("type", "shadow");
        chart.addTooltip("axisPointer", (Object)axisPointer);
        HashMap gridProperties = Maps.newHashMapWithExpectedSize((int)2);
        gridProperties.put("bottom", "10%");
        chart.addProperty("grid", (Object)gridProperties);
        BarSeries createBarSeries = chart.createBarSeries(usedSeriesName);
        createBarSeries.setData((Number[])usedData);
        createBarSeries.setPropValue("label", (Object)labelMap);
        BarSeries createBarSeries2 = chart.createBarSeries(totalSeriesName);
        createBarSeries2.setData((Number[])totalData);
        createBarSeries2.setPropValue("label", (Object)labelMap);
        Axis xAxis = chart.createXAxis("x", AxisType.value);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("formatter", String.format("{value} %1s", unit));
        map.put("rorate", 45);
        xAxis.setPropValue("axisLabel", (Object)map);
        Axis yAxis = chart.createYAxis("", AxisType.category);
        this.formatLength(categorys);
        yAxis.setCategorys(categorys);
        chart.refresh();
        this.autoFixHeight(categorys.length, "deptamtchartap");
    }

    private void autoFixHeight(int length, String controlKey) {
        int height = 110 + 70 * length;
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap heightMap = Maps.newHashMapWithExpectedSize((int)1);
        heightMap.put("zh_CN", String.format("%spx", height));
        fieldMap.put("h", heightMap);
        this.getView().updateControlMetadata(controlKey, (Map)fieldMap);
    }

    private void formatLength(String[] categorys) {
        for (int i = 0; i < categorys.length; ++i) {
            if (categorys[i].length() <= 4) continue;
            categorys[i] = this.splitWithLineSpre(categorys[i]);
        }
    }

    private String splitWithLineSpre(String str) {
        StringBuilder sb = new StringBuilder();
        int beginIndex = 0;
        int endIndex = 0;
        int max = str.length();
        while (beginIndex < str.length()) {
            endIndex = beginIndex + 4 > max ? max : beginIndex + 4;
            sb.append(str.substring(beginIndex, endIndex));
            beginIndex = endIndex;
            if (endIndex >= max) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void segmentedControlSelected(SegmentedControlSelectEvent event) {
        String key = event.getSegmentKey();
        this.selectTab(key, false);
        this.getPageCache().put(SEGMENTKEY, key);
    }

    private void selectTab(String key, boolean forceFresh) {
        BigDecimal[] usedData;
        BigDecimal[] totalData;
        String[] categorys;
        String data;
        if (forceFresh) {
            this.getPageCache().remove(PERIODFLEX);
            this.getPageCache().remove(YEARFLEX);
        }
        boolean yearvisible = false;
        boolean periodvisible = false;
        Tuple tuple = null;
        Tuple tuple2 = null;
        if ("year".equals(key)) {
            yearvisible = true;
            tuple = new Tuple((Object)"totalamount", (Object)ResManager.loadKDString((String)"\u5e74\u603b\u989d\u5ea6", (String)"DeptAmtQueryPageMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            tuple2 = new Tuple((Object)"thisYearUsedAmount", (Object)ResManager.loadKDString((String)"\u672c\u5e74\u5df2\u7528\u989d\u5ea6", (String)"DeptAmtQueryPageMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            periodvisible = true;
            tuple = new Tuple((Object)"thisTermAmount", (Object)ResManager.loadKDString((String)"\u672c\u671f\u989d\u5ea6", (String)"DeptAmtQueryPageMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            tuple2 = new Tuple((Object)"thisTermBalanceAmount", (Object)ResManager.loadKDString((String)"\u672c\u5e74\u53ef\u7528\u989d\u5ea6", (String)"DeptAmtQueryPageMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (this.chartDatas == null && (data = ReportDataProcessCenter.getData("amt.report.datas", this.getView())) != null) {
            this.chartDatas = (List)SerializationUtils.fromJsonString((String)data, List.class);
        }
        if (this.chartDatas != null && !this.chartDatas.isEmpty()) {
            int size = this.chartDatas.size() > 6 ? 6 : this.chartDatas.size();
            categorys = new String[size];
            totalData = new BigDecimal[size];
            usedData = new BigDecimal[size];
            for (int i = 0; i < size; ++i) {
                categorys[size - 1 - i] = (String)this.chartDatas.get(i).get("expenseitem");
                totalData[size - 1 - i] = this.formatBigDecimalSafe(this.chartDatas.get(i).get(tuple.item1));
                usedData[size - 1 - i] = this.formatBigDecimalSafe(this.chartDatas.get(i).get(tuple2.item1));
            }
        } else {
            this.getModel().setValue("datatag", (Object)0);
            return;
        }
        this.paintChart(categorys, this.formatNumber(totalData), this.formatNumber(usedData), (String)tuple.item2, (String)tuple2.item2);
        this.getModel().setValue("datatag", (Object)1);
        this.showDetailList(key, yearvisible, periodvisible);
    }

    private void showDetailList(String key, boolean yearvisible, boolean periodvisible) {
        this.getView().setVisible(Boolean.valueOf(yearvisible), new String[]{YEARFLEX});
        this.getView().setVisible(Boolean.valueOf(periodvisible), new String[]{PERIODFLEX});
        if (periodvisible && this.getPageCache().get(PERIODFLEX) == null) {
            this.showForm(PERIODFLEX, "er_m_deptamtquery_period");
        }
        if (yearvisible && this.getPageCache().get(YEARFLEX) == null) {
            this.showForm(YEARFLEX, "er_m_deptamtquery_year");
        }
    }

    private BigDecimal formatBigDecimalSafe(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(obj.toString());
    }

    private BigDecimal[] formatNumber(BigDecimal[] decimals) {
        BigDecimal[] numbers = new BigDecimal[decimals.length];
        for (int i = 0; i < decimals.length; ++i) {
            numbers[i] = decimals[i] == null ? BigDecimal.ZERO : decimals[i];
        }
        return numbers;
    }

    private void showForm(String targetKey, String formid) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formid);
        this.getPageCache().put(targetKey, "1");
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

